#define INCL_DEV
#define INCL_DOSERRORS
#define INCL_DOSPROCESS
#define INCL_GPICONTROL
#define INCL_GPICORRELATION
#define INCL_GPILCIDS
#define INCL_GPILOGCOLORTABLE
#define INCL_GPIPATHS
#define INCL_GPIPRIMITIVES
#define INCL_GPITRANSFORMS
#define INCL_SPL
#define INCL_SPLDOSPRINT
#include <os2.h>
#include <stdlib.h>
#include <string.h>



BOOL bDead;



#define DW_FONT_HELV             1
#define DW_TEXT_COLOR            0x00CCCCCC
#define DW_MAX_ANGLE             90



BOOL _Optlink checkBoundary(HPS hpsPrn,PCHAR pchText,PSIZEL pszlBound)
{
   BOOL bNoError;
   POINTL ptlPoint;
   RECTL rclBound;

   bNoError=FALSE;

   GpiQueryPS(hpsPrn,pszlBound);

   ptlPoint.x=pszlBound->cx/2;
   ptlPoint.y=pszlBound->cy/2;

   pszlBound->cx=0;
   pszlBound->cy=0;

   //----------------------------------------------------------------------
   // Reset the boundary data, draw the string, and query the boundary
   // data.
   //----------------------------------------------------------------------
   if (!GpiResetBoundaryData(hpsPrn))
      ;

   else if (GpiCharStringAt(hpsPrn,
                            &ptlPoint,
                            strlen(pchText),
                            pchText)==GPI_ERROR)
      ;

   else if (!GpiQueryBoundaryData(hpsPrn,&rclBound))
      ;

   //----------------------------------------------------------------------
   // Did we get an empty rectangle?
   //----------------------------------------------------------------------
   else
   {
      pszlBound->cx=rclBound.xRight-rclBound.xLeft+1;
      pszlBound->cy=rclBound.yTop-rclBound.yBottom+1;

      bNoError=TRUE;
   } /* endif */

   return bNoError;
}



BOOL _Optlink doWatermark(HPS hpsPrn,PCHAR pchText,USHORT usAngle)
//-------------------------------------------------------------------------
// This function draws a watermark on the current page of the print job.
// It assumes that the presentation space was created with the GPIT_NORMAL
// flag and that the Helvetica ATM font is installed on the system.  This
// function should be called immediately after the job is started or after
// a new page is begun.
//
// Input:  hpsPrn - specifies the handle of the presentation space.
//         pchText - points to the text to be used as the watermark
//         usAngle - specifies the degrees that the watermark should be
//                   rotated and must be in the range 0-90, inclusive.
// Returns:  TRUE if successf/ul, FALSE otherwise
//-------------------------------------------------------------------------
{
   BOOL bNoError;
   FATTRS faFont;
   SIZEL szlHps;
   MATRIXLF mxRotate;
   SIZEF szfChar;
   POINTL ptlPoint;
   SIZEL szlBound;
   BOOL bLoop;
   FONTMETRICS fmFont;
   POINTL ptlText;

   bNoError=FALSE;
   usAngle %= (DW_MAX_ANGLE+1);

   faFont.usRecordLength=sizeof(faFont);
   faFont.fsSelection=0;
   faFont.lMatch=0;
   strcpy(faFont.szFacename,"Helvetica");
   faFont.idRegistry=0;
   faFont.usCodePage=GpiQueryCp(hpsPrn);
   faFont.lMaxBaselineExt=0;
   faFont.lAveCharWidth=0;
   faFont.fsType=0;
   faFont.fsFontUse=FATTR_FONTUSE_OUTLINE | FATTR_FONTUSE_TRANSFORMABLE;

   //----------------------------------------------------------------------
   // Get the HPS dimensions.  GpiQueryPS() does not have an error return
   // code defined.
   //----------------------------------------------------------------------
   GpiQueryPS(hpsPrn,&szlHps);

   //----------------------------------------------------------------------
   // Start off with a ridiculously large character box size.  This
   // results in more iterations of the loop below, but it's a helluva
   // lot easier than trying to make an educated first guess.  [grin]
   //----------------------------------------------------------------------
   szfChar.cx=MAKEFIXED(szlHps.cy/2,0);
   szfChar.cy=szfChar.cx;

   ptlPoint.x=szlHps.cx/2;
   ptlPoint.y=szlHps.cy/2;

   //----------------------------------------------------------------------
   // Save the HPS so that we can do as we please with it.  [grin]
   //----------------------------------------------------------------------
   if (GpiSavePS(hpsPrn)==GPI_ERROR)
      ;

   //----------------------------------------------------------------------
   // Create the logical font.
   //----------------------------------------------------------------------
   else if (GpiCreateLogFont(hpsPrn,NULL,DW_FONT_HELV,&faFont)==GPI_ERROR)
      ;

   //----------------------------------------------------------------------
   // Set the font into the HPS.
   //----------------------------------------------------------------------
   else if (!GpiSetCharSet(hpsPrn,DW_FONT_HELV))
      ;

   //----------------------------------------------------------------------
   // Set the character mode to 3 so that we can rotate them.
   //----------------------------------------------------------------------
   else if (!GpiSetCharMode(hpsPrn,CM_MODE3))
      ;

   else if (!GpiSetCharBox(hpsPrn,&szfChar))
      ;

   //----------------------------------------------------------------------
   // The algorithm that we use is as follows:
   //
   // 1. Set the rotate transform to the appropriate angle.
   // 2. Start boundary data collection
   // 3. Draw the string
   // 4. Stop boundary data collection and query the bounding rectangle
   //    in boundX
   // 5. If the width and height of the bounding rectangle is larger than
   //    the width and height of the printed page, then loop to step 2.
   // 6. Reset the rotate transform
   // 7. Start boundary data collection
   // 8. Draw the string
   // 9. Stop boundary data collection and query the bounding rectangle
   //    in boundBound
   // 10. Set the rotate transform to the appropriate angle.
   // 11. Draw the string at the point which is horizontally centered,
   //     basing the centering calculation on boundBound.  The rotate
   //     transform insures that the starting point is rotated properly.
   //----------------------------------------------------------------------

   //----------------------------------------------------------------------
   // Rotate about the center of the page.
   //----------------------------------------------------------------------
   else if (!GpiRotate(hpsPrn,
                       &mxRotate,
                       TRANSFORM_REPLACE,
                       MAKEFIXED(usAngle,0),
                       &ptlPoint))
      ;

   else if (!GpiSetModelTransformMatrix(hpsPrn,
                                        9,
                                        &mxRotate,
                                        TRANSFORM_REPLACE))
      ;

   else if (!GpiCreateLogColorTable(hpsPrn,0,LCOLF_RGB,0,0,NULL))
      ;

   else if (!GpiSetColor(hpsPrn,DW_TEXT_COLOR))
      ;

   //----------------------------------------------------------------------
   // Turn off drawing and turn on boundary collection
   //----------------------------------------------------------------------
   else if (!GpiSetDrawControl(hpsPrn,DCTL_DISPLAY,DCTL_OFF))
      ;

   else if (!GpiSetDrawControl(hpsPrn,DCTL_BOUNDARY,DCTL_ON))
      ;

   else
   {
      bLoop=TRUE;
      bNoError=TRUE;

      while (bLoop && bNoError)
      {
         bNoError=FALSE;

         if (!checkBoundary(hpsPrn,pchText,&szlBound))
            ;

         //----------------------------------------------------------------
         // Check to see if the -size- of the bounding rectangle is greater
         // in either dimension than the -size- of the printed page.
         // Because we're checking the -size- and not the absolute values,
         // we can draw the string at -any- starting point.
         //----------------------------------------------------------------
         else if ((szlBound.cx>0) && (szlBound.cy>0) &&
                  (szlBound.cx<=szlHps.cx) && (szlBound.cy<=szlHps.cy))
         {
            bLoop=FALSE;
            bNoError=TRUE;
         }
         else
         {
            //-------------------------------------------------------------
            // The bounding rectangle is too big, so shrink the size of
            // the character box by 1/10th.
            //-------------------------------------------------------------
            szfChar.cx=MAKEFIXED(FIXEDINT(szfChar.cx)*0.9,0);
            szfChar.cy=MAKEFIXED(FIXEDINT(szfChar.cy)*0.9,0);

            if ((szfChar.cx==0) || (szfChar.cy==0))
               ;

            else if (!GpiSetCharBox(hpsPrn,&szfChar))
               ;

            else
               bNoError=TRUE;
         } /* endif */
      }; /* endwhile */
   } /* endif */

   if (bNoError)
   {
      bNoError=FALSE;

      //-------------------------------------------------------------------
      // Reset the rotation transform
      //-------------------------------------------------------------------
      if (!GpiRotate(hpsPrn,
                     &mxRotate,
                     TRANSFORM_REPLACE,
                     MAKEFIXED(0,0),
                     &ptlPoint))
         ;

      else if (!GpiSetModelTransformMatrix(hpsPrn,
                                           9,
                                           &mxRotate,
                                           TRANSFORM_REPLACE))
         ;

      else if (!checkBoundary(hpsPrn,pchText,&szlBound))
         ;

      //-------------------------------------------------------------------
      // Turn on drawing and turn off boundary collection
      //-------------------------------------------------------------------
      else if (!GpiSetDrawControl(hpsPrn,DCTL_DISPLAY,DCTL_ON))
         ;

      else if (!GpiSetDrawControl(hpsPrn,DCTL_BOUNDARY,DCTL_OFF))
         ;

      //-------------------------------------------------------------------
      // Rotate about the center of the page.
      //-------------------------------------------------------------------
      else if (!GpiRotate(hpsPrn,
                          &mxRotate,
                          TRANSFORM_REPLACE,
                          MAKEFIXED(usAngle,0),
                          &ptlPoint))
         ;

      else if (!GpiSetModelTransformMatrix(hpsPrn,
                                           9,
                                           &mxRotate,
                                           TRANSFORM_REPLACE))
         ;

      //-------------------------------------------------------------------
      // We need the maximum descender size.
      //-------------------------------------------------------------------
      else if (!GpiQueryFontMetrics(hpsPrn,sizeof(fmFont),&fmFont))
         ;

      //-------------------------------------------------------------------
      // Draw the text.
      //-------------------------------------------------------------------
      else
      {
         ptlText.x=szlHps.cx/2-szlBound.cx/2;
         ptlText.y=szlHps.cy/2-FIXEDINT(szfChar.cy)/2+fmFont.lMaxDescender;

         if (GpiCharStringAt(hpsPrn,
                             &ptlText,
                             strlen(pchText),
                             pchText)==GPI_ERROR)
            ;

         else
            bNoError=TRUE;
      } /* endif */
   } /* endif */

   if (bNoError)
   {
      bNoError=FALSE;

      //-------------------------------------------------------------------
      // Restore the default font
      //-------------------------------------------------------------------
      if (!GpiSetCharSet(hpsPrn,LCID_DEFAULT))
         ;

      //-------------------------------------------------------------------
      // Delete the font
      //-------------------------------------------------------------------
      else if (!GpiDeleteSetId(hpsPrn,DW_FONT_HELV))
         ;

      else if (!GpiRestorePS(hpsPrn,-1))
         ;

      else
         bNoError=TRUE;
   } /* endif */

   return bNoError;
}



VOID _Optlink printThread(PVOID pvDummy)
{
   BOOL bNoError;
   PRQINFO3 *ppiInfo;
   HAB habAnchor;
   HMQ hmqQueue;
   HDC hdcPrn;
   HPS hpsPrn;
   APIRET arReturn;
   ULONG ulReturn;
   ULONG ulTotal;
   ULONG ulNeeded;
   PRQINFO3 *ppiCurrent;
   ULONG ulIndex;
   CHAR achDocName[256];
   CHAR achDriver[256];
   PCHAR pchPos;
   DEVOPENSTRUC dopPrn;
   SIZEL szlPrn;
   USHORT usJobId;
   LONG lSzData;

   bNoError=TRUE;
   ppiInfo=NULL;
   habAnchor=NULLHANDLE;
   hmqQueue=NULLHANDLE;
   hdcPrn=NULLHANDLE;
   hpsPrn=NULLHANDLE;

   habAnchor=WinInitialize(0);
   if (habAnchor==NULLHANDLE)
      bNoError=FALSE;

   if (bNoError)
   {
      hmqQueue=WinCreateMsgQueue(habAnchor,0);
      if (hmqQueue==NULLHANDLE)
         bNoError=FALSE;
   } /* endif */

   if (bNoError)
   {
      arReturn=SplEnumQueue(NULL,
                            3,
                            NULL,
                            0,
                            &ulReturn,
                            &ulTotal,
                            &ulNeeded,
                            0);
      if ((arReturn!=0) && (arReturn!=ERROR_MORE_DATA))
         bNoError=FALSE;
   } /* endif */

   if (bNoError)
   {
      ppiInfo=(PRQINFO3 *)malloc(ulNeeded);
      if (ppiInfo==NULL)
         bNoError=FALSE;
   } /* endif */

   if (bNoError)
   {
      arReturn=SplEnumQueue(NULL,
                            3,
                            ppiInfo,
                            ulNeeded,
                            &ulReturn,
                            &ulTotal,
                            &ulNeeded,
                            0);
      if ((arReturn!=0) && (arReturn!=ERROR_MORE_DATA))
         bNoError=FALSE;
   } /* endif */

   if (bNoError)
   {
      ppiCurrent=ppiInfo;

      for (ulIndex=0; ulIndex<ulTotal; ulIndex++)
      {
         if ((ppiCurrent->fsType & PRQ3_TYPE_APPDEFAULT)!=0)
            break;

         ppiCurrent++;
      } /* endfor */

      if (ulIndex==ulTotal)
         bNoError=FALSE;
   } /* endif */

   if (bNoError)
   {
      strcpy(achDocName,"Watermark Test");

      strcpy(achDriver,ppiCurrent->pszDriverName);
      pchPos=strchr(achDriver,'.');
      if (pchPos!=NULL)
         *pchPos=0;

      dopPrn.pszLogAddress=ppiCurrent->pszName;
      dopPrn.pszDriverName=achDriver;
      dopPrn.pdriv=ppiCurrent->pDriverData;
      dopPrn.pszDataType=0;
      dopPrn.pszComment=achDocName;
      dopPrn.pszQueueProcName=ppiCurrent->pszPrProc;
      dopPrn.pszQueueProcParams=ppiCurrent->pszParms;
      dopPrn.pszSpoolerParams=NULL;
      dopPrn.pszNetworkParams=NULL;

      hdcPrn=DevOpenDC(habAnchor,
                       OD_QUEUED,
                       "*",
                       9,
                       (PDEVOPENDATA)&dopPrn,
                       NULLHANDLE);
      if (hdcPrn==NULLHANDLE)
         bNoError=FALSE;
   } /* endif */

   if (bNoError)
   {
      DevQueryCaps(hdcPrn,CAPS_WIDTH,1,&szlPrn.cx);
      DevQueryCaps(hdcPrn,CAPS_HEIGHT,1,&szlPrn.cy);

      hpsPrn=GpiCreatePS(habAnchor,
                         hdcPrn,
                         &szlPrn,
                         PU_PELS | GPIT_NORMAL | GPIA_ASSOC);
      if (hpsPrn==NULLHANDLE)
         bNoError=FALSE;
   } /* endif */

   if (bNoError)
   {
      DevEscape(hdcPrn,
                DEVESC_STARTDOC,
                strlen(achDocName),
                achDocName,
                NULL,
                NULL);

      doWatermark(hpsPrn,"Top Secret",45);

      lSzData=sizeof(usJobId);

      DevEscape(hdcPrn,
                DEVESC_ENDDOC,
                0,
                NULL,
                &lSzData,
                (PBYTE)&usJobId);
   } /* endif */

   if (hpsPrn!=NULLHANDLE)
      GpiDestroyPS(hpsPrn);

   if (hdcPrn!=NULLHANDLE)
      DevCloseDC(hdcPrn);

   if (hmqQueue!=NULLHANDLE)
      WinDestroyMsgQueue(hmqQueue);

   if (habAnchor!=NULLHANDLE)
      WinTerminate(habAnchor);

   if (ppiInfo!=NULL)
      free(ppiInfo);

   bDead=TRUE;
}



INT main(VOID)
{
   HAB habAnchor;
   HMQ hmqQueue;

   habAnchor=WinInitialize(0);
   hmqQueue=WinCreateMsgQueue(habAnchor,0);

   bDead=FALSE;

   _beginthread(printThread,NULL,0x8000,NULL);

   while (!bDead)
      DosSleep(1);

   WinDestroyMsgQueue(hmqQueue);
   WinTerminate(habAnchor);
   return 0;
}
