
/*------------------------------------------------------------------*
 *                                                                  *
 *  Video Toolkit For OS/2 Version 1.0                              *
 *  Example PM Application No. 2.                                   *
 *  Written by Stephen Sloan.                                       *
 *  Date : 22/02/95.                                                *
 *  Copyright (c) Abbotsbury Software Ltd., United Kingdom. 1995.   *
 *                                                                  *
 *  Filename : tune.h                                               *
 *                                                                  *
 *------------------------------------------------------------------*/

typedef struct _SOURCE_DATA
{
    CHAR    src_string[32];
    USHORT  src_no;
    USHORT  src_tuner_flag;
} SOURCE_DATA, FAR *PSOURCE_DATA;

typedef struct _VIDEO_FORMAT_DATA
{
    CHAR    vf_string[32];
    USHORT  vf_no;
} VIDEO_FORMAT_DATA, FAR *PVIDEO_FORMAT_DATA;

SOURCE_DATA celebnb_src[] =
{
    {"Ext 1", 0, 0},
    {"Ext 2", 1, 0},
    {"TV Tuner", 2, 1},
    {"SVHS", 3, 0},
    {"Testcard", 4, 0},
    0
};

VIDEO_FORMAT_DATA   celebnb_vf[] =
{
    {"PAL BGHI", CF_PAL_BGHI},
    {"NTSC M", CF_NTSC_M},
    {"SECAM", CF_SECAM},
    {"PAL M", CF_PAL_M},
    {"PAL N", CF_PAL_N},
    {"NTSC 443", CF_NTSC_443},
    {"External Src", CF_EXTERNAL_SRC},
    0
};

SOURCE_DATA highqnb_src[] =
{
    {"Ext 1", 0, 0},
    {"Ext 2", 1, 0},
    {"SVHS", 3, 0},
    {"Testcard", 4, 0},
    0
};

VIDEO_FORMAT_DATA   highqnb_vf[] =
{
    {"PAL BGHI", CF_PAL_BGHI},
    {"NTSC M", CF_NTSC_M},
    {"SECAM", CF_SECAM},
    {"PAL M", CF_PAL_M},
    {"PAL N", CF_PAL_N},
    {"NTSC 443", CF_NTSC_443},
    {"External Src", CF_EXTERNAL_SRC},
    0
};

SOURCE_DATA prismnb_src[] =
{
    {"Ext 1", 0, 0},
    {"Ext 2", 1, 0},
    {"TV Tuner", 2, 1},
    0
};

VIDEO_FORMAT_DATA   prismnb_vf[] =
{
    {"PAL BGHI - Europe", 0},
    {"PAL N - USA", 1},
    {"SECAM", 2},
    {"PAL M", 3},
    {"PAL 443", 4},
    {"NTSC M", 5},
    {"NTSC 443", 6},
    {"Black & White", 7},
    0
};

SOURCE_DATA encornb_src[] =
{
    {"Ext 1", 0, 0},
    {"Ext 2", 1, 0},
    {"TV Tuner", 2, 1},
    {"SVHS", 3, 0},
    0
};

VIDEO_FORMAT_DATA   encornb_vf[] =
{
    {"PAL BGHI", CF_PAL_BGHI},
    {"NTSC M", CF_NTSC_M},
    {"SECAM", CF_SECAM},
    {"PAL M", CF_PAL_M},
    {"PAL N", CF_PAL_N},
    {"NTSC 443", CF_NTSC_443},
    {"External Src", CF_EXTERNAL_SRC},
    0
};

#define     MAX_SOURCES             (16)
#define     MAX_VIDEO_FORMATS       (16)
