
/***************************************************************/
/*                                                             */
/*  Aver TVPhone98 Remote Control Plug-in for T&V HappyPlayer  */
/*  Copyright (c) 2000  Vadim Rumyantsev, Tatyana Rumyantseva  */
/*                                                             */
/*  This program and its source code is a commercial software, */
/*  NOT freeware! You must be a legal T&V HappyPlayer user to  */
/*  use this software for any purpose.                         */
/*                                                             */
/***************************************************************/


#include <stdlib.h>
#include <string.h>

#define INCL_DOSPROCESS
#define INCL_WIN
#include <os2.h>

#include "tvplugin.h"
#include "aver98rm.h"

#define IDLE_DELAY 150
#define BUSY_DELAY  20

PLCALLS Pl;

enum {ModeBrightness, ModeContrast, ModeHue, ModeFreq};

BOOL Inited = FALSE;
int  CurrentMode = ModeBrightness;
char ModeKeyP [4] = {'b', 'c', 'h', ']'};
char ModeKeyM [4] = {'B', 'C', 'H', '['};

void _Optlink Remote98 (void* hwnd) {

  ULONG data;
  char key, skey;
  int mask, lastmask;

  lastmask = 0;

  while (Inited) {
	
    data = (*Pl.GetRegister)(0x200);
  
    if (data&(1<<16))
      mask = (data>>15) & 0x1FF;
    else
      mask = 0;

    if (mask == lastmask) {
      if (lastmask)
        DosSleep (BUSY_DELAY);
      else
        DosSleep (IDLE_DELAY);
      continue;
    }

    lastmask = mask;

    key = skey = 0;

    switch (mask) {

      case R_1:
        skey = 2;
      break;
      case R_2:
        skey = 3;
      break;
      case R_3:
        skey = 4;
      break;
      case R_4:
        skey = 5;
      break;
      case R_5:
        skey = 6;
      break;
      case R_6:
        skey = 7;
      break;
      case R_7:
        skey = 8;
      break;
      case R_8:
        skey = 9;
      break;
      case R_9:
        skey = 10;
      break;
      case R_0:
        skey = 11;
      break;

      case R_PREVIEW:
        skey = 14;
      break;

      case R_AUTOSCAN:
        key = 'S';
      break;

      case R_FREEZE:
        key = 'v';
      break;

      case R_MUTE:
        key = 'm';
      break;
   
      case R_LEFT:
        skey = 102;
      break;

      case R_RIGHT:
        skey = 97;
      break;

      case R_TVFM:
        key = 'i';
      break;

      case R_VIDEO:
        key = 'p';
      break;

      case R_EMPTY1:
        CurrentMode = ModeBrightness;
      break;

      case R_EMPTY2:
        CurrentMode = ModeContrast;
      break;

      case R_EMPTY3:
        CurrentMode = ModeHue;
      break;

      case R_EMPTY4:
        CurrentMode = ModeFreq;
      break;

      case R_MINUS:
        key = ModeKeyM [CurrentMode];
      break;

      case R_PLUS:
        key = ModeKeyP [CurrentMode];
      break;

      case R_EMPTY0:
        key = 27;
      break;

      case R_CD:
        key = 'o';
      break;

      default:;
        
    }

    if (key||skey) {
      WinPostMsg((HWND)hwnd, WM_CHAR, 
                   MPFROMSH2CH(KC_CHAR|KC_SCANCODE,1,skey), 
                   MPFROM2SHORT(key,0) );
    }

    DosSleep (BUSY_DELAY);

  }

}




TV_EXTERN APIRET PLINIT (PLCALLS *calls, HWND hwnd, ULONG version) {

  if (calls->Total >= 6) {
    Inited = TRUE;
    memcpy(&Pl, calls, sizeof(PLCALLS));
    _beginthread(Remote98,NULL,65536,(void*)hwnd);
    return 0;
  }
  else
    return 1;

}


TV_EXTERN APIRET PLDONE () {

  Inited = FALSE;

  return 0;

}


TV_EXTERN APIRET PLPRESS (char key, char skey) {

  if (Inited) {

  }

  return 0;

}

