/* Recreate objects script.
 *
 * Generated via Object Desktop Package File 'Object Package'.
 */

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

CreateCollision = 'Update'

Call SysCls

/* Get COM port. */
Say ' '
Say ' '
Say 'COM port Pilot cradle is connected to:'
Say 'NOTE: Without colon.'
Call CharOut, '  (COM1,COM2,COM3,COM4,etc) : '
Parse Upper Pull COMport
Say ' '

Call CreateObjects
Exit

CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc

CreateObjects:

/* Figure out the directories involved. */
current_dir = directory()
previous_dir = left(current_dir, ( length(current_dir) - 4 ))

  rc = CreateObject( 'WPFolder',,
    'Pilot Link 0.6.5^for OS/2',,
    '<WP_DESKTOP>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ALWAYSSORT=YES;'||,
        'OBJECTID=<Pilot_Link_0_6_5_for_OS_2>',,
    CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'ChangeLog',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'SHADOWID='||previous_dir||'\ChangeLog',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Get ROM: Install PRC^(Required to use Get ROM)',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||previous_dir||'\PILOT-XFER.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS='||COMport||' -i "getrom.prc";'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Backup Pilot',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||previous_dir||'\PILOT-XFER.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS='||COMport||' -b [Destination path for Pilot Backup:];'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'List Pilot Files',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS=/C '||previous_dir||'\PILOT-XFER.EXE '||COMport||' -l |more;'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Get Clipboard from Pilot',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||previous_dir||'\PILOT-CLIP.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS='||COMport||' -g;'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'User Information',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||previous_dir||'\install-user.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS='||COMport||';'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Install PRC or PDB^(Droped on me)',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||previous_dir||'\PILOT-XFER.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS='||COMport||' -i "%*";'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'README',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'SHADOWID='||previous_dir||'\README',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'README.OS2',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'SHADOWID='||previous_dir||'\README.OS2',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Get ROM',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||previous_dir||'\GETROM.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS='||COMport||';'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Restore Pilot',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||previous_dir||'\PILOT-XFER.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS='||COMport||' -r [Full path to restore Pilot from:];'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Install PRC or  PDB^(Prompts for file)',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||previous_dir||'\PILOT-XFER.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS='||COMport||' -i "[Full pathname to PRC or PDB]";'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'DLP Shell',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||previous_dir||'\DLPSH.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS='||COMport||';'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'COPYING',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'SHADOWID='||previous_dir||'\COPYING',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Install File to MemoPad^(Prompts for file path)',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||previous_dir||'\INSTALL-MEMO.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS='||COMport||' [File to Install into MemoPad on Pilot:];'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Install File to MemoPad^(Droped on me)',,
      '<Pilot_Link_0_6_5_for_OS_2>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||previous_dir||'\INSTALL-MEMO.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS='||COMport||' "%*";'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPFolder',,
    'Schlep',,
    '<Pilot_Link_0_6_5_for_OS_2>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ALWAYSSORT=YES;'||,
        'OBJECTID=<Pilot_Link_0_6_5_for_OS_2_Schlep>',,
    CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Schlep: Store File to Pilot^(Prompts for file path)',,
      '<Pilot_Link_0_6_5_for_OS_2_Schlep>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS=/C '||previous_dir||'\PILOT-SCHLEP.EXE '||COMport||' -i < [Path of File to Store on Pilot:];'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Schlep: Store File to Pilot^(Droped on me)',,
      '<Pilot_Link_0_6_5_for_OS_2_Schlep>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS=/C '||previous_dir||'\PILOT-SCHLEP.EXE '||COMport||' -i < "%*";'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Schlep: Get File Stored on Pilot^(Prompts for file path)',,
      '<Pilot_Link_0_6_5_for_OS_2_Schlep>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS=/C '||previous_dir||'\PILOT-SCHLEP.EXE '||COMport||' -f > [Path of File to Store File from Pilot To:];'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Schlep: Display File Stored on Pilot^(Displays file to screen)',,
      '<Pilot_Link_0_6_5_for_OS_2_Schlep>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS=/C '||previous_dir||'\PILOT-SCHLEP.EXE '||COMport||' -f | more;'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Schlep: Delete File Stored on Pilot',,
      '<Pilot_Link_0_6_5_for_OS_2_Schlep>',,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||previous_dir||'\PILOT-SCHLEP.EXE;'||,
          'STARTUPDIR='||previous_dir||';'||,
          'PARAMETERS='||COMport||' -d;'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

return
