/* util.c */

/*
    Nut nutrition software 
    Copyright (C) 1998 Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "util.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
            
char KeyArray[366];
char *Key[] = {KeyArray, KeyArray + 61, KeyArray + 122, KeyArray + 183, KeyArray + 244, KeyArray + 305};

int get_char()
{
int ch;
int junk;
ch = getchar();
if ( ch == '\n' ) return (ch);
while ( (junk = getchar() ) != '\n' );
return ch;    
}

void get_qty(float *result, float *grams)
{
char buff[128];
gets(buff);
if (strchr(buff,'g') != NULL) *result = ((float) (atof(buff) / *grams));
else if (strchr(buff,'o') != NULL) *result = ((float) (atof(buff) * 28.35 / *grams));
else if (strchr(buff,'b') != NULL || strchr(buff,'B') != NULL) *result = -38;
else *result = ((float) atof(buff));
}

int get_int()
{
char buff[128];
gets(buff);
return (atoi(buff));
}

void get_string(char *dest, int length)
{
char temp[128];
gets(temp);
strncpy(dest,temp,length);
dest[length-1] = '\0';
}

void header(char *string)
{
char buffer[81];
int count;
size_t size = 80;
size -= strlen(string);
size /= 2;
for (count = 0 ; count < size ; count++) buffer[count] = ' '; 
buffer[count] = '\0';
printf("\033[2J%s%s\n\n",buffer,string);
}

void spacer(int lines)
{
lines = 20 - lines;
for ( ; lines > 0 ; lines--) printf("\n");
}

void key_clean()
{
int i;
for (i = 0 ; i < 6 ; i++) strcpy(Key[i],"");
}
 
void key_put(char *key)
{
int i;
for (i = 4 ; i >= 0 ; i--) strcpy(Key[i+1],Key[i]);
strcpy(Key[0],key);
}

char *key_take()
{
static char key[61];
int i;
strcpy(key,Key[0]);
for (i = 0 ; i < 5 ; i++) strcpy(Key[i],Key[i+1]); 
strcpy(Key[5],"");
return key;
}
