/* recmeal.c */

/*
    Nut nutrition software 
    Copyright (C) 1998 Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "recmeal.h"
#include "food.h"
#include "options.h"
#include "util.h"
#include "db.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

void record_meals()
{
struct food *food_ptr;
char meal_date[7];
char new_meal_date[7];
char key[60];
int meal, c, delfood, junk;
float ratio = 0, one = 1;
key[0] = '\0';
today(meal_date);
for ( ; ; )
 {
 header("NUT:  Record Meals");
 printf("\n\n\n\n\n\nMeal Date:    %s\n\n",meal_date);
 spacer(8);
 printf("\nType meal date (yymmdd) or just press <enter> for today's date:  ");
 get_string(new_meal_date,7);
 if (strlen(new_meal_date) == 6) strcpy(meal_date,new_meal_date);
 if (strlen(new_meal_date) == 6 || strlen(new_meal_date) == 0) break;
 }
header("NUT:  Record Meals");
printf("\n\n\n\n\n\nMeal Date:    %s\n\n",meal_date);
printf("Meal Number:\n");
spacer(9);
printf("\nType meal number (1, 2, or 3) or just <enter> to quit:  ");
meal = get_int();
if (meal < 1 || meal > 3) return;
for ( ; ; )
 {
 for ( ; ; )
  {
  if ((ratio >= 0) && (meal_find(meal_date,meal) != 0))
   {
   header("NUT:  Record Meals");
   if (! meal_show(meal_date,meal))
    {
    printf("\nPress <enter> to continue...");
    junk = get_int();
    }
   else
    {
    printf("\nEnter number to delete or name of next food:  ");
    get_string(key,60);
    if (strcmp(key,"") == 0)
     {
     delete_meals(options.delopt); 
     return;
     }
    }
   }
  delfood = atoi(key);
  if (strcmp(key,"") == 0 || delfood == 0) break;
  delete_meal_food(meal_date,meal,delfood);
  write_meal_db();
  strcpy(key,"");
  }
 key_put(key);
 food_ptr = food_choice("NUT:  Record Meals");
 if (food_ptr == (struct food *) -1) return;
 if (food_ptr == (struct food *)  0) key_clean();
 if (food_ptr == (struct food *)  0) continue;
 header("NUT:  Record Meals");
 food_show(food_ptr, &one);
 printf("\nType # of servings {xxxg for grams, xxxo for oz, \"b\" for back}:  ");
 get_qty(&ratio, &(food_ptr->grams));
 if (ratio < 0)
  {
  key_take();
  strcpy(key,key_take());
  }
 if (ratio > 0)
  {
  if ((new_meal = malloc(sizeof(struct food))) == NULL)
   {
   printf("We are out of memory.  Bummer.\n");
   abort();
   } 
  memcpy(new_meal,food_ptr,sizeof(struct food));
  strcpy(new_meal->meal_date,meal_date);
  new_meal->meal = meal;
  new_meal->grams *= ratio;
  for (c = 0; c < NutrientCount; c++) new_meal->nutrient[c] *= ratio; 
  order_new_meal();
  write_meal_db();
  }
 }
}

void today(char *whatever)
{
int c, month = 0;
struct tm *p;
time_t t;
char timestamp[26];
char meal_date[7];
char *thismonth;
char *Months[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
time(&t);
p = localtime(&t);
strcpy(timestamp,asctime(p));
meal_date[0] = timestamp[22];
meal_date[1] = timestamp[23];
thismonth = timestamp + 4;
for (c = 0; c < 12 ; c++) if (strncmp(thismonth,Months[c],3) == 0) month = c+1;
sprintf(meal_date+2,"%02d",month);
meal_date[4] = timestamp[8];
meal_date[5] = timestamp[9];
meal_date[6] = '\0';
if (meal_date[4] == ' ') meal_date[4] = '0';
strncpy(whatever,meal_date,7);
}
