/* menu.c */

/*
    Nut nutrition software 
    Copyright (C) 1998 Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "menu.h"
#include "util.h"
#include "recmeal.h"
#include "anameal.h"
#include "remmeal.h"
#include "viewfood.h"
#include "addreci.h"
#include "viewrdi.h"
#include "options.h"
#include "prtmenu.h"
#include <stdio.h>

void menu()
{
int menu_choice;
for ( ; ; )
 {
 header("NUT :  Main Menu");
 printf("                       1  --  Record Meals\n\n");
 printf("                       2  --  Analyze Meals and Food Suggestions\n\n");
 printf("                       3  --  Remove Meals\n\n");
 printf("                       4  --  View Foods\n\n");
 printf("                       5  --  Add Recipes\n\n");
 printf("                       6  --  View RDI and Rank Foods\n\n");
 printf("                       7  --  Set Personal Calorie Level\n\n");
 printf("                       8  --  Automatic Deletion of Meals\n\n");
 printf("                       9  --  Print Menus from Meal Database\n\n");
 printf("                       Q  --  Quit NUT\n\n");
 spacer(19);
 printf("Enter your choice:  ");
 menu_choice = get_char();
 switch (menu_choice)
  {
  case 'Q' :
  case 'q' : printf("\033[2JNUT has ended.\n\n");
             exit(0);
             break;
  case '1' : record_meals();
             break; 
  case '2' : analyze_meals();
             break; 
  case '3' : remove_meals();
             break; 
  case '4' : view_foods();
             break; 
  case '5' : add_recipes();
             break; 
  case '6' : view_rdis_menu();
             break; 
  case '7' : personal_cal();
             break; 
  case '8' : auto_del();
             break; 
  case '9' : print_menus();
             break; 
  default  : break;
  }
 }
}

void view_rdis_menu()
{
int menu_choice;
for ( ; ; )
 {
 header("NUT:  View RDIs and Rank Foods");
 printf("\n\n                              1  --  Per 100 Grams\n\n");
 printf("                              2  --  Per 100 Calories\n\n");
 printf("                              3  --  Per Serving\n\n");
 spacer(8);
 printf("\nEnter your choice (just <enter> to quit):  ");
 menu_choice = get_char();
 switch (menu_choice)
  {
  case '1' : view_rdis(1);
             break; 
  case '2' : view_rdis(0);
             break; 
  case '3' : view_rdis(2);
             break; 
  default  : return;
  }
 }
}
