/* food.h */

/*
    Nut nutrition software 
    Copyright (C) 1998 Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef FOOD_H
#define FOOD_H

struct food
 {
 char  meal_date[7];
 char  meal;
 char  name[61];
 char  serving[51];
 float grams;
 float refuse;
 float nutrient[31];
 struct food *next;
 };

extern struct food food_root, meal_root, recipe_root, food_work, *new_food, *new_meal, *new_recipe;
extern char *Nutrient[];
extern float Rdi[];
extern float RdiBase[];
extern char *RdiUnit[];
extern int NutrientCount;
extern int FoodCount;

void order_new_food(void);
int namestrcmp(char *, char *);
void order_new_meal(void);
void order_new_recipe(void);
struct food *food_choice(char *);
void food_subcat(char *, struct food **, int);
int meal_show(char *, int);
void food_show(struct food *, float *);
struct food *food_number(int);
struct food *meal_find(char *,int);
void delete_meal_food(char *, int, int);
int meal_count(void);
int meal_food_count(void);
void clear_work(void);
void food_display(void);
void delete_recipe_food(int);
void delete_meals(int);

#endif
