/* food.c */

/*
    Nut nutrition software 
    Copyright (C) 1998 Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "food.h"
#include "util.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

struct food food_root, food_work, *new_food, meal_root, *new_meal, recipe_root, *new_recipe;

char *Nutrient[] =
{
"Calories:","Protein:","Total Fat:","Carbohydrate:","Fiber:",
"Calcium:","Phosphorus:","Iron:","Sodium:","Potassium:",
"Magnesium:","Zinc:","Copper:","Manganese:","Selenium:","Vit A:",
"Vit E:","Thiamin:","Riboflavin:","Niacin:","Panto Acid:",
"Vit B6:","Folate:","Vit B12:","Vit C:","Fat Sat:",
"Fat Mono:","Fat Poly:","Cholesterol:","Linoleic:","Linolenic:"
};

float Rdi[] =
{
2000,55,65,300,25,
1000,1000,18,2400,4000,
400,15,2,2,70,5000,
20,1.5,1.7,20,10,
2,400,6,60,20,
25,20,300,10.75,1.5
};

float RdiBase[] =
{
2000,55,65,300,25,
1000,1000,18,2400,4000,
400,15,2,2,70,5000,
20,1.5,1.7,20,10,
2,400,6,60,20,
25,20,300,10.75,1.5
};

char *RdiUnit[] =
{
"kc","gm","gm","gm","gm",
"mg","mg","mg","mg","mg",
"mg","mg","mg","mg","mcg","IU",
"mg","mg","mg","mg","mg",
"mg","mcg","mcg","mg","gm",
"gm","gm","mg","gm","gm"
};

int NutrientCount = 31;

int FoodCount = 0;

void order_new_food()
{
struct food *food_ptr = &food_root;
while (food_ptr->next != NULL &&
       namestrcmp(new_food->name, food_ptr->next->name) >= 0)
       food_ptr = food_ptr->next;
new_food->next = food_ptr->next;
food_ptr->next = new_food;
}

void order_new_recipe()
{
struct food *food_ptr = &recipe_root;
while (food_ptr->next != NULL) food_ptr = food_ptr->next;
new_recipe->next = NULL;
food_ptr->next = new_recipe;
}

int namestrcmp(char *name1, char *name2)
{
char namebuf1[61], namebuf2[61];
int count;
for (count = 0 ; count <= 60 ; count++)
 {
 if (name1[count] == ',') namebuf1[count] = '\a';
 else namebuf1[count] = name1[count]; 
 if (name2[count] == ',') namebuf2[count] = '\a';
 else namebuf2[count] = name2[count]; 
 }
return strcmp(namebuf1,namebuf2);
}

void order_new_meal()
{
struct food *meal_ptr = &meal_root;
while (meal_ptr->next != NULL &&
       strcmp(new_meal->meal_date, meal_ptr->next->meal_date) < 0)
            meal_ptr = meal_ptr->next;
while (meal_ptr->next != NULL &&
       strcmp(new_meal->meal_date, meal_ptr->next->meal_date) <= 0 &&
       new_meal->meal < meal_ptr->next->meal)
            meal_ptr = meal_ptr->next;
while (meal_ptr->next != NULL &&
       strcmp(new_meal->meal_date, meal_ptr->next->meal_date) <= 0 &&
       new_meal->meal <= meal_ptr->next->meal &&
       strcmp(new_meal->name,meal_ptr->next->name) > 0) 
            meal_ptr = meal_ptr->next;
new_meal->next = meal_ptr->next;
meal_ptr->next = new_meal;
}

struct food *food_choice(char *screentitle)
{
struct food *food_ptr;
struct food *ptrlist[1325];
int count = 0, charcount, keysize, lines, junk;
char key[61];
for ( ; ; )
 {
 strcpy(key,key_take());
 if (strcmp(key,"") == 0)
  {
  header(screentitle);
  spacer(0);
  if (strcmp(screentitle,"NUT:  Add Recipes") == 0) printf("\nType beginning of food name to add to recipe (or <enter> to quit):  ");
  else printf("\nType beginning of food name to select (or <enter> to quit):  ");
  get_string(key,60);
  key_clean();
  }
 if (key[0] == '\0') return (struct food *) -1;
 for (charcount = 0 ; charcount < 60 ; charcount++) key[charcount] = toupper(key[charcount]);
 key_put(key);
 header(screentitle);
 food_ptr = &food_root;
 keysize = strlen(key); lines = 0; count = 0;
 while ((food_ptr = food_ptr->next)) if (strncmp(key,food_ptr->name,keysize) == 0) ptrlist[++count] = food_ptr;
 while (count == 0)
  {
  key_clean();
  spacer(-1);
  printf("No food named \"%s\".  Try another (or <enter> to quit):  ",key);
  get_string(key,60);
  if (key[0] == '\0') return (struct food *) 0;
  for (charcount = 0 ; charcount < 60 ; charcount++) key[charcount] = toupper(key[charcount]);
  key_put(key);
  header(screentitle);
  food_ptr = &food_root;
  keysize = strlen(key); lines = 0; count = 0;
  while ((food_ptr = food_ptr->next)) if (strncmp(key,food_ptr->name,keysize) == 0) ptrlist[++count] = food_ptr;
  }
 if (count == 1) return ptrlist[1];
 if (count < 21)
  {
  for (lines = 1 ; lines <= count ; lines++) printf("%2d. %s\n",lines,ptrlist[lines]->name);
  spacer(lines - 2);
  printf("Type number of food category (\"b\" to go back, <enter> to quit):  ");
  get_string(key,60);
  junk = 0;
  if (strcmp(key,"b") == 0 || strcmp(key,"B") == 0) junk = -38;
  if (junk == -38) 
   {
   key_take();
   continue;
   }
  junk = atoi(key); 
  if (junk > 0 && junk <= count) 
   {
   key_put(ptrlist[junk]->name);
   return ptrlist[junk];
   }
  else return (struct food *) 0;   
  }
 if (count > 20) food_subcat(key, ptrlist, count);
 }
}

void food_subcat(char *key, struct food **ptrlist, int count)
{
char food_screen[1476];
char *fsptr[121], *thisfsptr, *bufptr, buffer[61], format[11], format100[11], tokenhead[61], junkstring[20];
char *col[10], colformat1[110], colformat2[110];
int i, l, s, subcount = 0, charcount, tokencount, nlength, tokenlength, tokenunique, headlength, linecount, savelinecount = 0, tokenmax = 0, colcount;
for (linecount = 1 ; linecount <= 20 ; linecount++) fsptr[linecount] = food_screen + (61 * linecount);
for (linecount = 1 ; linecount <= count ; linecount++)
 {
 tokencount = 0;
 nlength = strlen(ptrlist[linecount]->name);
 for (charcount = 0 ; charcount <= nlength ; charcount++) if (ptrlist[linecount]->name[charcount] == ',') tokencount++;
 if (tokencount > tokenmax) tokenmax = tokencount;
 }
while (subcount < count && tokenmax > -1)
 {
 tokenmax--;
 subcount = 0;
 for (linecount = 1; subcount < count && linecount <= 20 ; linecount++)
  {
  subcount++;
  nlength = strlen(ptrlist[subcount]->name);
  thisfsptr = fsptr[linecount];
  tokencount = 0;
  for (charcount = 0 ; charcount <= nlength ; charcount++)
   {
   if (ptrlist[subcount]->name[charcount] == ',') tokencount++;
   if (tokencount == tokenmax) 
    {
    thisfsptr[charcount] = '\0';
    break;
    }
   thisfsptr[charcount] = ptrlist[subcount]->name[charcount];
   if (ptrlist[subcount]->name[charcount] == '\0') break;
   }
  if (linecount > 1 && 0 == strcmp(fsptr[linecount],fsptr[linecount-1])) linecount--;
  }
 savelinecount = --linecount;
 }
if (savelinecount > 1)
 {
 for (linecount = 1; linecount <= savelinecount ; linecount++) printf("%2d.  %s\n",linecount,fsptr[linecount]);
 spacer(savelinecount-1);
 printf("Type number of food category (\"b\" to go back, <enter> to quit):  ");
 get_string(junkstring,20);
 if (strcmp(junkstring,"b") == 0 || strcmp(junkstring,"B") == 0) 
  {
  key_take();
  return;
  }
 linecount = atoi(junkstring);
 if (linecount > 0 && linecount <= savelinecount) 
  {
  strcpy(key,fsptr[linecount]);
  for (subcount = 1 ; subcount <= count ; subcount++) if (strcmp(key,ptrlist[subcount]->name) == 0) break;
  if (--subcount == count) strcat(key,",");
  }
 else key[0] = '\0';
 key_put(key);
 }
else
 {
 tokenhead[0] = '\0';
 for (tokenmax = 1 ; ; tokenmax++)
  {
  buffer[0] = '\0';
  tokenunique = 0;
  tokenlength = 0;
  for (subcount = 1 ; subcount <= count ; subcount++)
   {
   bufptr = ptrlist[subcount]->name;
   nlength = 0;
   for (tokencount = 1 ; tokencount <= tokenmax ; tokencount++)
    {
    bufptr += nlength;
    bufptr += strspn(bufptr,",");
    nlength = strcspn(bufptr,",");
    } 
   if (nlength > tokenlength) 
    {
    tokenlength = nlength;
    tokenunique++;
    strncpy(buffer,bufptr,nlength);
    buffer[nlength] = '\0';
    }
   else if (nlength < tokenlength) 
    {
    tokenunique++;
    strncpy(buffer,bufptr,nlength);
    buffer[nlength] = '\0';
    }
   else if (strncmp(buffer,bufptr,nlength) != 0)
    {
    tokenunique++;
    strncpy(buffer,bufptr,nlength);
    buffer[nlength] = '\0';
    }
   else;
   }
  if (tokenunique == 1)
   {
   strcat(buffer,",");
   strcat(tokenhead,buffer);
   }
  if (tokenunique != 1) break;
  }
 if (tokenhead[0] == '\0') savelinecount = 20;
 else savelinecount = 19; 
 headlength = strlen(tokenhead);
 while ( savelinecount * (81 / (tokenlength + 5 ) ) < tokenunique )
  {
  buffer[0] = '\0';
  tokenunique = 0 ;
  tokenlength--;
  for (subcount = 1 ; subcount <= count ; subcount++)
   {
   bufptr = ptrlist[subcount]->name + headlength;
   nlength = strcspn(bufptr,",");
   while (*(bufptr + nlength - 1) == ' ') nlength--;
   if (nlength > tokenlength) nlength = tokenlength;
   if (strncmp(buffer,bufptr,nlength) != 0)
    {
    tokenunique++;
    strncpy(buffer,bufptr,nlength);
    buffer[nlength] = '\0';
    }
   }
  }
 for (linecount = 0 ; linecount <= (tokenunique+2) ; linecount++) fsptr[linecount] = food_screen + ((tokenlength+1) * linecount);
 food_screen[0] = '\0';
 linecount = 0;
 for (subcount = 1 ; subcount <= count ; subcount++)
  { 
  bufptr = ptrlist[subcount]->name + headlength;
  nlength = (strcspn(bufptr,","));
  if (nlength > tokenlength) nlength = tokenlength;
  while (*(bufptr + nlength - 1) == ' ') nlength--;
  strncpy(fsptr[linecount + 1],bufptr,nlength);
  thisfsptr = fsptr[linecount + 1];
  thisfsptr[nlength] = '\0';
  if (strncmp(fsptr[linecount],fsptr[linecount + 1],nlength) != 0) linecount++;
  }
 sprintf(format,"%%2d. %%-%ds",tokenlength);
 sprintf(format100,"%%3d. %%-%ds",tokenlength);
 strcpy(colformat1,format);
 strcpy(colformat2,format);
 colcount = (linecount % savelinecount == 0 ? 0 : 1) + (linecount / savelinecount);
 for (i = 2 ; i <= colcount ; i++)
  {
  if (i != colcount) strcat(colformat1," ");
  strcat(colformat2," ");
  if ((i * savelinecount) < 100 || tokenunique < 100)
   {
   if (i != colcount) strcat(colformat1,format);
   strcat(colformat2,format);
   }
  else 
   {
   if (i != colcount) strcat(colformat1,format100);
   strcat(colformat2,format100);
   }
  }
 strcat(colformat1,"\n");
 strcat(colformat2,"\n");
 col[colcount - 1] = colformat1;
 col[colcount] = colformat2;
 if (headlength > 0 ) printf("%-s\n",tokenhead);
 l = linecount ; s = savelinecount;
 for (i = 1 ; i <= savelinecount ; i++)
  {
  if      (i+(1*s)>l) printf(col[1],i,fsptr[i]);
  else if (i+(2*s)>l) printf(col[2],i,fsptr[i],i+s,fsptr[i+s]);
  else if (i+(3*s)>l) printf(col[3],i,fsptr[i],i+s,fsptr[i+s],i+(2*s),fsptr[i+(2*s)]);
  else if (i+(4*s)>l) printf(col[4],i,fsptr[i],i+s,fsptr[i+s],i+(2*s),fsptr[i+(2*s)],i+(3*s),fsptr[i+(3*s)]);
  else if (i+(5*s)>l) printf(col[5],i,fsptr[i],i+s,fsptr[i+s],i+(2*s),fsptr[i+(2*s)],i+(3*s),fsptr[i+(3*s)],i+(4*s),fsptr[i+(4*s)]);
  else if (i+(6*s)>l) printf(col[6],i,fsptr[i],i+s,fsptr[i+s],i+(2*s),fsptr[i+(2*s)],i+(3*s),fsptr[i+(3*s)],i+(4*s),fsptr[i+(4*s)],i+(5*s),fsptr[i+(5*s)]);
  else if (i+(7*s)>l) printf(col[7],i,fsptr[i],i+s,fsptr[i+s],i+(2*s),fsptr[i+(2*s)],i+(3*s),fsptr[i+(3*s)],i+(4*s),fsptr[i+(4*s)],i+(5*s),fsptr[i+(5*s)],i+(6*s),fsptr[i+(6*s)]);
  else if (i+(8*s)>l) printf(col[8],i,fsptr[i],i+s,fsptr[i+s],i+(2*s),fsptr[i+(2*s)],i+(3*s),fsptr[i+(3*s)],i+(4*s),fsptr[i+(4*s)],i+(5*s),fsptr[i+(5*s)],i+(6*s),fsptr[i+(6*s)],i+(7*s),fsptr[i+(7*s)]);
  else if (i+(9*s)>l) printf(col[9],i,fsptr[i],i+s,fsptr[i+s],i+(2*s),fsptr[i+(2*s)],i+(3*s),fsptr[i+(3*s)],i+(4*s),fsptr[i+(4*s)],i+(5*s),fsptr[i+(5*s)],i+(6*s),fsptr[i+(6*s)],i+(7*s),fsptr[i+(7*s)],i+(8*s),fsptr[i+(8*s)]);
  else;
  }
 spacer(19);
 printf("Type number of food category (\"b\" to go back, <enter> to quit):  ");
 get_string(junkstring,20);
 if (strcmp(junkstring,"b") == 0 || strcmp(junkstring,"B") == 0) 
  {
  key_take();
  return;
  }
 i = atoi(junkstring);
 if (i > 0 && i <= linecount)
  {
  if (headlength > 0)
   {
   strcpy(key,tokenhead);
   strcat(key,fsptr[i]);
   }
  else strcpy(key,fsptr[i]);
  }
 else key[0] = '\0';
 key_put(key);
 }
}

int meal_show(char *meal_date, int meal)
{
struct food *meal_ptr = &meal_root;
char namebuf[61];
int count = 0;
printf("Meal Date:  %s                                               Meal Number:  %d\n\n",meal_date,meal);
for ( ; ; )
 {
 if (strcmp(meal_date,meal_ptr->meal_date) == 0 && meal == meal_ptr->meal) 
  {
  count++;
  strncpy(namebuf,meal_ptr->name,60); namebuf[60] = '\0';
  printf("%2d. %-60s     %8.1f oz\n",count,namebuf,meal_ptr->grams/28.35);
  }
 if (meal_ptr->next == NULL) break;
 meal_ptr = meal_ptr->next;
 }
if (count == 0) 
 {
 printf("\n\n\nNo foods have yet been recorded for this meal.\n");
 spacer(6);
 return 0;
 } 
spacer(count + 2);
return 1;
}

void food_show(struct food *food_ptr, float *ratio)
{
char servingstring[62];
int count;
if (*ratio > 1 || (*ratio > 0 && *ratio < 1))
 {
 sprintf(servingstring,"%5.1f x %-43s",*ratio,food_ptr->serving);
 servingstring[51] = '\0';
 }
printf("%s\n",food_ptr->name);
if (*ratio == 1) printf("Serving:  %-50s   Grams:  %6.2f\n",food_ptr->serving,food_ptr->grams * *ratio);
else printf("Serving:  %-51s  Grams:  %6.2f\n",servingstring,food_ptr->grams * *ratio);
                 printf("          %-50s  Ounces:  %6.2f\n"," ",*ratio * food_ptr->grams / 28.35);
printf("Percentages of RDI in this serving:\n\n");
for (count = 0; count < NutrientCount; count++) food_work.nutrient[count] = *ratio * 100 * food_ptr->nutrient[count] / Rdi[count]; 
food_display();
spacer(20);
}

struct food *food_number(int i)
{
int count;
struct food *food_ptr = &food_root;
for (count = -1; count < i; count++) food_ptr = food_ptr->next;
return food_ptr;
}

struct food *meal_find(char *meal_date,int meal)
{
struct food *meal_ptr = &meal_root;
while (meal_ptr->next != NULL)
 {
 meal_ptr = meal_ptr->next;
 if (strcmp(meal_ptr->meal_date,meal_date) == 0 && meal_ptr->meal == meal) return meal_ptr;
 }
return NULL;
}

void delete_meal_food(char *meal_date, int meal, int num)
{
struct food *m, *meal_ptr = &meal_root;
int count = 0;
while (meal_ptr->next != NULL)
 {
 if (strcmp(meal_date,meal_ptr->next->meal_date) == 0 && meal == meal_ptr->next->meal) 
  {
  count++;
  if (count == num)
   {
   m = meal_ptr->next;
   meal_ptr->next = meal_ptr->next->next;
   free(m);
   return;
   }
  }
 meal_ptr = meal_ptr->next;
 }
}

int meal_count()
{
struct food *meal_ptr = &meal_root;
int count = 0;
char lastdate[7];
int lastmeal;
if (meal_root.next == NULL) return 0;
meal_ptr = meal_root.next;
strcpy(lastdate,meal_ptr->meal_date);
lastmeal = meal_ptr->meal;
count = 1;
while ((meal_ptr = meal_ptr->next))
 {
 if (strcmp(lastdate,meal_ptr->meal_date) != 0 || lastmeal != meal_ptr->meal)
  {
  count++;
  strcpy(lastdate,meal_ptr->meal_date);
  lastmeal = meal_ptr->meal;
  }
 } 
return count;
}

int meal_food_count()
{
struct food *meal_ptr = &meal_root;
int count = 0;
if (meal_root.next == NULL) return 0;
meal_ptr = meal_root.next;
count = 1;
while ((meal_ptr = meal_ptr->next)) count++;
return count;
}

void clear_work()
{
int count;
for (count = 0; count < NutrientCount; count++) food_work.nutrient[count] = 0;
food_work.grams = 0;
}

void food_display()
{
float calsfromfat = 0, calsfromcarb = 0, calsfromprot = 0, correction;
if (food_work.nutrient[0] != 0)
 {
 calsfromfat = (int) (float) (food_work.nutrient[2]*Rdi[2]*8.8235294) / (food_work.nutrient[0]*Rdi[0]/100);
 calsfromcarb = (int) (float) ((food_work.nutrient[3]*Rdi[3]) - (food_work.nutrient[4]*Rdi[4]))* 4.175 / (food_work.nutrient[0]*Rdi[0]/100);
 calsfromprot = (int) (float) (food_work.nutrient[1]*Rdi[1]*4.175) / (food_work.nutrient[0]*Rdi[0]/100);
 calsfromfat = ceil(calsfromfat);
 calsfromprot = ceil(calsfromprot);
 calsfromcarb = ceil(calsfromcarb);
 correction = calsfromfat + calsfromcarb + calsfromprot - 100;
 if (calsfromcarb - correction >= 0) calsfromcarb -= correction;
 else if (calsfromprot - correction >= 0) calsfromprot -= correction;
 else calsfromfat -= correction;
 }
printf("%-13s  %5.0f%%        %-13s  %5.0f%%        %-13s  %5.0f%%\n",Nutrient[0],food_work.nutrient[0],Nutrient[1],food_work.nutrient[1],Nutrient[2],food_work.nutrient[2]);
printf("%-12s                 %-13s  %5.0f%%        %-13s  %5.0f%%\n"," ",Nutrient[3],food_work.nutrient[3],Nutrient[25],food_work.nutrient[25]);
printf("Cals from Fat:   %3.0f%% %6s %-13s  %5.0f%%        %-13s  %5.0f%%\n",calsfromfat," ",Nutrient[4],food_work.nutrient[4],Nutrient[26],food_work.nutrient[26]);
printf("Cals from Carb:  %3.0f%% %6s %-13s  %5.0f%%        %-13s  %5.0f%%\n",calsfromcarb," ",Nutrient[29],food_work.nutrient[29],Nutrient[27],food_work.nutrient[27]);
printf("Cals from Prot:  %3.0f%% %6s %-13s  %5.0f%%        %-13s  %5.0f%%\n",calsfromprot," ",Nutrient[30],food_work.nutrient[30],Nutrient[28],food_work.nutrient[28]);
printf("\n");
printf("%-13s  %5.0f%%        %-13s  %5.0f%%        %-13s  %5.0f%%\n",Nutrient[15],food_work.nutrient[15],Nutrient[20],food_work.nutrient[20],Nutrient[23],food_work.nutrient[23]);
printf("%-13s  %5.0f%%        %-13s  %5.0f%%        %-13s  %5.0f%%\n",Nutrient[17],food_work.nutrient[17],Nutrient[21],food_work.nutrient[21],Nutrient[24],food_work.nutrient[24]);
printf("%-13s  %5.0f%%        %-13s  %5.0f%%        %-13s  %5.0f%%\n",Nutrient[18],food_work.nutrient[18],Nutrient[22],food_work.nutrient[22],Nutrient[16],food_work.nutrient[16]);
printf("%-13s  %5.0f%%\n",Nutrient[19],food_work.nutrient[19]);
printf("\n");
printf("%-13s  %5.0f%%        %-13s  %5.0f%%        %-13s  %5.0f%%\n",Nutrient[5],food_work.nutrient[5],Nutrient[13],food_work.nutrient[13],Nutrient[14],food_work.nutrient[14]);
printf("%-13s  %5.0f%%        %-13s  %5.0f%%        %-13s  %5.0f%%\n",Nutrient[12],food_work.nutrient[12],Nutrient[6],food_work.nutrient[6],Nutrient[8],food_work.nutrient[8]);
printf("%-13s  %5.0f%%        %-13s  %5.0f%%        %-13s  %5.0f%%\n",Nutrient[7],food_work.nutrient[7],Nutrient[9],food_work.nutrient[9],Nutrient[11],food_work.nutrient[11]);
printf("%-13s  %5.0f%%\n",Nutrient[10],food_work.nutrient[10]);
}

void delete_recipe_food(int num)
{
struct food *m, *recipe_ptr = &recipe_root;
int count = 0;
while (recipe_ptr->next != NULL)
 {
 count++;
 if (count == num)
  {
  m = recipe_ptr->next;
  recipe_ptr->next = recipe_ptr->next->next;
  free(m);
  return;
  }
 recipe_ptr = recipe_ptr->next;
 }
}

void delete_meals(int keep)
{
struct food *meal_ptr = &meal_root, *last_meal_ptr = NULL;
int count = 0;
char meal_date[7], meal = 0;
if (keep < 0) return;
strcpy(meal_date,"");
while (count <= keep && meal_ptr->next != NULL)
 {
 last_meal_ptr = meal_ptr;
 meal_ptr = meal_ptr->next;
 if (strcmp(meal_date,meal_ptr->meal_date) != 0  || meal != meal_ptr->meal) 
  {
  count++;
  strcpy(meal_date,meal_ptr->meal_date);
  meal = meal_ptr->meal;
  }
 }  
if (count <= keep) return;
last_meal_ptr->next = NULL;
while (meal_ptr != NULL)
 {
 last_meal_ptr = meal_ptr;
 meal_ptr = meal_ptr->next;
 free(last_meal_ptr);
 }
}
