/* db.c */

/*
    Nut nutrition software 
    Copyright (C) 1998 Jim Jozwiak.

    Source code OS/2 adaptation by Michele Della Guardia
    E-mail : mikedg@ghostbbs.ml.org
    Team OS/2 Italy

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "db.h"
#include "food.h"
#include "options.h"
#include "util.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
 
#ifndef NUTDIR
char nutdir1[]=".\.";
#else
char nutdir1[]=NUTDIR ;
#endif

char rawfoodfile1[] = "abbrev.txt";
char rawnutfoodfile1[] = "nutfood.txt";
char foodfile1[] = "food.db";
char mealfile1[] = "meal.db";
char optionsfile1[] = "options.db";

char rawfoodfile[2000];
char rawnutfoodfile[2000];
char foodfile[2000];
char mealfile[2000];
char optionsfile[2000];

FILE *fp;

void read_raw_food_db() 
{
char buffer[700];
char *bufptr;
char *fieldptr;
int count, foodcount = 0, junk;
float ratio, weight2;
if ((fp = fopen(rawfoodfile,"r")) == NULL)
 {
 printf("Can't open food file \"%s\" to create food database.\n",rawfoodfile);
 printf("Press <enter> to continue...");
 junk = get_int();
 abort();
 }
printf("Reading food file and creating NUT database. Please wait...");
while (fgets(buffer,700,fp) != NULL)
 {
 if ((new_food = malloc(sizeof(struct food))) == NULL)
  {
  printf("We are out of memory.  Bummer.\n");
  abort();
  }
 bufptr = buffer ;
 bufptr += 9;                  /* bypass food id number */
 fieldptr = new_food->name;
 while (*bufptr != '~')
  {
  *fieldptr++ = *bufptr++ ;
  }
 *fieldptr = '\0' ; bufptr +=2 ;
 bufptr += strcspn(bufptr,"^"); bufptr++ ; /* bypass water value */ 
 count = 0;
 while (count < 5)
  {
  fieldptr = bufptr ;
  while (*bufptr != '^' ) bufptr++ ;
  *bufptr = '\0'; bufptr++ ;
  new_food->nutrient[count] = (float) atof(fieldptr);
  count++;
  }
 bufptr += strcspn(bufptr,"^"); bufptr++ ; /* bypass ash value */ 
 while (count < NutrientCount)
  {
  fieldptr = bufptr ;
  while (*bufptr != '^' ) bufptr++ ;
  *bufptr = '\0'; bufptr++ ;
  new_food->nutrient[count] = (float) atof(fieldptr);
  count++;
  }
 fieldptr = bufptr;
 while (*bufptr != '^' ) bufptr++ ;
 *bufptr = '\0'; bufptr++ ;
 new_food->grams = (float) atof(fieldptr);
 if (new_food->grams == 0) new_food->grams = 100;
 fieldptr = ++bufptr;
 while (*bufptr != '~' ) bufptr++ ;
 *bufptr = '\0'; bufptr += 2 ;
 strncpy(new_food->serving,fieldptr,50); new_food->serving[50] = '\0';
 fieldptr = bufptr;
 while (*bufptr != '^' ) bufptr++ ;
 *bufptr = '\0'; bufptr++ ;
/* is second household weight smaller? */
 weight2 = (float) atof(fieldptr);
 if (weight2 < new_food->grams && weight2 > 0)
  {
  new_food->grams = weight2;
  fieldptr = ++bufptr;
  while (*bufptr != '~' ) bufptr++ ;
  *bufptr = '\0'; bufptr += 2 ;
  strncpy(new_food->serving,fieldptr,50); new_food->serving[50] = '\0';
  }
 else
  {
  fieldptr = ++bufptr;
  while (*bufptr != '~' ) bufptr++ ;
  *bufptr = '\0'; bufptr += 2 ;
  }
 fieldptr = ++bufptr;
 new_food->refuse = (float) atof(fieldptr);
 ratio = new_food->grams / 100;
 for (count = 0 ; count < NutrientCount ; count++) new_food->nutrient[count] *= ratio;
 order_new_food();
 foodcount++;
 }
fclose(fp);
FoodCount += foodcount;
write_food_db();
}

int read_food_db()
{
int block, foodcount = 0;
struct food *food_ptr = &food_root;
if ((fp = fopen(foodfile,"r")) == NULL) return 0;
for ( ; ; )
 {
 if ((new_food = malloc(sizeof(struct food))) == NULL)
  {
  printf("Bad news.  We are out of memory...");
  abort();
  }
 if ((block = fread(new_food,sizeof(struct food),1,fp)) != 0)
  {
  food_ptr->next = new_food;
  food_ptr = new_food;
  foodcount++;
  }
 else break;
 }
fclose(fp);
FoodCount += foodcount;
return 1;
}

void read_meal_db()
{
int block;
struct food *meal_ptr = &meal_root;
if ((fp = fopen(mealfile,"r")) == NULL)
 {
 write_meal_db();
 }
for ( ; ; )
 {
 if ((new_meal = malloc(sizeof(struct food))) == NULL)
  {
  printf("Bad news.  We are out of memory...");
  abort();
  }
 if ((block = fread(new_meal,sizeof(struct food),1,fp)) != 0)
  {
  meal_ptr->next = new_meal;
  meal_ptr = new_meal;
  }
 else break;
 }
fclose(fp);
}

void write_meal_db()
{
int block;
struct food *meal_ptr = &meal_root;
if ((fp = fopen(mealfile,"w")) == NULL)
 {
 printf("Can't open meal database %s to write.\n",mealfile);
 abort();
 }
while (meal_ptr -> next != NULL)
 {
 meal_ptr = meal_ptr -> next;
 if ((block = fwrite(meal_ptr,sizeof(struct food),1,fp)) != 1)
  {
  printf("Cannot write to the disk.  Aborting...\n");
  abort();
  }
 }
fclose(fp);
}

void write_food_db()
{
int block;
struct food *food_ptr = &food_root;
if ((fp = fopen(foodfile,"w")) == NULL)
 {
 printf("Can't open food database %s to write.\n",foodfile);
 abort();
 }
while (food_ptr -> next != NULL)
 {
 food_ptr = food_ptr -> next;
 if ((block = fwrite(food_ptr,sizeof(struct food),1,fp)) != 1)
  {
  printf("Cannot write to the disk.  Aborting...\n");
  abort();
  }
 }
fclose(fp);
}

void write_nut_raw_food_file()
{
char buffer[700], numbuf[11];
int block, c;
if ((fp = fopen(rawnutfoodfile,"a")) == NULL)
 {
 printf("Can't open nut food file %s to append.\n",rawnutfoodfile);
 abort();
 }
strcpy(buffer,"~99999~^~\0");
strcat(buffer,food_work.name);
strcat(buffer,"~^^\0");
for (c = 0 ; c < 5 ; c++)
 {
 sprintf(numbuf,"%5.3f^",100 * food_work.nutrient[c] / food_work.grams);
 strcat(buffer,numbuf);
 }
strcat(buffer,"^\0");
for (c = 5 ; c < NutrientCount ; c++)
 {
 sprintf(numbuf,"%5.3f^",100 * food_work.nutrient[c] / food_work.grams);
 strcat(buffer,numbuf);
 }
sprintf(numbuf,"%5.2f^",food_work.grams);
strcat(buffer,numbuf);
strcat(buffer,"~\0");
strcat(buffer,food_work.serving);
strcat(buffer,"~^^~~^");
sprintf(numbuf,"%2.0f^",food_work.refuse);
strcat(buffer,numbuf);
strcat(buffer,"\n\0");
c = strlen(buffer);
if ((block = fwrite(buffer,c,1,fp)) != 1)
 {
 printf("Cannot write to the disk.  Aborting...\n");
 abort();
 }
fclose(fp);
}

void read_nut_raw_food_file() 
{
char buffer[700];
char *bufptr;
char *fieldptr;
int count, foodcount = 0;
float ratio, weight2;
if ((fp = fopen(rawnutfoodfile,"r")) == NULL) return;
printf("Reading nut food file \"%s\" to add to food database \"%s\"...\n",rawnutfoodfile,foodfile);
while (fgets(buffer,700,fp) != NULL)
 {
 if ((new_food = malloc(sizeof(struct food))) == NULL)
  {
  printf("We are out of memory.  Bummer.\n");
  abort();
  }
 bufptr = buffer ;
 bufptr += 9;                  /* bypass food id number */
 fieldptr = new_food->name;
 while (*bufptr != '~')
  {
  *fieldptr++ = *bufptr++ ;
  }
 *fieldptr = '\0' ; bufptr +=2 ;
 bufptr += strcspn(bufptr,"^"); bufptr++ ; /* bypass water value */ 
 count = 0;
 while (count < 5)
  {
  fieldptr = bufptr ;
  while (*bufptr != '^' ) bufptr++ ;
  *bufptr = '\0'; bufptr++ ;
  new_food->nutrient[count] = (float) atof(fieldptr);
  count++;
  }
 bufptr += strcspn(bufptr,"^"); bufptr++ ; /* bypass ash value */ 
 while (count < NutrientCount)
  {
  fieldptr = bufptr ;
  while (*bufptr != '^' ) bufptr++ ;
  *bufptr = '\0'; bufptr++ ;
  new_food->nutrient[count] = (float) atof(fieldptr);
  count++;
  }
 fieldptr = bufptr;
 while (*bufptr != '^' ) bufptr++ ;
 *bufptr = '\0'; bufptr++ ;
 new_food->grams = (float) atof(fieldptr);
 if (new_food->grams == 0) new_food->grams = 100;
 fieldptr = ++bufptr;
 while (*bufptr != '~' ) bufptr++ ;
 *bufptr = '\0'; bufptr += 2 ;
 strncpy(new_food->serving,fieldptr,50); new_food->serving[50] = '\0';
 fieldptr = bufptr;
 while (*bufptr != '^' ) bufptr++ ;
 *bufptr = '\0'; bufptr++ ;
/* is second household weight smaller? */
 weight2 = (float) atof(fieldptr);
 if (weight2 < new_food->grams && weight2 > 0)
  {
  new_food->grams = weight2;
  fieldptr = ++bufptr;
  while (*bufptr != '~' ) bufptr++ ;
  *bufptr = '\0'; bufptr += 2 ;
  strncpy(new_food->serving,fieldptr,50); new_food->serving[50] = '\0';
  }
 else
  {
  fieldptr = ++bufptr;
  while (*bufptr != '~' ) bufptr++ ;
  *bufptr = '\0'; bufptr += 2 ;
  }
 fieldptr = ++bufptr;
 new_food->refuse = (float) atof(fieldptr);
 ratio = new_food->grams / 100;
 for (count = 0 ; count < NutrientCount ; count++) new_food->nutrient[count] *= ratio;
 order_new_food();
 foodcount++;
 }
fclose(fp);
FoodCount += foodcount;
write_food_db();
}

void write_options_db()
{
int block;
if ((fp = fopen(optionsfile,"w")) == NULL)
 {
 printf("Can't open options database \"%s\" to write.\n",optionsfile);
 printf("Press <enter> to continue...");
 block = get_int();
 abort();
 }
if ((block = fwrite(&options,sizeof(struct opt),1,fp)) != 1)
 {
 printf("Cannot write to the disk.  Aborting...\n");
 abort();
 }
fclose(fp);
}

void read_options_db()
{
int block;
float ratio;
if ((fp = fopen(optionsfile,"r")) == NULL)
 {
 write_options_db();
 return;
 }
if ((block = fread(&options,sizeof(struct opt),1,fp)) != 0)
 {
 fclose(fp);
 ratio = options.calopt / RdiBase[0];
 Rdi[0] *= ratio;
 Rdi[2] *= ratio;
 Rdi[3] *= ratio;
 Rdi[4] *= ratio;
 Rdi[25] *= ratio;
 Rdi[26] *= ratio;
 Rdi[27] *= ratio;  
 Rdi[29] *= ratio;  
 Rdi[30] *= ratio;  
 delete_meals(options.delopt);
 write_meal_db();
 }
}

void make_filenames(void)
{
sprintf(rawfoodfile,"%s/%s/%s",getenv("HOME"),nutdir1,rawfoodfile1);
sprintf(rawnutfoodfile,"%s/%s/%s",getenv("HOME"),nutdir1,rawnutfoodfile1);
sprintf(foodfile,"%s/%s/%s",getenv("HOME"),nutdir1,foodfile1);
sprintf(mealfile,"%s/%s/%s",getenv("HOME"),nutdir1,mealfile1);
sprintf(optionsfile,"%s/%s/%s",getenv("HOME"),nutdir1,optionsfile1);
}                             
