/*
    Nut nutrition software 
    Copyright (C) 1998 Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "anameal.h"
#include "food.h"
#include "util.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>

void analyze_meals()
{
struct food *food_ptr, *meal_ptr, *food_ptr_abacus[FoodCount];
struct food *food_recommended[18];
int meals, count, mealcount, meal = 0, max, deficnuts;
int prodefic, abacuscount, spacecount, frcount, high_grams;
char meal_date[7], inbuf[128], *servptr, servbuf[61];
float deficpct[NutrientCount], food_abacus[FoodCount], serving_ratio_abacus[FoodCount];
int deficnut[NutrientCount];
float thispct, totaldefic, serving_ratio;
mealcount = meal_count();
if (mealcount == 0)
 {
 header("NUT:  Analyze Meals");
 spacer(0);
 printf("\nThere are no meals in database.  Press <enter> to continue..."); 
 count = get_int();
 return;
 }
max = mealcount;
while (max > 0)
 {
 meal_ptr = &meal_root;
 strcpy(meal_date,"");
 if (max > mealcount) max = mealcount;
 meals = 0;
 header("NUT:  Analyze Meals");
 if (max != 1) printf("Here are RDI average percentages for your previous %d meals:\n\n",max);
 else printf("Here are RDI average percentages for your previous 1 meal:\n\n");
 clear_work();
 while (meal_ptr->next != NULL && meals <= max)
  {
  meal_ptr = meal_ptr->next;
  if (strcmp(meal_date,meal_ptr->meal_date) != 0 || meal != meal_ptr->meal)
   {
   strcpy(meal_date,meal_ptr->meal_date);
   meal = meal_ptr->meal;
   meals++;
   }
  if (meals > max) break;
  for (count = 0; count < NutrientCount; count++) food_work.nutrient[count] = food_work.nutrient[count] + ((300 * meal_ptr->nutrient[count]) / (Rdi[count] * max)); 
  }
 food_display();
 spacer(17);
 printf("Type number of meals to analyze or \"s\" for food suggestions.\n");
 printf("Just press <enter> to quit:  ");
 get_string(inbuf,127);
 if (strncmp(inbuf,"s",1) == 0)
  {
  header("NUT:  Food Suggestions");
  deficnuts = -1;
  totaldefic = 0;
  for (count = 0; count < NutrientCount; count++) 
   {
   if (count == 0 || count == 1 || count == 2 || count == 3 || count == 8 || count == 25 || 
      count == 26 || count == 27 || count == 28 || 
      100 - food_work.nutrient[count] <= 0) deficpct[count] = 0;
   else 
    {
    deficnuts++;
    deficnut[deficnuts] = count;
    deficpct[deficnuts] = (((float) max) / 3) * (100 - food_work.nutrient[count]);
    totaldefic += deficpct[deficnuts];
    }
   }
  if (deficnuts > 0) deficsort(deficpct, deficnut, deficnuts);
  if (deficnuts == -1 || deficpct[0] == 0)
   {
   printf("You have achieved the RDI for all nutrients.");
   spacer(0);
   printf("\nPress <enter> to continue..."); 
   count = get_int();
   return;        
   }
  printf("Here are those nutrients with additional daily percentages in the RDI:\n\n");
  spacecount = 0;
  for (count = 0; count <= deficnuts; count++) 
   {
   if (totaldefic >= 1) printf("%-31s%-13s %3.0f%%\n"," ",Nutrient[deficnut[count]],deficpct[count]);
   else printf("%-31s%-13s %f%%\n"," ",Nutrient[deficnut[count]],deficpct[count]);
   if (deficnuts > count && count == 16) printf("%-31s%-23s\n"," ","plus additional nutrients...");
   if (deficnuts > count && count == 16) break;
   }
  spacer(deficnuts + 3);
  printf("\nPress <enter> to continue..."); 
  count = get_int();
  header("NUT:  Food Suggestions");
  printf("Here are randomly selected foods that provide the additional nutrients noted:\n\n");
  frcount = -1;
  while (totaldefic > 0)
   {
   food_ptr = &food_root;
   abacuscount = -1;
   while (food_ptr->next != NULL)
    {
    food_ptr = food_ptr->next;
    food_ptr_abacus[++abacuscount] = food_ptr;
    prodefic = 0;
    serving_ratio_abacus[abacuscount] = 10;
    high_grams = 114;
    for (count = 0; count <= deficnuts; count++)
     {
     thispct = 100 * food_ptr->nutrient[deficnut[count]] / Rdi[deficnut[count]]; 
     serving_ratio = deficpct[count] / thispct;
     if (serving_ratio < serving_ratio_abacus[abacuscount] && serving_ratio * food_ptr->grams > 14) serving_ratio_abacus[abacuscount] = serving_ratio;
     }
    servptr = strcpy(servbuf,food_ptr->serving);
    servptr = strtok(servbuf," ");
    while (servptr != NULL)
     {
     if (strcmp("fl",servptr) == 0) high_grams = 228;
     servptr = strtok(NULL," ");
     }
    servptr = strcpy(servbuf,food_ptr->name);
    servptr = strtok(servbuf,",");
    while (servptr != NULL)
     {
     if (strcmp("DEHYD",servptr) == 0 || strcmp("DRY",servptr) == 0) high_grams = 114;
     servptr = strtok(NULL,",");
     }
    servptr = strcpy(servbuf,food_ptr->name);
    servptr = strtok(servbuf,",");
    while (servptr != NULL)
     {
     if (strcmp("FROZEN DSSRT",servptr) == 0) high_grams = 114;
     servptr = strtok(NULL,",");
     }
    servptr = strcpy(servbuf,food_ptr->name);
    servptr = strtok(servbuf,",");
    while (servptr != NULL)
     {
     if (strcmp("CEREALS RTE",servptr) == 0) serving_ratio_abacus[abacuscount] = 0;
     if (strcmp("CEREALS",servptr) == 0)
      {
      servptr = strtok(NULL,",");
      if (strcmp("RTE",servptr) == 0) serving_ratio_abacus[abacuscount] = 0;
      }
     servptr = strtok(NULL,",");
     }
    servptr = strcpy(servbuf,food_ptr->name);
    servptr = strtok(servbuf,",");
    while (servptr != NULL)
     {
     if (strcmp("INFANT FORMULA",servptr) == 0 || strcmp("CHILD FORMULA",servptr) == 0 || strcmp("BABYFOOD",servptr) == 0) serving_ratio_abacus[abacuscount] = 0;
     servptr = strtok(NULL,",");
     }   
    if (serving_ratio_abacus[abacuscount] > 1 && high_grams == 114) serving_ratio_abacus[abacuscount] = 1;
    if ((serving_ratio_abacus[abacuscount] * food_ptr->grams) > high_grams) serving_ratio_abacus[abacuscount] = high_grams / food_ptr->grams;
    for (count = 0; count <= deficnuts; count++)
     {
     thispct = serving_ratio_abacus[abacuscount] * 100 * food_ptr->nutrient[deficnut[count]] / Rdi[deficnut[count]]; 
     if (thispct > deficpct[count]) thispct = deficpct[count];
     prodefic += thispct;
     }
    if (serving_ratio_abacus[abacuscount] == 0) prodefic = 0;
    food_abacus[abacuscount] = prodefic;
    for (count = 0 ; count <= frcount; count++) if (food_ptr_abacus[abacuscount] == food_recommended[count]) food_abacus[abacuscount] = -1;
    }
   abacuscount = random_max_var_array(food_abacus, abacuscount);
   food_ptr = food_ptr_abacus[abacuscount];            
   food_recommended[++frcount] = food_ptr;
   printf("%4.0f gm or %4.1f oz %-60s\n",serving_ratio_abacus[abacuscount] * food_ptr->grams,serving_ratio_abacus[abacuscount] * food_ptr->grams / 28.35,food_ptr->name);
   spacecount++;
   totaldefic = 0;
   for (count = 0; count <= deficnuts; count++) 
    {
    thispct = serving_ratio_abacus[abacuscount] * 100 * food_ptr->nutrient[deficnut[count]] / Rdi[deficnut[count]]; 
    if (thispct > deficpct[count]) thispct = deficpct[count];
    deficpct[count] -= thispct;
    totaldefic += deficpct[count];
    }
   }
  spacer(++spacecount);
  printf("Press <enter> to continue...");
  count = get_int();
  }
 else max = atoi(inbuf);
 }
}

void deficsort(float *deficpct, int *deficnut, int deficnuts)
{
int count, subcount, tempint;
float tempfloat;
for (count = 0 ; count < deficnuts ; count++)
 {
 for (subcount = count + 1 ; subcount <= deficnuts ; subcount++)
  {
  if (deficpct[subcount] > deficpct[count])
   {
   tempfloat = deficpct[count];
   deficpct[count] = deficpct[subcount];
   deficpct[subcount] = tempfloat;
   tempint = deficnut[count];
   deficnut[count] = deficnut[subcount];
   deficnut[subcount] = tempint;
   }
  }
 }
}

int random_max_var_array(float abacus[], int last)
{
int count, i = 0, max_count = 0, rand_count;
unsigned seed;
time_t t;
for ( count = 1 ; count < last ; count++ )
 {
 if (abacus[count] > abacus[i])
  {
  i = count;
  max_count = 1;
  }
 else if (abacus[count] == abacus[i]) max_count++;
 }
time(&t);
seed = (unsigned) t;
srand(seed);
rand_count = rand() % max_count;
for (count = 0 ; count < last ; count++)
 {
 if (abacus[count] == abacus[i]) rand_count--;
 if (rand_count < 0) return count;
 }
return i;
}
