/* addreci.c */

/*
    Nut nutrition software 
    Copyright (C) 1998 Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "addreci.h"
#include "food.h"
#include "util.h"
#include "db.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

void add_recipes()
{
struct food *food_ptr = &food_root;
char key[61];
int c, delfood, junk, likeit = 'n';
float ratio, one = 1, servings = 0;
key[0] = '\0';
key_clean();
while (likeit == 'N' || likeit == 'n')
 {
 header("NUT:  Add Recipes");
 spacer(-1);
 printf("Type name of new recipe (or <enter> to quit):  ");
 get_string(food_work.name,60);
 if (strcmp(food_work.name,"") == 0) return;
 junk = strlen(food_work.name);
 for (c = 0 ; c < junk ; c++) food_work.name[c] = toupper(food_work.name[c]);
 for (c = junk ; c >= 0 ; c--)
  {
  if (food_work.name[c] == ' ') food_work.name[c] = '\0';
  else break;
  }
 while (food_ptr->next != NULL)
  {
  food_ptr = food_ptr->next;
  if (food_work.name[0] == food_ptr->name[0]) if (strcmp(food_work.name,food_ptr->name) == 0)
  {
   get_string(food_work.name,60);
   for (c = 0 ; c < 60 ; c++) food_work.name[c] = toupper(food_work.name[c]);
   food_ptr = &food_root;
   }
  }
 header("NUT:  Add Recipes");
 spacer(0);
 printf("Recipe name is \"%-s.\"\n",food_work.name);
 printf("Is this correct?  (y/n):  ");
 likeit = get_char();
 }
if (strcmp(food_work.name,"") == 0) return;
for ( ; ; )
 {
 for ( ; ; )
  {
  if (recipe_root.next != NULL)
   {
   header("NUT:  Add Recipes");
   if (! recipe_show())
    {
    printf("\nPress <enter> to continue...");
    junk = get_int();
    }
   else
    {
    printf("\nEnter number to delete or name of next food (or <enter> to quit):  ");
    get_string(key,60);
    if (strcmp(key,"") == 0)
     {
     header("NUT:  Add Recipes");
     recipe_show();
     printf("\nDo you want to save recipe in the food database?  (y/n):  ");
     junk = get_char();
     if (junk == 'n' || junk == 'N')
      {
      while (recipe_root.next != NULL) delete_recipe_food(1);
      return;
      }
     header("NUT:  Add Recipes");
     recipe_show();
     printf("\nDo you want to add more foods to recipe?  (y/n):  ");
     junk = get_char();
     if (junk == 'y' || junk == 'Y') continue;
     clear_work();
     food_ptr = &recipe_root;
     while (food_ptr->next != NULL)
      {
      food_ptr = food_ptr->next;
      for (c = 0; c < NutrientCount; c++) food_work.nutrient[c] += 100 * food_ptr->nutrient[c] / Rdi[c]; 
      food_work.grams += food_ptr->grams;
      }
     while (recipe_root.next != NULL) delete_recipe_food(1);
     while (servings <= 0)
      {
      header("NUT:  Add Recipes");
      new_recipe_show();
      printf("\nHow many servings does this recipe make?  ");
      get_string(key,60);
      servings = atof(key);
      if (servings <= 0) continue;
      header("NUT:  Add Recipes");
      new_recipe_show();
      printf("\nIs \"%-s\" the correct number of servings for this recipe?  (y/n)  ",key);
      junk = get_char();
      if (junk == 'N' || junk == 'n') servings = 0; 
      }
     for (c = 0; c < NutrientCount; c++) food_work.nutrient[c] /= servings; 
     food_work.grams /= servings;
     new_recipe_show();
     printf("\nPlease enter description of serving size:  ");
     get_string(food_work.serving,50); 
     new_recipe_show();
     printf("\nWould you like to change weight of serving?  (y/n):  ");
     junk = get_char();
     if (junk == 'y' || junk == 'Y')
      {
      junk = 'n';
      while (junk == 'n' || junk == 'N')
       {
       new_recipe_show();
       printf("\nType new weight of serving {xxxg for grams, xxxo for oz}:  ");
       get_recipe_qty(&food_work.grams);
       new_recipe_show();
       printf("\nIs weight now correct?  (y/n):  ");
       junk = get_char();
       }
      }
     if ((new_food = malloc(sizeof(struct food))) == NULL)
      {
      printf("We are out of memory.  Bummer.\n");
      abort();
      } 
     for (c = 0; c < NutrientCount; c++) food_work.nutrient[c] *= Rdi[c] / 100; 
     memcpy(new_food,&food_work,sizeof(struct food));
     order_new_food();
     FoodCount++;
     write_food_db();
     write_nut_raw_food_file();
     for (c = 0; c < NutrientCount; c++) food_work.nutrient[c] *= 100 / Rdi[c]; 
     new_recipe_show();
     printf("\nRecipe saved in food database.  Press <enter> to continue...  ");
     junk = get_int();
     food_work.name[0] = '\0';
     food_work.serving[0] = '\0';
     return;
     }
    }
   }
  delfood = atoi(key);
  if (strcmp(key,"") == 0 || delfood == 0) break;
  delete_recipe_food(delfood);
  strcpy(key,"");
  }
 ratio = -38;
 while (ratio < 0)
  {
  key_put(key);
  food_ptr = food_choice("NUT:  Add Recipes");
  if (food_ptr == (struct food *) -1) return;
  if (food_ptr == (struct food *)  0) key_clean();
  if (food_ptr == (struct food *)  0) continue;
  header("NUT:  Add Recipes");
  food_show(food_ptr, &one);
  printf("\nType # of servings {xxxg for grams, xxxo for oz, \"b\" for back}:  ");
  get_qty(&ratio, &(food_ptr->grams));
  if (ratio < 0)
   {
   key_take();
   strcpy(key,key_take());
   }
  }
 if (ratio == 0)
  {
  key_clean();
  strcpy(key,"");
  }
 if (ratio > 0)
  {
  key_clean();
  strcpy(key,"");
  if ((new_recipe = malloc(sizeof(struct food))) == NULL)
   {
   printf("We are out of memory.  Bummer.\n");
   abort();
   } 
  memcpy(new_recipe,food_ptr,sizeof(struct food));
  new_recipe->grams *= ratio;
  for (c = 0; c < NutrientCount; c++) new_recipe->nutrient[c] *= ratio; 
  order_new_recipe();
  }
 }
}

void new_recipe_show()
{
header("NUT:  Add Recipes");
printf("%s\n",food_work.name);
printf("Serving:  %-50s     Grams:  %6.2f\n",food_work.serving,food_work.grams);
printf("          %-50s    Ounces:  %6.2f\n"," ",food_work.grams / 28.35);
printf("Percentages of RDI in this serving:\n\n");
food_display();
spacer(20);
}

void get_recipe_qty(float *result)
{
char buff[128];
gets(buff);
if (strchr(buff,'g') != NULL) *result = (float) atof(buff);
else if (strchr(buff,'o') != NULL) *result = (float) atof(buff) * 28.35;
else *result = ((float) 0);
}

int recipe_show()
{
struct food *recipe_ptr = &recipe_root;
int count = 0;
printf("Recipe Name:  %-s\n\n",food_work.name);
while (recipe_ptr->next != NULL)
 {
 recipe_ptr = recipe_ptr->next;
 count++;
 printf("%2d. %-60s     %8.1f oz\n",count,recipe_ptr->name,recipe_ptr->grams/28.35);
 }
if (count == 0) 
 {
 printf("\n\n\nNo foods have yet been recorded for this recipe.\n");
 spacer(6);
 return 0;
 } 
spacer(count + 2);
return 1;
}
