/***************************************************************/
/*                  WELC21.CMD                                 */
/*                                                             */
/*      This Rexx file recreates the Preinstalled Essentials   */
/*      Folder and all of its utilities on OS/2 V2.1           */
/*      Preloaded Systems. If the Executable files that are    */
/*      associated with the Preinstalled Essentials Folder are */
/*      removed from the hard drive, this program will not     */
/*      completely restore the Preinstalled Essentials Folder  */
/*      to its original state.                                */
/*                                                             */
/*      This is an updated utility to work specifically with   */
/*      OS/2 V2.1 Preloaded Systems.  The previous utility     */
/*      that Welc21.Cmd is replacing is named Welcome.Cmd.     */
/*      Welcome.Cmd should still be used for OS/2 V2.0         */
/*      Preloaded Systems to recreate the Welcome Folder.      */
/*                                                             */
/*                      Shawn McAlhany                         */
/*                     29-30 July 1993                            */
/***************************************************************/

/***************************************************************/
/* This procedure explains the utility to the user and calls   */
/* other procedures to continue or terminate the program.      */
/***************************************************************/

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs                /* register system functions */
address cmd 'echo off'          /* echo is turned off */

'cls'
say
say
say '     *   *   *  *******  *        *******  *******  *     *  *******'
say '      * * * *   *        *        *        *     *  **   **  *'
say '      * * * *   *******  *        *        *     *  * * * *  *******'
say '      * * * *   *        *        *        *     *  *  *  *  *'
say '       *   *    *******  *******  *******  *******  *  *  *  *******'
say
say
say'                                WELC21.CMD'
say                                                             
say'      This Rexx file recreates the Preinstalled Essentials Folder and all'
say'      of its utilities on OS/2 V2.1 Preloaded Systems. If the Executable'
say'      files that are associated with the Preinstalled Essentials Folder' 
say'      are removed from the hard drive, this program will not completely'
say'      restore the Preinstalled Essentials Folder to its original state.'
say                                     
say'      This is an updated utility to work specifically with OS/2 V2.1'
say'      Preloaded Systems.  The previous utility that Welc21.Cmd is'
say'      replacing is named Welcome.Cmd. Welcome.Cmd should still be used'
say'      for OS/2 V2.0 Preloaded Systems to recreate the Welcome Folder.'
say
say'                               Page (1 of 2)'
say
say
'pause'
'cls'
say
say
say
say'      Note:  The book files run quicker when created using this utility.'
say'      If you really care to read those boring Logo Screens while the'
say'      books are loading just highlight the book icon, click the right'
say'      mouse button and then click on the arrow to the right of open, and'
say'      then settings. Go under the Session Tab and then into the DOS'
say'      Settings. Locate Video_Retrace_Emulation towards the bottom and'
say'      set this to OFF.'
say
say'                               Shawn McAlhany'
say'                               29-30 July 1993'
say
say
say
say'                               Page (2 of 2)'
say
say
call option

say
say 'Program has been asked to continue at the users discretion...'

'cls'
call create_folder

end:

say
say 'Creation of the Welcome Folder has been completed.'
say 'The Welcome Folder that came with the preloaded system'
say 'had two more folders in the Applications folder.  These folders'
say 'are named Games and Productivity and are both located in'
say 'the OS/2 System icon.'
say
say 'Any fixes or updates to this utility will be available on' 
say 'the IBM Bulletin Board System.'
say
say 'Creator: Shawn McAlhany'
say

call quit

/***************************************************************/ 
/* Procedure: create_folder                                    */
/*                                                             */
/* This procedure creates the icons and folders that are part  */
/* of the original Welcome Folder.                             */
/***************************************************************/    

create_folder:

say
say 'Creating Welcome Folder...'

/* create Welcome Folder */

rc = SysCreateObject('WPFolder','Preinstalled Essentials','<WP_DESKTOP>','OBJECTID=<WELCOME>;','R')
if rc = 1 then do
   say 'Preinstalled Essentials folder was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Welcome folder.  This folder was not'
   say 'created successfully.'
   call reason
   say
end /* do */

/* create Configuration Tools in Welcome Folder */

rc = SysCreateObject('WPFolder','Configuration Tools','<WELCOME>','OBJECTID=<CONFIGURE>;ICONFILE=\OS2\INSTALL\PRELOAD\TOOLS.ICO','R')

if rc = 1 then do
   say 'Configuration Tools folder was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Configuration Tools folder .  This folder was not'
   say 'created successfully.'
   call reason
   say
end /* do */

/* create Applications Folder in Welcome Folder */

rc = SysCreateObject('WPFolder','Applications','<WELCOME>','OBJECTID=<APPS>','R')
if rc = 1 then do
   say 'Applications folder was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Applications folder.  This folder was not'
   say 'created successfully.'
   call reason
   say
end /* do */

/* create Features Folder in Welcome Folder */

rc = SysCreateObject('WPFolder','Features','<WELCOME>','OBJECTID=<FEATURES>','R')
if rc = 1 then do
   say 'Features folder was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Features folder.  This folder was not'
   say 'created successfully.'
   call reason
   say
end /* do */

/* create Tutorials Folder in Welcome Folder */

rc = SysCreateObject('WPFolder','Tutorials','<WELCOME>','OBJECTID=<TUTORIALS>;ICONFILE=C:\OS2\INSTALL\PRELOAD\TUTFOLD.ICO','R')
if rc = 1 then do
   say 'Tutorials folder was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Tutorials folder.  This folder was not'
   say 'created successfully.'
   call reason
   say
end /* do */

/* create Welcome & Quick Tour Book in Welcome Folder */

rc = SysCreateObject('WPProgram','Essentials Quick Tour','<WELCOME>','EXENAME=\OS2\VIEW.EXE;PROGTYPE=PM;PARAMETERS=QTOUR.INF INTRODUCTION;STARTUPDIR=\OS2\INSTALL\PRELOAD\;','R')

if rc = 1 then do
   say 'Essentials Quick Tour icon was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Welcome & Quick Tour icon.  This icon was not'
   say 'created successfully.'
   call reason
   say
end /* do */

/* create Create Utility Diskettes in Configuration Tools folder */

rc = SysCreateObject('WPProgram','Create Utility Diskettes','<CONFIGURE>','EXENAME=\OS2\INSTALL\PRELOAD\BOOTDISK.EXE;PROGTYPE=PM;PARAMETERS=;STARTUPDIR=\OS2\INSTALL\PRELOAD\;','R')
                                                                                                                                                                            
if rc = 1 then do
   say 'Create Utility Diskettes icon was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Create Utility Diskettes icon.  This icon was not'
   say 'created successfully.'
   call reason
   say
end /* do */

/* create Configure in Configuration Tools folder */

rc = SysCreateObject('WPProgram','Configure','<CONFIGURE>','EXENAME=\OS2\INSTALL\PRELOAD\CONFIG.EXE;PROGTYPE=PM;PARAMETERS=;STARTUPDIR=\OS2\INSTALL\PRELOAD\;','R')

if rc = 1 then do
   say 'Configure icon was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Configure icon.  This icon was not'
   say 'created successfully.'
   call reason
   say
end /* do */

/* create Selective Uninstall in Configuration Tools folder */

rc = SysCreateObject('WPProgram','Selective Uninstall','<CONFIGURE>','EXENAME=\OS2\INSTALL\PRELOAD\UNINSTAL.EXE;PROGTYPE=PM;PARAMETERS=;STARTUPDIR=\OS2\INSTALL\PRELOAD\;','R')

if rc = 1 then do
   say 'Selective Uninstall icon was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Selective Unistall icon.  This icon was not'
   say 'created successfully.'
   call reason
   say
end  /* do */

/* create Application Installation Overview in Applications folder */

rc = SysCreateObject('WPProgram','Application Installation Overview','<APPS>','EXENAME=\OS2\VIEW.EXE;PROGTYPE=PM;PARAMETERS=INSTALL.INF INSTALLING YOUR APPLICATIONS;STARTUPDIR=\OS2\INSTALL\PRELOAD\;','R')

if rc = 1 then do
   say 'Application Installation Overview icon was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Application Installation Overview.  This icon was not'
   say 'created successfully.'
   call reason
   say
end /* do */

/* create Services and Support in Features folder */

rc = SysCreateObject('WPProgram','Services and Support','<FEATURES>','EXENAME=\OS2\VIEW.EXE;PROGTYPE=PM;PARAMETERS=SERVICES.INF SERVICES AND SUPPORT;STARTUPDIR=\OS2\INSTALL\PRELOAD\;ICONFILE=C:\OS2\INSTALL\PRELOAD\HLPWARER.ICO','R')

if rc = 1 then do
   say 'Services and Support icon was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Services and Support.  This icon was not'
   say 'created successfully.'
   call reason
   say
end /* do */

/* Preloaded 85XX systems do not come with the System Information */
/* Utility.  This procedure prompts the user for a system of this type. */
/* If the system is an 85XX Type, it will not install the System       */
/* Information Utility, otherwise, it will be installed.                   */

say
say 'Look on or below the faceplate of the computer, where the power button'
say 'is located, for a label that mentions the Type.  Use the first four digits'
say 'of the Type to answer the following question:'
say 'Is this computer an 8556 or 8557 Type (Y/N)?'
Pull Answer
'cls'
if Answer = 'Y' then
   call jump
else
   nop

say
/* create Your System in Features folder */

rc = SysCreateObject('WPProgram','Your System','<FEATURES>','EXENAME=\OS2\APPS\SYSINFO.EXE;PROGTYPE=PM;PARAMETERS=;STARTUPDIR=\OS2\APPS\;','R')

if rc = 1 then do
   say 'Your System icon was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Your System icon.  This icon was not'
   say 'created successfully.'
   call reason
   say
end /* do */

jump:

/* create For the DOS User in Tutorials folder */

rc = SysCreateObject('WPProgram','For the DOS User','<TUTORIALS>','EXENAME=\OS2\INSTALL\PRELOAD\DOSUSER.EXE;PROGTYPE=VDM;PARAMETERS=D;STARTUPDIR=\OS2\INSTALL\PRELOAD\;','R')

if rc = 1 then do
   say 'For the DOS User icon was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Your System icon.  This icon was not'
   say 'created successfully.'
   call reason
   say
end /* do */    

/* create System Overview in Tutorials folder */

rc = SysCreateObject('WPProgram','System Overview','<TUTORIALS>','EXENAME=\OS2\INSTALL\PRELOAD\SYSOVER.EXE;PROGTYPE=VDM;PARAMETERS=;STARTUPDIR=\OS2\INSTALL\PRELOAD\;ICONFILE=C:\OS2\INSTALL\PRELOAD\OSTUTOR.ICO','R')

if rc = 1 then do
   say 'System Overview icon was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'System Overview icon.  This icon was not'
   say 'created successfully.'
   call reason
   say
end /* do */    

/* create Application Installation Overview in Tutorials folder */

rc = SysCreateObject('WPProgram','Application Installation Overview','<TUTORIALS>','EXENAME=\OS2\VIEW.EXE;PROGTYPE=PM;PARAMETERS=INSTALL.INF INSTALLING YOUR APPLICATIONS;STARTUPDIR=\OS2\INSTALL\PRELOAD\;','R')

if rc = 1 then do
   say 'Application Installation Overview icon was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'Application Installation Overview.  This icon was not'
   say 'created successfully.'
   call reason
   say
end /* do */

/* create Tutorial in the Tutorials folder */

rc = SysCreateObject('WPProgram','Tutorial','<TUTORIALS>','EXENAME=\OS2\TUTORIAL.EXE;PROGTYPE=PM;STARTUPDIR=\OS2\HELP\;','R')

if rc = 1 then do
   say 'Tutorial icon was successfully installed.'
end /* do */

else do
   say
   say 'A problem occured during the installation of the'
   say 'System Overview icon.  This icon was not'
   say 'created successfully.'
   call reason
   say
end /* do */   

call end

/***************************************************************/
/* Procedure: option                                           */
/*                                                             */
/* Prompts the user for continuation of creation of the        */
/* Welcome Folder.                                             */
/***************************************************************/
 
option:

Say "Do you want to continue (Y/N)?"
Parse Upper Pull yesno .
If Substr(yesno,1,1) <> 'Y' Then Call quit

return

/***************************************************************/ 
/* Procedure: reason                                           */
/*                                                             */
/* This procedure gives the user some knowledge as to why the  */
/* icon did not successfully install.                          */
/***************************************************************/ 

reason:
   say 'The icon may not have installed because:'
   say '   1.  This is not a feature that was preloaded on your system.'
   say '   2.  The executable file was not located on you system.  It'
   say '       may have been deleted.'
return

/***************************************************************/  
/* Procedure: quit                                             */
/*                                                             */
/* This procedure terminates the program at the appropriate    */
/* time.  Determined by user or program completion             */
/***************************************************************/  

quit:

say
say 'Program terminated.'

exit

