/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         Common
*/
Common: 

return

/*:VRX         Config_Close
*/
Config_Close: 
    call Config_Fini
return

/*:VRX         Config_Create
*/
Config_Create: 
    call Config_Init
return

/*:VRX         Config_Fini
*/
Config_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Config_Init
*/
Config_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window

if xb <> "YES" then do
 time = Time( "M")
 date = Date( "D")
 time = date||time 
 time = time ||".log"
 say time
 say "copying to logfile  "||time
 "copy C:\LANSPOOL\Current.log C:\LANSPOOL\LOGS\"||time
Say "Deleteing queues"
 Call RxQueue "Delete", "Getque"
 Call RxQueue "Delete", "Gotque"
 Call RxQueue "Delete", "taskque"

      ok = VRRedirectStdio("Off") 

return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    ok = VRRedirectStdio("On","C:\LANSPOOL\Current.log") 
    call VRSet "Console", "Left", "10", "Top", "10"
    call VRSet "Console", "Width", "10", "Height", "10"
   /* call VRSet "Console", "WindowListTitle", " "*/
    call RxFuncAdd 'SysSleep' , 'RexxUtil', 'SysSleep'
    datechk = Date("U")
    time = Date( "W")
    date = Date( "L")
    date = time||" "||date 
    time = Time( "N")
    Say "Program Started at "||date||" "||time 
    Say "Activity logging has begun"
    Say "Checking for a configuration file..............."

    ok = VRFileExists( "C:\LANSPOOL\CONFIG\CONFIG.DAT" )
       
        IF ok = "1" then do
        say "Configuration file found...will process entries"
          end
        else do
        id = VRMessage( VRWindow(), "Please define a configuration file pairing a VSE/ESA LST queue to a LAN SERVER directory. Then restart this program!", "Missing configuration file", "Warning", , WILL DO!,  )
        return
        end

        Say "Creating queues"
        Call RxQueue "Create", "Getque"
        Call RxQueue "Create", "Gotque"
        Call RxQueue "Create", "taskque"
        Call REFRESH
        
        If Filecnt = 0 then do
        SAY "THERE ARE NO FILES IN SELECTED LST QUEUE TO PROCESS"
        time = Time( "C" )
        SAY time||" ENDING PROGRAM NOW.........................."
        call Quit
        call Fini
        end

/* SETUP FOR TIMER PROCESSING */
waiting = "NO"
timecount = 0
ok = VRSet( "TM_1", "Enabled", 1 ) /* REENABLE TRIGGER */
ok = VRSet( "TM_1", "Delay", 2000 )

Return


 
/*:VRX         IPB_2_Click
*/
IPB_2_Click: 
"copy C:\LANSPOOL\Current.log C:\LANSPOOL\temp.log"
"E C:\LANSPOOL\temp.log"
return

/*:VRX         IPB_3_Click
*/
IPB_3_Click: 

 path = VRFileDialog(VRWindow(),"LOG TO VIEW?",,"C:\LANSPOOL\Logs\*")
    if path = "" then return
    time = time( "C")
    say path||" LOG FILE viewed at "||time
    EPM.EXE path
return

return

/*:VRX         IPB_4_Click
*/
IPB_4_Click: 
window = VRLoadSecondary( "CONFIG" )

return

/*:VRX         PB_10_Click
*/
PB_10_Click: 
    ok = VRFileExists("C:\LANSPOOL\CONFIG\CONFIG.DAT" )
    IF ok = "1" then do
        NOP
    end
    else do
        id = VRMessage( VRWindow(), "There is no Configuration File defined. Please add a definition, then restart this program!", "Missing configuration file", "Warning", , WILL DO!,  )
        return
    end 

    value = VRGet( "SPIN_1", "Value" )
    class = "REMOVE VSE/ESA LST CLASS "||value||" ?"
    Button.0 = 2
    Button.1 = "CANCEL"
    Button.2 = "CONTINUE"
    Okay = VRMessage("Window1", class, "DELETE VSE/ESA LIST CLASS ENTRY?:", "Q", "Button.",1,1)
    If Okay = 1 then return


    infile = "C:\LANSPOOL\CONFIG\CONFIG.DAT"
    LINEIN(infile,1,0)
    outfile = "C:\LANSPOOL\CONFIG\CONFIG.DEL"

    Do until LINES(infile) = "0"
        thisline = LINEIN(infile)
        selected = SUBWORD(thisline,2,1)
            if selected = value then do
                NOP
            end
            else do
            x = LineOut(outfile,thisline)
            end
    end
  x = stream(outfile,'c','close')
  x = stream(infile,'c','close')

    "copy C:\LANSPOOL\CONFIG\CONFIG.DAT C:\LANSPOOL\CONFIG\CONFIG.EMG"
    "copy C:\LANSPOOL\CONFIG\CONFIG.DEL C:\LANSPOOL\CONFIG\CONFIG.DAT"
    "erase C:\LANSPOOL\CONFIG\CONFIG.DEL"
call VRMessage VRWindow(), "ITEM DELETED FROM THE CONFIG FILE."
say "CLASS DELETED FROM SCHEDULE FILE: " selected

       
return

/*:VRX         PB_11_Click
*/
PB_11_Click: 
  ok = VRFileExists( "C:\LANSPOOL\CONFIG\CONFIG.DAT" )  
  IF ok = 1 then do
        NOP
    end
    else do
        id = VRMessage( VRWindow(), "There is no Configuration File defined. Please add a definition, then restart this program!", "Missing configuration file", "Warning", , WILL DO!,  )
        return
    end

"Copy C:\LANSPOOL\CONFIG\CONFIG.DAT C:\LANSPOOL\CONFIG\CONFIG.SEE"
"E C:\LANSPOOL\CONFIG\CONFIG.SEE"
return

/*:VRX         PB_12_Click
*/
PB_12_Click: 
     call Config_Close

return

/*:VRX         PB_9_Click
*/
PB_9_Click: 

VSELST = VRGet( "SPIN_1", "Value" )
SERVER = VRGet( "EF_1", "Value" )
DIR = VRGet( "EF_2", "Value" )
NETDR = VRGet( "SPIN_2", "Value" )

event = "VSELST "||VSELST NETDR "\\"||SERVER||"\"||DIR 

/* Now append event to schedular file */
okay = LINEOUT("C:\LANSPOOL\CONFIG\CONFIG.DAT",event)
    if okay = "1" then do
        say "ERROR WRITING "||event||" to the config file!"
        okay = LINEOUT("C:\LANSPOOL\CONFIG\CONFIG.DAT") /* Close the file */ 
        return
    end
okay = LINEOUT("C:\LANSPOOL\CONFIG\CONFIG.DAT") /* Close the file */
say "EVENT ADDED: "||event
call VRMessage VRWindow(), "ITEM ADDED TO CONFIG FILE."

okay = "C:\LANSPOOL\CLASS"||VSELST
    If ok = VRIsDir( "C:\LANSPOOL\CLASSN" ) then do
        NOP
    end
    else do
    okay = "MKDIR "||okay
    okay
end



return

/*:VRX         PB_STATUS_Click
*/
PB_STATUS_Click: 

return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         REFRESH
*/
REFRESH: 
/* Process file here */
     button = "CHECKING FOR LST ENTRIES"
     ok = VRSet( "PB_STATUS", "Caption", button )


    filecnt = "0"
    Lstfil = "C:\LANSPOOL\CONFIG\CONFIG.DAT" 
    LINEIN(Lstfil,1,0)
    

/* load all entries */
Do until LINES(Lstfil) = "0"
       goahead = "YES"
       item = LINEIN(Lstfil)
       Lstclass  = SubWord( item, 2, 1 )
       Netdrive = SubWord( item, 3, 1 )
       Netuse = SubWord( item, 3, 2 )
       Netuse = "NET Use "||Netuse  
        
        Remdrive = " NET USE "||Netdrive||" /d"
        Remdrive
        Netuse
      
        if rc = 0 then do
        NOP
        end
        else do
        SAY "Unable to establish network connection for"
        SAY "Will not process config definition for VSE LST CLASS="||Lstclass
        goahead = "NO"
        end

        fileout = "C:\LANSPOOL\RDR"||Lstclass
        ok = VRFileExists( fileout )
        if ok = 1 then do
        remove = "ERASE "||fileout
        remove
        end

        /* GET VSE LST QUE ENTRIES */
        if goahead = "NO" then do
        NOP
        end
        else do
        usercom = "D LST,"||Lstclass
        command = "RECEIVE "||Fileout||" TS (FILE=PCMD) "||usercom
        "start /win/c/b/min c:\LANSPOOL\getlst.cmd" command "<con >con"
        Call SysSleep 10
        end
              
        ok = VRFileExists( fileout )
          
        if ok = 0 then do /* didn't get anything */
        NOP
        end
        else do
        SAY "GOT QUEUE ENTRIES FOR VSE/ESA LST CLASS = "||Lstclass
        button = "GOT LST CLASS = "||Lstclass
        ok = VRSet( "PB_STATUS", "Caption", button )
        CALL Postfile netdrive
        end

end

x = stream(lstfil,'c','close')
Postit = "ENDLIST"
CALL LineOut "QUEUE:", Postit
SAY "*****TOTAL FILE GET REQUESTS POSTED FOR THIS PEEK AT LIST QUEUES = "||filecnt
button = "LST ENTRIES TO DO = "||filecnt
        ok = VRSet( "PB_STATUS", "Caption", button )


return

Postfile:
    parse arg netdrive

    /* Process VSE list que entries  here */

    CALL RxQueue "Set", "Getque"
    LINEIN(Fileout,1,0)
    item = LINEIN(Fileout) /* BYPASS HEADER LINE */

    Do until LINES(Fileout) = "0"
       item = LINEIN(Fileout)
       Jobname  = SubWord( item, 2, 1 )
       Jobnum = SubWord( item, 3, 1 )
       Numpge = SubWord( item, 7, 1 )
       Postit = "FILE" Jobname Jobnum Numpge Netdrive
       /* SAY "POSTING="Postit */
       CALL LineOut "QUEUE:", Postit
       Filecnt = Filecnt +1
    end
    Postit = "ENDCLASS "||Lstclass
    CALL LineOut "QUEUE:", Postit
  x = stream(Fileout,'c','close')
return
/*:VRX         TM_1_Trigger
*/
TM_1_Trigger: 
time = Time( "C" )
ok = VRSet( "PB_1", "Caption", time )
ok  = Beep( 255, 255 )
ok = VRSet( "TM_1", "Enabled", 0 ) /* DISABLE TRIGGER */
CALL RxQueue "Set","Gotque"
lines = Queued()

select
    when timecount > 29 then do
    SAY "SELECTED INTERVENE"
    CALL INTERVENE
    end
    when lines > 0  then do
    CALL GOTONE
    end
    when waiting = "YES" then do
    timecount = timecount + 1
    end
    when waiting = "NO" then do
    CALL STARTNEW
    end
    otherwise do
    NOP
    end
end

ok = VRSet( "TM_1", "Enabled", 1 ) /* REENABLE TRIGGER */
ok = VRSet( "TM_1", "Delay", 5000 )

return

GOTONE:
timecount = 0
waiting = "NO"
task = LineIn("QUEUE:")

    CALL RxQueue "Set","taskque"
    lines = Queued()
    If lines > 0 then do
        task = LineIn("QUEUE:")
    end

taskdone = SubWord( task,1,1 )
select

    when taskdone = "FILE" then do
    CALL POSTDEL
    end

    when taskdone = "ENDCLASS" then do
    class = SubWord( task,2,1 )
    button = "DID LST CLASS = "||class
    ok = VRSet( "PB_STATUS", "Caption", button )
    time = Time( "C" )
        SAY time||" Completed processing the LST CLASS="||class
    CALL STARTNEW
    end

    when taskdone = "ENDLIST" then do
    button = "DID ALL ENTRIES"
    ok = VRSet( "PB_STATUS", "Caption", button )
    time = Time( "C" )
    SAY time||" Completed processing ALL LST CLASSES"
    SAY "Will check for new listing"
    CALL REFRESH
     If Filecnt = 0 then do
        SAY "THERE ARE NO FILES IN SELECTED LST QUEUE TO PROCESS"
        time = Time( "C" )
        SAY time||" ENDING PROGRAM NOW.........................."
        call Quit
        call Fini
     end
    waiting = "NO"
    timecount = 0
    end
    otherwise do
    NOP
    end
 end
return

POSTDEL:
jobname = SubWord(task,2,1)
jobnum = SubWord(task,3,1)
netdrive = SubWord(task,4,1)

/* Did we get it ? */
checkfile = "C:\LANSPOOL\LISTS\"||jobname
ok = VRFileExists( checkfile )

IF ok = "1" then do
    button = "GOT LISTING "
    button = button||jobname
    button = button jobnum
    ok = VRSet( "PB_STATUS", "Caption", button )
    usercom = "L LST,"||jobname||","||jobnum
    command = "RECEIVE C:\LANSPOOL\RESULTS TS (FILE=PCMD) "||usercom
    SAY "DELETING RECEIVED FILE FROM LST QUEUE: "||jobname
    "start /win/c/b/min c:\LANSPOOL\WORKERBE.cmd" command "<con >con"
     FLE = "DEL" jobname jobnum
    Call RxQueue "Set","taskque"
    CALL LineOut "QUEUE:", FLE
    waiting = "YES"
    timecount = 0 
    x = RANDOM(0,999)
    flname = "C:\LANSPOOL\LISTS\"||jobname
    transfer = "COPY "||flname||" "||netdrive||"\"jobname||"."||x
    time = Time( "C" )
    SAY time||" EXECUTING: "transfer
    transfer
        if RC = 0 then do
            button = "Delivered file "
            button = button||jobname
            button = button||"."
            button = button||x
            ok = VRSet( "PB_STATUS", "Caption", button )
            remove = "ERASE "flname
            time = Time( "C" )
            SAY time||" EXECUTING: "remove
            remove
        end
end
return

STARTNEW:
Call RxQueue "Set", "Getque"
FLE = LineIn("QUEUE:")
SAY "PROCESSING: "||FLE
What = SubWord(FLE,1,1)
    select
        when What = "ENDCLASS" then do
            Call RxQueue "Set","Gotque"
            CALL LineOut "QUEUE:", FLE
        end
        when What = "ENDLIST"  then do
            Call RxQueue "Set","Gotque"
            CALL LineOut "QUEUE:", FLE
        end
        when What = "FILE"  then do
            jobname = SubWord(FLE,2,1)
            jobnum = SubWord(FLE,3,1)
            netdrive = SubWord(FLE,5,1)
        command = "RECEIVE C:\LANSPOOL\LISTS\"||jobname jobname jobnum||" (file=lst"
        "start /win/c/b/min c:\LANSPOOL\WORKERBE.cmd" command "<con >con"
        FLE = "FILE " jobname jobnum netdrive
        Call RxQueue "Set","taskque"
        CALL LineOut "QUEUE:", FLE

        waiting = "yes"
        timecount = 0
        end
        otherwise do
        end
     end
    
return

INTERVENE:
ok = VRSet( "PB_STATUS", "BackColor", "Red" )
ok = VRSet( "PB_STATUS", "Caption", "STOPPED!" )
    do 30
    ok  = Beep( 255, 255 )
    ok  = Beep( 100, 100 )
    ok  = Beep( 255, 255 )
    end
SAY "*****THERE MAY BE A COMMUNICATIONS SESSION PROBLEM"
SAY "*****WILL DELETE QUES AND QUIT OUT NOW************"
call Quit
call Fini
return
/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

