/*static char sccsid[] = "@(#)11  1.2  src/uls/common/include/uc_convP.h"
 *
 *   COMPONENT_NAME:   wp.uconv
 *
 *   Private functions:
 *     __getTableName
 *     __getUcTable
 *     __freeUcTable
 *
 *   IBM CONFIDENTIAL -- (IBM Confidential Restricted when
 *   combined with the aggregated modules for this product)
 *   OBJECT CODE ONLY SOURCE MATERIALS
 *
 *   (C) COPYRIGHT International Business Machines Corp. 1995
 *   All Rights Reserved
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

#ifndef __UC_CONVP
   #define __UC_CONVP

   #include <ucommon.h>

   #ifdef __cplusplus
     extern "C" {
   #endif

   #if defined(__IBMCPP__) || defined(__IBMC__)
     #pragma pack(1)
   #else
     #pragma Align_members(1)
   #endif

   /*
    * UCS conversion table version & release
    */
   #define UC_VERSION  0x02
   #define UC_RELEASE  0x00

   /*
    * UCS conversion table types
    */
   #define UC_CLASS_INVAL            0       /* Invalid type              */
   #define UC_CLASS_ASCII7           0       /* UCS <-> ASCII7 data       */
   #define UC_CLASS_SBCS             1       /* UCS <-> SBCS              */
   #define UC_CLASS_DBCS             2       /* UCS <-> DBCS  (stateless) */
   #define UC_CLASS_MBCS             3       /* UCS <-> MBCS  (stateless) */
   #define UC_CLASS_EBCDIC_STATEFUL  4       /* UCS <-> EBCDIC (stateful) */
   #define UC_CLASS_EBCS             4       /* UCS <-> EBCDIC (stateful) */
   #define UC_CLASS_UCS2             5       /* Unicode (null map)        */
   #define UC_CLASS_UTF8             6       /* UCS <-> UTF-8             */
   #define UC_CLASS_UPF8             7       /* UCS <-> UTF-7             */

   /*
    * UCS conversion table default substitution character
    */
   #define UC_DEF_SUB         0xfffd
   #define STEM_MAX           13

   /*
    * Version 2 UCS conversion table header structures
    *
    * This is the header for both file and in-memory tables since we just
    * memory map the file.
    *
    */
   #ifndef _USE_FILESERVER
      typedef unsigned int   uint32;
      typedef unsigned short uint16;
   #endif

   typedef struct _ucm_base_rec {
      uint32    size;                /* size of header                  */
      uint16    bom;                 /* = 0xfeff      (our endian)      */
      char      version;             /* = UC_VERSION                    */
      char      release;             /* = UC_RELEASE                    */
      char      eyecatcher[4];       /* "ucv"                           */
      uint16    codepage;            /* IBM registered codepage         */
      uint16    flags;               /* Flags UCVF_                     */
      char      name[16];            /* Name of codepage                */
      uint16    hdrlen;              /* Length of header                */
      uint16    copyright;           /* Offset to copyright             */
      uint16    desc;                /* Offset to description           */
      uint16    uconv_more;          /* Additional codepoints           */
      uint16    udctab;              /* User defined characters         */
      uint16    udclen;              /* Length (bytes) of udc table     */
      uint16    codeoffset;          /* Offset to code table            */
      UniChar   Display7F;           /* Display char for 0x7f           */
      uint16    uconv_class;         /* UCONV CLASS                     */
      uint16    encoding;            /* Encoding scheme id              */
      uint16    mb_min_len;          /* Minimum character length        */
      uint16    mb_max_len;          /* Maximum character length        */
      uint16    subchar_len;         /* Substitution character length   */
      UniChar   undef_uni;           /* Equivalent char of undef_char   */
      char      undef_char;          /* Marker for invalid char in MBCS */
      char      noncdra;             /* Allow non-CRDA                  */
      UniChar   subuni;              /* Substitution char in UCS        */
      char      subchar[16];         /* Substitution char in MBCS       */
      uint16    upperlower;
      uint16    crc;                 /* Validity check                  */
      char      date[12];            /* Build date                      */
      char      vardata[64];         /* Variable length data            */
   } ucm_base_t;

   typedef struct _ucm_normal_rec {
      ucm_base_t base;
      UniChar    Display[32];        /* Display translations            */
      uint16     U2Mof4set[256];     /* Offsets to conversion rows      */
      uint16     M2Uof4set[256];     /* Offsets to conversion rows      */
   } ucm_normal_t;

   typedef struct _ucm_extra_rec {
      ucm_base_t base;
      UniChar    Display[32];        /* Display translations            */
      uint16     U2Mof4set[256];     /* Offsets to conversion rows      */
      uint16     M2Uof4set[256];     /* Offsets to conversion rows      */
      char       code_len[256];      /* Code length array   (optional)  */
      char       other_byte[256];    /* Other byte array    (optional)  */
   } ucm_extra_t;

   typedef union _ucm_hdr_rec {
      ucm_base_t   base;
      ucm_normal_t normal;
      ucm_extra_t  extra;
   } ucm_hdr_t;

   typedef struct _ucm_hdrbak_rec {
      uint32    size;                /* size of header                  */
      uint16    bom;                 /* = 0xfeff      (our endian)      */
      char      version;             /* = UC_VERSION                    */
      char      release;             /* = UC_RELEASE                    */
      char      eyecatcher[4];       /* "ucv"                           */
      uint16    codepage;            /* IBM registered codepage         */
      uint16    flags;               /* Flags UCVF_                     */
      char      name[16];            /* Name of codepage                */
      uint16    hdrlen;              /* Length of header                */
      uint16    copyright;           /* Offset to copyright             */
      uint16    desc;                /* Offset to description           */
      uint16    uconv_more;          /* Additional codepoints           */
      uint16    udctab;              /* User defined characters         */
      uint16    udclen;              /* Length (bytes) of udc table     */
      uint16    codeoffset;          /* Offset to code table            */
      UniChar   Display7F;           /* Display char for 0x7f           */
      uint16    uconv_class;         /* UCONV CLASS                     */
      uint16    encoding;            /* Encoding scheme id              */
      uint16    mb_min_len;          /* Minimum character length        */
      uint16    mb_max_len;          /* Maximum character length        */
      uint16    subchar_len;         /* Substitution character length   */
      UniChar   undef_uni;           /* Equivalent char of undef_char   */
      char      undef_char;          /* Marker for invalid char in MBCS */
      char      noncdra;             /* Allow non-CRDA                  */
      UniChar   subuni;              /* Substitution char in UCS        */
      char      subchar[16];         /* Substitution char in MBCS       */
      uint16    resv;
      uint16    crc;                 /* Validity check                  */
      char      date[12];            /* Build date                      */
      char      vardata[64];         /* Variable length data            */

      UniChar   Display[32];         /* Display translations            */
      uint16    U2Mof4set[256];      /* Offsets to conversion rows      */
      uint16    M2Uof4set[256];      /* Offsets to conversion rows      */

      char      code_len[256];       /* Code length array   (optional)  */
      char      other_byte[256];     /* Other byte array    (optional)  */
   } ucm_hdrbak_t;

   #define M2Utable M2Uof4set
   #define UCMHDR_BASE  sizeof (ucm_base_t)
   #define UCMHDR_NORM  sizeof (ucm_normal_t)
   #define UCMHDR_EXTRA sizeof (ucm_extra_t)

   /*
    * MBCS conversion table
    */
   typedef struct {                  /* MBCS conversion row table unit  */
      uint16    n_slots;             /* Number of slots of this table   */
      uint16    l_value;             /* Lowest byte value in row        */
      uint16    nextOf4set[256];     /* Offsets to next rows            */
   } _uc_row_t;

   typedef struct {                  /* MBCS STEM information           */
      char      stem[STEM_MAX+1];    /* Stem string                     */
      uint16    stem_len;            /* Stem length                     */
   } _uc_stem_t;

   typedef struct {                  /* UCS_MBCS conversion table unit  */
      uint16    stem_index;          /* Index for stem table            */
      uint16    code;                /* The last 2 byte of codepoint    */
   } _uc_u2m_t;

   #define SHIFT_IN   0
   #define SHIFT_OUT  1

   /*
    * Conversion handle table
    *
    * This is an internal table, so only those field we need now are
    * encoded.  Other data we need is in the table itself.  Only the
    * uconv_class is copies since it is used a lot.
    */
   typedef struct _uc_ch_rec {
      ucm_hdr_t * table;             /* Conversion table C/B            */
      uint16      uconv_class;       /* Type of conversion              */
      uint16      endianto;          /* To endian                       */
      uint16      endianfrom;        /* From endian                     */
      uint16      subuni_len;        /* Substitution option             */
      UniChar     subuni;            /* Substitution char in UCS        */
      uint16      subchar_len;       /* Substitution char length        */
      char        subchar[16];       /* Substitution char in MBCS       */
      char        state_flag_from;   /* State flag                      */
      char        state_flag_to;     /* State flag                      */
      uint16      options;           /* Map and Substitution Options    */
      uint32      displaymask;       /* Display mask                    */
      uint32      converttype;       /* Conversion options              */
    } _uc_ch_t;

    typedef int (*table_fvt_t)(char *buf, size_t bufsize, size_t filesize, int flag);

    #define TYPE_UCTABLE               0x0001
    #define TYPE_UCSID                 0x0002

    #define UCONV_ENV_PATH           "ULSPATH"
    #define DEF_ULSPATH_LEN          14
    #define DEF_CODEPAGEPATH         (UniChar *)L"codepage\\"
    #define DEF_CODEPAGEPATH_LEN     9
    #define UCSID_DATAPATH_LEN       18
    #define DEF_ULSPATH              "c:\\language\\"
    #define ALIAS_TABLE              "ucstbl.lst"
    #define ALIAS_TABLE_UNI          (UniChar)L"ucstbl.lst"
    #define ALIAS_TABLE_LEN          10
    #define MYEOF                      EOF
    #define _UCONV_MAX_PATH            256
    /*
     * Internal use function prototypes
     */
    int __getTableName (            /* Get table File/Path name        */
        UniChar      * cs_name,     /* Unicode table name              */
        size_t         length,      /* name length                     */
        char         * table_name); /* Returns relative File/Path name */

    int __getUcTable (              /* Get conversion table            */
        char         * table_name,  /* Conversion table File/Path name */
        size_t         name_len,    /* base file name length           */
        table_fvt_t    table_func,  /* test function execute in loading*/
        ucm_hdr_t  * * ucmap);      /* Returns pointer to found table  */

/*4ADWH149653start*/

    int __freeUcTable (             /* Free conversion table           */
        ucm_hdr_t * ucmap);         /* Conversion table C/B            */

  #if defined(__IBMCPP__) || defined(__IBMC__)
    #pragma pack()
  #else
    #pragma Align_members()
  #endif

  #ifdef __cplusplus
  }
  #endif
#endif
