/* @(#)01       1.3  src/bos/usr/include/uc_conv.h, libiconv, bos410 4/5/94 08:35:52
 *
 *   COMPONENT_NAME:    LIBICONV
 *
 *   FUNCTIONS:         Definitions for UCS Toolkit
 *                      codeset conversion functions.
 *
 *   ORIGINS: 27
 *
 *   IBM CONFIDENTIAL -- (IBM Confidential Restricted when
 *   combined with the aggregated modules for this product)
 *   OBJECT CODE ONLY SOURCE MATERIALS
 *
 *   (C) COPYRIGHT International Business Machines Corp. 1993
 *   All Rights Reserved
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

#ifndef __UC_CONV
#define __UC_CONV

#include <unidef.h>
#include <sys/types.h>
#include <uc_convp.h>
#include <uconv.h>

/*
 * Function prototypes
 */
int  UCCINIT (                       /* Initialize UCS conversion         */
        UniChar           * cs_name, /* MBCS codeset name                 */
        size_t              len,     /* MBCS codeset name length          */
        uconv_attribute_t * attr,    /* Attributes                        */
        _uc_ch_t        * * ch);     /* Reterns conversion handle         */

int  UCCM2U (        /* MBCS to UCS conversion            */
        _uc_ch_t * ch,            /* Conversion handle                 */
        char     * in_buf,        /* Input buffer                      */
        size_t   * in_size,       /* #of bytes of in_buf / processed   */
        UniChar  * out_buf,       /* Output buffer                     */
        size_t   * out_size,      /* #of UniChar of out_buf / output   */
        size_t   * subs);         /* #of non-identical conversions     */

int UCCU2M (       /* UCS to MBCS conversion            */
        _uc_ch_t * ch,            /* Conversion handle                 */
        UniChar  * in_buf,        /* Input buffer                      */
        size_t   * in_size,       /* #of bytes of in_buf / processed   */
        char     * out_buf,       /* Output buffer                     */
        size_t   * out_size,      /* #of UniChar of out_buf / output   */
        size_t   * subs);         /* #of non-identical conversions     */

int UCCTERM (                     /* Terminate UCS conversion          */
        _uc_ch_t        *ch);     /* Conversion handle                 */

/*
 * Error status codes for the function return value
 */
#define UC_NO_ERRORS              0
#define UC_INVALID_HANDLE         ULS_BADOBJECT
#define UC_INVALID_OPTION         ULS_BADATTR
#define UC_INVALID_SUBCHAR        ULS_BADATTR
#define UC_INVALID_TABLE          ULS_INVALID
#define UC_TABLE_NOT_AVAILABLE    ULS_INVALID
#define UC_NOT_ENOUGH_SPACE       ULS_NOMEMORY
#define UC_BUFFER_FULL            ULS_BUFFERFULL
#define UC_INVALID_CHAR_FOUND     ULS_ILLEGALSEQUENCE
#define UC_INPUT_CHAR_TRUNCATED   ULS_INVALID
#define UC_INVALID_VERSION        ULS_VERSION
#define UC_OTHER_ERRORS           ULS_OTHER

#endif /*!__UC_CONV*/
