/*REXX*/

/*   tvsample.cmd   TVFS sample REXX interface.
 *
 *   (c) Copyright International Business Machines Corporation 1994, 1995.
 *   All rights reserved.
 *
 *   Load the REXX interface via: TvLoadFuncs, TvDropFuncs.
 *   Available TVFS commands are: TvMount, TvUmount, TvLink, TvUlink, TvMkdir.
 *
 *   10.01.93   T.B.Francis   Creation
 *   10.13.93   M.D.Leitch    Incorporated into TVFS.
 */

signal on error

/* Load the Tv REXX interface. */
call RxFuncAdd 'TvLoadFuncs', 'TVRX', 'TvLoadFuncs'
call TvLoadFuncs

/* Mount the virtual drive. */
drive = 'T:'
call TvMount drive

/* Link to the virtual drive. */
linkPoint = drive'\OS2.ALL'
links = 'C:\OS2 C:\OS2\SYSTEM C:\OS2\MDOS'
do while links<>''
   parse var links link links
   call TvLink linkPoint link 
end
                    
/* Unlink from the virtual drive. */
call TvUlink linkPoint '*'

/* Make a directory (in place of the link). */
call TvMkdir linkPoint

/* Unmount the virtual drive. */
call TvUmount drive

/* Unload the Tv REXX interface. */
call TvDropFuncs
      
exit(0)

error:
   say 'Error processing "' condition('D') "'"
   say 'Return code is' rc
   exit(rc)
