/* TVFS.CONF / TVFS Configuration Utility / release 2B    */
/* written by Byron Q. Desnoyers Winmill                  */
/*                                                        */
/* Revision History:                                      */
/* 16-Sep-97 : release 1                                  */
/*     original release                                   */
/* 26-Sep-97 : release 2                                  */
/*     built TVFSCONFIG class                             */
/*     loads TVCTL automagically                          */
/*     numerous parsing fixes                             */
/*     consistent error messages                          */
/*     cleaned up code                                    */
/*     fixed comment bugs                                 */

/* todo: make constants more accessable */

'@ ECHO OFF'

/* Define global constants.           */
TITLE='[tvfs.conf]';

/* Parse command line.                */
parse arg conf_file tv_drives

tvfs_conf = .TVFSConfig~new(TITLE);
tvfs_conf~work(conf_file, tv_drives);
tvfs_conf~done;

exit(0);

/* ----------========== ObjectREXX Classes ==========---------- */

::CLASS TVFSConfig                      /* TVFS configuration class.     */
  ::METHOD init                         /* Initializes TVRX extensions.  */
    expose title;
    use arg title;

    'tvctl -t -w -f0';

    rc = RxFuncAdd('TvLoadFuncs', 'TVRX', 'TvLoadFuncs');
    if ( rc <> 0 ) then do
      say title '| Error calling RxFuncAdd()';
      self~done;
      exit(1);
    end;                           /* if, rc */

    rc = TvLoadFuncs();
    if ( rc <> 0 ) then do
      say title '| Error calling TvLoadFuncs()';
      self~done;
      exit(2);
    end;                           /* if, rc */
  return;                          /* method, init */

  ::METHOD work                         /* Configures TVFS.              */
    use arg conf_file, tv_drives;

    self~mount(tv_drives);
    self~link(conf_file);          /* method, work */
  return;

  ::METHOD done                         /* Terminates TVRX extensions.   */
    rc = TvDropFuncs()
  return;                          /* method, done */

  ::METHOD mount                        /* Mounts TVFS partitions.       */
    expose title;
    use arg tv_drives;

    DIVIDER=',';

    do while ( tv_drives~length > 0 )
      parse var tv_drives this_drive (DIVIDER) tv_drives;
      rc = TvMount(this_drive':');
      if ( rc <> 0 ) then say title '| Warning, could not mount 'this_drive':'
    end;                           /* while, tv_drives */
  return;                          /* method, mount */

  ::METHOD link                         /* Links TVFS files and paths.   */
    expose title;
    use arg conf_file;

    COMMENT='#';
    DISPLAY='!';

    conf_stream = .stream~new(conf_file);
    do while ( conf_stream~lines > 0 )
      buffer = conf_stream~linein;

      if ( buffer~length > 0 ) then do
        parse var buffer command 2 string;

        select
          when ( command = COMMENT ) then
            nop;
          when ( command = DISPLAY ) then
            say title string;
          otherwise
            parse var buffer parameters source destination;

            if ( source~length = 0 ) | ( destination~length = 0 ) then
              say title '| Warning, could not link' buffer;
            else do
              rc = TvLink(parameters source destination);
              if ( rc <> 0 ) then say title '| Warning, error' rc 'linking' buffer;
            end;                   /* if: string.source, string.destination */
          end;                     /* select */
      end;                         /* if, buffer */
    end;                           /* while, conf_stream~lines */
    conf_stream~close;
  return;                          /* method, link */
