
#include "win.h"

////////////////////////////////////////////////////////////////////////////
//	this function redraws the correct window frame and client area
///////////////////////////////////////////////////////////////////////////
void WindowClass::redraw() {
	register int count;
	char h,v,c1,c2,c3,c4;						// varibles for the line drawing
	scrx = scry = 0;								// unscroll
	char barlist[ 85 ];
	if ( status == FG ) {		  				// frame drawing chars
		h = 205;
		v = 186;
		c1 = 201;
		c2 = 200;
		c3 = 188;
		c4 = 187;
	}
	else {
		h = 196;
		v = 179;
		c1 = 218;
		c2 = 192;
		c3 = 217;
		c4 = 191;
	}

	textcolor( 7 );
	textbackground( 0 );
	gotoxy( x1, y1 );							// draw top line
	for( count = 0; count < ( x2 - x1) + 1; count++ )
		barlist[ count ] = h;

	barlist[ count ] = '\0';
	barlist[ 0 ] = c1;
	barlist[ count - 1 ] = c4;
	cprintf( "%s", barlist );

	gotoxy( x1, y2 );							// draw bottom line
	barlist[ 0 ] = c2;
	barlist[ count - 1 ] = c3;
	cprintf( "%s", barlist );

	for( count = 1; count < ( y2 - y1 ); count++ ){// draw sides of window
		gotoxy( x1, y1 + count );
		cprintf( "%c", v );
		gotoxy( x2, y1 + count );
		cprintf( "%c", v );
	}

	gotoxy( x1 + 2, y1 );
	cprintf( "[ %s ]", title );

	clientdraw();										// redraw client area
}

////////////////////////////////////////////////////////////////////////////
// places the client area in the window
////////////////////////////////////////////////////////////////////////////
void WindowClass::clientdraw() {
	int x, y;
	puttext( x1 + 1, y1 + 1, x2 - 1, y2 - 1, clientarea );
	// now locate cursor to the proper place on the screen
	if ( scrx > ( x2 - x1 - 1 ) ) 
		x = x2 - 1;
	else
		x = x1 + scrx;

	if ( scry > ( y2 - y1 - 1 ) )
		y = y2 - 1;
	else
		y = y1 + scry;

	gotoxy( x, y );
}
		
///////////////////////////////////////////////////////////////////////////
//	brings the window foreground
///////////////////////////////////////////////////////////////////////////
void WindowClass::gofg() {
	status = FG;
}

///////////////////////////////////////////////////////////////////////////
//	redraws the window as a background win
///////////////////////////////////////////////////////////////////////////
void WindowClass::gobg() {
	status = BG;
}

/////////////////////////////////////////////////////////////////////////////
//	moves the window the desired amount of x and y if possible
/////////////////////////////////////////////////////////////////////////////
void WindowClass::relocate( int x, int y ) {
	if ( ( x1 + x < 1 ) 	||							// check to make sure we don't
		( x2 + x > 80 ) 	||							// exceed screen bounds
		( y1 + y < 1 ) 	||
		( y2 + y > 25 ) )
		return;											// ignore call if bounds exceed

	x1 += x;												// make location change
	x2 += x;
	y1 += y;
	y2 += y;
	redraw();
}

//////////////////////////////////////////////////////////////////////////
//	the cnostructor redies the windowclass
//////////////////////////////////////////////////////////////////////////
WindowClass::WindowClass() {
	x1 = 15; 
	x2 = 65;
	y1 = 4; 
	y2 = 15;

	title = new char[ 40 ];
	title[ 0 ] = '\0';
	clientarea = new char[ 4000 ];
	scrx = scry = 0;
}

WindowClass::~WindowClass() {
	delete [] title;
	delete [] clientarea;
}

/////////////////////////////////////////////////////////////////////////////
//	clientdata gets the 80x25 data and formats it for use with current win
//	settings.
/////////////////////////////////////////////////////////////////////////////
void WindowClass::clientdata( char *data ) {
	register int datapos = 0;						// location within line
	register int linecount = 0;					// current line number
	register int count = 0;							// temp counter
	register int finc = 0;							// finished location
	int xwidth = ( x2 - 1 ) - ( x1 + 1 ) + 1;
	int ywidth = ( y2 - 1 ) - ( y1 + 1 ) + 1;

	if ( scry > ywidth ) 							// scroll window text down to
		datapos = ( scry - ywidth ) * 160;		// cursor position	

	for ( linecount = 0; linecount < ywidth; linecount++ ) {
		// loop through building the data for each line

		// determine if we need to scroll horizantly.  If so, calc scroll
		if ( scrx > xwidth ) 						// scroll over for x position
			datapos += ( scrx - xwidth ) * 2;

		// read in the data we actually need, saving the new stuff in the
		// window's client area buffer
		for ( count = 0; count < xwidth; count++ ) {
			clientarea[ finc++ ] = data[ datapos++ ];	// copy char
			clientarea[ finc++ ] = data[ datapos++ ];	// copy attributes
		}

		// since the data is passed to use in a 80x25 format, we need to
		// 'waiste off' the remaining chars at the end of the line.  If
		//	scrx > xwidth, we need to account for the fact that some of these
		// characters have already been removed.
		if ( scrx > xwidth )
			datapos += ( ( 80 - xwidth	) - ( scrx - xwidth ) ) * 2;
		else
			datapos += ( 80 - xwidth ) * 2;
	}// for linecount
}
	
/////////////////////////////////////////////////////////////////////////////
//	WinResize will, if allowable, resize the window so its view area is bigger
/////////////////////////////////////////////////////////////////////////////
void WindowClass::resize( int x, int y ) {
	if	( ( x2 + x > 80 ) ||
		( x2 + x <= x1 )	||
		( y2 + y > 25 )	||
		( y2 + y <= y1 ) )
		return;									// out of bounds resize

	else {
		x2 += x;
		y2	+= y;
	}
	redraw();
}

////////////////////////////////////////////////////////////////////////////
// title sets the title of the window
//////////////////////////////////////////////////////////
void WindowClass::settitle( char *newtitle ) {
	strcpy( title, newtitle );
}

char* WindowClass::gettitle() {
	return title;
}

void WindowClass::scroll( int x, int y ) {
	if(	( x2 + x > 80 ) 	||
			( x1 - x < 1 ) 	||
			( y2 + y > 25 )	||
			( y1 - y < 1 ) )
			return;
	else {
		scrx += x;
		scry += y;
	}
}

void WindowClass::setcurpos( int x, int y ) {
	scrx = x;
	scry = y;
}
