
#define INCL_DOSPROCESS
#define INCL_DOSMEMMGR

#include <os2.h>
#include <stdio.h>
#include <conio.h>
#include <process.h>
#include <string.h>
#include <stdlib.h>
#include "win.h"
#include "keybd.h"

#define MAXWIN 10

/************************************************ globals */
char *ScreenData[ MAXWIN ];						// holds screen client info
char *KeyData[ MAXWIN ];							// holds keyboard buffers
WindowClass Window[ MAXWIN ];						// make window classes
WindowClass *foreground = NULL;					// pointer to FG window
int nFG = 0;											// index of fg window
int INUSE[ MAXWIN ];

/*********************************************** init shared memory */
void initshared() {
	int count;
	char memname[ 50 ];								// holds memory name

	for ( count = 0; count < MAXWIN; count++ ) {
		sprintf( memname, "WINDOW%d", count );
		Window[ count ].settitle( memname );  // set the window name

		// allocate share memory for screen gettings
		sprintf( memname, "\\SHAREMEM\\%s", Window[count].gettitle() );
		if ( DosAllocSharedMem( (PPVOID) &ScreenData[count], memname,
										4096, PAG_READ | PAG_COMMIT ) ) {
			cprintf( "Shared Mem Error" );
			exit( 1 );
		}
		sprintf( memname, "\\SHAREMEM\\K%s", Window[count].gettitle() );
		if ( DosAllocSharedMem( (PPVOID) &KeyData[count], memname,
										10, PAG_READ | PAG_COMMIT | PAG_WRITE ) ) {
			cprintf( "Shared Mem Error" );
			exit( 1 );
		}


	}// for
}



/////////////////////////////////////////////////////////////////////////////
// this function performs a total redraw of the host screen
/////////////////////////////////////////////////////////////////////////////

void sysredraw() {				// redraw all windows
	textcolor( 7 );
	textbackground( 0 );
	clrscr();
	int count;
	for ( count = 0; count < MAXWIN; count++ ) {
		if ( INUSE[ count ] )
			Window[ count ].redraw();
	}

	foreground -> redraw();
}

/////////////////////////////////////////////////////////////////////////////
// this function redraws the foreground window every once in a while so that
// it looks real-time, but isn't so energy (cpu) inefficient
/////////////////////////////////////////////////////////////////////////////

void redraw_daemon( void *arglist ) {
	int count;
	while( 1 ) {
	DosSleep( 125 );									// sleep a bit
	for ( count = 0; count < MAXWIN; count++ ) {
		Window[ count ].setcurpos( atoi( KeyData[ nFG ] + 3 ), 
											 atoi( KeyData[ nFG ] + 6 ) );
		Window[ count ].clientdata( ScreenData[ count ] );// redraw client area
	}

	foreground -> clientdraw();
	}
}

void startsession( int number ) {
	INUSE[ number ] = 1;
	char cmdline[ 75 ];
	sprintf( cmdline, "start /bg /c /fs capd %s", Window[ number ].gettitle() );
	system( cmdline );
	Window[ number ].gofg();
}

void sysmenu() {
	textcolor( 14 );
	textbackground( 1 );
	gotoxy( 1, 25 );
	cprintf( " Options:  Move, Resize, Switch, Begin " );

	int in = getch();
	switch( in ) {

		case 'm':
		case 'M':
 			gotoxy( 2, 25 );
			cprintf( "Cursor keys move window.  Enter to commit and redraw." );
			while( 1 ) {
				int in = getch();
				if ( in == 0 ) 						// function key hit
					continue;
				if ( in == RIGHT ) 
					foreground -> relocate( 1, 0 );
				if ( in == LEFT )
					foreground -> relocate( -1, 0 );
				if ( in == DOWN )
					foreground -> relocate( 0, 1 );
				if ( in == UP )
					foreground -> relocate( 0, -1 );
				if ( in == 13 )						// enter key
					break;
			}
			sysredraw();								// redraw screen
			break;

		case 'r':
		case 'R':										// resize
			gotoxy( 2, 25 );
			cprintf( "Cursor keys resize window.  Enter to commit and redraw." );
			while( 1 ) {
				int in = getch();
				if ( in == 0 )
					continue;
				if ( in == RIGHT ) 
					foreground -> resize( 1, 0 );
				if ( in == LEFT )
					foreground -> resize( -1, 0 );
				if ( in == UP )
					foreground -> resize( 0, -1 );
				if ( in == DOWN )
					foreground -> resize( 0, 1 );
				if ( in == 13 )
					break;
			}
			sysredraw();
			break;

		case 'S':
		case 's': {		  // switch windows
			gotoxy( 2, 25 );
			cprintf( "Type the window number to switch to ( 0 - 9 )" );
			int in = getch();
			if ( ( ( in - '0' ) <= 9 ) && ( ( in - '0' ) >= 0 ) ) {
					// ensure we are within range
				foreground -> gobg();	
				nFG = ( in - '0' );
				foreground = &Window[ ( in - '0' ) ];
				foreground -> gofg();
			}
			sysredraw();
			break;
		}

		case 'B':
		case 'b':
			startsession( nFG );
			break;

		default:
			sysredraw();
			break;
	}// case
}


int keyproc() {
	register int counter = 0;
	int in;
	in = getch();

	if ( in == 28 ) {									// system menu requested
		sysmenu();
		return 1;
	}
				 
	while ( KeyData[ nFG ][0] != '\0' )	{		// wait until memory is clear
		DosSleep( 5 );
		counter++;
		if ( counter > 100 ) {						// window has stalled
			INUSE[ nFG ] = 0;								// terminate window
			sysredraw();
			gotoxy( 50, 25 );
			cprintf( "%s has quit responding.", Window[ nFG ].gettitle() );
			sysmenu();
			return 1;
		}
	}

	if	( in == 0 ) {									// trap function key
		in = getch();									// get the scan code
		KeyData[ nFG ][ 1 ] = 1;					// let monior know of f-key
	}
	KeyData[ nFG ][ 0 ] = in;
	return 1;
}


int main() {
	clrscr();
	nFG = 0;
	initshared();
	startsession( 0 );
	foreground = &Window[ 0 ];
	_beginthread( redraw_daemon, 4096, NULL );
	sysredraw();
	while ( keyproc() );
	return 0;
}
