
/*************************************************************************
   Screen Capture Daemon for use with TaskView
**************************************************************************/


#define INCL_DOS
#define INCL_BASE
#define INCL_DOSMEMMGR
#define INCL_DOSPROCESS
#define INCL_DOSNMPIPES
#define INCL_DOSFILEMGR

#include <os2.h>
#include "monitor.h"
#include <bsememf.h>
#include <stdio.h>
#include <conio.h>
#include <process.h>
#include <stdlib.h>
#include <string.h>


typedef struct _LINFOSEG{
	USHORT pid;
	USHORT ppid;
	USHORT prty;
	USHORT tid;
	USHORT csg;
	USHORT sgSub;
} LINFOSEG;


USHORT MonHandle;				// handle for monitor loop
UCHAR inbuf[ 128 ];
UCHAR outbuf[ 128 ];
char *ScreenMemory;
char *KeyInfo;

void screend( void *arglist );
void mond( void *arglist );
void keyd( void *arglist );
void getcursorpos( int& x, int& y );
void cursord( void *arglist );


struct KeyPacket {
	USHORT MonFlags;
	KBDKEYINFO Data;
	USHORT DevFlags;
};

LINFOSEG *local;
USHORT GlobalSeg;
USHORT LocalSeg;
USHORT SessionID;


int main( int argc, char *argv[] ) {
	cprintf("%c", 7 );
	if ( argc < 2 ) {
		cprintf( "Invalid Arguments" );
		return 1;
	}

	char name[ 100 ];
	sprintf( name, "\\SHAREMEM\\%s", argv[ 1 ] );
	if ( DosGetNamedSharedMem( (PPVOID) &ScreenMemory, name, PAG_WRITE ) ) {
		cprintf( "Shared Memory Failed." );
		return 1;
	}

	sprintf( name, "\\SHAREMEM\\K%s", argv[ 1 ] );
	if ( DosGetNamedSharedMem( (PPVOID) &KeyInfo, name, 
												PAG_READ | PAG_WRITE ) ) {
		cprintf( "KeyShared memory failed." );
		return 1;
	}

	if ( DosGetInfoSeg( &GlobalSeg, &LocalSeg ) ) {
		cprintf( "Segmentation Requsition Fault" );
		return 1;
	}
	local = (LINFOSEG*) MAKEP( LocalSeg, 0 );


	if ( DosMonOpen( "KBD$", &MonHandle ) ) {	// open monitor
		cprintf("Error opening monitor" );
		return 1;
	}

	inbuf[0] = outbuf[0] = 128; 

	SessionID = local -> csg;
	cprintf( " %d ", SessionID );
	if ( DosMonReg( MonHandle, inbuf, outbuf, 0, SessionID ) ) {
		cprintf("Monitor Resitration Failure" );
		DosSleep( 2500 );
		return 1;
	}

	_beginthread( screend, 4096, NULL );		// start screen daemon
	_beginthread( mond, 4096, NULL );
	_beginthread( keyd, 4096, NULL );
	_beginthread( cursord, 4096, NULL );

	system( "4os2" );

	DosMonClose( MonHandle );
	return 0;
}

void screend( void *arglist ) {
	while( 1 ) {
	gettext( 1, 1, 80, 25, ScreenMemory );
	DosSleep( 125 );
	}
}


/////////////////////////////////////////////////////////////////////////////
// This function simply reads all keystrokes and passes them along to the
// child application (4os2 or whatever).
/////////////////////////////////////////////////////////////////////////////

void mond( void *arglist ) {
	struct KeyPacket Key;
	int Keylength = sizeof( Key );

	while( 1 ) {
		if ( DosMonRead( inbuf, 0, (PBYTE16) &Key, (PUSHORT) &Keylength ) ) {
			cprintf( "%c Monitor Read Error", 7 );
			return;
		}
	 /* cprintf( " %d,%c,%c,%c,%c,%c,%d ", Key.MonFlags, Key.Data.chChar,
					Key.Data.chScan, Key.Data.fbStatus, 
					Key.Data.fsState, Key.Data.time, Key.DevFlags ); */

		if ( DosMonWrite( outbuf, (PBYTE16) &Key, Keylength ) ) {
			cprintf( "%c Monitor Write error", 7 );
			return;
		}
	}
}


/////////////////////////////////////////////////////////////////////////////
// The Key daemon monitors KeyInfo which is shared memory.  Keyinfo[ 0 ] is
//	the ascii value of the key, while if KeyInfo[ 1 ] is true, the ascii value
// representes the code for a function key.
/////////////////////////////////////////////////////////////////////////////

void keyd( void *arglist ) {
	struct KeyPacket Key	= { 0, { 0, 0, 0, 0, 0, 0}, 0 };

	while( 1 ) {
		if ( KeyInfo[ 0 ] != '\0' ) {
			Key.Data.chChar = 0;					// reset varibles
			Key.Data.chScan = 0;
			Key.Data.fbStatus = 0;

			if ( KeyInfo[ 1 ] == 1 ) {				// check for function key
				Key.Data.fbStatus = 0x0020;
				Key.Data.chChar = 0x0000;			 	// exteded
				Key.Data.chScan = KeyInfo[ 0 ];
				DosMonWrite( outbuf, (PBYTE16) &Key, sizeof( Key ) );
			}
			else {	  										// standard key
 				Key.Data.chChar = KeyInfo[ 0 ]; 
				DosMonWrite( outbuf, (PBYTE16) &Key, sizeof( Key ) );
			}
			KeyInfo[ 0 ] = '\0';
			KeyInfo[ 1 ] = 0;
		}
		else
			DosSleep( 5 );
	}
}			


/////////////////////////////////////////////////////////////////////////////
// Every once in a while this function gets the cursor locations and sticks 
// them into shared memory so that the host can properly position the 
// cursor.  Note the nulls, that makes it easy to atoi() the memory and get
// the integer value	.
////////////////////////////////////////////////////////////////////////////

void cursord( void *arglist ) {
	int x, y;
	char tmp[ 5 ];

	while( 1 ) {
		getcursorpos( x, y );			 // copy cursor positions into shared mem
		itoa( x, tmp, 10 );
		strcpy( KeyInfo + 3, tmp );
		itoa( y, tmp, 10 );				// strcpy automaticaly appends a null
		strcpy( KeyInfo + 6, tmp );
		DosSleep( 125 );
	}
}


void getcursorpos( int& x, int& y ) {
	struct text_info ti;

	gettextinfo( &ti );
	x = ti.curx;
	y = ti.cury;
}

