
/*************************************************************************
   Screen Capture Daemon for use with TaskView
**************************************************************************/


#define INCL_DOS
#define INCL_BASE
#define INCL_DOSMEMMGR
#define INCL_DOSPROCESS
#define INCL_DOSNMPIPES
#define INCL_DOSFILEMGR

#include <os2.h>
#include "monitor.h"
#include <bsememf.h>
#include <stdio.h>
#include <conio.h>
#include <process.h>
#include <stdlib.h>
#include <string.h>


typedef struct _LINFOSEG{
	USHORT pid;
	USHORT ppid;
	USHORT prty;
	USHORT tid;
	USHORT csg;
	USHORT sgSub;
} LINFOSEG;


USHORT MonHandle;				// handle for monitor loop
UCHAR inbuf[ 128 ];
UCHAR outbuf[ 128 ];
char *ScreenMemory;
char *KeyInfo;

void screend( void *arglist );
void mond( void *arglist );
void keyd( void *arglist );
void getcursorpos( int& x, int& y );
void cursord( void *arglist );


struct KeyPacket {
	BYTE mnflags;
	BYTE chChar;
	BYTE chScan;
	BYTE fbStatus;
	BYTE bNlsShift;
	USHORT fsState;
	ULONG time;
	USHORT ddflags;
	BYTE filler;
};

LINFOSEG *local;
USHORT GlobalSeg;
USHORT LocalSeg;
USHORT SessionID;


int main( int argc, char *argv[] ) {
	cprintf("%c", 7 );
	if ( argc < 2 ) {
		cprintf( "Invalid Arguments" );
		return 1;
	}

	char name[ 100 ];
	sprintf( name, "\\SHAREMEM\\%s", argv[ 1 ] );
	if ( DosGetNamedSharedMem( (PPVOID) &ScreenMemory, name, PAG_WRITE ) ) {
		cprintf( "Shared Memory Failed." );
		return 1;
	}

	sprintf( name, "\\SHAREMEM\\K%s", argv[ 1 ] );
	if ( DosGetNamedSharedMem( (PPVOID) &KeyInfo, name, 
												PAG_READ | PAG_WRITE ) ) {
		cprintf( "KeyShared memory failed." );
		return 1;
	}

	if ( DosGetInfoSeg( &GlobalSeg, &LocalSeg ) ) {
		cprintf( "Segmentation Requsition Fault" );
		return 1;
	}
	local = (LINFOSEG*) MAKEP( LocalSeg, 0 );


	if ( DosMonOpen( "KBD$", &MonHandle ) ) {	// open monitor
		cprintf("Error opening monitor" );
		return 1;
	}

	inbuf[0] = outbuf[0] = 128; 

	SessionID = local -> csg;
	cprintf( " %d ", SessionID );
	if ( DosMonReg( MonHandle, inbuf, outbuf, 0, SessionID ) ) {
		cprintf("Monitor Resitration Failure" );
		DosSleep( 2500 );
		return 1;
	}

	_beginthread( screend, 4096, NULL );		// start screen daemon
	_beginthread( mond, 4096, NULL );
	_beginthread( keyd, 4096, NULL );
	_beginthread( cursord, 4096, NULL );

	system( "4os2" );

	DosMonClose( MonHandle );
	return 0;
}

void screend( void *arglist ) {
	while( 1 ) {
	gettext( 1, 1, 80, 25, ScreenMemory );
	DosSleep( 125 );
	}
}


void mond( void *arglist ) {
	struct KeyPacket Key;
	int Keylength = sizeof( Key );

	while( 1 ) {
		if ( DosMonRead( inbuf, 0, (PBYTE16) &Key, (PUSHORT) &Keylength ) ) {
			cprintf( "%c Monitor Read Error", 7 );
			return;
		}
	 /* cprintf( " %d,%c,%c,%c,%c,%c,%d ", Key.MonFlags, Key.Data.chChar,
					Key.Data.chScan, Key.Data.fbStatus, 
					Key.Data.fsState, Key.Data.time, Key.DevFlags ); */

		if ( DosMonWrite( outbuf, (PBYTE16) &Key, Keylength ) ) {
			cprintf( "%c Monitor Write error", 7 );
			return;
		}
	}
}



void keyd( void *arglist ) {
	struct KeyPacket key;
	BYTE Char = 0;
	BYTE buff[ 128 ];
	while( 1 ) {
		memset( &key, 0, sizeof( key ) );		// init key to 0
		if ( KeyInfo[ 0 ] != '\0' ) {
			if ( KeyInfo[ 1 ] == 1 ) 				// check for function key
				key.bNlsShift = 0x42;

			switch ( KeyInfo[ 0 ] ) {
					// the cases indicate the ASCII value of the keystroke
					// I then map the actual scan code into the Char varible
					// using the lookup table.  So: case 1 is control a, 97 is
					// also an 'a' and so is '65' (A).  The acsii value in keyinfo
					// will distinguish which one.  The keyboard scan code tells
					// dosmonwrite what key was actually hit
					case 1:	// control a
					case 65:
					case 97:
						Char = 30;
						break;
					case 2:	// control b
					case 66:
					case 98:
						Char = 48;
						break;
					case 3:	//	control c
					case 67:
					case 99:
						Char = 46;
						break;
					case 4:	// control d
					case 68:
					case 100:
						Char = 32;
						break;
					case 5:	// control e
					case 69:
					case 101:
						Char = 18;
						break;
					case 6:	// control f
					case 70:
					case 102:
						Char = 33;
						break;
					case 7:	// control g
					case 71:
					case 103:
						Char = 34;
						break;
					case 8:	// control h
					case 72:
					case 104:
						Char = 35;
						break;
					case 9:	// control i
					case 73:
					case 105:
						Char = 23;
						break;
					case 10:	// control j
					case 74:
					case 106:
						Char = 36;
						break;
					case 11:	// control k
					case 75:
					case 107:
						Char = 37;
						break;
					case 12: // control l
					case 76:
					case 108:					
						Char = 38;
						break;
					case 13:	// comtrol m
					case 77:
					case 109:
						Char = 50;
						break;
					case 14:	//	control n
					case 78:
					case 110:
						Char = 49;
						break;
					case 15:	// control o
					case 79:
					case 111:
						Char = 24;
						break;
					case 16: // control p
					case 80:
					case 112:
						Char = 25;
						break;
					case 17: // control q
					case 81:
					case 113:
						Char = 16;
						break;
					case 18: // control r
					case 82:
					case 114:
						Char = 19;
						break;
					case 19:	// control s
					case 83:
					case 115:
						Char = 31;
						break;
					case 20:	// control t
					case 84:
					case 116:
						Char = 20;
						break;
					case 21:	// control u
					case 85:
					case 117:
						Char = 22;
						break;
					case 22: // control v
					case 86:
					case 118:
						Char = 47;
						break;
					case 23:	// control w
					case 87:
					case 119:
						Char = 17;
						break;
					case 24:	// control x
					case 88:
					case 120:
						Char = 45;
						break;
					case 25: // control y
					case 89:
					case 121:
						Char = 21;
						break;
					case 26: // control z
					case 90:
					case 122:
						Char = 44;
						break;
					case 27:	// escape
						Char = 1;
						break;
					case 32: // space
						Char = 57;
						break;
					case 33: // !
					case 49: // 1
						Char = 2;
						break;
					case 50: // 2
					case 64: // @
						Char = 3;
						break;
					case 34: // "
					case 39: // '
						Char = 40;
						break;
					case 35: // #
					case 51: // 3
						Char = 4;
						break;
					case 36: // $
					case 52: // 4
						Char = 5;
						break;
					case 37: // %
					case 53: // 5
						Char = 6;
						break;
					case 38: // &
					case 55: // 7
						Char = 8;
				 		break;			
					case 40: // (
					case 57: // 9
						Char = 10;
						break;
					case 41: // )
					case 48: // 0
						Char = 11;
						break;
					case 42: // *
					case 56: // 8
						Char = 9;
						break;
					case 43: // +
					case 61: // =
						Char = 13;
						break;
					case 44: // ,
					case 60: // <
						Char = 51;
						break;
					case 45: // -
					case 95: // _
						Char = 12;
						break;
					case 46: // .
					case 62: // >
						Char = 52;
						break;
					case 47: // /
					case 63: // ?
						Char = 53;
						break;
					case 91: // [
					case 123: // {
						Char = 26;
						break;
					case 92: // \
					case 124: // |
						Char = 43;
						break;
					case 93: // ]
					case 125: // }
						Char = 27;
						break;
					case 94: // ^
					case 54: // 6
						Char = 7;
						break;
					case 96: // `
					case 126: // ~
						Char = 41;
						break;
			} // switch

			//key.mnflags - 0x80;
			if ( KeyInfo[ 1 ] == 1 ) {
				key.chChar = Char;
				key.chScan = KeyInfo[ 0 ];
			}
			else {
				key.chChar = Char;
				key.chScan = KeyInfo[ 0 ];
				key.fbStatus = Char;
			}
			memcpy( buff, &key, sizeof( key ) );

			DosMonWrite( outbuf, buff, 14 );
			key.chChar |= 0x80;
			key.ddflags = 0x4000;
			memcpy( buff, &key, sizeof( key ) );
			DosMonWrite( outbuf, buff, 14 );
			KeyInfo[ 0 ] = '\0';
			KeyInfo[ 1 ] = 0;
		}
		else
			DosSleep( 5 );
	}// while
}			


void cursord( void *arglist ) {
	int x, y;
	char tmp[ 5 ];

	while( 1 ) {
		getcursorpos( x, y );			 // copy cursor positions into shared mem
		itoa( x, tmp, 10 );
		strcpy( KeyInfo + 3, tmp );
		itoa( y, tmp, 10 );
		strcpy( KeyInfo + 6, tmp );
		DosSleep( 125 );
	}
}


void getcursorpos( int& x, int& y ) {
	struct text_info ti;

	gettextinfo( &ti );
	x = ti.curx;
	y = ti.cury;
}

