/* SAMPLE.CMD to demonstrate the use of a rexx exit for  */
/* Time Tracker - author Trevor Hemsley, 01-08-96        */
/*                                                       */
/* This exit must pass back a numeric return code to its */
/*   caller. If it passes back 0 the log record is used  */
/*   by the report function. If it passes back 1 the     */
/*   the record is ignored and not used. Any other value */
/*   is treated as invalid and zero is assumed           */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs   /* load rexx functions */

PARSE ARG logrecord             /* get the arguments passed to us (the log record) */

/* split the input record at the commas into variables date, time, duration and description */
PARSE VALUE logrecord WITH date ',' time ',' duration ',' description 

if date = "01-08-1996" then exit 0 /* only report on records from 1st August */
else exit 1                        /* otherwise ignore them */
