unit timeform;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Tabs, Grids;

type
  TFormTime = class(TForm)
    b_Reset: TButton;
    l_Speed: TLabel;
    l_Elapsed: TLabel;
    b_Exit: TButton;
    Panel1: TPanel;
    TabSet1: TTabSet;
    Notebook1: TNotebook;
    l_4: TLabel;
    l_5: TLabel;
    l_6: TLabel;
    GroupBox1: TGroupBox;
    l_1: TLabel;
    l_2: TLabel;
    l_3: TLabel;
    b_Start: TButton;
    rg_Setup: TRadioGroup;
    b_Stop: TButton;
    Label1: TLabel;
    sg_Bench: TStringGrid;
    procedure FormCreate(Sender: TObject);
    procedure b_ResetClick(Sender: TObject);
    procedure b_ExitClick(Sender: TObject);
    procedure TabSet1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure b_StartClick(Sender: TObject);
    procedure b_StopClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
    TestType: Integer;
    Elapsed: Double;
    StartTime: Longint;
    Stop: Boolean;
  public
    { Public declarations }
    procedure UpdateLabels(Sender: TObject; var Done: Boolean);
  end;

var
  FormTime: TFormTime;

implementation

{$R *.DFM}

const
  Counter : Longint = 0;

procedure TFormTime.UpdateLabels(Sender: TObject; var Done: Boolean);
var
  s: String;
begin
  if Counter = 0 then
    StartTime := GetTickCount;
  inc(Counter);
  s := IntToStr(Counter);
  l_1.Caption := s;
  l_2.Caption := s;
  l_3.Caption := s;
  l_4.Caption := s;
  l_5.Caption := s;
  l_6.Caption := s;

  if Counter mod 25 = 0 then
    begin
      { Update updates/sec and elapsed time }
      Elapsed := (GetTickCount-StartTime)/1000;
      l_Speed.Caption := Format('%.1f', [Counter/Elapsed]);
      l_Elapsed.Caption := Format('%.1f', [Elapsed]);
    end;
  Done := True;
end;

procedure TFormTime.FormCreate(Sender: TObject);
begin
  Tabset1.Tabs := Notebook1.Pages;
  with sg_Bench do
    begin
      RowCount := 8;
      ColWidths[2] := DefaultColWidth+15;
      ColWidths[3] := DefaultColWidth-20;
      Cells[0,0] := 'OpSys';
      Cells[1,0] := 'TimeTest Exe';
      Cells[2,0] := 'CPU';
      Cells[3,0] := 'Result';

      Cells[0,1] := 'Win NT 4';
      Cells[1,1] := 'Win32';
      Cells[2,1] := 'Pentium Pro 200';
      Cells[3,1] := '448';

      Cells[0,2] := 'Windows 95';
      Cells[1,2] := 'Win32';
      Cells[2,2] := 'Pentium Pro 200';
      Cells[3,2] := '411';

      Cells[0,3] := 'Windows 95';
      Cells[1,3] := 'Win16';
      Cells[2,3] := 'Pentium Pro 200';
      Cells[3,3] := '404';

      Cells[0,4] := 'Win NT 4';
      Cells[1,4] := 'Win16';
      Cells[2,4] := 'Pentium Pro 200';
      Cells[3,4] := '291';

      Cells[0,5] := 'Win 3.11';
      Cells[1,5] := 'Win16';
      Cells[2,5] := '486 DX/2 66';
      Cells[3,5] := '91';

      Cells[0,6] := 'Warp 4';
      Cells[1,6] := 'OS/2';
      Cells[2,6] := 'Pentium Pro 200';
      Cells[3,6] := '48';

      Cells[0,7] := 'Warp 4';
      Cells[1,7] := 'OS/2';
      Cells[2,7] := '486 DX/2 66';
      Cells[3,7] := '9';
    end;
end;

procedure TFormTime.b_ResetClick(Sender: TObject);
begin
  Counter := 0;
end;

procedure TFormTime.b_ExitClick(Sender: TObject);
begin
  close;
end;

procedure TFormTime.TabSet1Change(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
  notebook1.PageIndex := NewTab;
end;

procedure TFormTime.b_StartClick(Sender: TObject);
var
  Dummy: Boolean;
begin
  TestType := rg_Setup.ItemIndex;
  Counter := 0;
  b_Start.Enabled := False;
  b_Reset.Enabled := True;
  case TestType of
    0 : Application.OnIdle := UpdateLabels;
    1 : begin
          Stop := false;
          Elapsed := 0;
          Repeat
            UpdateLabels(nil, Dummy);
            Application.ProcessMessages;
          Until Stop or (Elapsed > 10);
          b_StopClick(Sender);
        end;
  end;
end;

procedure TFormTime.b_StopClick(Sender: TObject);
begin
  case TestType of
    0 : Application.OnIdle := nil;
    1 : Stop := True;
  end;
  b_Reset.Enabled := False;
  b_Start.Enabled := true;
end;

procedure TFormTime.FormResize(Sender: TObject);
begin
  Panel1.Height := FormTime.ClientHeight - 225;
  sg_Bench.Height := notebook1.ClientHeight - 60;
end;

end.
