/*
$Revision:   1.32  $
$Date:   18 Jan 1999 13:58:32  $

*/
/***************************************************************************
*                         QuaTech, Incorporated                            *
*                          Akron, Ohio  44311                              *
*                                                                          *
*                   Copyright 1992-1995 QuaTech, Incorporated              *
*                           All rights reserved                            *
*                                                                          *
*                                                                          *
*  PROGRAM: syncdriv.h                                                     *
*                                                                          *
*  PURPOSE: MsgBuf structure definition file and function prototype        *
*           for Syncdrive                                                  *
*                                                                          *
***************************************************************************/

// CHM  12/18/1995  1:54pm
// Flag to make sure this file is only processed once.
#ifndef syncdrive_h
#define syncdrive_h


/**************************************************************************
 *
 * Definition of buffer_size.
 *
 * This is the number of bytes in comm_buffer array of the com_block
 *    structure.  This is determined at compile time.
 *
 * This value should be set by the user to the maximum expected frame
 *    length.  Added to COMBLOCK_OVERHEAD, this value cannot exceed
 *    65535 bytes.
 *
 * The factory default is for 1000 byte comm_buffers.
 *
 *************************************************************************/
#ifndef buffer_size
#define buffer_size        1000
#endif



/**************************************************************************
 *
 * CHM  12/18/1995  1:46pm
 * Board signatures
 *
 *************************************************************************/
#define MPASyncdriveSig    0xcc

#define MPA100_ID          0x91
#define MPA200_ID          0x90
#define MPA2000_ID         0x92
#define MPA102_ID          0x93
#define MPAP100_ID         0x94

#define SYNC_BASE          0x90



/**************************************************************************
 *
 * CHM  12/18/1995  1:46pm
 * Data types
 *
 *************************************************************************/
#ifndef USHORT
#define USHORT  unsigned short
#endif

#ifndef UCHAR
#define UCHAR   unsigned char
#endif

#ifndef ULONG
#define ULONG   unsigned long
#endif

#ifndef FALSE
#define FALSE   0
#endif

#ifndef TRUE
#define TRUE    !FALSE
#endif

/**************************************************************************
 *
 * CHM  12/18/1995  1:57pm
 * Syncdrive com_block structure
 *
 * This is the structure used for transmit and receive com_blocks.
 *
 * There are two generic forms of this structure, and a version specific
 * to each protocol that Syncdrive supports.  These forms are overlaid
 * in a UNION, so the user is free to use whichever form is most convenient.
 *
 *************************************************************************/

/**************************************************************************
 *
 * CHM  12/18/1995  1:48pm
 * Syncdrive global limits
 *
 *************************************************************************/

// CHM  12/18/1995  1:50pm
// Boards numbered 0 through 5 supported.
#define MAX_BOARDS            6

// CHM  12/18/1995  1:50pm
// MPA-102 supports two channels.  Other board support one channel.
#define MAX_CHN_PER_BOARD     2
#define MAX_CHANNELS          (MAX_BOARDS * MAX_CHN_PER_BOARD)

// CHM  12/18/1995  1:54pm
// Length in bytes of the fixed portion of a com_block structure.
//    This includes everything except the comm_buffer array.
#if defined(_WINDOWS) && !defined(__WIN95__)
#define COMBLOCK_OVERHEAD      16+4    // Extra space for WIN_HANDLE in Win 3.1
#else 
#define COMBLOCK_OVERHEAD      16
#endif




/**************************************************************************
*
* CHM  12/18/1995  2:32pm
* Syncdrive command numbers for sync_command function
*
*************************************************************************/
#define  GetBoardStatus    0x00
#define  WriteBoardStatus  0x01
#define  SetTransmitBaud   0x02
#define  SetReceiveBaud    0x03
#define  HaltReceiver      0x04
#define  ModReceiveMask    0x05


/**************************************************************************
 *
 * CHM  12/18/1995  2:33pm
 * BISYNC receive mask definitions
 *
 *************************************************************************/
#define  ReceiveChar       0x00        /* Normal recieved character */
#define  StartOfMessage    0x01
#define  EndOfMessage      0x02
#define  PadChar           0x03
#define  SynchChar         0x04


/**************************************************************************
 *
 * CHM  12/18/1995  2:33pm
 * Com_block buffer_status (b_stat) definitions
 *
 *************************************************************************/
#define  MessageDone       0x80
#define  RxDone            0x80
#define  RxData            0x40
#define  RxCRC             0x20
#define  RxFull            0x10
#define  RxAbort           0x08
#define  RxError           0x04

#define  TxDone            0x80
#define  TxData            0x40
#define  TxCRC             0x20
#define  TxAbort           0x08
#define  TxError           0x04

#define  FrameTimeout      0x01


/**************************************************************************
 *
 * CHM  6/3/1996  3:28pm
 * Com_block buffer_error (b_error) definitions
 *
 *************************************************************************/
#define  RX_OVERWRITTEN    0x01

#define  TX_RETRANSMITTED  0x01



/**************************************************************************
 *
 * CHM  5/2/1997  8:34am
 * Com_block misc_options definitions
 *
 *************************************************************************/

#define BLOCK_STREAM       0x01



/**************************************************************************
 *
 * CHM  12/13/1995  4:01pm
 * Syncdrive API function return codes.
 *    All functions return a short integer value (16 bits).
 *
 * 0x0000   Function successfully completed
 *
 * 0x0xxx   User error (see below)
 *
 * 0x1xxx   Internal Syncdrive error (report to Quatech)
 *
 *************************************************************************/
#define SYNC_SUCCESS                      0x0000   // Function complete
#define BAD_CFG_POINTER                   0x0001   // Invalid channel_cfg pointer
#define BAD_SIGNATURE                     0x0002   // Invalid signature (channel_cfg)
#define BAD_BOARD_ID                      0x0003   // Invalid board type (channel_cfg)
#define NO_BISYNC_MASK                    0x0004   // Not running BISYNC mode
#define CHANNEL_ALREADY_CONFIGURED        0x0005   // Invalid repeat config_mpaxxxx call
#define BAD_MASK_TYPE                     0x0006   // Rx char type out of range
#define CANNOT_SET_STATUS                 0x0007
#define CANNOT_SET_BAUD                   0x0008
#define CANNOT_RESET_RX                   0x0009
#define BAD_QUEUE_MODE                    0x000A   // Invalid BufferQueue.QueueMode
#define CANNOT_ALLOCATE_DMA_BUFFER        0x000B
#define CANNOT_FREE_DMA_BUFFERS           0x000C
#define TOO_MANY_DMA_BUFFERS              0x000D   // DMA buffer count limit exceeded
#define BOARD_NUMBER_OUT_OF_RANGE         0x000F   // Invalid board_number (channel_cfg)
#define BAD_DMA_CHANNEL_NUMBER            0x0010   // DMA 1, 2, or 3 are valid
#define TOO_MANY_COMBLOCKS                0x0011
#define CANNOT_ABORT_TX                   0x0012
#define QUEUE_ALREADY_REGISTERED          0x0013   // Free the registered queue first
#define QUEUE_NOT_REGISTERED              0x0014   // Register a queue first
#define QUEUE_ALREADY_RUNNING             0x0015   // Abort the Rx or Tx operation first
#define CHANNEL_NOT_OPEN                  0x0016   // Call config_mpaXXXX first
#define COMBLOCK_TOO_LARGE                0x0017   // Exceeds 64kB, including overhead
#define NULL_BUFFER_LENGTH                0x0018   // Comblock buffer_length was 0.
#define VERSION_MISMATCH                  0x0019   // DLL, device driver versions don't match.
#define BAD_IRQ_NUMBER                    0x0020   // Invalid IRQ or IRQ in use
#define INVALID_COMMAND                   0x0030   // Command number out of range
#define BAD_BAUD_RATE                     0x0031   // Maximum = (0.25)(clock rate)
#define QUEUE_DMA_SETUP_ERROR             0x0032   // BufferArray[] contains non-DMA buffer.
#define DMA_SETUP_ERROR                   0x0033   // Use sync_alloc_dma_buffer with DMA.
#define DRIVER_BUSY                       0x0082   // Still processing an earlier frame

#define FATAL_CANNOT_GET_SEMAPHORE        0x1001
#define FATAL_CANNOT_RELEASE_SEMAPHORE    0x1002
#define FATAL_CANNOT_CREATE_SEMAPHORE     0x1003
#define FATAL_CANNOT_DESTROY_SEMAPHORE    0x1004
#define FATAL_CANNOT_OPEN_CHANNEL         0x1005
#define FATAL_CANNOT_CLOSE_CHANNEL        0x1006
#define FATAL_CANNOT_SET_SYSINFO          0x1007
#define FATAL_CANNOT_MALLOC_OBJECT        0x1008
#define FATAL_CANNOT_MALLOC_MASK          0x1009
#define FATAL_CANNOT_MALLOC_QUEUE         0x100A
#define FATAL_CANNOT_STORE_CONFIG_ARRAY   0x100B
#define FATAL_CANNOT_LOCK_MEMORY          0x100C
#define FATAL_GDT_MAPPING_FAILED          0x100D
#define FATAL_CANNOT_UNLOCK_MEMORY        0x100E
#define FATAL_CANNOT_GET_GLOBAL_MAP       0x100F
#define FATAL_CANNOT_FREE_GLOBAL_MAP      0x1010
#define FATAL_CANNOT_FIND_DRIVER          0x1011





/**************************************************************************
 *
 * CHM  1/18/1999  10:51am
 * Handles update for Windows 3.1 applications
 *
 * Starting with Release 4.00, Syncdrive no longer uses Windows memory handles
 * internally.  The user is no longer required to allocate and free locked 
 * memory with the sync_lmem_alloc() and sync_lmem_free() Syncdrive APIs.
 * Though no longer used, placeholders for WIN_HANDLEs have been left in the
 * various com_block structures and in the channel configuration structure
 * in order to accommodate existing binaries.
 *
 *************************************************************************/



// CHM  12/18/1995  2:01pm
// First generic form of com_block structure.

struct MsgBuf
         {
#if defined(_WINDOWS) && !defined(__WIN95__)
        WIN_HANDLE (BufferHNDL, res0)       // Windows 3.1 backward compat.
#endif
        USHORT   b_len;                     // length of message in b_data
        USHORT   b_ptr;                     // tx, rx buffer pointers
        UCHAR    b_stat;                    // tx, rx buffer status
        UCHAR    b_error;                   // Error number if tx, rx error
        USHORT   md0;                       // Message dependent values
        USHORT   md1;                       //   (see specific versions)
        USHORT   md2;
        USHORT   md3;
        USHORT   md4;
        UCHAR    b_data[buffer_size];       // data buffer for tx, rx
        };




// CHM  12/18/1995  2:02pm
// Second generic form of com_block structure (long names).

struct GenMsgBuf
        {
#if defined(_WINDOWS) && !defined(__WIN95__)
        WIN_HANDLE (BufferHNDL, res0)       // Windows 3.1 backward compat.
#endif
        USHORT   buffer_length;             // length of message in b_data
        USHORT   buffer_pointer;            // tx, rx buffer pointers
        UCHAR    buffer_status;             // tx, rx buffer status
        UCHAR    buffer_error;              // Error number if tx, rx error
        UCHAR    message_dependent_1;       // Message dependent values
        UCHAR    message_dependent_2;       //   (see specific versions)
        UCHAR    message_dependent_3;
        UCHAR    message_dependent_4;
        UCHAR    message_dependent_5;
        UCHAR    message_dependent_6;
        UCHAR    message_dependent_7;
        UCHAR    message_dependent_8;
        USHORT   reserved_int;
        UCHAR    comm_buffer[buffer_size];  // data buffer for tx, rx
        };




// CHM  12/18/1995  2:08pm
// Bit synchronous transmit form of com_block structure.

struct BitTMsgBuf
        {
#if defined(_WINDOWS) && !defined(__WIN95__)
        WIN_HANDLE (BufferHNDL, res0)       // Windows 3.1 backward compat.
#endif
        USHORT   buffer_length;             // length of message in b_data
        USHORT   buffer_pointer;            // tx buffer pointer
        UCHAR    buffer_status;             // tx buffer status
        UCHAR    buffer_error;              // Error number if tx error
        UCHAR    idle_flag;                 // 0 = idle with syncs, 1 = disable
        UCHAR    reserved_char_1;
        UCHAR    reserved_char_2;
        UCHAR    reserved_char_3;
        UCHAR    reserved_char_4;
        UCHAR    reserved_char_5;
        UCHAR    reserved_char_6;
        UCHAR    dma_page;                  // DO NOT MODIFY!
        USHORT   dma_offset;                // DO NOT MODIFY!
        UCHAR    comm_buffer[buffer_size];  // data buffer for tx
        };




// CHM  12/18/1995  2:09pm
// Bit synchronous receive form of com_block structure.

struct BitRMsgBuf
        {
#if defined(_WINDOWS) && !defined(__WIN95__)
        WIN_HANDLE (BufferHNDL, res0)       // Windows 3.1 backward compat.
#endif
        USHORT   buffer_length;             // length of message in b_data
        USHORT   buffer_pointer;            // rx buffer pointer
        UCHAR    buffer_status;             // rx buffer status
        UCHAR    buffer_error;              // Error number if rx error
        UCHAR    reserved_char_1;
        UCHAR    reserved_char_2;
        UCHAR    reserved_char_3;
        UCHAR    reserved_char_4;
        UCHAR    reserved_char_5;
        UCHAR    reserved_char_6;
        UCHAR    reserved_char_7;
        UCHAR    dma_page;                  // DO NOT MODIFY!
        USHORT   dma_offset;                // DO NOT MODIFY!
        UCHAR    comm_buffer[buffer_size];  // data buffer for rx
        };




// CHM  12/18/1995  2:09pm
// Byte synchronous transmit form of com_block structure.

struct ByteTMsgBuf
        {
#if defined(_WINDOWS) && !defined(__WIN95__)
        WIN_HANDLE (BufferHNDL, res0)       // Windows 3.1 backward compat.
#endif
        USHORT   buffer_length;             // length of message in b_data
        USHORT   buffer_pointer;            // tx buffer pointer
        UCHAR    buffer_status;             // tx buffer status
        UCHAR    buffer_error;              // Error number if tx error
        UCHAR    idle_flag;                 // 0 = idle with syncs, 1 = disable
        UCHAR    misc_options;              // bit 0 = 1 for block mode streaming
        UCHAR    reserved_char_1;
        UCHAR    message_type;              // 0 = message mode, 1 = block mode
        UCHAR    message_sdi;               // UCHAR defining SDI for this message
        UCHAR    message_edi;               // UCHAR defining EDI for this message
        UCHAR    num_syncs;                 // No. of syncs (-2) to start message
        UCHAR    sync_count;                // DO NOT MODIFY!
        UCHAR    num_txpads;                // No. of pads to terminate message
        UCHAR    txpad_count;               // DO NOT MODIFY!
        UCHAR    comm_buffer[buffer_size];  // data buffer for tx
        };




// CHM  12/18/1995  2:10pm
// Byte synchronous receive form of com_block structure.

struct ByteRMsgBuf
        {
#if defined(_WINDOWS) && !defined(__WIN95__)
        WIN_HANDLE (BufferHNDL, res0)       // Windows 3.1 backward compat.
#endif
        USHORT   buffer_length;             // length of message in b_data
        USHORT   buffer_pointer;            // rx buffer pointer
        UCHAR    buffer_status;             // rx buffer status
        UCHAR    buffer_error;              // Error number if rx error
        UCHAR    reserved_char_1;
        UCHAR    misc_options;              // bit 0 = 1 for block mode streaming
        UCHAR    reserved_char_2;
        UCHAR    message_type;              // 0 = message mode, 1 = block mode
        UCHAR    reserved_char_3;
        UCHAR    reserved_char_4;
        UCHAR    num_pads;                  // No. of pads determining idle line
        UCHAR    pad_count;                 // DO NOT MODIFY!
        UCHAR    block_term;                // UCHAR defining block mode terminator
        UCHAR    reserved_char_5;           // DO NOT MODIFY!
        UCHAR    comm_buffer[buffer_size];  // data buffer for rx
        };



/**************************************************************************
 *
 * CHM  12/18/1995  2:21pm
 * Union to overlay all com_block structure definitions
 *
 *************************************************************************/

union com_block
        {
         struct  MsgBuf      A;             // Generic, short names
         struct  GenMsgBuf   B;             // Generic, long names
         struct  BitTMsgBuf  BitT;          // Bit sync transmit
         struct  BitRMsgBuf  BitR;          // Bit sync receive
         struct  ByteTMsgBuf ByteT;         // Byte sync transmit
         struct  ByteRMsgBuf ByteR;         // Byte sync receive
         };






/**************************************************************************
 *
 * CHM  12/18/1995  1:46pm
 * Buffer queue definitions
 *
 * QueueStatus:   b31         QUEUE_DONE
 *                b30         QUEUE_RUNNING
 *                b29         QUEUE_HALTED
 *                b28         QUEUE_ADVANCED
 *                b17         QUEUE_OVERRUN
 *                b16         QUEUE_ERROR
 *                b15-b0      Error detail
 *
 *   all other bits are reserved
 *
 *
 * QueueMode:     b0       RING
 *                b1       ONESHOT   (b0, b1 mutually exclusive)
 *                b2       RECEIVE
 *                b3       TRANSMIT  (b2, b3 mutually exclusive)
 *                b4       ALLOW_OVERRUN
 *                b5       DMA
 *
 *    all other bits are reserved
 *
 *************************************************************************/

#define QUEUE_DONE            0x80000000L
#define QUEUE_RUNNING         0x40000000L
#define QUEUE_HALTED          0x20000000L
#define QUEUE_ADVANCED        0x10000000L
#define QUEUE_OVERRUN         0x00020000L
#define QUEUE_ERROR           0x00010000L
#define QUEUE_NULL_BUFFER     0x00000018L

#define QUEUE_RING            0x00000001L
#define QUEUE_ONESHOT         0x00000002L
#define QUEUE_RECEIVE         0x00000004L
#define QUEUE_TRANSMIT        0x00000008L
#define QUEUE_ALLOW_OVERRUN   0x00000010L
#define QUEUE_DMA             0x00000020L



/**************************************************************************
 *
 * CHM  10/25/1995  10:59am
 * Buffer queue structure.
 *
 * When created with sync_register_queue, extra space is allocated after the
 * ComBlockPtrs element to hold the actual com_block pointers.  The application
 * should never touch these pointers because Syncdrive may modify them, depending
 * on the operating system platform in use.
 *
 *************************************************************************/

struct BufferQueue
        {
        ULONG    NumberOfPointers;    // Number of com_block pointers in this structure.
        ULONG    CurrentBuffer;       // Buffer number (starting with 0) that Syncdrive
                                                                                        //  is currently processing.
        ULONG    NotifyThreshold;     // Number of buffers after which to notify app.
        ULONG    QueueStatus;         // Overall status of the buffer queue.
        ULONG    QueueMode;           // Oneshot or ring.

        union com_block _far * (_far *ComBlockPtrs); // DO NOT MODIFY!
        union com_block _far * (_far *res1);         // DO NOT MODIFY!

#ifdef __OS2__
        void        _far * (_far *LockHandlePtrs);   // DO NOT MODIFY!
#endif
        };



#endif         /* syncdrive_h */

