/*
$Revision:   1.9  $
$Date:   Jan 26 1999 16:13:02  $

*/
/***************************************************************************
*                         QuaTech, Incorporated                            *
*                          Akron, Ohio  44311                              *
*                                                                          *
*                   Copyright 1992-1995 QuaTech, Incorporated              *
*                           All rights reserved                            *
*                                                                          *
*                                                                          *
*  PROGRAM: mpa-x00.h                                                      *
*                                                                          *
*  PURPOSE: configuration array channel_cfg structure definition file for  *
*           Syncdrive and the MPA series adapters.                         *
*                                                                          *
****************************************************************************
*
*/

// CHM  12/18/1995  3:11pm
// Flag to make sure this file is only processed once.
#ifndef mpax00_h
#define mpax00_h


// CHM  12/19/1995  9:09am
// Make sure that syncdriv.h has already been included.
#ifndef syncdrive_h
#error "Please include SYNCDRIV.H before MPA-X00.H!"
#endif


/**************************************************************************
 *
 * CHM  12/18/1995  3:00pm
 * Structure definition for channel_cfg structure
 *
 *************************************************************************/

struct channel_cfg
   {
   UCHAR   signature;               // Reserved, set to 0xCC
                                    // type of card:  MPA-200  0x90
   UCHAR   structure_type;          //                MPA-100  0x91
                                    //                MPA-2000 0x92
                                    //                MPA-102  0x93
                                    //                MPAP-100 0x94

   USHORT  board_number;            // Board number 0-5
   UCHAR   channel;                 // 0 = A, and 1 = B

   UCHAR   operating_mode;          //   76543210
                                    //   00------     Reserved
                                    //   --00----     NRZ
                                    //   --01----     NRZI
                                    //   --10----     FM1
                                    //   --11----     FM0
                                    //   ----0010     MonoSync w/ 8 bit sync
                                    //   ----0100     Bisync w/ 16 bit sync
                                    //   ----1000     Bit Sync w/ 8 bit address

   UCHAR   line_control;            //   76543210
                                    //   00------     5 bit TX
                                    //   01------     7 bit TX
                                    //   10------     6 bit TX
                                    //   11------     8 bit TX
                                    //   --00----     5 bit RX
                                    //   --01----     7 bit RX
                                    //   --10----     6 bit RX
                                    //   --11----     8 bit RX
                                    //   ----00--     Reserved
                                    //   ------00     No Parity
                                    //   ------01     Odd Parity
                                    //   ------11     Even Parity


   UCHAR   options;                 //   76543210
                                    //   1-------     AUTO ENABLES
                                    //   -1           ADDRESS ENABLES
                                    //   --000000     Reserved

   USHORT  base_address;            // Base address of the card.
   UCHAR   tx_dma_channel;          // TX DMA channel, 0 if unused
   UCHAR   rx_dma_channel;          // RX DMA channel, 0 if unused
   UCHAR   tx_interrupt;            // Rx, Tx IRQ levels must
   UCHAR   rx_interrupt;            //    be the same number.

   UCHAR   crc_mode;                //  CRC algorithim hardware:
                                    //
                                    //   76543210
                                    //   000000--      Reserved
                                    //   ------00      No CRC
                                    //   ------01      CRC-16
                                    //   ------10      CRC-CCITT
                                    //

   UCHAR   clock_source;            //   76543210
                                    //   ========
                                    //   00------   x1  clock
                                    //   01------   x16 clock
                                    //   10------   x32 clock
                                    //   11------   x64 clock
                                    //   --1-----   output rx clk (from TRxCB)
                                    //   --0-----   input  rx clk (RTxCA or RTxCB)
                                    //   ---00---   rx clk src = RTxC pin
                                    //   ---01---   rx clk src = TRxC pin
                                    //   ---10---   rx clk src = BR gen
                                    //   ---11---   rx clk src = DPLL output
                                    //   -----1--   output Tx clk (TRxCA)
                                    //   -----0--   input Tx clk  (TRxCA)
                                    //   ------00   tx clk src = RTxC pin
                                    //   ------01   tx clk src = TRxC pin
                                    //   ------10   tx clk src = BR gen
                                    //   ------11   tx clk src = DPLL output

   ULONG   clock_rate;              // On board clock oscillator freq
   ULONG   rx_baud_rate;            // Desired Recieve baud rate
   ULONG   tx_baud_rate;            // Desired Transmit baud rate

   ULONG   read_timeout;            // For OS/2, device driver read and
   ULONG   write_timeout;           //  write timeouts in milliseconds.

   UCHAR   sync_char_1;             // monosync - 8 bit tx sync character
                                    // bisync   - 8 LSB's of 16 bit tx/rx sync
                                    // bit sync - secondary address


   UCHAR   sync_char_2;             // monosync - 8 bit rx sync character
                                    // bisync   - 8 MSB's of 16 bit tx/rx sync
                                    // bit sync - must be 0x7E (Flag character)


   UCHAR   protocol_dependent0;     // BISYNC PAD CHAR

   UCHAR   protocol_dependent1;     // BISYNC:
                                    //   1=Don't include STX in CRC

   UCHAR   protocol_dependent2;     // HDLC:
                                    //   0=Idle line with syncs
                                    //   1=Idle line with Flags

   UCHAR   protocol_dependent3;     // 85230 Fifo Support:
                                    //   bit 0 --- FIFO support (ignored:
                                    //     FIFOs always enabled when present)


   UCHAR   protocol_dependent4;     // Reserved --- DO NOT MODIFY!!!!
   UCHAR   protocol_dependent5;     // Reserved --- DO NOT MODIFY!!!!
   UCHAR   protocol_dependent6;     // Reserved --- DO NOT MODIFY!!!!
   UCHAR   protocol_dependent7;     // Reserved --- DO NOT MODIFY!!!!

#if defined(_WINDOWS) && !defined(__WIN95__)
   WIN_HANDLE (res0, res1)          // Reserved --- DO NOT MODIFY!!!!
#endif

   void   _far    *pt1;             // Reserved --- DO NOT MODIFY!!!!
   void   _far    *pt1a;            // Reserved --- DO NOT MODIFY!!!!
   };





/*****************************************************************************
 *
 *  CHM   2 Feb 1995   2:10pm
 *  Syncdrive API function prototypes.
 *
 *****************************************************************************/




// CHM  2 Feb 1995   1:59pm ***/
// Allow different calling conventions per platform by using
//    the SYNCDRIVE_API function type modifier.

#ifndef SYNCDRIVE_API

   #ifdef __OS2__
      #define    SYNCDRIVE_API APIENTRY         // OS/2 DLL
   #else
      #ifdef _WINDOWS
         #ifdef __WIN95__ // Win95 32 bit dll
            #ifdef BUILDING_THE_DLL    // (Quatech use only.)
               #define SYNCDRIVE_API __declspec(dllexport) _cdecl 
            #else // For customers building apps.
               #define SYNCDRIVE_API __declspec(dllimport) _cdecl 
            #endif 
         #else
            #define SYNCDRIVE_API _export _cdecl   // 16 bit WINXX DLL
         #endif   
      #else
         #define SYNCDRIVE_API                  // null for DOS
      #endif
   #endif

#endif




/*** CHM  2 Feb 1995   2:10pm ***/
/*** Allow C++ code to link with Syncdrive. ***/

#if __cplusplus
extern "C" {
#endif


// CHM  12/18/1995  2:28pm
// These functions have the same interface across all platforms.

short SYNCDRIVE_API config_MPA100 (struct channel_cfg _far *);

short SYNCDRIVE_API config_MPA200 (struct channel_cfg _far *);

short SYNCDRIVE_API config_MPA2000(struct channel_cfg _far *);

short SYNCDRIVE_API config_MPA102 (struct channel_cfg _far *);

short SYNCDRIVE_API config_MPAP100(struct channel_cfg _far *);

short SYNCDRIVE_API sync_command(struct channel_cfg _far *, short,...);

short SYNCDRIVE_API sync_abort_message(struct channel_cfg _far *);

short SYNCDRIVE_API sync_release(struct channel_cfg _far *);

short SYNCDRIVE_API sync_free_dma_buffers(void);

short SYNCDRIVE_API sync_alloc_dma_buffer(struct channel_cfg far *,
                                          USHORT,
                                          union com_block far * (*));

short SYNCDRIVE_API sync_register_queue(struct channel_cfg _far *,
                                        ULONG,
                                        union com_block _far *[],
                                        ULONG,
                                        ULONG,
                                        struct BufferQueue _far * (_far *));

short SYNCDRIVE_API sync_free_queue(struct channel_cfg _far *, struct BufferQueue _far *);

short SYNCDRIVE_API sync_version (struct channel_cfg _far *,
                                  USHORT *,
                                  USHORT *);


// CHM  12/18/1995  2:29pm
// The sync_receive and sync_transmit functions have an extra
//    parameter in the OS/2 and Windows versions of Syncdrive.
//
// The sync_lmem_alloc and sync_lmem_free functions exist only
//    in the Windows 3.1 version of Syncdrive. They exist only
//    for compatibility with previously-compiled applications.
//    Their use is no longer required with Syncdrive Release 4.00
//    or later.


#ifdef _WINDOWS
      short SYNCDRIVE_API sync_receive(struct channel_cfg *,
                                       union com_block *,
                                       ULONG);

      short SYNCDRIVE_API sync_receive_queue(struct channel_cfg *,
                                             struct BufferQueue *,
                                             ULONG);

      short SYNCDRIVE_API sync_transmit(struct channel_cfg *,
                                        union com_block *,
                                        ULONG);

      short SYNCDRIVE_API sync_transmit_queue(struct channel_cfg *,
                                              struct BufferQueue *,
                                              ULONG);

   #ifndef __WIN95__
      short SYNCDRIVE_API sync_lmem_alloc(HGLOBAL *Handle,
                                          void far **Ptr,
                                          ULONG);

      short SYNCDRIVE_API sync_lmem_free(HGLOBAL Handle);
   #endif

#else
   #ifdef __OS2__
      short SYNCDRIVE_API sync_receive(struct channel_cfg *,
                                       union com_block *,
                                       ULONG);

      short SYNCDRIVE_API sync_receive_queue(struct channel_cfg *,
                                             struct BufferQueue *,
                                             ULONG);

      short SYNCDRIVE_API sync_transmit(struct channel_cfg *,
                                        union com_block *,
                                        ULONG);

      short SYNCDRIVE_API sync_transmit_queue(struct channel_cfg *,
                                              struct BufferQueue *,
                                              ULONG);

   #else

   /*
    * Finally, Dos Function prototypes
    */
   short SYNCDRIVE_API sync_receive(struct channel_cfg _far *, union com_block _far *);
   short SYNCDRIVE_API sync_receive_queue(struct channel_cfg _far *, struct BufferQueue _far *);
   short SYNCDRIVE_API sync_transmit(struct channel_cfg _far *, union com_block _far *);
   short SYNCDRIVE_API sync_transmit_queue(struct channel_cfg _far *, struct BufferQueue _far *);
   #endif
#endif


#if __cplusplus
}
#endif




#endif         /* mpax00_h */

