/*--------------------------------------------------------------------------
         FILE HEADER FOR seamless.c
         HEADER LAST UPDATED :  9 May 1994

         COMPILER : Borland C++ for OS/2, version 1.0

         PURPOSE :
              This is a utility program written to launch a seamless
         windows application from the command prompt.  This program also
         demonstrates how to launch a seamless child application from a
         program.

         POSSIBLE IMPROVEMENTS :

         (1) This version assumes that WIN.COM is in \OS2\MDOS\WINOS2 on
             the boot drive, so an improvement would be to allow for an
             override of WIN.COM or find some other way to account for OS/2
             for Windows.

         (2) This version does not apply special settings for the session.
             Probably these can be altered by changing the evironment in
             the PROGDETAILS structure which is passed to WinStartApp().

         (3) If anyone can figure out how to accomplish what this program
             does using DosStartSession(), please upload a sample program.
             DosStartSession() is much superior to the WinStartApp() API
             used here in that it returns a process id.

         PARAMETER : The fully qualified name of the executable.

         RETURNS : 0 if failure, 1 if success

  --------------------------------------------------------------------------*/


#define INCL_WIN
#define INCL_DOS
#include <os2.h>
#include <stdio.h>
#include <string.h>


ULONG StartSeamless(HWND hwndNotify,char *pszProgram);
MRESULT EXPENTRY ParentWndProc(HWND, ULONG, MPARAM, MPARAM);
HAB hab;
CHAR szProgram[CCHMAXPATH];
ULONG ulReturnCode;

int main(int argc,char *argv[])
{
CHAR szClientClass[] = "Seamless";
ULONG flFrameFlags = FCF_TITLEBAR      | FCF_SYSMENU   |
                     FCF_SIZEBORDER    | FCF_MINMAX    |
                     FCF_SHELLPOSITION | FCF_TASKLIST;

HMQ    hmq;
HWND   hwndFrame, hwndClient;
QMSG   qmsg;

if (argc == 1)
   {
   printf("Need an argument for the program to launch.\n");
   return 1;
   }
if (strlen(szProgram) > CCHMAXPATH)
   {
   printf("Argument 1 is too long\n");
   return 1;
   }
strcpy(szProgram,argv[1]);
ulReturnCode = 0;

hab = WinInitialize(0);
hmq = WinCreateMsgQueue(hab,0);
WinRegisterClass(hab,
                 szClientClass,
                 (PFNWP)ParentWndProc,
                 0L,
                 0);
hwndFrame =  WinCreateStdWindow(HWND_OBJECT,
                                WS_VISIBLE,
                                (PULONG)&flFrameFlags,
                                szClientClass,
                                NULL,
                                0L,
                                (HMODULE)NULL,
                                0,
                                (PHWND)&hwndClient);

while (WinGetMsg(hab,(PQMSG)&qmsg,(HWND)NULL,0,0))
      {
      WinDispatchMsg(hab,(PQMSG)&qmsg);
      }

WinDestroyWindow(hwndFrame);
WinDestroyMsgQueue(hmq);
WinTerminate(hab);
return ulReturnCode;
}

MRESULT EXPENTRY ParentWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

switch (msg)
     {
     case WM_CREATE:
          if (!StartSeamless(hwnd,szProgram))
             {
             ulReturnCode = 1;
             WinSendMsg(hwnd,WM_CLOSE,NULL,NULL);
             }
          return 0;

     case WM_APPTERMINATENOTIFY:
          printf("Seamless APP terminated\n");
          WinSendMsg(hwnd,WM_CLOSE,NULL,NULL);
          return 0;

     case WM_DESTROY:
          return 0;
     }

return WinDefWindowProc(hwnd,msg,mp1,mp2);
}


ULONG StartSeamless(HWND hwndNotify,char *pszProgram)
{
PROGDETAILS Details;
HAPP happ;
CHAR szParams[CCHMAXPATH+5];
ULONG ulBootDrive;
APIRET rc;


Details.pszExecutable   = "c:\\os2\\mdos\\winos2\\winos2.com";
rc = DosQuerySysInfo(QSV_BOOT_DRIVE,QSV_BOOT_DRIVE,&ulBootDrive,
                     sizeof(ulBootDrive));
if (rc != 0)
   {
   printf("DosQuerySysInfo returned %ld \n",rc);
   return FALSE;
   }
*(Details.pszExecutable) = (char)(ulBootDrive-1+'A');



Details.Length          = sizeof(PROGDETAILS);
Details.progt.progc     = PROG_SEAMLESSCOMMON;
Details.progt.fbVisible = SHE_VISIBLE;
Details.pszTitle        = "";
Details.pszParameters   = NULL;
Details.pszStartupDir   = "";
Details.pszIcon         = NULL;
Details.pszEnvironment  = NULL;
Details.swpInitial.fl   = SWP_ACTIVATE;
Details.swpInitial.cy   = 0;
Details.swpInitial.cx   = 0;
Details.swpInitial.y    = 0;
Details.swpInitial.x    = 0;
Details.swpInitial.hwndInsertBehind = HWND_TOP;
Details.swpInitial.hwnd             = hwndNotify;
Details.swpInitial.ulReserved1      = 0;
Details.swpInitial.ulReserved2      = 0;
strcpy(szParams," /K ");
strcat(szParams,pszProgram);
happ = WinStartApp(hwndNotify,
                   &Details,
                   szParams,
                   NULL,
                   SAF_STARTCHILDAPP);
printf(" %ld %04X",happ,WinGetLastError(hab));
if (happ == NULLHANDLE) return FALSE;
return TRUE;
}


