ARCHCFLAGS	=	-DSYSVSIGNAL -DSYSVSTR -DNOGETDTBLSIZ -DNOTMPNAM -DNOWAIT3 -DNOSOCKOPT -DNOWAITPID
ARCHDLIB	=  ../../implib/so32.a ../../implib/xdr.a ../../implib/tcp32.a -los2
ARCHDOBJ	=
ARCHLIB 	=  ../../implib/so32.a ../../implib/xdr.a ../../implib/tcp32.a -los2
HASRANLIB	=	f
PVM_ARCH	=	OS2

#
# Generic Makefile body to be concatenated to config header.
#
# Imports:
#  PVM_ARCH   = the official pvm-name of your processor
#  ARCHCFLAGS = special cc flags
#  ARCHDLIB   = special libs needed for daemon
#  ARCHDOBJ   = special objects needed for daemon
#  HASRANLIB  = 't' or 'f'
#
# Define:
#  FDSETPATCH      if system includes don't have fd_set stuff
#  NOGETDTBLSIZ    if system doesn't have getdtablesize()
#  NOREXEC         if system doesn't have rexec()
#  NOSOCKOPT       if system doesn't have setsockopt() or it doesn't work
#  NOSTRCASE       if system doesn't have strcasecmp, strncasecmp
#  NOTMPNAM        if system doesn't have tmpnam() or it's hosed
#  OVERLOADHOST    to allow different virtual machines to overlap on a host
#  RSHCOMMAND      for rsh command other than "/usr/ucb/rsh"
#  RSHNPLL         for number of parallel rsh startups (default is 8)
#  RSHTIMEOUT      for rsh timeout other than default (60 sec)
#  SOCKADHASLEN    if struct sockaddr has an sa_len field
#  SYSVBFUNC       if system uses memcpy() instead of bcopy(), etc.
#  SYSVSIGNAL      if system has sysV signal handling
#  SYSVSTR         if system uses strchr() instead of index()
#  UDPMAXLEN       for alternate max udp packet size
#  USE_PVM_ALLOC   to enable instrumented malloc functions (for debugging pvm)
#
SHELL	=	cmd.exe
CC	=	gcc
SDIR	=	..
LIBDIR	=	../../lib/$(PVM_ARCH)
#OPTIONS	=	-O
OPTIONS	=	-O2
#OPTIONS	=	-g -DSTATISTICS
#OPTIONS	=	-g -DUSE_PVM_ALLOC -DSTATISTICS
#OPTIONS	=	-p
CFLAGS	=	$(OPTIONS) -I$(SDIR)/../include -DARCHCLASS=\"$(PVM_ARCH)\" -DIMA_$(PVM_ARCH) $(ARCHCFLAGS)

DOBJ	=pvmd.o archcode.o ddpro.o pvmfrag.o imalloc.o \
			mesg.o nmdclass.o pkt.o pvmalloc.o pvmcruft.o pvmdabuf.o \
			pvmlog.o task.o tdpro.o host.o startup.o waitc.o
LOBJ	=	imalloc.o lpvm.o lpvmgen.o lpvmpack.o \
			pvmalloc.o pvmcruft.o pvmdabuf.o pvmfrag.o pvmumbuf.o

all:	pvmd3.exe libpvm3.a

install:	pvmd3.exe libpvm3.a $(LIBDIR)
	mv libpvm3.a pvmd3.exe $(LIBDIR)

$(LIBDIR):
	- mkdir $(LIBDIR)

pvmd3.exe:	$(DOBJ)
	$(CC) $(CFLAGS) -o pvmd3.exe $(DOBJ) $(ARCHDLIB)
	emxbind -s pvmd3.exe

libpvm3.a:	$(LOBJ)
	rm -f libpvm3.a
	ar cr libpvm3.a $(LOBJ)
	ar s  libpvm3.a

clean:
	rm -f $(DOBJ) $(LOBJ) pvmd3.exe libpvm3.a

tidy:
	rm -f $(DOBJ) $(LOBJ)

lint:
	lint -DARCHCLASS=\"$(PVM_ARCH)\" \
		archcode.c ddpro.c mesg.c imalloc.c pkt.c \
		pvmcruft.c pvmd.c pvmfrag.c pvmlog.c pvmalloc.c startup.c \
		task.c tdpro.c waitc.c > Ld
	lint \
		imalloc.c lpvm.c lpvmgen.c lpvmpack.c \
		pvmalloc.c pvmcruft.c pvmfrag.c pvmumbuf.c > Ll
#
archcode.o:	$(SDIR)/archcode.c
	$(CC) $(CFLAGS) -c $(SDIR)/archcode.c
ddpro.o:	$(SDIR)/ddpro.c
	$(CC) $(CFLAGS) -c $(SDIR)/ddpro.c
pvmfrag.o:	$(SDIR)/pvmfrag.c
	$(CC) $(CFLAGS) -c $(SDIR)/pvmfrag.c
host.o:	$(SDIR)/host.c
	$(CC) $(CFLAGS) -c $(SDIR)/host.c
imalloc.o:	$(SDIR)/imalloc.c
	$(CC) $(CFLAGS) -c $(SDIR)/imalloc.c
lpvm.o:	$(SDIR)/lpvm.c
	$(CC) $(CFLAGS) -c $(SDIR)/lpvm.c
lpvmgen.o:	$(SDIR)/lpvmgen.c
	$(CC) $(CFLAGS) -c $(SDIR)/lpvmgen.c
lpvmpack.o:	$(SDIR)/lpvmpack.c
	$(CC) $(CFLAGS) -c $(SDIR)/lpvmpack.c
mesg.o:	$(SDIR)/mesg.c
	$(CC) $(CFLAGS) -c $(SDIR)/mesg.c
nmdclass.o:	$(SDIR)/nmdclass.c
	$(CC) $(CFLAGS) -c $(SDIR)/nmdclass.c
pkt.o:	$(SDIR)/pkt.c
	$(CC) $(CFLAGS) -c $(SDIR)/pkt.c
pvmalloc.o:	$(SDIR)/pvmalloc.c
	$(CC) $(CFLAGS) -c $(SDIR)/pvmalloc.c
pvmcruft.o:	$(SDIR)/pvmcruft.c
	$(CC) $(CFLAGS) -c $(SDIR)/pvmcruft.c
pvmd.o:	$(SDIR)/pvmd.c
	$(CC) $(CFLAGS) -c $(SDIR)/pvmd.c
pvmdabuf.o:	$(SDIR)/pvmdabuf.c
	$(CC) $(CFLAGS) -c $(SDIR)/pvmdabuf.c
pvmlog.o:	$(SDIR)/pvmlog.c
	$(CC) $(CFLAGS) -c $(SDIR)/pvmlog.c
pvmumbuf.o:	$(SDIR)/pvmumbuf.c
	$(CC) $(CFLAGS) -c $(SDIR)/pvmumbuf.c
startup.o:	$(SDIR)/startup.c
	$(CC) $(CFLAGS) -c $(SDIR)/startup.c
task.o:	$(SDIR)/task.c
	$(CC) $(CFLAGS) -c $(SDIR)/task.c
tdpro.o:	$(SDIR)/tdpro.c
	$(CC) $(CFLAGS) -c $(SDIR)/tdpro.c
waitc.o:	$(SDIR)/waitc.c
	$(CC) $(CFLAGS) -c $(SDIR)/waitc.c

# .h deps
archcode.o: $(SDIR)/protoglr.h
archcode.o: $(SDIR)/pvmalloc.h
ddpro.o: $(SDIR)/global.h
ddpro.o: $(SDIR)/fromlib.h
ddpro.o: $(SDIR)/tdpro.h
ddpro.o: $(SDIR)/ddpro.h
ddpro.o: $(SDIR)/protoglr.h
ddpro.o: $(SDIR)/pvmalloc.h
ddpro.o: $(SDIR)/host.h
ddpro.o: $(SDIR)/mesg.h
ddpro.o: $(SDIR)/waitc.h
ddpro.o: $(SDIR)/task.h
ddpro.o: $(SDIR)/listmac.h
ddpro.o: $(SDIR)/pvmmimd.h
ddpro.o: $(SDIR)/bfunc.h
host.o: $(SDIR)/protoglr.h
host.o: $(SDIR)/global.h
host.o: $(SDIR)/pvmalloc.h
host.o: $(SDIR)/host.h
host.o: $(SDIR)/mesg.h
host.o: $(SDIR)/pkt.h
host.o: $(SDIR)/ddpro.h
host.o: $(SDIR)/bfunc.h
imalloc.o: $(SDIR)/bfunc.h
lpvm.o: $(SDIR)/../include/pvm3.h
lpvm.o: $(SDIR)/global.h
lpvm.o: $(SDIR)/tdpro.h
lpvm.o: $(SDIR)/ddpro.h
lpvm.o: $(SDIR)/pvmalloc.h
lpvm.o: $(SDIR)/pvmfrag.h
lpvm.o: $(SDIR)/pvmumbuf.h
lpvm.o: $(SDIR)/listmac.h
lpvm.o: $(SDIR)/tvdefs.h
lpvm.o: $(SDIR)/bfunc.h
lpvmgen.o: $(SDIR)/../include/pvm3.h
lpvmgen.o: $(SDIR)/global.h
lpvmgen.o: $(SDIR)/pvmalloc.h
lpvmgen.o: $(SDIR)/tdpro.h
lpvmgen.o: $(SDIR)/pvmumbuf.h
lpvmgen.o: $(SDIR)/listmac.h
lpvmgen.o: $(SDIR)/bfunc.h
lpvmmimd.o: $(SDIR)/../include/pvm3.h
lpvmmimd.o: $(SDIR)/global.h
lpvmmimd.o: $(SDIR)/tdpro.h
lpvmmimd.o: $(SDIR)/ddpro.h
lpvmmimd.o: $(SDIR)/pvmalloc.h
lpvmmimd.o: $(SDIR)/pvmfrag.h
lpvmmimd.o: $(SDIR)/pvmumbuf.h
lpvmmimd.o: $(SDIR)/listmac.h
lpvmmimd.o: $(SDIR)/pvmmimd.h
lpvmmimd.o: $(SDIR)/bfunc.h
lpvmpack.o: $(SDIR)/../include/pvm3.h
lpvmpack.o: $(SDIR)/global.h
lpvmpack.o: $(SDIR)/tdpro.h
lpvmpack.o: $(SDIR)/ddpro.h
lpvmpack.o: $(SDIR)/pvmfrag.h
lpvmpack.o: $(SDIR)/pvmumbuf.h
lpvmpack.o: $(SDIR)/listmac.h
lpvmpack.o: $(SDIR)/pvmmimd.h
lpvmpack.o: $(SDIR)/bfunc.h
mesg.o: $(SDIR)/protoglr.h
mesg.o: $(SDIR)/pvmalloc.h
mesg.o: $(SDIR)/pvmfrag.h
mesg.o: $(SDIR)/mesg.h
mesg.o: $(SDIR)/listmac.h
nmdclass.o: $(SDIR)/protoglr.h
nmdclass.o: $(SDIR)/pvmalloc.h
nmdclass.o: $(SDIR)/listmac.h
pkt.o: $(SDIR)/protoglr.h
pkt.o: $(SDIR)/pvmalloc.h
pkt.o: $(SDIR)/pkt.h
pkt.o: $(SDIR)/pvmdabuf.h
pkt.o: $(SDIR)/listmac.h
pkt.o: $(SDIR)/bfunc.h
pvmalloc.o: $(SDIR)/protoglr.h
pvmalloc.o: $(SDIR)/pvmalloc.h
pvmd.o: $(SDIR)/global.h
pvmd.o: $(SDIR)/fromlib.h
pvmd.o: $(SDIR)/tdpro.h
pvmd.o: $(SDIR)/ddpro.h
pvmd.o: $(SDIR)/protoglr.h
pvmd.o: $(SDIR)/pvmalloc.h
pvmd.o: $(SDIR)/host.h
pvmd.o: $(SDIR)/pvmdabuf.h
pvmd.o: $(SDIR)/pvmfrag.h
pvmd.o: $(SDIR)/mesg.h
pvmd.o: $(SDIR)/pkt.h
pvmd.o: $(SDIR)/task.h
pvmd.o: $(SDIR)/waitc.h
pvmd.o: $(SDIR)/listmac.h
pvmd.o: $(SDIR)/tvdefs.h
pvmd.o: $(SDIR)/pvmmimd.h
pvmd.o: $(SDIR)/bfunc.h
pvmdabuf.o: $(SDIR)/protoglr.h
pvmdabuf.o: $(SDIR)/pvmalloc.h
pvmfrag.o: $(SDIR)/protoglr.h
pvmfrag.o: $(SDIR)/pvmalloc.h
pvmfrag.o: $(SDIR)/pvmfrag.h
pvmfrag.o: $(SDIR)/listmac.h
pvmfrag.o: $(SDIR)/pvmdabuf.h
pvmumbuf.o: $(SDIR)/../include/pvm3.h
pvmumbuf.o: $(SDIR)/pvmalloc.h
pvmumbuf.o: $(SDIR)/pvmfrag.h
pvmumbuf.o: $(SDIR)/pvmumbuf.h
pvmumbuf.o: $(SDIR)/listmac.h
pvmumbuf.o: $(SDIR)/bfunc.h
startup.o: $(SDIR)/global.h
startup.o: $(SDIR)/fromlib.h
startup.o: $(SDIR)/ddpro.h
startup.o: $(SDIR)/tdpro.h
startup.o: $(SDIR)/protoglr.h
startup.o: $(SDIR)/pvmalloc.h
startup.o: $(SDIR)/mesg.h
startup.o: $(SDIR)/host.h
startup.o: $(SDIR)/listmac.h
startup.o: $(SDIR)/tvdefs.h
startup.o: $(SDIR)/bfunc.h
task.o: $(SDIR)/global.h
task.o: $(SDIR)/ddpro.h
task.o: $(SDIR)/protoglr.h
task.o: $(SDIR)/mesg.h
task.o: $(SDIR)/pkt.h
task.o: $(SDIR)/task.h
task.o: $(SDIR)/waitc.h
task.o: $(SDIR)/pvmalloc.h
task.o: $(SDIR)/listmac.h
task.o: $(SDIR)/bfunc.h
tdpro.o: $(SDIR)/global.h
tdpro.o: $(SDIR)/fromlib.h
tdpro.o: $(SDIR)/tdpro.h
tdpro.o: $(SDIR)/ddpro.h
tdpro.o: $(SDIR)/protoglr.h
tdpro.o: $(SDIR)/pvmalloc.h
tdpro.o: $(SDIR)/mesg.h
tdpro.o: $(SDIR)/task.h
tdpro.o: $(SDIR)/host.h
tdpro.o: $(SDIR)/waitc.h
tdpro.o: $(SDIR)/listmac.h
tdpro.o: $(SDIR)/bfunc.h
waitc.o: $(SDIR)/global.h
waitc.o: $(SDIR)/protoglr.h
waitc.o: $(SDIR)/pvmalloc.h
waitc.o: $(SDIR)/waitc.h
waitc.o: $(SDIR)/mesg.h
waitc.o: $(SDIR)/host.h
waitc.o: $(SDIR)/listmac.h
waitc.o: $(SDIR)/bfunc.h
