ARCHCFLAGS	=	-DSYSVSIGNAL -DSYSVSTR -DNOGETDTBLSIZ -DNOTMPNAM -DNOWAIT3 -DNOSOCKOPT -DNOWAITPID
ARCHDLIB	=  ../../implib/so32.a ../../implib/xdr.a ../../implib/tcp32.a -los2
ARCHDOBJ	=
ARCHLIB 	=  ../../implib/so32.a ../../implib/xdr.a ../../implib/tcp32.a -los2
HASRANLIB	=	f
PVM_ARCH	=	OS2
#
#
# Generic Makefile body to be concatenated to config header.
#
# Imports:
#  PVM_ARCH   = the official pvm-name of your processor
#  ARCHCFLAGS = special cc flags
#  ARCHLIB    = special libs needed for daemon
#  HASRANLIB  = 't' or 'f'
#
# Define:
#  NOSTRCASE       if libc doesn't have strcasecmp, strncasecmp
#  SYSVSIGNAL      for system5 signal handling
#  SYSVSTR         for strchr() instead of index()
#
SHELL	=	cmd.exe
CC	=	gcc
SDIR	=	..
DOBJ	=	pvmgs.o
LOBJ	=	pvmgslib.o
PVMIDIR	=	../../include
PVMLDIR	=	../../lib/$(PVM_ARCH)
PVMBDIR	=	../../bin
PVMXDIR	=	$(PVMBDIR)/$(PVM_ARCH)
PVMLIB	=	$(PVMLDIR)/libpvm3.a
CFLAGS	=	 -O2 -I$(PVMIDIR) -L$(PVMLDIR) $(ARCHCFLAGS)
LIBS	=	$(PVMLIB) $(ARCHLIB)

all:	pvmgs.exe libgpvm3.a pvmgstat.exe

install: pvmgs.exe libgpvm3.a pvmgstat.exe $(PVMXDIR) $(PVMLDIR)
	cp pvmgs.exe $(PVMXDIR)
	cp pvmgs.exe pvmgstat.exe libgpvm3.a $(PVMLDIR)

$(PVMXDIR):
	- mkdir $(PVMBDIR)
	- mkdir $(PVMXDIR)

$(PVMLDIR):
	- mkdir $(PVMLDIR)

pvmgs.exe:	$(DOBJ)
	$(CC) $(CFLAGS) -o pvmgs.exe $(DOBJ) $(LIBS)
	emxbind -s pvmgs.exe

libgpvm3.a:	$(LOBJ)
	rm -f libgpvm3.a
	ar cr libgpvm3.a $(LOBJ)
	ar s libgpvm3.a

pvmgstat.exe: pvmgstat.o libgpvm3.a
	$(CC) $(CFLAGS) -o pvmgstat.exe pvmgstat.o libgpvm3.a $(LIBS)
	emxbind -s pvmgstat.exe

clean:
	rm -f $(DOBJ) $(LOBJ) pvmgs.exe libgpvm3.a pvmgstat.exe pvmgstat.o

tidy:
	rm -f $(DOBJ) $(LOBJ)

lint:
	lint -DARCHCLASS=\"$(PVM_ARCH)\" pvmgs.c > Ld
	lint -DARCHCLASS=\"$(PVM_ARCH)\" pvmgslib.c > Ll
#
pvmgs.o:	$(SDIR)/pvmgs.c
	$(CC) $(CFLAGS) -c $(SDIR)/pvmgs.c
pvmgslib.o:	$(SDIR)/pvmgslib.c
	$(CC) $(CFLAGS) -c $(SDIR)/pvmgslib.c
pvmgstat.o:	$(SDIR)/pvmgstat.c
	$(CC) $(CFLAGS) -c $(SDIR)/pvmgstat.c

# .h deps
pvmgs.o: $(SDIR)/pvmgdef.h $(SDIR)/pvmgs.h $(PVMIDIR)/pvm3.h
pvmgslib.o: $(PVMIDIR)/pvm3.h $(SDIR)/pvmgdef.h

