
/* $Id: fromlib.h,v 1.4 1997/06/25 22:08:43 pvmsrc Exp $ */

/*
 *         PVM version 3.4:  Parallel Virtual Machine System
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  J. J. Dongarra, G. E. Fagg, M. Fischer
 *          G. A. Geist, J. A. Kohl, R. J. Manchek, P. Mucci,
 *         P. M. Papadopoulos, S. L. Scott, and V. S. Sunderam
 *                   (C) 1997 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM version 3 was funded in part by the U.S. Department of Energy,
 * the National Science Foundation and the State of Tennessee.
 */

/*
 *	fromlib.h
 *
 *	Stuff from libpvm that pvmd needs to know.
 *
$Log: fromlib.h,v $
 * Revision 1.4  1997/06/25  22:08:43  pvmsrc
 * Markus adds his frigging name to the author list of
 * 	every file he ever looked at...
 *
 * Revision 1.3  1997/01/28  19:27:54  pvmsrc
 * New Copyright Notice & Authors.
 *
 * Revision 1.2  1996/10/24  20:34:55  pvmsrc
 * Removed TEV_* constants...  included directly from pvmtev.h now.
 *
 * Revision 1.1  1996/09/23  23:43:14  pvmsrc
 * Initial revision
 *
 * Revision 1.2  1994/06/03  20:38:13  manchek
 * version 3.3.0
 *
 * Revision 1.1  1993/08/30  23:26:47  manchek
 * Initial revision
 *
 */

/*
*	pvm_spawn options
*/

#define	PvmTaskHost		1	/* specify host */
#define	PvmTaskArch		2	/* specify architecture */
#define	PvmTaskDebug	4	/* start task in debugger */
#define	PvmTaskTrace	8	/* process generates trace data */
#define	PvmMppFront		16	/* spawn task on service node */
#define	PvmHostCompl	32	/* complement host set */

/*
*	pvm_notify types
*/

#define	PvmTaskExit		1	/* on task exit */
#define	PvmHostDelete	2	/* on host fail/delete */
#define	PvmHostAdd		3	/* on host startup */

/*
*	Libpvm error codes
*/

#define	PvmBadParam		-2	/* bad parameter */
#define	PvmNoHost		-6	/* no such host */
#define	PvmNoFile		-7	/* no such executable */
#define	PvmHostFail		-22	/* host failed */
#define	PvmDSysErr		-25	/* pvmd system error */
#define	PvmBadVersion	-26	/* pvmd-pvmd protocol version mismatch */
#define	PvmOutOfRes		-27	/* out of resources */
#define	PvmDupHost		-28	/* host already configured */
#define	PvmCantStart	-29	/* failed to exec new slave pvmd */
#define	PvmAlready		-30	/* already doing operation */
#define	PvmNoTask		-31	/* no such task */
#define	PvmNoEntry		-32	/* no such name, index pair */
#define	PvmDupEntry		-33	/* name, index pair already exists */

