
/* $Id: pvmfreduce.m4,v 1.3 1997/05/08 15:58:49 pvmsrc Exp $ */

#include "pvm3.h"
#include "pvm_consts.h"

void
FUNCTION(pvmfreduce) ARGS(`func, data,count, datatype, msgtag, STRING_ARG(gname), rootinst, info')
#ifdef IMA_UXPM
void (**func)(); /* correction for Fujitsu FORTRAN77 EX */
#else
void (*func)();
#endif
void *data;
int *count, *datatype, *msgtag, *rootinst, *info;
STRING_ARG_DECL(gname);
{
  char tgroup[MAX_GRP_NAME + 1];

  /*
   * Copy the group name to make sure there's a NUL at the end.
   */
  if (ftocstr(tgroup, sizeof(tgroup), STRING_PTR(gname), STRING_LEN(gname))){
    *info = PvmBadParam;
    return;
    }

#ifdef IMA_UXPM
  *info = pvm_reduce(*func, data, *count, *datatype, *msgtag, tgroup, 
                     *rootinst);
#else
  *info = pvm_reduce(func, data, *count, *datatype, *msgtag, tgroup, 
                     *rootinst);
#endif

}

/* various reduction functions are defined here */

void
FUNCTION(pvmmax) ARGS(`datatype, data, work, count, info')
int *datatype;
void *data, *work;
int *count, *info;
{
  PvmMax(datatype, data, work, count, info);
}



void
FUNCTION(pvmmin) ARGS(`datatype, data, work, count, info')
int *datatype;
void *data, *work;
int *count, *info;
{
  PvmMin(datatype, data, work, count, info);
}

void
FUNCTION(pvmsum) ARGS(`datatype, data, work, count, info')
int *datatype;
void *data, *work;
int *count, *info;
{
  PvmSum(datatype, data, work, count, info);
}

void
FUNCTION(pvmproduct) ARGS(`datatype, data, work, count, info')
int *datatype;
void *data, *work;
int *count, *info;
{
  PvmProduct(datatype, data, work, count, info);
}
