/*
** SEARCH.CMD
** Rexx command file to search for a keyword in a set files and put
** the result into an output file.
** arg(1) = keyword to search for
** arg(2) = file mask to look for keyword in
** arg(3) = filename to put results in
*/

Search:

call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysFileTree',   'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysFileSearch', 'RexxUtil', 'SysFileSearch'

/*
** Query for the number of log files generated.
*/
call SysFileTree arg(2), files., 'FO'

/*
** Delete any old results file.
*/
call SysFileDelete arg(3)

/*
** Search each log file for the keyword: ERROR and copy located lines to
** the results file.
*/
if files.0 > 0 then
do i = 1 to files.0
   call SysFileSearch arg(1), files.i, results., 'C'
   if results.0 > 0 then
   do
      call stream arg(3), 'command', 'open write'
      do j = 1 to results.0
         /* SAY files.i results.j */
         call lineout arg(3), files.i results.j
      end
      call stream arg(3), 'command', 'close'
   end
end
return
