/********************************************************************* */
/* REMVKIT.CMD  -  Removes all PCM COMPATABILITY TESTKIT dirs & files  */
/*                                                                     */
/*  OS2 environment variables to determine testcase drive & boot drive */
/*                                                                     */
/*  Uses ZAP.EXE to wipe out & remove testkit directories.             */
/*-------------------------------------------------------------------- */
'cls'
say ''
'echo off'

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end

say '[1;45;37mͻ'
say '         PCM OS/2 WARP Compatibility Testkit         '
say '                                                     '
say ' This command will remove all testkit directories,   '
say ' files and folder objects from the system.           '
say '                                                     '
say ' Press ENTER to continue with removal                '
say ' OR                                                  '
say ' Press CTRL-BREAK to stop now.                       '
say '                                                     '
say 'ͼ[0;40;37m'
pause


call rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

os2drv':'
'cd os2'

if pos(tstdrv,'CDEFGHIJKLMNOPQRSTUVWXYZ') > 0 then do
   /*---------------------------------------------------------------------------*/
   /* --PCM BASE ONLY DIRS AND FILES------ acc, str, fvt, mme, pcmcia, smp, apm */
   /*---------------------------------------------------------------------------*/
   'zap   'tstdrv':\ACCEPT        >NUL' /* acc,                                 */
   'zap   'tstdrv':\APS           >NUL' /*                mme                   */
   'zap   'tstdrv':\APM           >NUL' /*                mme               apm */
   'zap   'tstdrv':\BATCH         >NUL' /* acc,                                 */
   'zap   'tstdrv':\BUILD         >NUL' /*                mme                   */
   'zap   'tstdrv':\CMD           >NUL' /*      str, fvt       pcmcia       apm */
   'zap   'tstdrv':\DATA          >NUL' /*                mme                   */
   'zap   'tstdrv':\DUTPCM        >NUL' /*                mme                   */
   'zap   'tstdrv':\FLCFLI        >NUL' /*                mme                   */
   'zap   'tstdrv':\FORMAT        >NUL' /*           fvt                        */
   'zap   'tstdrv':\GE            >NUL' /* acc,                                 */
   'zap   'tstdrv':\INDEO         >NUL' /*                mme                   */
   'zap   'tstdrv':\KBD           >NUL' /*           fvt                        */
   'zap   'tstdrv':\LOG           >NUL' /* execution dir for pcmmed01           */
   'zap   'tstdrv':\LOGA          >NUL' /* log dir for ACCEPT switcher runs     */
   'zap   'tstdrv':\LOGF          >NUL' /* log dir for FVT    switcher runs     */
   'zap   'tstdrv':\LOGM1         >NUL' /* log dir for STRESS pcmmed01          */
   'zap   'tstdrv':\LOGS          >NUL' /* log dir for STRESS pcmsniff          */
   'zap   'tstdrv':\LOGP1         >NUL' /* log dir for PCMCIA FVT slot1         */
   'zap   'tstdrv':\LOGP2         >NUL' /* log dir for PCMCIA FVT slot2         */
   'zap   'tstdrv':\LOGP3         >NUL' /* log dir for PCMCIA FVT slot1+2       */
   'zap   'tstdrv':\NLSCPA        >NUL' /* acc,                                 */
   'zap   'tstdrv':\NLSDOS        >NUL' /*  Pc,                                 */
   'zap   'tstdrv':\PARTTEST      >NUL' /*                mme                   */
   'zap   'tstdrv':\PCMCIA        >NUL' /*                     pcmcia           */
   'zap   'tstdrv':\PIC           >NUL' /* acc,                                 */
   'zap   'tstdrv':\PRINT         >NUL' /* acc,                                 */
   'zap   'tstdrv':\PRINTDD       >NUL' /*           fvt                        */
   'zap   'tstdrv':\RESULTS       >NUL' /*                mme                   */
   'zap   'tstdrv':\REXX          >NUL' /* acc,                                 */
   'zap   'tstdrv':\SCRIPT        >NUL' /* acc, str, fvt,      pcmcia           */
   'zap   'tstdrv':\SMP           >NUL' /*                             smp      */
   'zap   'tstdrv':\STRESS        >NUL' /* acc, str, fvt,      pcmcia           */
   'zap   'tstdrv':\SUBDIR1       >NUL' /*                mme                   */
   'zap   'tstdrv':\SYSTEST       >NUL' /*                mme                   */
   'zap   'tstdrv':\TEXT          >NUL' /* acc, str,           pcmcia           */
   'zap   'tstdrv':\TIMERDD       >NUL' /*           fvt                        */
   'zap   'tstdrv':\ULTI          >NUL' /*                mme                   */
   'zap   'tstdrv':\UTIL          >NUL' /* acc, str, fvt, mme, pcmcia           */
   'zap   'tstdrv':\VDM           >NUL' /* acc                                  */
   'erase 'tstdrv':\README.FVT   2>NUL' /*           fvt                        */
   'erase 'tstdrv':\FLT_TEXT.TXT 2>NUL' /*           fvt                        */
   'zap   'tstdrv':\TMP1          >NUL' /* work dirs from pcmmed01              */
   'zap   'tstdrv':\TMP2          >NUL' /* work dirs from pcmmed01              */
   'zap   'tstdrv':\TMP3          >NUL' /* work dirs from pcmmed01              */
   'zap   'tstdrv':\TMP4          >NUL' /* work dirs from pcmmed01              */
   'zap   'tstdrv':\RANDIR        >NUL' /* work dirs from pcmmed01              */
   'zap   'tstdrv':\SEQDIR        >NUL' /* work dirs from pcmmed01              */
   'zap   'tstdrv':\SPEECH        >NUL' /*      str, fvt       pcmcia       spch*/
   'erase 'tstdrv':\TEMP.WAV     2>NUL' /*                mme                   */
   'erase 'os2drv':\PCMCIA* /N   2>NUL'
   'erase 'os2drv':\*.#UF   /N   2>NUL'
   /*----------------------------------------*/
   /* PCM BASE ONLY FILES FROM \SETUP\OS2    */
   /*----------------------------------------*/
   'erase 'os2drv':\os2\CLEARPCM.CMD  2>NUL'
   'erase 'os2drv':\os2\LOCK32.SYM    2>NUL'
   'erase 'os2drv':\os2\LOCK32.SYS    2>NUL'
   'erase 'os2drv':\os2\LOCKER.SYM    2>NUL'
   'erase 'os2drv':\os2\LOCKER.SYS    2>NUL'
   'erase 'os2drv':\os2\PROBLEM.TXT   2>NUL'
   'erase 'os2drv':\os2\SETUP.DOC     2>NUL'
   'erase 'os2drv':\os2\STARTUP.TST   2>NUL'
   'erase 'os2drv':\os2\TIMEX1.SYS    2>NUL'
   /*---------------------------------------*/
   /*  PCM BASE ONLY FILES FROM \PCM_INST   */
   /*---------------------------------------*/
   'erase 'os2drv':\os2\PCMSETUP.EXE  2>NUL'
   'erase 'os2drv':\os2\PCMSETUP.ICO  2>NUL'
   'erase 'os2drv':\os2\PCMTEST.EXE   2>NUL'
   'erase 'os2drv':\os2\PCMTEST.ICO   2>NUL'
   'erase 'os2drv':\os2\PCMRBOOT.CMD  2>NUL'
   'erase 'os2drv':\os2\STARTCTL.CMD  2>NUL'
   'erase 'os2drv':\os2\STARTUP.CTL   2>NUL'
   'erase 'os2drv':\os2\D.CMD         2>NUL'
   'erase 'os2drv':\os2\R.CMD         2>NUL'
   'erase 'os2drv':\os2\YES.IN        2>NUL'
   'erase 'os2drv':\os2\PCMEAS.EXE    2>NUL'
end

/*--------------------------------------------------------*/
/* restore original config.sys, startup.cmd, autoexec.bat */
/*--------------------------------------------------------*/
'copy  'os2drv':\config.os2   'os2drv':\config.sys   2>NUL'
'copy  'os2drv':\autoexec.os2 'os2drv':\autoexec.bat 2>NUL'
'copy  'os2drv':\startup.os2  'os2drv':\startup.cmd  2>NUL'
'erase 'os2drv':\*.os2        2>NUL'

/* -------------------------------------*/
/* zap PCMLOGS and PCM TESTKIT FOLDER   */
/* -------------------------------------*/
'zap   'os2drv':\PCMLOGS            >NUL'

If SysDestroyObject('<PCM_KIT>') Then
   Say 'PCM Testkit folder has been removed.'
Else Say 'PCM Testkit folder was not found.'

/*---------------------------------------*/
/* BASE AND LAN -  COMMON FILES TO BOTH  */
/*---------------------------------------*/
'erase 'os2drv':\os2\PCMKIT_F.ICO  2>NUL'
'erase 'os2drv':\os2\PCMBLDOB.CMD  2>NUL'
'erase 'os2drv':\os2\PCMDOC.INF    2>NUL'
'erase 'os2drv':\os2\PCMDOC.ICO    2>NUL'
'erase 'os2drv':\os2\PCMHDW.EXE    2>NUL'
'erase 'os2drv':\os2\PCMHDW.ICO    2>NUL'
'erase 'os2drv':\os2\PCMRSLTS.EXE  2>NUL'
'erase 'os2drv':\os2\PCMRSLTS.ICO  2>NUL'
'erase 'os2drv':\os2\PREPRSLT.CMD  2>NUL'
'erase 'os2drv':\os2\CHEKRSLT.CMD  2>NUL'
'erase 'os2drv':\os2\PCLIRSLT.CMD  2>NUL'
'erase 'os2drv':\os2\ACLIRSLT.CMD  2>NUL'
'erase 'os2drv':\os2\PSVRRSLT.CMD  2>NUL'
'erase 'os2drv':\os2\ASVRRSLT.CMD  2>NUL'
'erase 'os2drv':\os2\FORTEXT       2>NUL'
'erase 'os2drv':\os2\GREP.EXE      2>NUL'
'erase 'os2drv':\os2\HKDD.SYS      2>NUL'
'erase 'os2drv':\os2\SWBOOT.EXE    2>NUL'

/*--------------------------------------*/
/* LAN ONLY TEST DIRECTORIES AND FILES  */
/*--------------------------------------*/
'zap   'os2drv':\ITLUTIL            >NUL'
'zap   'os2drv':\D01LOGS            >NUL'
'zap   'os2drv':\S01LOGS            >NUL'
'zap   'os2drv':\R01LOGS            >NUL'
'zap   'os2drv':\R02LOGS            >NUL'
'erase 'os2drv':\os2\LANSETUP.CMD  2>NUL'
'erase 'os2drv':\os2\LANRBOOT.CMD  2>NUL'
'erase 'os2drv':\os2\LANTEST.EXE   2>NUL'
'erase 'os2drv':\os2\LANTEST.ICO   2>NUL'

say '[1;45;37mͻ'
say '                 PCM OS/2 WARP Compatibility Testkit                 '
say '                                                                     '
say ' Directories, Files, and Folder have been removed from the system.   '
say '                                                                     '
say ' Config.sys, Autoexec,bat, and Startup.cmd files have been restored. '
say 'ͼ[0;40;37m'

'cd \'



exit


INFO_PLEASE:
say '[1;45;37mͻ'
say ' REMVKIT.CMD - Remove PCM Testkit directories, files, desktop folder. '
say '                                                                      '
say ' Parameters: NONE                                                     '
say '                                                                      '
say ' Uses OS/2 environment variables to determine testcase & boot drives. '
say '                                                                      '
say ' Restores (config.os2, autoexec.os2, startup.os2)                     '
say 'ͼ[0;40;37m'
exit
