/*-----------------------------------------------------------*/
/* CLEARPCM.CMD - Erases all testcase log files following    */
/*                completion of PCM Testkit BASE testcases.  */
/*                                                           */
/*    Parameters: NONE                                       */
/*                                                           */
/*    Invoked by user to clear all old logfiles.             */
/*                                                           */
/*    OS2 environment variables to determine testcase drive. */
/*-----------------------------------------------------------*/
'@echo off'
arg parm.1 comments
'cls'
say ''
if left(parm.1,1) = '?' then signal INFO_PLEASE

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say ' ***************************************************************'
   say ' * OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *'
   say ' * to update config.sys, then shutdown & reboot to continue.   *'
   say ' ***************************************************************'
   exit
   end
if pos(tstdrv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say ' ***************************************************************'
   say ' * OS2 environment variable PCM_TESTDRV not set.  Run PCMSETUP *'
   say ' * to update config.sys, then shutdown & reboot to continue.   *'
   say ' ***************************************************************'
   exit
   end


say ' *****************************************************************'
say ' * This command file will ERASE ALL PCM BASE TESTCASE LOG FILES. *'
say ' *                                                               *'
say ' * IF YOU HAVE NOT ALREADY CREATED THE RESULTS DISKETTE, THEN    *'
say ' * YOU SHOULD STOP NOW.  ONLY CONTINUE AFTER YOU HAVE CREATED    *'
say ' * THE RESULTS DISKETTE FOR SUBMISSION.                          *'
say ' *                                                               *'
say ' * If you have created your results diskette and wish to clear   *'
say ' * all PCM testcase log files so that you can re-run the full    *'
say ' * PCM Testkit BASE testcases, then continue this routine.       *'
say ' *                                                               *'
say ' * This routine should be used when you have re-configured a     *'
say ' * test system by adding adapters, upgrading the CPU or BIOS     *'
say ' * or after you have made any changes to hardware as a result    *'
say ' * of testcase failures and you wish to re-test the modified     *'
say ' * system.                                                       *'
say ' *                                                               *'
say ' * PRESS ENTER TO CONTINUE -- OR CTRL-BREAK TO STOP NOW......    *'
say ' *****************************************************************'
pause


'erase 'OS2DRV':\PCMLOGS\PCMSCORE.TXT                  >nul'

/*------------------------------------*/
/* erase logfiles from testcase drive */
/*------------------------------------*/
'erase 'TSTDRV':\ACCEPT\CORE\SWITCH_2                  >nul'
'erase 'TSTDRV':\ACCEPT\CORE\SNF002.LOG                >nul'
'erase 'TSTDRV':\ACCEPT\CORE\TESTS\S\RESULT\*. <yes.in >nul'
'erase 'TSTDRV':\BATCH\PCMACCPT.SUM                    >nul'

'erase 'TSTDRV':\NLSCPA\FONTD                  >nul'
'erase 'TSTDRV':\NLSCPA\PRINTD                 >nul'
'erase 'TSTDRV':\NLSCPA\CPALOG                 >nul'
'erase 'TSTDRV':\NLSCPA\SWITCH_6               >nul'

'zap   'TSTDRV':\LOGA                          >nul'

'erase 'TSTDRV':\BATCH\SNFBPB_L                >nul'

'erase 'TSTDRV':\REXX\REXX_LOG                 >nul'

'erase 'TSTDRV':\VDM\SWITCH_V                  >nul'
'erase 'TSTDRV':\VDM\VDM1                      >nul'
'erase 'TSTDRV':\VDM\VVTATXM4                  >nul'
'erase 'TSTDRV':\VDM\FLT018                    >nul'
'erase 'TSTDRV':\VDM\MAT015                    >nul'
'erase 'TSTDRV':\VDM\CTTCLOCK                  >nul'

'erase 'OS2DRV':\PCMLOGS\SNFWIN.TXT            >nul'

'zap   'TSTDRV':\LOG                           >nul'
'zap   'TSTDRV':\LOGM1                         >nul'

'erase 'TSTDRV':\KBD\KBDV.LOG                  >nul'
'erase 'TSTDRV':\LOGF\FVTSECT2.SUM             >nul'

'zap   'TSTDRV':\LOGF                          >nul'

'erase 'TSTDRV':\TIMERDD\DH\DH\DH.LOG          >nul'
'erase 'TSTDRV':\TIMERDD\IRQ8\HZ32.LOG         >nul'

'erase 'TSTDRV':\PRINTDD\*.LOG                 >nul'

'erase 'TSTDRV':\DUTPCM\MMEPCM\*.* <YES.IN        >nul'
'erase 'TSTDRV':\RESULTS\MMEPCM\SVTRES\*PCM*      >nul'
'erase 'TSTDRV':\RESULTS\MMEPCM\SVTLOG\* <yes.in  >nul'
'erase 'TSTDRV':\RESULTS\MMEPCM\SVTRAW\* <yes.in  >nul'
'erase 'TSTDRV':\*.WAV                            >nul'

'copy  'TSTDRV':\APM\APM.ORG       'TSTDRV':\APM\APM.TXT  >nul'

'copy  'TSTDRV':\SPEECH\SPEECH.ORG 'TSTDRV':\SPEECH\SPEECH.TXT >nul'

'erase 'TSTDRV':\PCMCIA\*.LOG                  >nul'
'erase 'TSTDRV':\PCMCIA\SSLOG*                 >nul'

'erase 'TSTDRV':\SMP\SMPTEST.LOG               >nul'


exit

INFO_PLEASE:
say ' ͻ '
say '  CLEARPCM.CMD - Erases PCM BASE testcase logfiles from the     '
say '                 system to prepare for full re-test of system.  '
say '                                                                '
say '  Parameters: NONE                                              '
say '                                                                '
say '  Uses OS/2 environment variables to determine testcase drive.  '
say ' ͼ '
exit
