/* ------------------------------------------------------------------------- */
/* PCMCIA_A.CMD  -  Test PCMCIA ATA-DISK cards.                              */
/*                                                                           */
/*    Parameters: 1st - PCMCIA drive letter                                  */
/*                                                                           */
/*                                                                           */
/*    Carried on: PCMCIA Diskette and w:\pcmcia\cmd on LAN                   */
/*                                                                           */
/*    Invocation: from OS/2 full screen prompt->    \pcmcia_d  e             */
/*                                                                           */
/*    Uses OS2 environment variables to determine testcase drive.            */
/*                                                                           */
/*    Formats PCMCIA drive and copies testcase files to PCMCIA drive         */
/*    and executes testcases on drive, then copies log files back            */
/*    to the testcase drive under the directory \PCMCIA                      */
/* ------------------------------------------------------------------------- */
'@echo off'
arg parm.1 parm.2 comments
'cls'
say ''
if left(parm.1,1) = '?' then signal INFO_PLEASE
/* ------------------------------------------------------------------------- */
os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');       /* get OS2 boot drive */
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');       /* get testcase drive */
if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end
if pos(tstdrv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_TESTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end

/* ------------------------------------------------------------------------- */
pcmdrive = left(parm.1,1)
if pos(pcmdrive.1,'CDEFGHIJKLMNOPQRSTUVWXYZ') > 0 then signal INFO_PLEASE

/* ------------------------------------------------------------------------- */
cardtype = 'ATA-DISK'
logname = tstdrv':\PCMCIA\ATA-DISK.LOG'
switchlog   = 'PCMCIA_A.LOG'

say 'CARDTYPE        = 'cardtype
say 'PCMCIA DRIVE    = 'pcmdrive

say 'TESTCASE DRIVE  = 'tstdrv

tstdrv':'
'cd \PCMCIA'

'erase 'logname

/* ------------------------------------------------------------------------- */
'echo *** PCMCIA testcase started for ATA-DISK type PCMCIA adapter >'logname
'echo *** >>'logname
'echo *** PCMCIA Drive = 'pcmdrive'   >>'logname
'echo *** Card Type    = 'cardtype'   >>'logname
'echo *** >>'logname
'echo *** Begin Test: 'date('U')' - 'time('N')'  >>'logname
'echo *** >>'logname

/* ------------------------------------------------------------------------ */
say '[1;26;45m  ͻ  '
say '   Starting FORMAT of PCMCIA card now  --  Please Wait....            '
say '                                                                      '
say '   Time will vary depending on the size of the card being formatted.  '
say '  ͼ  [0;40;37m'
'echo *** Formatting PCMCIA ATA-DISK drive   >>'logname
'echo *** >>'logname
'format' pcmdrive': /fs:fat <\TEXT\FMTREPLY  >>'logname
if rc \= 0 then do
   'echo *** ERROR in formatting PCMCIA ATA-DISK drive  >>'logname
   'echo *** >>'logname
   exit
   end
else do
     'echo *** Format of PCMCIA ATA-DISK drive - PASS  >>'logname
     'echo *** >>'logname
     end
say '[1;26;45m  ͻ  '
say '   Format of PCMCIA card has completed, continuing with testcase.     '
say '  ͼ  [0;40;37m'

/* ------------------------------------------------------------------------ */
'echo *** >>'logname
'echo *** Running chkdsk on PCMCIA ATA-DISK drive  >>'logname
'echo *** >>'logname
'chkdsk ' pcmdrive':  >>'logname
if rc \= 0 then do
   'echo *** ERROR running chkdsk on PCMCIA ATA-DISK drive  >>'logname
   'echo *** >>'logname
   exit
   end
else do
     'echo *** Chkdsk of PCMCIA ATA-DISK drive - PASS  >>'logname
     'echo *** >>'logname
     end

/* ------------------------------------------------------------------------ */
/*   Copy testcases from TESTCASE drive to PCMCIA drive for execution.      */
/* ------------------------------------------------------------------------ */
'echo *** Copying testcase directories and files to PCMCIA drive  >>'logname
'echo *** >>'logname
'@echo on'
'mkdir 'pcmdrive':\PCMTST  >>'logname
'mkdir 'pcmdrive':\JUNK    >>'logname

'copy  'tstdrv':\TEXT\YES.IN         'pcmdrive':\PCMTST'
'copy  'tstdrv':\TEXT\FMTREPLY       'pcmdrive':\PCMTST'
'copy  'tstdrv':\UTIL\GREP.EXE       'pcmdrive':\PCMTST'
'copy  'tstdrv':\SCRIPT\PCMCIA_A.SCR 'pcmdrive':\PCMTST'
'copy  'tstdrv':\SCRIPT\PCMCIA_F.SCR 'pcmdrive':\PCMTST'
'copy  'tstdrv':\STRESS\FSCOPY.EXE   'pcmdrive':\PCMTST'
'copy  'tstdrv':\STRESS\FSDEL.EXE    'pcmdrive':\PCMTST'
'copy  'tstdrv':\STRESS\FSDIR.EXE    'pcmdrive':\PCMTST'
'copy  'tstdrv':\STRESS\SWITCH.EXE   'pcmdrive':\PCMTST'
'copy  'tstdrv':\STRESS\TESTLOG.DLL  'pcmdrive':\PCMTST'
'copy  'tstdrv':\STRESS\TSTLOG16.DLL 'pcmdrive':\PCMTST'

/* ------------------------------------------------------------------------- */
rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
call SysLoadfuncs
'@echo off'

drvinfo = SysDriveInfo(pcmdrive':')
'echo *** >>'logname
'echo *** SYS-DRIVE-INFO is: 'drvinfo'  >>'logname
'echo *** >>'logname

'attrib -r -h -s 'os2drv':\OS2*'

freespace = word(drvinfo, 2)
totalsize = word(drvinfo, 3)
'echo *** TOTAL DRIVE SIZE = 'totalsize'  FREE SPACE = 'freespace' >>'logname

'copy  'os2drv':\OS2KRNL 'pcmdrive':\JUNK\OS2KNRLX.JNK'
'copy  'os2drv':\OS2LDR  'pcmdrive':\JUNK\OS2LDRX.JNK'

drvinfo = SysDriveInfo(pcmdrive':')
freespace = word(drvinfo, 2)
totalsize = word(drvinfo, 3)
'echo *** TOTAL DRIVE SIZE = 'totalsize'  FREE SPACE = 'freespace' >>'logname


'attrib +r +h +s 'os2drv':\OS2*'
/* ------------------------------------------------------------------------ */
pcmdrive':'
'dir  >>'logname
'cd pcmtst'
'dir  >>'logname

/* ------------------------------------------------------------------------ */
/*  Run the PCMCIA testcase script                                          */
/* ------------------------------------------------------------------------ */
'echo *** Running testcases from PCMCIA ATA-DISK drive  >>'logname
'echo *** >>'logname

'switch -l5 -v5 -o -u'pcmdrive':\pcmtst\pcmcia_a.scr -f'switchlog

call SysSleep 30;

'rename FSCPYATA FSCPYATA.LOG'
'rename FSDELATA FSDELATA.LOG'
'rename FSDIRATA FSDIRATA.LOG'

call SysSleep 10;
pcmdrive':\PCMTST\GREP -Np -Ny "PASS" *.log  >> 'logname
call SysDropFuncs

/* ------------------------------------------------------------------------ */
/* After execution, copy all .log files back to testcase drive \PCMCIA dir  */
/* ------------------------------------------------------------------------ */
'copy  'pcmdrive':\PCMTST\*.LOG  'tstdrv':\PCMCIA'
/* ------------------------------------------------------------------------ */
'echo *** End Test:   'date('U')' - 'time('N')'  >>'logname
'echo *** >>'logname
tstdrv':'
say '[1;18;33m************************************************************'
say ' ***  Scanning output log for "PASS"  ***'
say ' ***      There should be 11 entries.  ***'
'find /c "PASS"  'logname
say '************************************************************[0;40;37m'

exit
/*-------------------------------------------------------------------------- */
INFO_PLEASE:
say '[1;26;45m  ͻ  '
say '   PCMCIA_A.CMD is copied to \CMD directory on testcase partition     '
say '                                                                      '
say '   Parameters: 1st - PCMCIA drive letter                              '
say '                                                                      '
say '   Tests PCMCIA ATA-DISK cards.                                       '
say '                                                                      '
say '   Uses OS/2 environment variables to determine testcase drive.       '
say '                                                                      '
say '   Formats PCMCIA drive and copies testcase files to PCMCIA drive     '
say '   and executes testcases on drive, then copies log files back        '
say '   to the testcase drive under the directory \PCMCIA                  '
say '  ͼ  [0;40;37m'
exit
