/* ------------------------------------------------------------------*/
/* PCMCIA_S.CMD   - Test PCMCIA SRAM Cards.                          */
/*                                                                   */
/*    Parameters: 1st - PCMCIA drive letter                          */
/*                                                                   */
/*                                                                   */
/*    Carried on: PCMCIA Diskette and w:\pcmcia\cmd on LAN           */
/*                                                                   */
/*    Invocation: from OS/2 full screen prompt->    \pcmcia_d  e     */
/*                                                                   */
/*    Uses OS2 environment variables to determine testcase drive.    */
/*                                                                   */
/*    Formats PCMCIA drive and copies testcase files to PCMCIA drive */
/*    and executes testcases on drive, then copies log files back    */
/*    to the testcase drive under the directory \PCMCIA              */
/* ------------------------------------------------------------------*/
'@echo off'
arg parm.1 parm.2 comments
'cls'
say ''
if left(parm.1,1) = '?' then signal INFO_PLEASE

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end
if pos(tstdrv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_TESTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end


pcmdrive = left(parm.1,1)
if pos(pcmdrive.1,'CDEFGHIJKLMNOPQRSTUVWXYZ') > 0 then signal INFO_PLEASE


cardtype = 'SRAM'
logname = tstdrv':\PCMCIA\SRAMCRD.LOG'
switchlog   = 'PCMCIA_S.LOG'

say 'CARDTYPE        = 'cardtype
say 'PCMIA DRIVE     = 'pcmdrive

say 'TESTCASE DRIVE  = 'tstdrv

tstdrv':'
'cd \PCMCIA'

'erase 'logname


'echo *** PCMCIA testcase started for SRAM type PCMCIA adapter >'logname
'echo *** >>'logname
'echo *** PCMCIA Drive = 'pcmdrive'   >>'logname
'echo *** Card Type    = 'cardtype'   >>'logname
'echo *** >>'logname
'echo *** Begin Test: 'date('U')' - 'time('N')'  >>'logname
'echo *** >>'logname


say '[1;26;45m  ͻ  '
say '   Starting FORMAT of PCMCIA card now  --  Please Wait....            '
say '                                                                      '
say '   Time will vary depending on the size of the card being formatted.  '
say '  ͼ  [0;40;37m'
'echo *** >>'logname
'echo *** Formatting PCMCIA SRAM drive   >>'logname
'echo *** >>'logname
'format' pcmdrive': <\TEXT\FMTREPLY  >>'logname
if rc \= 0 then do
   'echo *** Formatting PCMCIA SRAM drive has FAILED >>'logname
   'echo *** >>'logname
   exit
   end
else do
     'echo *** Formatting PCMCIA SRAM drive has PASSED >>'logname
     'echo *** >>'logname
     end
say '[1;26;45m  ͻ  '
say '   Format of PCMCIA card has completed, continuing with testcase.     '
say '  ͼ  [0;40;37m'


'echo *** >>'logname
'echo *** Putting LABEL on PCMCIA SRAM drive  >>'logname
'echo *** >>'logname
'label 'pcmdrive': <\TEXT\FLASHRAM.LBL >>'logname
if rc \= 0 then do
   'echo *** Putting LABEL on PCMCIA SRAM drive has FAILED  >>'logname
   'echo *** >>'logname
   exit
   end
else do
     'echo *** Putting LABEL on PCMCIA SRAM drive has PASSED  >>'logname
     'echo *** >>'logname
     end


'echo *** >>'logname
'echo *** Running chkdsk on PCMCIA SRAM drive  >>'logname
'echo *** >>'logname
'chkdsk ' pcmdrive':  >>'logname
if rc \= 0 then do
   'echo *** Running chkdsk on PCMCIA SRAM drive has FAILED >>'logname
   'echo *** >>'logname
   exit
   end
else do
     'echo *** Running chkdsk on PCMCIA SRAM drive has PASSED >>'logname
     'echo *** >>'logname
     end

pcmdrive':'
/*-------------------------------------------------------------*/
/* Copy testcases from TESTCASE drive to PCMCIA drive for test */
/*-------------------------------------------------------------*/
'echo *** Copying files to fill PCMCIA SRAM drive  >>'logname
'echo *** >>'logname
'@echo on'

do inx=1 to 999 by 1
   'copy  'tstdrv':\PCMCIA\README 'pcmdrive':\README.'inx
   if rc \= 0 then do
      say rc
      if rc == 1 then do
         'echo *** PCMCIA SRAM drive is now FULL  >>'logname
         'echo *** >>'logname
         'echo *** Copying files to PCMCIA SRAM drive has PASSED >>'logname
         'echo *** >>'logname
         lastinx = inx - 1
         leave
         end
      'echo *** Copy to PCMCIA SRAM drive has FAILED >>'logname
      'echo *** >>'logname
      exit
      end
   'copy  'tstdrv':\UTIL\GREP.EXE  'pcmdrive':\GREP-EXE.'inx
   if rc \= 0 then do
      say rc
      if rc == 1 then do
         'echo *** PCMCIA SRAM drive is now FULL  >>'logname
         'echo *** >>'logname
         'echo *** Copying files to PCMCIA SRAM drive has PASSED >>'logname
         'echo *** >>'logname
         lastinx = inx - 1
         leave
         end
      'echo *** Copy to PCMCIA SRAM drive has FAILED >>'logname
      'echo *** >>'logname
      exit
      end
end

'echo *** End Test:   'date('U')' - 'time('N')'  >>'logname
'echo *** >>'logname
tstdrv':'
say '[1;18;33m************************************************************'
say ' ***  Scanning output log for "PASS"  ***'
say ' ***      There should be 4 entries.  ***'
'find /c "PASS"  'logname
say '************************************************************[0;40;37m'

exit

INFO_PLEASE:
say '[1;26;45m  ͻ  '
say '   PCMCIA_S.CMD is copied to \CMD directory on testcase partition     '
say '                                                                      '
say '   Parameters: 1st - PCMCIA drive letter                              '
say '                                                                      '
say '   Tests PCMCIA card:  SRAM                                           '
say '                                                                      '
say '   Uses OS/2 environment variables to determine testcase drive.       '
say '                                                                      '
say '   Formats PCMCIA drive and places label on drive, runs chkdsk and    '
say '   then copies until the drive is full, the output log files on       '
say '   the testcase drive under the directory \PCMCIA                     '
say '  ͼ  [0;40;37m'
exit
