/* ------------------------------------------------------------------*/
/* PCMCIA_C.CMD - Test PCMCIA COMBO cards with FLASH and SRAM areas  */
/*                                                                   */
/*    Parameters: 1st - PCMCIA drive letter                          */
/*    Parameters: 2nd - PCMCIA drive letter                          */
/*                                                                   */
/*    Carried on: PCMCIA Diskette and w:\pcmcia\cmd on LAN           */
/*                                                                   */
/*    Invocation: from OS/2 full screen prompt->    \pcmcia_d  e f   */
/*                                                                   */
/*    Uses OS2 environment variables to determine testcase drive.    */
/*                                                                   */
/*    Formats PCMCIA drive and copies testcase files to PCMCIA drive */
/*    and executes testcases on drive, then copies log files back    */
/*    to the testcase drive under the directory \PCMCIA              */
/* ------------------------------------------------------------------*/
'@echo off'
arg parm.1 parm.2 comments
'cls'
say ''
if left(parm.1,1) = '?' then signal INFO_PLEASE

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end
if pos(tstdrv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_TESTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end


drv1 = left(parm.1,1)
if pos(drv1,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then signal INFO_PLEASE
drv2 = left(parm.2,1)
if pos(drv2,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then signal INFO_PLEASE

pcmdrive.1 = drv1;
pcmdrive.2 = drv2;

cardtype = 'COMBO FLASH & SRAM'
logname = tstdrv':\PCMCIA\COMBOCRD.LOG'
switchlog   = 'PCMCIA_C.LOG'

say 'CARDTYPE        = 'cardtype
say 'PCMDRIVE1 FLASH region = 'pcmdrive.1
say 'PCMDRIVE2 SRAM  region = 'pcmdrive.2
say 'TESTCASE DRIVE  = 'tstdrv

tstdrv':'
'cd \PCMCIA'

'erase 'logname

region.1 = 'FLASH'
region.2 = 'SRAM'
label.1  = 'COMBO_FL.LBL'
label.2  = 'COMBO_SR.LBL'


'echo *** PCMCIA testcase started for COMBO FLASH/SRAM PCMCIA adapter >'logname
'echo *** >>'logname
'echo *** PCMCIA COMBO FLASH Drive = 'pcmdrive.1'   >>'logname
'echo *** PCMCIA COMBO SRAM  Drive = 'pcmdrive.2'   >>'logname
'echo *** >>'logname
'echo *** Begin Test: 'date('U')' - 'time('N')'  >>'logname
'echo *** >>'logname

do indx=1 to 2 by 1
     tstdrv':'

     say '[1;26;45m  ͻ  '
     say '   Starting FORMAT of PCMCIA card now  --  Please Wait....            '
     say '                                                                      '
     say '   Time will vary depending on the size of the card being formatted.  '
     say '  ͼ  [0;40;37m'
     'echo *** Formatting PCMCIA COMBO 'region.indx' region - drive 'pcmdrive.indx'  >>'logname
     'echo *** >>'logname
     'format' pcmdrive.indx': <\TEXT\FMTREPLY  >>'logname
     if rc \= 0 then do
        'echo *** Formatting PCMCIA COMBO 'region.indx' drive has FAILED >>'logname
        'echo *** >>'logname
        exit
        end
     else do
          'echo *** Formatting PCMCIA COMBO 'region.indx' drive has PASSED >>'logname
          'echo *** >>'logname
          end
     say '[1;26;45m  ͻ  '
     say '   Format of PCMCIA card has completed, continuing with testcase.     '
     say '  ͼ  [0;40;37m'


     'echo *** >>'logname
     'echo *** Putting LABEL on PCMCIA COMBO 'region.indx' drive  >>'logname
     'echo *** >>'logname
     'label 'pcmdrive.indx': <\TEXT\'label.indx'  >>'logname
     if rc \= 0 then do
        'echo *** Putting LABEL on PCMCIA COMBO 'region.indx' drive has FAILED  >>'logname
        'echo *** >>'logname
        exit
        end
     else do
          'echo *** Putting LABEL on PCMCIA COMBO 'region.indx' drive has PASSED  >>'logname
          'echo *** >>'logname
          end


     'echo *** >>'logname
     'echo *** Running chkdsk on PCMCIA COMBO 'region.indx' drive  >>'logname
     'echo *** >>'logname
     'chkdsk ' pcmdrive.indx':  >>'logname
     if rc \= 0 then do
        'echo *** Running chkdsk on PCMCIA COMBO 'region.indx' drive has FAILED >>'logname
        'echo *** >>'logname
        exit
        end
     else do
          'echo *** Running chkdsk on PCMCIA COMBO 'region.indx' drive has PASSED >>'logname
          'echo *** >>'logname
          end

     pcmdrive.indx':'
     /*-------------------------------------------------------------*/
     /* Copy testcases from TESTCASE drive to PCMCIA drive for test */
     /*-------------------------------------------------------------*/
     'echo *** Copying files to fill PCMCIA COMBO 'region.indx' drive  >>'logname
     'echo *** >>'logname
     '@echo on'

     do inx=1 to 999 by 1
        'copy  'tstdrv':\PCMCIA\README 'pcmdrive.indx':\README.'inx
        if rc \= 0 then do
           say rc
           if rc == 1 then do
              'echo *** PCMCIA COMBO 'region.indx' drive is now FULL  >>'logname
              'echo *** >>'logname
              'echo *** Copying files to PCMCIA COMBO 'region.indx' drive has PASSED >>'logname
              'echo *** >>'logname
              lastinx = inx - 1
              leave
              end
           'echo *** Copy to PCMCIA COMBO 'region.indx' drive has FAILED >>'logname
           'echo *** >>'logname
           exit
           end
        'copy  'tstdrv':\UTIL\GREP.EXE  'pcmdrive.indx':\GREP-EXE.'inx
        if rc \= 0 then do
           say rc
           if rc == 1 then do
              'echo *** PCMCIA COMBO 'region.indx' drive is now FULL  >>'logname
              'echo *** >>'logname
              'echo *** Copying files to PCMCIA COMBO 'region.indx' drive has PASSED >>'logname
              'echo *** >>'logname
              lastinx = inx - 1
              leave
              end
           'echo *** Copy to PCMCIA COMBO 'region.indx' drive has FAILED >>'logname
           'echo *** >>'logname
           exit
           end
     end
     'dir /w'

end

'echo *** End Test:   'date('U')' - 'time('N')'  >>'logname
'echo *** >>'logname
tstdrv':'
say '[1;18;33m************************************************************'
say ' ***  Scanning output log for "PASS"  ***'
say ' ***      There should be 8 entries.  ***'
'find /c "PASS"  'logname
say '************************************************************[0;40;37m'

exit

INFO_PLEASE:
say '[1;26;45m  ͻ  '
say '   PCMCIA_C.CMD is copied to \CMD directory on testcase partition     '
say '                                                                      '
say '   Parameters: 1st - PCMCIA FLASH region drive letter                 '
say '               2nd - PCMCIA SRAM  region drive letter                 '
say '                                                                      '
say '   Tests PCMCIA COMBO cards with both FLASH and SRAM regions          '
say '                                                                      '
say '   Uses OS/2 environment variables to determine testcase drive.       '
say '                                                                      '
say '   Formats PCMCIA drive and places label on drive, runs chkdsk and    '
say '   then copies until the drive is full, the output log files are      '
say '   on the testcase drive under the directory \PCMCIA                  '
say '  ͼ  [0;40;37m'
exit
