/* ------------------------------------------------------------*/
/* PREPRSLT.CMD - Prepares testkit results diskette and copies */
/*                logfiles for analysis of pass-fail           */
/* Parameters: NONE                                            */
/* Invoked from PCMRSLTS.EXE for results diskette processing.  */
/* ------------------------------------------------------------*/
'@echo off'
arg parm.1 comments
'cls'
say ''
if left(parm.1,1) = '?' then signal INFO_PLEASE

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');
rellvl = value('PCM_RELLVL' ,,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
say ' ***************************************************************'
say ' * OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *'
say ' * to update config.sys, then shutdown & reboot to continue.   *'
say ' ***************************************************************'
exit
end

if stream('A:\SNF001'  ,'c','query size') = '' then 'md A:\SNF001'
if stream('A:\SNF002'  ,'c','query size') = '' then 'md A:\SNF002'
if stream('A:\SNF006'  ,'c','query size') = '' then 'md A:\SNF006'
if stream('A:\SNF007'  ,'c','query size') = '' then 'md A:\SNF007'
if stream('A:\SNFBPB'  ,'c','query size') = '' then 'md A:\SNFBPB'
if stream('A:\SNFREXX' ,'c','query size') = '' then 'md A:\SNFREXX'
if stream('A:\SNFMVDM' ,'c','query size') = '' then 'md A:\SNFMVDM'
if stream('A:\SNFWIN'  ,'c','query size') = '' then 'md A:\SNFWIN'
if stream('A:\STRESS'  ,'c','query size') = '' then 'md A:\STRESS'
if stream('A:\KBD'     ,'c','query size') = '' then 'md A:\KBD'
if stream('A:\FVTDISK' ,'c','query size') = '' then 'md A:\FVTDISK'
if stream('A:\FORMAT'  ,'c','query size') = '' then 'md A:\FORMAT'
if stream('A:\TIMERDD' ,'c','query size') = '' then 'md A:\TIMERDD'
if stream('A:\PRINTDD' ,'c','query size') = '' then 'md A:\PRINTDD'
if stream('A:\MMPM2'   ,'c','query size') = '' then 'md A:\MMPM2'
if stream('A:\APM'     ,'c','query size') = '' then 'md A:\APM'
if stream('A:\SPEECH'  ,'c','query size') = '' then 'md A:\SPEECH'
if stream('A:\PCMCIA'  ,'c','query size') = '' then 'md A:\PCMCIA'
if stream('A:\SMP'     ,'c','query size') = '' then 'md A:\SMP'
if stream('A:\JSFTEST' ,'c','query size') = '' then 'md A:\JFSTEST'

'copy 'OS2DRV':\CONFIG.SYS          A:\SNF001  >nul'
'copy 'OS2DRV':\AUTOEXEC.BAT        A:\SNF001  >nul'
'copy 'OS2DRV':\PCMLOGS\*.TXT       A:\SNF001  >nul'
'copy 'OS2DRV':\PCMLOGS\OS2REL.VER  A:\SNF001  >nul'
'copy 'OS2DRV':\MMOS2\MMPM2.INI     A:\SNF001  >nul'

if pos(tstdrv,'CDEFGHIJKLMNOPQRSTUVWXYZ') > 0 then do
 'copy 'TSTDRV':\ACCEPT\CORE\SWITCH_2   A:\SNF002 >nul'
 'copy 'TSTDRV':\ACCEPT\CORE\SNF002.LOG A:\SNF002 >nul'
 'copy 'TSTDRV':\BATCH\PCMACCPT.SUM     A:\SNF002 >nul'

 'copy 'TSTDRV':\NLSCPA\FONTD     A:\SNF006 >nul'
 'copy 'TSTDRV':\NLSCPA\PRINTD    A:\SNF006 >nul'
 'copy 'TSTDRV':\NLSCPA\CPALOG    A:\SNF006 >nul'
 'copy 'TSTDRV':\NLSCPA\SWITCH_6  A:\SNF006 >nul'

 'copy 'TSTDRV':\LOGA\SWITCH_7    A:\SNF007 >nul'

 'copy 'TSTDRV':\BATCH\SNFBPB_L   A:\SNFBPB >nul'

 'copy 'TSTDRV':\REXX\REXX_LOG    A:\SNFREXX >nul'

 'copy 'TSTDRV':\VDM\SWITCH_V     A:\SNFMVDM >nul'
 'copy 'TSTDRV':\VDM\VDM1         A:\SNFMVDM >nul'
 'copy 'TSTDRV':\VDM\VVTATXM4     A:\SNFMVDM >nul'
 'copy 'TSTDRV':\VDM\FLT018       A:\SNFMVDM >nul'
 'copy 'TSTDRV':\VDM\MAT015       A:\SNFMVDM >nul'
 'copy 'TSTDRV':\VDM\CTTCLOCK     A:\SNFMVDM >nul'

 'copy 'OS2DRV':\PCMLOGS\SNFWIN.TXT  A:\SNFWIN >nul'

 'copy 'TSTDRV':\LOGM1\PCMMED01.SUM  A:\STRESS >nul'
 'copy 'TSTDRV':\LOGM1\SWITCH_M      A:\STRESS >nul'

 'copy 'TSTDRV':\KBD\KBD.LOG        A:\KBD >nul'
 'copy 'TSTDRV':\KBD\KBD1.LOG       A:\KBD >nul'
 'copy 'TSTDRV':\KBD\KBD2.LOG       A:\KBD >nul'
 'copy 'TSTDRV':\LOGF\FVTSECT2.SUM  A:\KBD >nul'

 'copy 'TSTDRV':\LOGF\DASDSTD1.LOG  A:\FVTDISK >nul'
 'copy 'TSTDRV':\LOGF\DASDSTD2.LOG  A:\FVTDISK >nul'

 'copy 'TSTDRV':\LOGF\FLOP525.LOG   A:\FORMAT >nul'
 'copy 'TSTDRV':\LOGF\FLOP144.LOG   A:\FORMAT >nul'
 'copy 'TSTDRV':\LOGF\DSKTRSLT.LOG  A:\FORMAT >nul'

 'copy 'TSTDRV':\TIMERDD\DH\DH\DH.LOG   A:\TIMERDD >nul'
 'copy 'TSTDRV':\TIMERDD\IRQ8\HZ32.LOG  A:\TIMERDD >nul'

 'copy 'TSTDRV':\PRINTDD\*.LOG  A:\PRINTDD >nul'

 'copy 'TSTDRV':\RESULTS\MMEPCM\SVTRAW\*.RA_  A:\MMPM2 >nul'
 'copy 'TSTDRV':\RESULTS\MMEPCM\SVTRAW\*.OUT  A:\MMPM2 >nul'

 'copy 'TSTDRV':\APM\*.TXT  A:\APM >nul'

 'copy 'TSTDRV':\SPEECH\*.TXT  A:\SPEECH >nul'

 'copy 'TSTDRV':\PCMCIA\*.LOG   A:\PCMCIA >nul'
 'copy 'TSTDRV':\PCMCIA\SSLOG*  A:\PCMCIA >nul'

 'copy 'TSTDRV':\SMP\SMPTEST.LOG  A:\SMP >nul'

 'copy 'TSTDRV':\JFSTEST\JFSTEST.LOG   A:\JFSTEST >nul'

 'erase a:\snf001\pcmscore.txt >nul'
end

exit

INFO_PLEASE:
say 'ͻ'
say ' PREPRSLT.CMD - Prepares testkit results diskette with     '
say '                testkit logfiles for analysis of pass-fail.'
say '                                                           '
say ' Parameters: NONE                                          '
say '                                                           '
say ' REQUIRES DISKETTE IN DRIVE A: Verify write-protect is OFF '
say '                                                           '
say ' Called by PCMRSLTS.EXE                                    '
say 'ͼ'
exit
