/* ------------------------------------------------------------------------- */
/*                         PCM COMPATABILITY TESTKIT                         */
/*                                                                           */
/* PCMRBOOT.CMD - Reboot PCM system between PCM TESTCASE Groups to           */
/*                continue with testkit execution.                           */
/*                                                                           */
/* Carried on: "SETUP" Diskette                                              */
/*                                                                           */
/* Parameters: NONE - Called by PCMTEST.EXE when it is time to reboot.       */
/*                                                                           */
/* ------------------------------------------------------------------------- */
'@echo off'
arg parm.1 comments
'cls'
if left(parm.1,1) = '?' then signal INFO_PLEASE

/* ------------------------------------------------------------------------- */
os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');       /* get OS2 boot drive */
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');       /* get testcase drive */
if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end
if pos(tstdrv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_TESTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end

/*-------------------------------------------------------------------------- */
os2drv':'
'cd \os2'

/*-------------------------------------------------------------------------- */
call rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/*-------------------------------------------------------------------------- */
say ''
say ''
say '[1;37;45mͻ';
say ' PCMTEST - The system is being prepared to reboot and continue with  ';
say '           running testcases that were selected.                     ';
say '                                                                     ';
say ' The system will reboot after waiting for disk processing to finish. ';
say '                                                                     ';
say ' PLEASE WAIT --- Let program reboot system after finishing updates.  ';
say 'ͼ[0;40;37m';
call SysSleep 90;

os2drv':\os2\swboot r'

exit;

/* ------------------------------------------------------------------------ */
INFO_PLEASE:
say ''
say '[1;37;45mͻ';
say ' PCMRBOOT.CMD - Reboot PCM system between PCM TESTCASE Groups to     ';
say '                continue with testkit execution.                     ';
say '                                                                     ';
say ' Parameters:  NONE - Called by PCMTEST.EXE to reboot system.         ';
say 'ͼ[0;40;37m';
exit
