/* ------------------------------------------------------------*/
/* PCLIRSLT.CMD - Prepares testkit results diskette and copies */
/*                logfiles for analysis of pass-fail           */
/* Parameters: NONE                                            */
/* Invoked from PCMRSLTS.EXE for results diskette processing.  */
/* ------------------------------------------------------------*/
'@echo off'
arg parm.1 comments
'cls'
say ''
if left(parm.1,1) = '?' then signal INFO_PLEASE

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
say '***************************************************************'
say '* OS2 environment variable PCM_BOOTDRV not set.  Run LANSETUP *'
say '* to update config.sys, then shutdown & reboot to continue.   *'
say '***************************************************************'
exit
end

if stream('A:\R01LOGS'  ,'c','query size') = '' then 'md A:\R01LOGS'
if stream('A:\R02LOGS'  ,'c','query size') = '' then 'md A:\R02LOGS'

'copy 'OS2DRV':\R01LOGS\ITLPEER.S01   A:\R01LOGS  >nul'
'copy 'OS2DRV':\R01LOGS\ITLPEER.R02   A:\R01LOGS  >nul'
'copy 'OS2DRV':\R01LOGS\ITLLS56.R01   A:\R01LOGS  >nul'
'copy 'OS2DRV':\R01LOGS\ITLLS57.R01   A:\R01LOGS  >nul'
'copy 'OS2DRV':\R01LOGS\ITLMSG.D01    A:\R01LOGS  >nul'
'copy 'OS2DRV':\R01LOGS\ITLMSG.R01    A:\R01LOGS  >nul'
'copy 'OS2DRV':\R01LOGS\ITLFTP01.R01  A:\R01LOGS  >nul'

'copy 'OS2DRV':\R02LOGS\ITLLS56.R02   A:\R02LOGS  >nul'
'copy 'OS2DRV':\R02LOGS\ITLLS57.R02   A:\R02LOGS  >nul'
'copy 'OS2DRV':\R02LOGS\ITLFTP02.R02  A:\R02LOGS  >nul'
'copy 'OS2DRV':\R02LOGS\ITLLD.R02     A:\R02LOGS  >nul'

exit

INFO_PLEASE:
say 'ͻ'
say ' PCLIRSLT.CMD - Prepares testkit results diskette with     '
say '                testkit logfiles for analysis of pass-fail.'
say '                                                           '
say ' Parameters: NONE                                          '
say '                                                           '
say ' REQUIRES DISKETTE IN DRIVE A: Verify write-protect is OFF '
say '                                                           '
say ' Called by PCMRSLTS.EXE                                    '
say 'ͼ'
exit
