/* ------------------------------------------------------------------------- */
/*                         PCM COMPATABILITY TESTKIT                         */
/*                                                                           */
/* INSTALL.CMD  - Copy PCM Testkit Installation files to \OS2, and calls a   */
/*                PCMBLDOB.CMD to build desktop folder and objects.          */
/*                                                                           */
/* Carried on: PCM TESTKIT CDROM                                             */
/*                                                                           */
/* Parameters: NONE - Uses Presentation Manager Installation - PCMSETUP      */
/*                                                                           */
/* ASSUMES THAT CURRENT DRIVE IS --CDROM-- DRIVE WHEN INVOKED.               */
/*                                                                           */
/* INVOCATION FROM CDROM - PCM_INST DIRECTORY: [e:\pcm_inst\]install         */
/*     Copy install files to \OS2 on boot drive                              */
/*     Call PCMBLDOB.CMD                                                     */
/*     Invoke PCMSETUP.EXE                                                   */
/* ------------------------------------------------------------------------- */
'@echo off'
arg parm.1 comments
'cls'
if left(parm.1,1) = '?' then signal INFO_PLEASE
say ' '

/*-------------------------------------------------------------------------- */
call rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/*-------------------------------------------------------------------------- */
/* use OS2 environment variable COMSPEC=C:\OS2\CMD.EXE to find OS2 boot drv. */
/*-------------------------------------------------------------------------- */
cmspec = value('COMSPEC',,'OS2ENVIRONMENT');
os2drv = left(cmspec,1)
/*-------------------------------------------------------------------------- */
currdir=directory();          /* use REXX DIRECTORY to determine CDROM drive */
cddrv = left(currdir,1);

/*-------------------------------------------------------------------------- */
/* try to determine if installation is started from PCM Testkit CDROM        */
/*-------------------------------------------------------------------------- */

'CD \ 1>nul 2>nul'
'CD PCM_INST 1>nul 2>nul'
cdRC = RC
if cdRC \=0 then do
  say '[1;37;45m  *****************************************************[0;40;37m';
  say '[1;37;45m  *** Run this script from PCM Testkit CDROM          *[0;40;37m';
  say '[1;37;45m  *****************************************************[0;40;37m';
  signal INFO_PLEASE
end

/* Gets Drive Information in format:  DriveLetter Freespace TotalSpace Label */
DriveInfo = SysDriveInfo(os2drv':')
DiskFree = word(DriveInfo,2)
MBRequired = 20
if DiskFree < MBRequired*1024*1024 then do
  say '[1;37;45m  *****************************************************[0;40;37m';
  say '[1;37;45m  *** There is not enough free space on boot drive.   *[0;40;37m';
  say '[1;37;45m  *** Disk space required 'MBRequired' MB.                      *[0;40;37m';
  say '[1;37;45m  *****************************************************[0;40;37m';
  signal INFO_PLEASE
end

os2drv':'
'cd \'
/*-------------------------------------------------------------------------- */
'attrib  -h -r -s 'os2drv':\OS2KRNL'                           /**************/
if stream(os2drv':\os2krnl','c','query exists') = '' then do   /* NO OS2KRNL */
   say '[1;09;41m  *****************************************************[0;40;37m';
   say '[1;09;41m  *** Could NOT find 'os2drv':\OS2KRNL.  Check/Set the     ***[0;40;37m';
   say '[1;09;41m  *** COMSPEC environment var, reboot, and re-enter.   [0;40;37m';
   say '[1;09;41m  *****************************************************[0;40;37m';
   signal INFO_PLEASE
   end
else do
   say '[1;37;45m  *****************************************************[0;40;37m';
   say '[1;37;45m  *** OS2KRNL found on drive 'os2drv'                         [0;40;37m';
   say '[1;37;45m  *****************************************************[0;40;37m';
   end
'attrib  +h +r +s 'os2drv':\OS2KRNL'

/*-------------------------------------------------------------------------- */
if stream('\config.sys','c','query exists') = '' then do    /* NO CONFIG.SYS */
   say '[1;09;41m  *****************************************************[0;40;37m';
   say '[1;09;41m  *** Could NOT find 'os2drv':\CONFIG.SYS.  Verify drive   ***[0;40;37m';
   say '[1;09;41m  *** 'os2drv' is correct, then re-enter from CD drive.    ***[0;40;37m';
   say '[1;09;41m  *****************************************************[0;40;37m';
   signal INFO_PLEASE
   end
else do
   say '[1;37;45m  *** CONFIG.SYS found on drive 'os2drv'                      [0;40;37m';
   say '[1;09;41m  *****************************************************[0;40;37m';
   end

/*-------------------------------------------------------------------------- */
'copy   'cddrv':\pcm_inst\PCMKIT_F.ICO 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCMSETUP.EXE 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCMSETUP.ICO 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCMRSLTS.EXE 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCMRSLTS.ICO 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\OSLIST.TXT   'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCMHDW.EXE   'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCMHDW.ICO   'os2drv':\os2 >NUL'
'copy   'cddrv':\lan_inst\PCMHDW.HLP   'os2drv':\os2 >NUL'
'copy   'cddrv':\lan_inst\DYNAMIC.HDW  'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCMDOC.ICO   'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCMTEST.EXE  'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCMTEST.ICO  'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCMBLDOB.CMD 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PREPRSLT.CMD 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\CHEKRSLT.CMD 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCLIRSLT.CMD 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\ACLIRSLT.CMD 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PSVRRSLT.CMD 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\ASVRRSLT.CMD 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCMRBOOT.CMD 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\STARTCTL.CMD 'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\STARTUP.CTL  'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\YES.IN       'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\FORTEXT      'os2drv':\os2 >NUL'
'copy   'cddrv':\pcm_inst\PCMEAS.EXE   'os2drv':\os2 >NUL'

/* call SysSleep 5; */
/* ------------------------------------------------------------------------ */
/* for CDROM install, join EA data for .ICO files copied above              */
/* ------------------------------------------------------------------------ */
'eautil 'os2drv':\os2\pcmkit_f.ico  'cddrv':\pcm_inst\eas\pcmkit_f.ico /J /P >NUL'
'eautil 'os2drv':\os2\pcmsetup.ico  'cddrv':\pcm_inst\eas\pcmsetup.ico /J /P >NUL'
'eautil 'os2drv':\os2\pcmrslts.ico  'cddrv':\pcm_inst\eas\pcmrslts.ico /J /P >NUL'
'eautil 'os2drv':\os2\pcmdoc.ico    'cddrv':\pcm_inst\eas\pcmdoc.ico   /J /P >NUL'
'eautil 'os2drv':\os2\pcmtest.ico   'cddrv':\pcm_inst\eas\pcmtest.ico  /J /P >NUL'
'eautil 'os2drv':\os2\pcmhdw.ico    'cddrv':\pcm_inst\eas\pcmhdw.ico   /J /P >NUL'
'eautil 'os2drv':\os2\pcmeas.exe    'cddrv':\pcm_inst\eas\pcmeas.exe   /j /p >NUL'

say '[1;37;45m  *** INSTALLATION AND RESULTS FILES COPIED TO DISK ***[0;40;37m';
say '[1;37;45m  *****************************************************[0;40;37m';

/* call SysSleep 5; */

Doku:

'md OS2\PCM_DOCS 1>nul 2>nul'
'xcopy 'cddrv':\PCM_DOCS\*.* 'os2drv':\OS2\PCM_DOCS\ /S /R /O 1>nul'

say '[1;37;45m  *** DOCUMENTATION FILES COPIED TO DISK            ***[0;40;37m';
say '[1;37;45m  *****************************************************[0;40;37m';

/* call SysSleep 5;*/

/* ------------------------------------------------------------------------ */
/* CALL PCMBLDOB.CMD to build desktop folder and program objects            */
/* ------------------------------------------------------------------------ */
call PCMBLDOB.CMD
/* call SysSleep 3; */

say '[1;37;45m  *****************************************************[0;40;37m';
/* ------------------------------------------------------------------- */
'START "PCM SETUP" /N /PGM /PM /I PCMSETUP'

'md pcmlogs 1>nul 2>nul'
'copy   'cddrv':\pcm_inst\snfwin.txt    'os2drv':\pcmlogs 1>nul'
'md itlutil 1>nul 2>nul'
'cd itlutil 1>nul 2>nul'
'md cube 1>nul 2>nul'
'copy   'cddrv':\cube\*.*               'os2drv':\itlutil\cube 1>nul'
'cd \'
say '[1;37;45m  *** PCMSETUP WILL CONTINUE INSTALLATION           ***[0;40;37m';
say '[1;37;45m  *****************************************************[0;40;37m';
say '';


exit;

/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */
INFO_PLEASE:
say ''
say '[1;37;45mͻ';
say ' INSTALL.CMD - Copy PCM Testkit Install files from TESTKIT CDROM       ';
say '               to \OS2 directory on boot drive.                        ';
say '                                                                       ';
say ' Parameters:  NONE - User enters parms in PM program menus.            ';
say '                                                                       ';
say ' ASSUMES THAT CURRENT DRIVE IS --CDROM-- DRIVE WHEN INVOKED.           ';
say '                                                                       ';
say ' INVOCATION FROM CDROM DRIVE  [E:\pcm_inst\]install                    ';
say '                                                                       ';
say '       Copy install files to \os2 directory of OS2 boot drive.         ';
say '       Call PCMBLDOB.CMD                                               ';
say '       Invoke PCMSETUP.EXE                                             ';
say 'ͼ[0;40;37m';
exit
