/* ------------------------------------------------------------*/
/* ASVRRSLT.CMD - Analyze results diskette logfiles for        */
/*                pass-fail-missing and update of PCMSCORE.TXT */
/* Parameters: NONE                                            */
/* Invoked from PCMRSLTS.EXE for results diskette processing.  */
/* ------------------------------------------------------------*/
'@echo off'
arg parm.1 comments
'cls'
say ''
if left(parm.1,1) = '?' then signal INFO_PLEASE

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
say 'Ŀ'
say ' OS2 environment variable PCM_BOOTDRV not set.  Run LANSETUP '
say ' to update config.sys, then shutdown & reboot to continue.   '
say ''
exit
end

CALL RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'
CALL SysLoadFuncs

grepchk = '-y -r'
rcx = value('grepopt',grepchk,'OS2ENVIRONMENT');

if stream(os2drv':\pcmlogs\temp'  ,'c','query size') = '' then 'md 'os2drv':\pcmlogs\temp'
'cd 'os2drv':\'

'xcopy a:\ 'os2drv':\pcmlogs\temp /s/e/v >nul'  /* get dirs-logfiles for processing */

'echo . >> 'os2drv':\pcmlogs\temp\testbad'
'echo . >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*---*/
D01.ITLLS56.S01:
if stream(os2drv':\pcmlogs\temp\d01logs\ITLLS56.S01'  ,'c','query size') = '' then signal D01.ITLLS56.S01.MISSING

'grep "ITLLS56 Completed successfully" 'os2drv':\pcmlogs\temp\d01logs\ITLLS56.S01 > nul'
if rc \= 1 then signal D01.ITLLS56.S01.FAIL

'echo PCM LAN Domain_______ITLLS56.S01________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal D01.ITLLS56.R01

D01.ITLLS56.S01.MISSING:
'echo PCM LAN Domain_______ITLLS56.S01________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS56.S01 - logfile is missing.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  The LAN exerciser tests the DOMAIN system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the DOMAIN when under light load.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal D01.ITLLS56.R01

D01.ITLLS56.S01.FAIL:
'echo PCM LAN Domain_______ITLLS56.S01________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS56.S01 - logfile shows fail.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  Check the logfile under \S01LOGS to determine >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, and rerun.  The LAN exerciser tests the DOMAIN system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the DOMAIN when under light load.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'


/*---*/
D01.ITLLS56.R01:
if stream(os2drv':\pcmlogs\temp\d01logs\ITLLS56.R01'  ,'c','query size') = '' then signal D01.ITLLS56.R01.MISSING

'grep "ITLLS56 Completed successfully" 'os2drv':\pcmlogs\temp\d01logs\ITLLS56.R01 > nul'
if rc \= 1 then signal D01.ITLLS56.R01.FAIL

'echo PCM LAN Domain_______ITLLS56.R01________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal D01.ITLLS56.R02

D01.ITLLS56.R01.MISSING:
'echo PCM LAN Domain_______ITLLS56.R01________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS56.R01 - logfile is missing.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  The LAN exerciser tests the DOMAIN system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the DOMAIN when under light load.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal D01.ITLLS56.R02

D01.ITLLS56.R01.FAIL:
'echo PCM LAN Domain_______ITLLS56.R01________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS56.R01 - logfile shows fail.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  Check the logfile under \R01LOGS to determine >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, and rerun.  The LAN exerciser tests the DOMAIN system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the DOMAIN when under light load.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'


/*---*/
D01.ITLLS56.R02:
if stream(os2drv':\pcmlogs\temp\d01logs\ITLLS56.R02'  ,'c','query size') = '' then signal D01.ITLLS56.R02.MISSING

'grep "ITLLS56 Completed successfully" 'os2drv':\pcmlogs\temp\d01logs\ITLLS56.R02 > nul'
if rc \= 1 then signal D01.ITLLS56.R02.FAIL

'echo PCM LAN Domain_______ITLLS56.R02________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal D01.ITLMSG.D01

D01.ITLLS56.R02.MISSING:
'echo PCM LAN Domain_______ITLLS56.R02________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS56.R02 - logfile is missing.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  The LAN exerciser tests the DOMAIN system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the DOMAIN when under light load.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal D01.ITLMSG.D01

D01.ITLLS56.R02.FAIL:
'echo PCM LAN Domain_______ITLLS56.R02________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS56.R02 - logfile shows fail.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  Check the logfile under \R02LOGS to determine >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, and rerun.  The LAN exerciser tests the DOMAIN system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the DOMAIN when under light load.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'


/*---*/
D01.ITLMSG.D01:
if stream(os2drv':\pcmlogs\temp\d01logs\ITLMSG.D01'  ,'c','query size') = '' then signal D01.ITLMSG.D01.MISSING

'grep "ITLMSG Completed successfully" 'os2drv':\pcmlogs\temp\d01logs\ITLMSG.D01 > nul'
if rc \= 1 then signal D01.ITLMSG.D01.FAIL

'echo PCM LAN Domain_______ITLMSG.D01_________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal D01.ITLMSG.R01

D01.ITLMSG.D01.MISSING:
'echo PCM LAN Domain_______ITLMSG.D01_________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLMSG.D01  - logfile is missing.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the DOMAIN Controller run the command       >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLMSG.CMD.  Then UPDATE the results diskette.                    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal D01.ITLMSG.R01

D01.ITLMSG.D01.FAIL:
'echo PCM LAN Domain_______ITLMSG.D01_________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLMSG.D01  - logfile shows fail.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  Check the logfile under \D01LOGS to determine    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, then from the DOMAIN Controller run the command        >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLMSG.CMD.  Then UPDATE the results diskette.                    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'


/*---*/
D01.ITLMSG.R01:
if stream(os2drv':\pcmlogs\temp\d01logs\ITLMSG.R01'  ,'c','query size') = '' then signal D01.ITLMSG.R01.MISSING

'grep "ITLMSG Completed successfully" 'os2drv':\pcmlogs\temp\d01logs\ITLMSG.R01 > nul'
if rc \= 1 then signal D01.ITLMSG.R01.FAIL

'echo PCM LAN Domain_______ITLMSG.R01_________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal D01.ITLFTP02.R02

D01.ITLMSG.R01.MISSING:
'echo PCM LAN Domain_______ITLMSG.R01_________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLMSG.R01  - logfile is missing.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the CLIENT #1 system, run the command       >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLMSG.CMD.  Then UPDATE the results diskette.                    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal D01.ITLFTP02.R02

D01.ITLMSG.R01.FAIL:
'echo PCM LAN Domain_______ITLMSG.R01_________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLMSG.R01  - logfile shows fail.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  Check the logfile under \R01LOGS to determine    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, then from the CLIENT #1 system, run the command        >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLMSG.CMD.  Then UPDATE the results diskette.                    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'


/*---*/
D01.ITLFTP02.R02:
if stream(os2drv':\pcmlogs\temp\d01logs\ITLFTP02.R02'  ,'c','query size') = '' then signal D01.ITLFTP02.R02.MISSING

'grep "ITLFTP02 Completed successfully" 'os2drv':\pcmlogs\temp\d01logs\ITLFTP02.R02 > nul'
if rc \= 1 then signal D01.ITLFTP02.R02.FAIL

'echo PCM LAN Domain_______ITLFTP02.R02_______PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal D01.ITLTCP01.D01

D01.ITLFTP02.R02.MISSING:
'echo PCM LAN Domain_______ITLFTP02.R02_______MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLFTP02.R02  logfile is missing.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the CLIENT #2 system, run the command       >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLFTP02.CMD.  Then UPDATE the results diskette.                  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal D01.ITLTCP01.D01

D01.ITLFTP02.R02.FAIL:
'echo PCM LAN Domain_______ITLFTP02.R02_______FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLFTP02.R02  logfile shows fail.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  Check the logfile under \R02LOGS to determine    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, then from the CLIENT #2 system, run the command        >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLFTP02.CMD.  Then UPDATE the results diskette.                  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'


/*---*/
D01.ITLTCP01.D01:
if stream(os2drv':\pcmlogs\temp\d01logs\ITLTCP01.D01'  ,'c','query size') = '' then signal D01.ITLTCP01.D01.MISSING

'grep "ITLTCP01 Completed successfully" 'os2drv':\pcmlogs\temp\d01logs\ITLTCP01.D01 > nul'
if rc \= 1 then signal D01.ITLTCP01.D01.FAIL

'echo PCM LAN Domain_______ITLTCP01.D01_______PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal D01.ITLDUMP

D01.ITLTCP01.D01.MISSING:
'echo PCM LAN Domain_______ITLTCP01.D01_______MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLTCP01.D01  logfile is missing.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the DOMAIN Controller run the command       >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLTCP01.CMD.  Then UPDATE the results diskette.                  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal D01.ITLDUMP

D01.ITLTCP01.D01.FAIL:
'echo PCM LAN Domain_______ITLTCP01.D01_______FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLTCP01.D01  logfile shows fail.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  Check the logfile under \D01LOGS to determine    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, then from the DOMAIN Controller run the command        >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLTCP01.CMD.  Then UPDATE the results diskette.                  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'


/*---*/
D01.ITLDUMP:
if stream(os2drv':\pcmlogs\temp\d01logs\ITLDUMP.TXT'  ,'c','query size') = '' then signal ITLDUMP.INCOMPLETE

'grep x 'os2drv':\pcmlogs\temp\d01logs\itldump.txt > nul'
if rc < 5 then signal ITLDUMP.INCOMPLETE

'grep "    x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLDUMP.TXT > nul'
if rc > 0 then signal ITLDUMPCMT
'grep "     x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLDUMP.TXT > nul'
if rc > 0 then signal ITLDUMPCMT
'grep "      x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLDUMP.TXT > nul'
if rc > 0 then signal ITLDUMPCMT
'grep "       x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLDUMP.TXT > nul'
if rc > 0 then signal ITLDUMPCMT

'grep "    x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLDUMP.TXT > nul'
if rc > 0 then signal ITLDUMPCMT
'grep "     x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLDUMP.TXT > nul'
if rc > 0 then signal ITLDUMPCMT
'grep "      x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLDUMP.TXT > nul'
if rc > 0 then signal ITLDUMPCMT
'grep "       x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLDUMP.TXT > nul'
if rc > 0 then signal ITLDUMPCMT

'echo PCM LAN Domain_______ITLDUMP.D01________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal D01.ITLPSNS

ITLDUMP.INCOMPLETE:
'echo PCM LAN Domain_______ITLDUMP.D01________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLDUMP.TXT file has not been updated.  Complete the ITLDUMP testcase >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and update \ITLUTIL\ITLDUMP.TXT, then UPDATE the results diskette >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal D01.ITLPSNS

ITLDUMPCMT:
'echo PCM LAN Domain_______ITLDUMP.D01________COMMENTS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLDUMP.TXT shows problems occurred.  Remember to update the PCMHDW >> 'os2drv':\pcmlogs\temp\testbad'
'echo     system information PANEL-4 Comments area with details. >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'


/*---*/
D01.ITLPSNS:
if stream(os2drv':\pcmlogs\temp\d01logs\ITLPSNS.TXT'  ,'c','query size') = '' then signal ITLPSNS.INCOMPLETE

'grep x 'os2drv':\pcmlogs\temp\d01logs\itlpsns.txt > nul'
if rc < 6 then signal ITLPSNS.INCOMPLETE

'grep "    x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLPSNS.TXT > nul'
if rc = 1 then signal ITLPSNSCMT
'grep "     x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLPSNS.TXT > nul'
if rc = 1 then signal ITLPSNSCMT
'grep "      x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLPSNS.TXT > nul'
if rc = 1 then signal ITLPSNSCMT
'grep "       x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLPSNS.TXT > nul'
if rc = 1 then signal ITLPSNSCMT

'grep "    x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLPSNS.TXT > nul'
if rc = 1 then signal ITLPSNSCMT
'grep "     x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLPSNS.TXT > nul'
if rc = 1 then signal ITLPSNSCMT
'grep "      x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLPSNS.TXT > nul'
if rc = 1 then signal ITLPSNSCMT
'grep "       x" 'os2drv':\PCMLOGS\TEMP\D01LOGS\ITLPSNS.TXT > nul'
if rc = 1 then signal ITLPSNSCMT

'echo PCM LAN Domain_______ITLPSNS.D01________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal D01.ITLRAID.D01

ITLPSNS.INCOMPLETE:
'echo PCM LAN Domain_______ITLPSNS.D01________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLPSNS.TXT file has not been updated.  Complete the ITLPSNS testcase >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and update \ITLUTIL\ITLPSNS.TXT, then UPDATE the results diskette >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal D01.ITLRAID.D01

ITLPSNSCMT:
'echo PCM LAN Domain_______ITLPSNS.D01________COMMENTS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLPSNS.TXT shows problems occurred.  Remember to update the PCMHDW >> 'os2drv':\pcmlogs\temp\testbad'
'echo     system information PANEL-4 Comments area with details. >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'


/*---*/
D01.ITLRAID.D01:

'grep "RAID System" 'os2drv':\pcmlogs\temp\D01LOGS\ITLRAID.D01 > nul'
if rc > 1 then signal CHK_RAID

'echo PCM LAN Domain_______ITLRAID.D01________NOT RUN >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal S01.ITLLS57.D01

CHK_RAID:
alertlog = os2drv':\pcmlogs\temp\D01LOGS\ITLRAID.D01'
x=stream(alertlog,'c','open read');
sta = 'Status'
raidstat = 0;

do forever;
   line = LINEIN(alertlog);
   if pos('Device Defunct', line) > 0 then
     do
       parse value line with dev ')' sta  unused;
       tstdev = right(dev,1);
       say 'device failed number ='tstdev
         do forever;
           line = LINEIN(alertlog);
           if pos('RAID Device Online', line) > 0 then
             do
               parse value line with dev ')' sta  unused;
               num = right(dev,1);
               say 'device online number ='num
               if num = tstdev then raidstat = 2;
             end
           if lines(alertlog) = 0 then leave
         end
     end
if lines(alertlog) = 0 then leave
end


/* ---------------------------------------------------------------------- */
x=stream(alertlog,'c','close')
if raidstat = 2 then signal RAID_PASS

'echo PCM LAN Domain_______ITLRAID.D01________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLRAID.D01 - alert.log indicates RAID drives, but removal alert and  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     online after rebuild alerts were not both found.  Please run the  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLRAID test as outlined in the documentation.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Then UPDATE the results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
signal S01.ITLLS57.D01

RAID_PASS:
'echo PCM LAN Domain_______ITLRAID.D01________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'


/*---*/
S01.ITLLS57.D01:

'echo . >> 'os2drv':\pcmlogs\temp\testbad'
'echo . >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

if stream(os2drv':\pcmlogs\temp\S01logs\ITLLS57.D01'  ,'c','query size') = '' then signal S01.ITLLS57.D01.MISSING

'grep "ITLLS57 Completed successfully" 'os2drv':\pcmlogs\temp\S01LOGS\ITLLS57.D01 > nul'
if rc \= 1 then signal S01.ITLLS57.D01.FAIL

'echo PCM LAN Server_______ITLLS57.D01________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal S01.ITLLS57.R01

S01.ITLLS57.D01.MISSING:
'echo PCM LAN Server_______ITLLS57.D01________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS57.D01 - logfile is missing.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  The LAN exerciser tests the SERVER system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (D01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the SERVER when under light load.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal S01.ITLLS57.R01

S01.ITLLS57.D01.FAIL:
'echo PCM LAN Server_______ITLLS57.D01________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS57.D01 - logfile shows fail.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  Check the logfile under \D01LOGS to determine >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, and rerun.  The LAN exerciser tests the SERVER system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (D01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the SERVER when under light load.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
S01.ITLLS57.R01:
if stream(os2drv':\pcmlogs\temp\S01logs\ITLLS57.R01'  ,'c','query size') = '' then signal S01.ITLLS57.R01.MISSING

'grep "ITLLS57 Completed successfully" 'os2drv':\pcmlogs\temp\S01LOGS\ITLLS57.R01 > nul'
if rc \= 1 then signal S01.ITLLS57.R01.FAIL

'echo PCM LAN Server_______ITLLS57.R01________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal S01.ITLLS57.R02

S01.ITLLS57.R01.MISSING:
'echo PCM LAN Server_______ITLLS57.R01________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS57.R01 - logfile is missing.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  The LAN exerciser tests the SERVER system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (D01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the SERVER when under light load.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal S01.ITLLS57.R02

S01.ITLLS57.R01.FAIL:
'echo PCM LAN Server_______ITLLS57.R01________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS57.R01 - logfile shows fail.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  Check the logfile under \R01LOGS to determine >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, and rerun.  The LAN exerciser tests the SERVER system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (D01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the SERVER when under light load.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
S01.ITLLS57.R02:
if stream(os2drv':\pcmlogs\temp\S01logs\ITLLS57.R02'  ,'c','query size') = '' then signal S01.ITLLS57.R02.MISSING

'grep "ITLLS57 Completed successfully" 'os2drv':\pcmlogs\temp\S01LOGS\ITLLS57.R02 > nul'
if rc \= 1 then signal S01.ITLLS57.R02.FAIL

'echo PCM LAN Server_______ITLLS57.R02________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal S01.ITLFTP01.R01

S01.ITLLS57.R02.MISSING:
'echo PCM LAN Server_______ITLLS57.R02________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS57.R02 - logfile is missing.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  The LAN exerciser tests the SERVER system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (D01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the SERVER when under light load.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal S01.ITLFTP01.R01

S01.ITLLS57.R02.FAIL:
'echo PCM LAN Server_______ITLLS57.R02________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS57.R02 - logfile shows fail.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  Check the logfile under \R02LOGS to determine >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, and rerun.  The LAN exerciser tests the SERVER system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (D01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the SERVER when under light load.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
S01.ITLFTP01.R01:
if stream(os2drv':\pcmlogs\temp\S01logs\ITLFTP01.R01'  ,'c','query size') = '' then signal S01.ITLFTP01.R01.MISSING

'grep "ITLFTP01 Completed successfully" 'os2drv':\pcmlogs\temp\S01LOGS\ITLFTP01.R01 > nul'
if rc \= 1 then signal S01.ITLFTP01.R01.FAIL

'echo PCM LAN Server_______ITLFTP01.R01_______PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal S01.ITLALERT.S01

S01.ITLFTP01.R01.MISSING:
'echo PCM LAN Server_______ITLFTP01.R01_______MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLFTP01.R01  logfile is missing.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the CLIENT #1 system, run the command       >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLFTP01.CMD.  Then UPDATE the results diskette.                  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal S01.ITLALERT.S01

S01.ITLFTP01.R01.FAIL:
'echo PCM LAN Server_______ITLFTP01.R01_______FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLFTP01.R01  logfile shows fail.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  Check the logfile under \R01LOGS to determine    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, then from the CLIENT #1 system, run the command        >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLFTP01.CMD.  Then UPDATE the results diskette.                  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
S01.ITLALERT.S01:
if stream(os2drv':\pcmlogs\temp\S01logs\ITLALERT.S01'  ,'c','query size') = '' then signal S01.ITLALERT.S01.MISSING

'grep "ITLALERT Completed successfully" 'os2drv':\pcmlogs\temp\S01LOGS\ITLALERT.S01 > nul'
if rc \= 1 then signal S01.ITLALERT.S01.FAIL

'echo PCM LAN Server_______ITLALERT.S01_______PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal S01.ITLLD.R02

S01.ITLALERT.S01.MISSING:
'echo PCM LAN Server_______ITLALERT.S01_______MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLALERT.S01  logfile is missing.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the SERVER system, run the command          >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLALERT.CMD.  Then UPDATE the results diskette.                  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal S01.ITLLD.R02

S01.ITLALERT.S01.FAIL:
'echo PCM LAN Server_______ITLALERT.S01_______FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLALERT.S01  logfile shows fail.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  Check the logfile under \S01LOGS to determine    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, then from the SERVER system, run the command           >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLALERT.CMD.  Then UPDATE the results diskette.                  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
S01.ITLLD.R02:
if stream(os2drv':\pcmlogs\temp\S01logs\ITLLD.R02'  ,'c','query size') = '' then signal S01.ITLLD.R02.MISSING

'grep "ITLLD Completed successfully" 'os2drv':\pcmlogs\temp\S01LOGS\ITLLD.R02 > nul'
if rc \= 1 then signal S01.ITLLD.R02.FAIL

'echo PCM LAN Server_______ITLLD.R02__________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal S01.SYSINFO.RPT

S01.ITLLD.R02.MISSING:
'echo PCM LAN Server_______ITLLD.R02__________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLD.R02 --  logfile is missing.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the CLIENT #2 system run the command        >> 'os2drv':\pcmlogs\temp\testbad'
'echo     LANRBOOT.CMD which will switch system to LAN Distance, reboot and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run the ITLLD.CMD testcase.  Then UPDATE the results diskette.    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal S01.SYSINFO.RPT

S01.ITLLD.R02.FAIL:
'echo PCM LAN Server_______ITLLD.R02__________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLD.R02 --  logfile shows fail.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  Check the logfile in \R02LOGS to determine the   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     cause, and then from the CLIENT #2 system run the command         >> 'os2drv':\pcmlogs\temp\testbad'
'echo     LANRBOOT.CMD which will switch system to LAN Distance, reboot and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run the ITLLD.CMD testcase.  Then UPDATE the results diskette.    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
S01.SYSINFO.RPT:
if stream(os2drv':\pcmlogs\temp\S01LOGS\SYSINFO.RPT'  ,'c','query size') = '' then signal SYSINFO.RPT.MISSING

'grep "IT01S01" 'os2drv':\pcmlogs\temp\S01LOGS\SYSINFO.RPT > nul'
if rc = 0 then signal SYSINFO.RPT.FAIL

'echo PCM LAN Server_______SYSINFO.RPT________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SYSFILE.SETUP

SYSINFO.RPT.MISSING:
'echo PCM LAN Server_______SYSINFO.RPT________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo SYSINFO.RPT - output file missing.  This test is required and can be  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the SERVER system, follow the directions    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to run the manual testcase ITLSV11 to generate the output file.   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Then UPDATE the results diskette.                                 >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal SYSFILE.SETUP

SYSINFO.RPT.FAIL:
'echo PCM LAN Server_______SYSINFO.RPT________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo SYSINFO.RPT - output incorrect.     This test is required and can be  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the SERVER system, follow the directions    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to run the manual testcase ITLSV11 to generate the output file.   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Then UPDATE the results diskette.                                 >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

SYSFILE.SETUP:
Call SysFileTree os2drv':\pcmlogs\temp\s01logs\*.inv', 'sysview', 'FO'

do i = 1 to sysview.0

   'grep "IT01D01" 'os2drv':\pcmlogs\temp\S01LOGS\'right(sysview.i,12)' > nul'
   if rc = 1 then do
      d01inv = right(sysview.i,12)
      d01hst = left(d01inv,8) || .hst
      iterate
      end

   'grep "IT01S01" 'os2drv':\pcmlogs\temp\S01LOGS\'right(sysview.i,12)' > nul'
   if rc = 1 then do
      s01inv = right(sysview.i,12)
      s01hst = left(s01inv,8) || .hst
      iterate
      end

   'grep "IT01R01" 'os2drv':\pcmlogs\temp\S01LOGS\'right(sysview.i,12)' > nul'
   if rc = 1 then do
      r01inv = right(sysview.i,12)
      r01hst = left(r01inv,8) || .hst
      iterate
      end

   'grep "IT01R02" 'os2drv':\pcmlogs\temp\S01LOGS\'right(sysview.i,12)' > nul'
   if rc = 1 then do
      r02inv = right(sysview.i,12)
      r02hst = left(r02inv,8) || .hst
      iterate
      end
end

/*-----*/
D01.HST:
if stream(os2drv':\pcmlogs\temp\S01LOGS\'d01hst  ,'c','query size') = '' then signal D01.HST.MISSING

'echo PCM LAN Server_______IT01D01.HST________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal D01.INV

D01.HST.MISSING:
'echo PCM LAN Server_______IT01D01.HST________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo IT01D01.HST - output file missing.  This test is required and uses    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the group setup from test ITLSV00 to schedule data gathering.     >> 'os2drv':\pcmlogs\temp\testbad'
'echo     From the SERVER system (after running ITLSV00) follow the         >> 'os2drv':\pcmlogs\temp\testbad'
'echo     directions to run manual testcase ITLSV07 to generate output file >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Then UPDATE the results diskette.                                 >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----*/
D01.INV:
if stream(os2drv':\pcmlogs\temp\S01LOGS\'d01inv  ,'c','query size') = '' then signal D01.INV.MISSING

'echo PCM LAN Server_______IT01D01.INV________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal S01.HST

D01.INV.MISSING:
'echo PCM LAN Server_______IT01D01.INV________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo IT01D01.INV - output file missing.  This test is required and uses    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the group setup from test ITLSV00 to schedule data gathering.     >> 'os2drv':\pcmlogs\temp\testbad'
'echo     From the SERVER system (after running ITLSV00) follow the         >> 'os2drv':\pcmlogs\temp\testbad'
'echo     directions to run manual testcase ITLSV08 to generate output file >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Then UPDATE the results diskette.                                 >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----*/
S01.HST:
if stream(os2drv':\pcmlogs\temp\S01LOGS\'s01hst  ,'c','query size') = '' then signal S01.HST.MISSING

'echo PCM LAN Server_______IT01S01.HST________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal S01.INV

S01.HST.MISSING:
'echo PCM LAN Server_______IT01S01.HST________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo IT01S01.HST - output file missing.  This test is required and uses    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the group setup from test ITLSV00 to schedule data gathering.     >> 'os2drv':\pcmlogs\temp\testbad'
'echo     From the SERVER system (after running ITLSV00) follow the         >> 'os2drv':\pcmlogs\temp\testbad'
'echo     directions to run manual testcase ITLSV07 to generate output file >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Then UPDATE the results diskette.                                 >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----*/
S01.INV:
if stream(os2drv':\pcmlogs\temp\S01LOGS\'s01inv  ,'c','query size') = '' then signal S01.INV.MISSING

'echo PCM LAN Server_______IT01S01.INV________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R01.INV

S01.INV.MISSING:
'echo PCM LAN Server_______IT01S01.INV________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo IT01S01.INV - output file missing.  This test is required and uses    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the group setup from test ITLSV00 to schedule data gathering.     >> 'os2drv':\pcmlogs\temp\testbad'
'echo     From the SERVER system (after running ITLSV00) follow the         >> 'os2drv':\pcmlogs\temp\testbad'
'echo     directions to run manual testcase ITLSV08 to generate output file >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Then UPDATE the results diskette.                                 >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'


/*-----*/
R01.INV:
if stream(os2drv':\pcmlogs\temp\S01LOGS\'r01inv  ,'c','query size') = '' then signal R01.INV.MISSING

'echo PCM LAN Server_______IT01R01.INV________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R02.HST

R01.INV.MISSING:
'echo PCM LAN Server_______IT01R01.INV________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo IT01R01.INV - output file missing.  This test is required and uses    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the group setup from test ITLSV00 to schedule data gathering.     >> 'os2drv':\pcmlogs\temp\testbad'
'echo     From the SERVER system (after running ITLSV00) follow the         >> 'os2drv':\pcmlogs\temp\testbad'
'echo     directions to run manual testcase ITLSV08 to generate output file >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Then UPDATE the results diskette.                                 >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----*/
R02.HST:
if stream(os2drv':\pcmlogs\temp\S01LOGS\'r02hst  ,'c','query size') = '' then signal R02.HST.MISSING

'echo PCM LAN Server_______IT01R02.HST________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R02.INV

R02.HST.MISSING:
'echo PCM LAN Server_______IT01R02.HST________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo IT01R02.HST - output file missing.  This test is required and uses    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the group setup from test ITLSV00 to schedule data gathering.     >> 'os2drv':\pcmlogs\temp\testbad'
'echo     From the SERVER system (after running ITLSV00) follow the         >> 'os2drv':\pcmlogs\temp\testbad'
'echo     directions to run manual testcase ITLSV07 to generate output file >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Then UPDATE the results diskette.                                 >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----*/
R02.INV:
if stream(os2drv':\pcmlogs\temp\S01LOGS\'r02inv  ,'c','query size') = '' then signal R02.INV.MISSING

'echo PCM LAN Server_______IT01R02.INV________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal D01.ITLPSF00

R02.INV.MISSING:
'echo PCM LAN Server_______IT01R02.INV________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo IT01R02.INV - output file missing.  This test is required and uses    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the group setup from test ITLSV00 to schedule data gathering.     >> 'os2drv':\pcmlogs\temp\testbad'
'echo     From the SERVER system (after running ITLSV00) follow the         >> 'os2drv':\pcmlogs\temp\testbad'
'echo     directions to run manual testcase ITLSV08 to generate output file >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Then UPDATE the results diskette.                                 >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*---------*/
D01.ITLPSF00:
if stream(os2drv':\pcmlogs\temp\s01logs\ITLPSF00.TXT'  ,'c','query size') = '' then signal ITLPSF00.INCOMPLETE

'grep x 'os2drv':\pcmlogs\temp\s01logs\ITLPSF00.txt > nul'
if rc < 5 then signal ITLPSF00.INCOMPLETE

'grep "    x" 'os2drv':\PCMLOGS\TEMP\S01LOGS\ITLPSF00.TXT > nul'
if rc = 1 then signal ITLPSF00CMT
'grep "     x" 'os2drv':\PCMLOGS\TEMP\S01LOGS\ITLPSF00.TXT > nul'
if rc = 1 then signal ITLPSF00CMT
'grep "      x" 'os2drv':\PCMLOGS\TEMP\S01LOGS\ITLPSF00.TXT > nul'
if rc = 1 then signal ITLPSF00CMT
'grep "       x" 'os2drv':\PCMLOGS\TEMP\S01LOGS\ITLPSF00.TXT > nul'
if rc = 1 then signal ITLPSF00CMT

'grep "    x" 'os2drv':\PCMLOGS\TEMP\S01LOGS\ITLPSF00.TXT > nul'
if rc = 1 then signal ITLPSF00CMT
'grep "     x" 'os2drv':\PCMLOGS\TEMP\S01LOGS\ITLPSF00.TXT > nul'
if rc = 1 then signal ITLPSF00CMT
'grep "      x" 'os2drv':\PCMLOGS\TEMP\S01LOGS\ITLPSF00.TXT > nul'
if rc = 1 then signal ITLPSF00CMT
'grep "       x" 'os2drv':\PCMLOGS\TEMP\S01LOGS\ITLPSF00.TXT > nul'
if rc = 1 then signal ITLPSF00CMT

'echo PCM LAN Server_______ITLPSF00.S01_______PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SYSMON.SETUP

ITLPSF00.INCOMPLETE:
'echo PCM LAN Server_______ITLPSF00.S01_______FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLPSF00.TXT file has not been updated.  Complete the ITLPSF00 testcase >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and update \ITLUTIL\ITLPSF00.TXT, then UPDATE the results diskette >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal SYSMON.SETUP

ITLPSF00CMT:
'echo PCM LAN Server_______ITLPSF00.S01_______COMMENTS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLPSF00.TXT shows problems occurred.  Remember to update the PCMHDW >> 'os2drv':\pcmlogs\temp\testbad'
'echo     system information PANEL-4 Comments area with details. >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'


SYSMON.SETUP:
Call SysFileTree os2drv':\pcmlogs\temp\s01logs\*.dbf', 'sysmons', 'FO'
monfle = '';
do i = 1 to sysmons.0

   'grep "IT01D01" 'os2drv':\pcmlogs\temp\S01LOGS\'right(sysmons.i,12)' > nul'
   if rc > 0 then do
      monfle = right(sysmons.i,12)
      leave
      end

   'grep "IT01R01" 'os2drv':\pcmlogs\temp\S01LOGS\'right(sysmons.i,12)' > nul'
   if rc > 0 then do
      monfle = right(sysmons.i,12)
      leave
      end

   'grep "IT01R02" 'os2drv':\pcmlogs\temp\S01LOGS\'right(sysmons.i,12)' > nul'
   if rc > 0 then do
      monfle = right(sysmons.i,12)
      leave
      end
end

if monfle = '' then signal SYSMONITOR.MISSING

'grep "MONITOR_VALUE" 'os2drv':\pcmlogs\temp\S01LOGS\'monfle' > nul'
if rc > 0 then signal SYSMONITOR.PASS

SYSMONITOR.MISSING:
'echo PCM LAN Server_______ITLSV06.S01________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLSV06.S01 - output file from Monitor Remote System Resources is     >> 'os2drv':\pcmlogs\temp\testbad'
'echo     missing.  From the SERVER system (after running ITLSV00) follow   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the directions to run manual testcase ITLSV06 to generate the     >> 'os2drv':\pcmlogs\temp\testbad'
'echo     output file.  Then UPDATE the results diskette.                   >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal CLEANUP

SYSMONITOR.PASS:
'echo PCM LAN Server_______ITLSV06.S01________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'


CLEANUP:

if stream(os2drv':\pcmlogs\temp\pcmscore.txt'  ,'c','query size') \= '' then do
   'copy 'os2drv':\pcmlogs\temp\pcmscore.txt A:\ > nul'
   'copy 'os2drv':\pcmlogs\temp\pcmscore.txt 'os2drv':\PCMLOGS > nul'
   end


if stream(os2drv':\pcmlogs\temp\testbad'  ,'c','query size') \= '' then do
   'copy 'os2drv':\pcmlogs\temp\testbad A:\ > nul'
   end

'zap 'os2drv':\PCMLOGS\TEMP > nul'
exit

INFO_PLEASE:
say 'ͻ'
say ' ASVRRSLT.CMD - Analyzes testkit results diskette and logfiles '
say '                for PASS-FAIL-MISSING and updates PCMSCORE.TXT '
say '                                                               '
say ' Parameters: NONE                                              '
say '                                                               '
say ' REQUIRES DISKETTE IN DRIVE A: PREPARED WITH PSVRRSLT.CMD      '
say '                                                               '
say ' Called by PCMRSLTS.EXE after running PSVRRSLT.CMD             '
say 'ͼ'
exit
