/* ------------------------------------------------------------*/
/* ACLIRSLT.CMD - Analyze results diskette logfiles for        */
/*                pass-fail-missing and update of PCMSCORE.TXT */
/* Parameters: NONE                                            */
/* Invoked from PCMRSLTS.EXE for results diskette processing.  */
/* ------------------------------------------------------------*/
'@echo off'
arg parm.1 comments
'cls'
say ''
if left(parm.1,1) = '?' then signal INFO_PLEASE

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
say '***************************************************************'
say '* OS2 environment variable PCM_BOOTDRV not set.  Run LANSETUP *'
say '* to update config.sys, then shutdown & reboot to continue.   *'
say '***************************************************************'
exit
end

grepchk = '-Ny -r -y'
rcx = value('grepopt',grepchk,'OS2ENVIRONMENT');

if stream(os2drv':\pcmlogs\temp'  ,'c','query size') = '' then 'md 'os2drv':\pcmlogs\temp'
'cd 'os2drv':\'

'xcopy a:\ 'os2drv':\pcmlogs\temp /s/e/v >nul'  /* get dirs-logfiles for processing */

'echo . >> 'os2drv':\pcmlogs\temp\testbad'
'echo . >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*-----------------*/
R01.ITLPEER.S01:
if stream(os2drv':\pcmlogs\TEMP\R01LOGS\ITLPEER.S01'  ,'c','query size') = '' then signal R01.ITLPEER.S01.MISSING

'grep "ITLPEER Completed successfully" 'os2drv':\pcmlogs\temp\R01LOGS\ITLPEER.S01 > nul'
if rc \= 1 then signal R01.ITLPEER.S01.FAIL

'echo PCM LAN Client1______ITLPEER.S01________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R01.ITLPEER.R02

R01.ITLPEER.S01.MISSING:
'echo PCM LAN Client1______ITLPEER.S01________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLPEER.S01 - logfile is missing.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  The LAN exerciser tests the CLIENT #1 PEER and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 2 systems (S01,R02) at the same time in order      >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the PEER when under light load.    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal R01.ITLPEER.R02

R01.ITLPEER.S01.FAIL:
'echo PCM LAN Client1______ITLPEER.S01________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLPEER.S01 - logfile shows fail.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  Check the logfile under \S01LOGS to determine >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, and rerun.  The LAN exerciser tests the CLIENT #1 PEER and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 2 systems (S01,R02) at the same time in order      >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the PEER when under light load.    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
R01.ITLPEER.R02:
if stream(os2drv':\pcmlogs\TEMP\R01LOGS\ITLPEER.R02'  ,'c','query size') = '' then signal R01.ITLPEER.R02.MISSING

'grep "ITLPEER Completed successfully" 'os2drv':\pcmlogs\temp\R01LOGS\ITLPEER.R02 > nul'
if rc \= 1 then signal R01.ITLPEER.R02.FAIL

'echo PCM LAN Client1______ITLPEER.R02________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R01.ITLLS56.R01

R01.ITLPEER.R02.MISSING:
'echo PCM LAN Client1______ITLPEER.R02________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLPEER.R02 - logfile is missing.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  The LAN exerciser tests the CLIENT #1 PEER and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 2 systems (S01,R02) at the same time in order      >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the PEER when under light load.    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal R01.ITLLS56.R01

R01.ITLPEER.R02.FAIL:
'echo PCM LAN Client1______ITLPEER.R02________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLPEER.R02 - logfile shows fail.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  Check the logfile under \R02LOGS to determine >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, and rerun.  The LAN exerciser tests the CLIENT #1 PEER and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 2 systems (S01,R02) at the same time in order      >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the PEER when under light load.    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
R01.ITLLS56.R01:
if stream(os2drv':\pcmlogs\TEMP\R01LOGS\ITLLS56.R01'  ,'c','query size') = '' then signal R01.ITLLS56.R01.MISSING

'grep "ITLLS56 Completed successfully" 'os2drv':\pcmlogs\temp\R01LOGS\ITLLS56.R01 > nul'
if rc \= 1 then signal R01.ITLLS56.R01.FAIL

'echo PCM LAN Client1______ITLLS56.R01________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R01.ITLLS57.R01

R01.ITLLS56.R01.MISSING:
'echo PCM LAN Client1______ITLLS56.R01________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS56.R01 - logfile is missing.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  The LAN exerciser tests the DOMAIN system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the DOMAIN when under light load,  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and if the CLIENT system can talk with the DOMAIN under light load. >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal R01.ITLLS57.R01

R01.ITLLS56.R01.FAIL:
'echo PCM_LAN_Cleint1______ITLLS56.R01________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS56.R01 - logfile shows fail.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  Check the logfile under \R01LOGS to determine >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, and rerun.  The LAN exerciser tests the DOMAIN system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the DOMAIN when under light load,  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and if the CLIENT system can talk with the DOMAIN under light load. >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
R01.ITLLS57.R01:
if stream(os2drv':\pcmlogs\TEMP\R01LOGS\ITLLS57.R01'  ,'c','query size') = '' then signal R01.ITLLS57.R01.MISSING

'grep "ITLLS57 Completed successfully" 'os2drv':\pcmlogs\temp\R01LOGS\ITLLS57.R01 > nul'
if rc \= 1 then signal R01.ITLLS57.R01.FAIL

'echo PCM LAN Client1______ITLLS57.R01________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R01.ITLMSG.R01

R01.ITLLS57.R01.MISSING:
'echo PCM LAN Client1______ITLLS57.R01________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS57.R01 - logfile is missing.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  The LAN exerciser tests the SERVER system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the SERVER when under light load,  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and if the CLIENT system can talk with the SERVER under light load. >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal R01.ITLMSG.R01

R01.ITLLS57.R01.FAIL:
'echo PCM LAN Client1______ITLLS57.R01________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS57.R01 - logfile shows fail.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  Check the logfile under \R01LOGS to determine >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, and rerun.  The LAN exerciser tests the SERVER system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the SERVER when under light load,  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and if the CLIENT system can talk with the SERVER under light load. >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
R01.ITLMSG.R01:
if stream(os2drv':\pcmlogs\TEMP\R01LOGS\ITLMSG.R01'  ,'c','query size') = '' then signal R01.ITLMSG.R01.MISSING

'grep "ITLMSG Completed successfully" 'os2drv':\pcmlogs\temp\R01LOGS\ITLMSG.R01 > nul'
if rc \= 1 then signal R01.ITLMSG.R01.FAIL

'echo PCM LAN Client1______ITLMSG.R01_________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R01.ITLMSG.D01

R01.ITLMSG.R01.MISSING:
'echo PCM LAN Client1______ITLMSG.R01_________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLMSG.R01  - logfile is missing.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the CLIENT #1 system, run the command       >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLMSG.CMD.  Then UPDATE the results diskette.                    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal R01.ITLMSG.D01

R01.ITLMSG.R01.FAIL:
'echo PCM LAN Client1______ITLMSG.R01_________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLMSG.R01  - logfile shows fail.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  Check the logfile under \R01LOGS to determine    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, then from the CLIENT #1 system, run the command        >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLMSG.CMD.  Then UPDATE the results diskette.                    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
R01.ITLMSG.D01:
if stream(os2drv':\pcmlogs\TEMP\R01LOGS\ITLMSG.D01'  ,'c','query size') = '' then signal R01.ITLMSG.D01.MISSING

'grep "ITLMSG Completed successfully" 'os2drv':\pcmlogs\temp\R01LOGS\ITLMSG.D01 > nul'
if rc \= 1 then signal R01.ITLMSG.D01.FAIL

'echo PCM LAN Client1______ITLMSG.D01_________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R01.ITLFTP01.R01

R01.ITLMSG.D01.MISSING:
'echo PCM LAN Client1______ITLMSG.D01_________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLMSG.D01  - logfile is missing.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the DOMAIN Controller run the command       >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLMSG.CMD.  Then UPDATE the results diskette.                    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal R01.ITLFTP01.R01

R01.ITLMSG.D01.FAIL:
'echo PCM LAN Client1______ITLMSG.D01_________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLMSG.D01  - logfile shows fail.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  Check the logfile under \D01LOGS to determine    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, then from the DOMAIN Controller run the command        >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLMSG.CMD.  Then UPDATE the results diskette.                    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
R01.ITLFTP01.R01:
if stream(os2drv':\pcmlogs\TEMP\R01LOGS\ITLFTP01.R01'  ,'c','query size') = '' then signal R01.ITLFTP01.R01.MISSING

'grep "ITLFTP01 Completed successfully" 'os2drv':\pcmlogs\temp\R01LOGS\ITLFTP01.R01 > nul'
if rc \= 1 then signal R01.ITLFTP01.R01.FAIL

'echo PCM LAN Client1______ITLFTP01.R01_______PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R02.ITLLS56.R02

R01.ITLFTP01.R01.MISSING:
'echo PCM LAN Client1______ITLFTP01.R01_______MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLFTP01.R01  logfile is missing.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the CLIENT #1 system, run the command       >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLFTP01.CMD.  Then UPDATE the results diskette.                  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal R02.ITLLS56.R02

R01.ITLFTP01.R01.FAIL:
'echo PCM LAN Client1______ITLFTP01.R01_______FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLFTP01.R01  logfile shows fail.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  Check the logfile under \R01LOGS to determine    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, then from the CLIENT #1 system, run the command        >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLFTP01.CMD.  Then UPDATE the results diskette.                  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
R02.ITLLS56.R02:

'echo . >> 'os2drv':\pcmlogs\temp\testbad'
'echo . >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

if stream(os2drv':\pcmlogs\TEMP\R02LOGS\ITLLS56.R02'  ,'c','query size') = '' then signal R02.ITLLS56.R02.MISSING

'grep "ITLLS56 Completed successfully" 'os2drv':\pcmlogs\temp\R02LOGS\ITLLS56.R02 > nul'
if rc \= 1 then signal R02.ITLLS56.R02.FAIL

'echo PCM LAN Client2______ITLLS56.R02________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R02.ITLLS57.R02

R02.ITLLS56.R02.MISSING:
'echo PCM LAN Client2______ITLLS56.R02________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS56.R02 - logfile is missing.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  The LAN exerciser tests the DOMAIN system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the DOMAIN when under light load,  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and if the CLIENT system can talk with the DOMAIN under light load. >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal R02.ITLLS57.R02

R02.ITLLS56.R02.FAIL:
'echo PCM LAN Client2______ITLLS56.R02________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS56.R02 - logfile shows fail.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  Check the logfile under \R02LOGS to determine >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, and rerun.  The LAN exerciser tests the DOMAIN system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the DOMAIN when under light load,  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and if the CLIENT system can talk with the DOMAIN under light load. >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
R02.ITLLS57.R02:
if stream(os2drv':\pcmlogs\TEMP\R02LOGS\ITLLS57.R02'  ,'c','query size') = '' then signal R02.ITLLS57.R02.MISSING

'grep "ITLLS57 Completed successfully" 'os2drv':\pcmlogs\temp\R02LOGS\ITLLS57.R02 > nul'
if rc \= 1 then signal R02.ITLLS57.R02.FAIL

'echo PCM LAN Client2______ITLLS57.R02________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R02.ITLFTP02.R02

R02.ITLLS57.R02.MISSING:
'echo PCM LAN Client2______ITLLS57.R02________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS57.R02 - logfile is missing.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  The LAN exerciser tests the SERVER system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the SERVER when under light load,  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and if the CLIENT system can talk with the SERVER under light load. >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal R02.ITLFTP02.R02

R02.ITLLS57.R02.FAIL:
'echo PCM LAN Client2______ITLLS57.R02________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLS57.R02 - logfile shows fail.  This test is required and MUST NOT >> 'os2drv':\pcmlogs\temp\testbad'
'echo     be run separately.  Check the logfile under \R02LOGS to determine >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, and rerun.  The LAN exerciser tests the SERVER system and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     MUST be run on 3 systems (S01,R01,R02) at the same time in order  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     to place the correct load on the system to determine if a problem >> 'os2drv':\pcmlogs\temp\testbad'
'echo     exists with the LAN support on the SERVER when under light load,  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and if the CLIENT system can talk with the SERVER under light load. >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
R02.ITLFTP02.R02:
if stream(os2drv':\pcmlogs\TEMP\R02LOGS\ITLFTP02.R02'  ,'c','query size') = '' then signal R02.ITLFTP02.R02.MISSING

'grep "ITLFTP02 Completed successfully" 'os2drv':\pcmlogs\temp\R02LOGS\ITLFTP02.R02 > nul'
if rc \= 1 then signal R02.ITLFTP02.R02.FAIL

'echo PCM LAN Client2______ITLFTP02.R02_______PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal R02.ITLLD.R02

R02.ITLFTP02.R02.MISSING:
'echo PCM LAN Client2______ITLFTP02.R02_______MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLFTP02.R02  logfile is missing.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the CLIENT #2 system, run the command       >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLFTP02.CMD.  Then UPDATE the results diskette.                  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal R02.ITLLD.R02

R02.ITLFTP02.R02.FAIL:
'echo PCM LAN Client2______ITLFTP02.R02_______FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLFTP02.R02  logfile shows fail.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  Check the logfile under \R02LOGS to determine    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the cause, then from the CLIENT #2 system, run the command        >> 'os2drv':\pcmlogs\temp\testbad'
'echo     ITLFTP02.CMD.  Then UPDATE the results diskette.                  >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'

/*-----------------*/
R02.ITLLD.R02:
if stream(os2drv':\pcmlogs\TEMP\R02LOGS\ITLLD.R02'  ,'c','query size') = '' then signal R02.ITLLD.R02.MISSING

'grep "ITLLD Completed successfully" 'os2drv':\pcmlogs\temp\R02LOGS\ITLLD.R02 > nul'
if rc \= 1 then signal R02.ITLLD.R02.FAIL

'echo PCM LAN Client2______ITLLD.R02__________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal CLEANUP

R02.ITLLD.R02.MISSING:
'echo PCM LAN Client2______ITLLD.R02__________MISSING >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLD.R02 --  logfile is missing.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  From the CLIENT #2 system run the command        >> 'os2drv':\pcmlogs\temp\testbad'
'echo     LANRBOOT.CMD which will switch system to LAN Distance, reboot and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run the ITLLD.CMD testcase.  Then UPDATE the results diskette.    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal CLEANUP

R02.ITLLD.R02.FAIL:
'echo PCM LAN Client2______ITLLD.R02__________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo ITLLD.R02 --  logfile shows fail.  This test is required and can be   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run separately.  Check the logfile in \R02LOGS to determine the   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     cause, and then from the CLIENT #2 system run the command         >> 'os2drv':\pcmlogs\temp\testbad'
'echo     LANRBOOT.CMD which will switch system to LAN Distance, reboot and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run the ITLLD.CMD testcase.  Then UPDATE the results diskette.    >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal CLEANUP


CLEANUP:

if stream(os2drv':\pcmlogs\temp\pcmscore.txt'  ,'c','query size') \= '' then do
   'copy 'os2drv':\pcmlogs\temp\pcmscore.txt A:\ > nul'
   'copy 'os2drv':\pcmlogs\temp\pcmscore.txt 'os2drv':\PCMLOGS > nul'
   end


if stream(os2drv':\pcmlogs\temp\testbad'  ,'c','query size') \= '' then do
   'copy 'os2drv':\pcmlogs\temp\testbad A:\ > nul'
   end

'zap 'os2drv':\PCMLOGS\TEMP > nul'
exit

INFO_PLEASE:
say 'ͻ'
say ' ACLIRSLT.CMD - Analyzes testkit results diskette and logfiles '
say '                for PASS-FAIL-MISSING and updates PCMSCORE.TXT '
say '                                                               '
say ' Parameters: NONE                                              '
say '                                                               '
say ' REQUIRES DISKETTE IN DRIVE A: PREPARED WITH PCLIRSLT.CMD      '
say '                                                               '
say ' Called by PCMRSLTS.EXE after running PCLIRSLT.CMD             '
say 'ͼ'
exit
