#include <stdio.h>
#include "mem.h"

int main (int argc, char *argv[]) {
	unsigned long size, size1;
	static struct {
		unsigned long cont;
		unsigned long base;
		unsigned long base1;
		unsigned long len;
		unsigned long len1;
		unsigned long type;
	} desc;
	static struct {
		unsigned short size;
		unsigned long local, local16;
		unsigned long system, system16;
		unsigned long cacheable, cacheable16;
		unsigned long nonsys, nonsys16;
		unsigned short x1, x2;
		unsigned long res;
	} desc1;

	size = Int12();
	printf ("Int12        returns: %ld KBytes\n", size);
	size = Int1588();
	if (size == -1)
		printf ("Int15 (88)   returns: not supported\n");
	else
		printf ("Int15 (88)   returns: %ld KBytes above 1M\n", size);
	size = Int158A();
	if (size == -1)
		printf ("Int15 (8A)   returns: not supported\n");
	else
		printf ("Int15 (8A)   returns: %ld KBytes above 1M\n", size);
	size = Int15C7 (&desc1);
	desc1.local     += desc1.local16;
	desc1.system    += desc1.system16;
	desc1.cacheable += desc1.cacheable16;
	desc1.nonsys    += desc1.nonsys16;
	if (size == -1)
		printf ("Int15 (C7)   returns: not supported\n");
	else {
		printf ("Int15 (C7)   returns memory table:\n");
		printf ("  local  memory: %ld KBytes above 1M\n", desc1.local);
		printf ("  system memory: %ld KBytes above 1M\n", desc1.system);
		printf ("  cacheable mem: %ld KBytes above 1M\n", desc1.cacheable);
		printf ("  address space: %ld KBytes above 1M before non-system memory\n", desc1.nonsys);
	}
	size = Int15DA88();
	if (size == -1)
		printf ("Int15 (DA88) returns: not supported\n");
	else
		printf ("Int15 (DA88) returns: %ld KBytes above 1M\n", size);
	size = Int15E801(0);
	size1= Int15E801(1);
	if (size == -1)
		printf ("Int15 (E801) returns: not supported\n");
	else
		printf ("Int15 (E801) returns: %ld KBytes above 1M available\n                      %ld KBytes above 1M configured\n", size, size1);
	printf ("Int15 (E820) returns memory list:\n");
	desc.cont = 0;
	do {
		Int15E820 (&desc);
		if (desc.type == 1)
			printf ("  %8lu KBytes @ %lu K\n", desc.len >> 10, desc.base >> 10);
	} while (desc.cont != 0);
	size = Int15E881();
	if (size == -1)
		printf ("Int15 (E881) returns: not supported\n");
	else
		printf ("Int15 (E881) returns: %ld KBytes above 1M\n", size);

	return (0);
}