/* $Id: wing32.cpp,v 1.2 2000/08/02 15:51:35 bird Exp $ */
#include <memory.h>
#include <wingdi.h>
#include <winuser.h>
#include "wing32impl.h"
#pragma pack(1)

RGBTRIPLE RGBTable[] = {
                        {0x00,0x00,0x00},
                        {0x80,0x00,0x00},
                        {0x00,0x80,0x00},
                        {0x80,0x80,0x00},
                        {0x00,0x00,0x80},
                        {0x80,0x00,0x80},
                        {0x00,0x80,0x80},
                        {0xC0,0xC0,0xC0},
                        {0xC0,0xDC,0xC0},
                        {0xA6,0xCA,0xF0},
                        {0x04,0x04,0x04},
                        {0x08,0x08,0x08},
                        {0x0C,0x0C,0x0C},
                        {0x11,0x11,0x11},
                        {0x16,0x16,0x16},
                        {0x1C,0x1C,0x1C},
                        {0x22,0x22,0x22},
                        {0x29,0x29,0x29},
                        {0x55,0x55,0x55},
                        {0x4D,0x4D,0x4D},
                        {0x42,0x42,0x42},
                        {0x39,0x39,0x39},
                        {0x81,0x81,0x81},
                        {0x81,0x00,0x00},
                        {0x00,0x81,0x00},
                        {0x81,0x81,0x00},
                        {0x00,0x00,0x81},
                        {0x81,0x00,0x81},
                        {0x00,0x81,0x81},
                        {0x33,0x00,0x00},
                        {0x66,0x00,0x00},
                        {0x99,0x00,0x00},
                        {0xCC,0x00,0x00},
                        {0x00,0x33,0x00},
                        {0x33,0x33,0x00},
                        {0x66,0x33,0x00},
                        {0x99,0x33,0x00},
                        {0xCC,0x33,0x00},
                        {0xFF,0x33,0x00},
                        {0x00,0x66,0x00},
                        {0x33,0x66,0x00},
                        {0x66,0x66,0x00},
                        {0x99,0x66,0x00},
                        {0xCC,0x66,0x00},
                        {0xFF,0x66,0x00},
                        {0x00,0x99,0x00},
                        {0x33,0x99,0x00},
                        {0x66,0x99,0x00},
                        {0x99,0x99,0x00},
                        {0xCC,0x99,0x00},
                        {0xFF,0x99,0x00},
                        {0x00,0xCC,0x00},
                        {0x33,0xCC,0x00},
                        {0x66,0xCC,0x00},
                        {0x99,0xCC,0x00},
                        {0xCC,0xCC,0x00},
                        {0xFF,0xCC,0x00},
                        {0x66,0xFF,0x00},
                        {0x99,0xFF,0x00},
                        {0xCC,0xFF,0x00},
                        {0x00,0x00,0x33},
                        {0x33,0x00,0x33},
                        {0x66,0x00,0x33},
                        {0x99,0x00,0x33},
                        {0xCC,0x00,0x33},
                        {0xFF,0x00,0x33},
                        {0x00,0x33,0x33},
                        {0x33,0x33,0x33},
                        {0x66,0x33,0x33},
                        {0x99,0x33,0x33},
                        {0xCC,0x33,0x33},
                        {0xFF,0x33,0x33},
                        {0x00,0x66,0x33},
                        {0x33,0x66,0x33},
                        {0x66,0x66,0x33},
                        {0x99,0x66,0x33},
                        {0xCC,0x66,0x33},
                        {0xFF,0x66,0x33},
                        {0x00,0x99,0x33},
                        {0x33,0x99,0x33},
                        {0x66,0x99,0x33},
                        {0x99,0x99,0x33},
                        {0xCC,0x99,0x33},
                        {0xFF,0x99,0x33},
                        {0x00,0xCC,0x33},
                        {0x33,0xCC,0x33},
                        {0x66,0xCC,0x33},
                        {0x99,0xCC,0x33},
                        {0xCC,0xCC,0x33},
                        {0xFF,0xCC,0x33},
                        {0x33,0xFF,0x33},
                        {0x66,0xFF,0x33},
                        {0x99,0xFF,0x33},
                        {0xCC,0xFF,0x33},
                        {0xFF,0xFF,0x33},
                        {0x00,0x00,0x66},
                        {0x33,0x00,0x66},
                        {0x66,0x00,0x66},
                        {0x99,0x00,0x66},
                        {0xCC,0x00,0x66},
                        {0xFF,0x00,0x66},
                        {0x00,0x33,0x66},
                        {0x33,0x33,0x66},
                        {0x66,0x33,0x66},
                        {0x99,0x33,0x66},
                        {0xCC,0x33,0x66},
                        {0xFF,0x33,0x66},
                        {0x00,0x66,0x66},
                        {0x33,0x66,0x66},
                        {0x66,0x66,0x66},
                        {0x99,0x66,0x66},
                        {0xCC,0x66,0x66},
                        {0x00,0x99,0x66},
                        {0x33,0x99,0x66},
                        {0x66,0x99,0x66},
                        {0x99,0x99,0x66},
                        {0xCC,0x99,0x66},
                        {0xFF,0x99,0x66},
                        {0x00,0xCC,0x66},
                        {0x33,0xCC,0x66},
                        {0x99,0xCC,0x66},
                        {0xCC,0xCC,0x66},
                        {0xFF,0xCC,0x66},
                        {0x00,0xFF,0x66},
                        {0x33,0xFF,0x66},
                        {0x99,0xFF,0x66},
                        {0xCC,0xFF,0x66},
                        {0xFF,0x00,0xCC},
                        {0xCC,0x00,0xFF},
                        {0x00,0x99,0x99},
                        {0x99,0x33,0x99},
                        {0x99,0x00,0x99},
                        {0xCC,0x00,0x99},
                        {0x00,0x00,0x99},
                        {0x33,0x33,0x99},
                        {0x66,0x00,0x99},
                        {0xCC,0x33,0x99},
                        {0xFF,0x00,0x99},
                        {0x00,0x66,0x99},
                        {0x33,0x33,0x99},
                        {0x33,0x66,0x99},
                        {0x66,0x33,0x99},
                        {0x99,0x33,0x99},
                        {0xCC,0x66,0x99},
                        {0xFF,0x33,0x99},
                        {0x33,0x99,0x99},
                        {0x66,0x99,0x99},
                        {0x99,0x99,0x99},
                        {0xCC,0x99,0x99},
                        {0xFF,0x99,0x99},
                        {0x00,0xCC,0x99},
                        {0x33,0xCC,0x99},
                        {0x66,0xCC,0x66},
                        {0x99,0xCC,0x99},
                        {0xCC,0xCC,0x99},
                        {0xFF,0xCC,0x99},
                        {0x00,0xFF,0x99},
                        {0x33,0xFF,0x99},
                        {0x66,0xCC,0x99},
                        {0x99,0xFF,0x99},
                        {0xCC,0xFF,0x99},
                        {0xFF,0xFF,0x99},
                        {0x00,0x00,0xCC},
                        {0x33,0x00,0x99},
                        {0x66,0x00,0xCC},
                        {0x99,0x00,0xCC},
                        {0xCC,0x00,0xCC},
                        {0x00,0x33,0x99},
                        {0x33,0x33,0xCC},
                        {0x66,0x33,0xCC},
                        {0x99,0x33,0xCC},
                        {0xCC,0x33,0xCC},
                        {0xFF,0x33,0xCC},
                        {0x00,0x66,0xCC},
                        {0x33,0x66,0xCC},
                        {0x66,0x66,0x99},
                        {0x99,0x66,0xCC},
                        {0xCC,0x66,0xCC},
                        {0xFF,0x66,0x99},
                        {0x00,0x99,0xCC},
                        {0x33,0x99,0xCC},
                        {0x66,0x99,0xCC},
                        {0x99,0x99,0xCC},
                        {0xCC,0x99,0xCC},
                        {0xFF,0x99,0xCC},
                        {0x00,0xCC,0xCC},
                        {0x33,0xCC,0xCC},
                        {0x66,0xCC,0xCC},
                        {0x99,0xCC,0xCC},
                        {0xCC,0xCC,0xCC},
                        {0xFF,0xCC,0xCC},
                        {0x00,0xFF,0xCC},
                        {0x33,0xFF,0xCC},
                        {0x66,0xFF,0x99},
                        {0x99,0xFF,0xCC},
                        {0xCC,0xFF,0xCC},
                        {0xFF,0xFF,0xCC},
                        {0x33,0x00,0xCC},
                        {0x66,0x00,0xFF},
                        {0x99,0x00,0xFF},
                        {0x00,0x33,0xCC},
                        {0x33,0x33,0xFF},
                        {0x66,0x33,0xFF},
                        {0x99,0x33,0xFF},
                        {0xCC,0x33,0xFF},
                        {0xFF,0x33,0xFF},
                        {0x00,0x66,0xFF},
                        {0x33,0x66,0xFF},
                        {0x66,0x66,0xCC},
                        {0x99,0x66,0xFF},
                        {0xCC,0x66,0xFF},
                        {0xFF,0x66,0xCC},
                        {0x00,0x99,0xFF},
                        {0x33,0x99,0xFF},
                        {0x66,0x99,0xFF},
                        {0x99,0x99,0xFF},
                        {0xCC,0x99,0xFF},
                        {0xFF,0x99,0xFF},
                        {0x00,0xCC,0xFF},
                        {0x33,0xCC,0xFF},
                        {0x66,0xCC,0xFF},
                        {0x99,0xCC,0xFF},
                        {0xCC,0xCC,0xFF},
                        {0xFF,0xCC,0xFF},
                        {0x33,0xFF,0xFF},
                        {0x66,0xFF,0xCC},
                        {0x99,0xFF,0xFF},
                        {0xCC,0xFF,0xFF},
                        {0xFF,0x66,0x66},
                        {0x66,0xFF,0x66},
                        {0xFF,0xFF,0x66},
                        {0x66,0x66,0xFF},
                        {0xFF,0x66,0xFF},
                        {0x66,0xFF,0xFF},
                        {0xC1,0xC1,0xC1},
                        {0x5F,0x5F,0x5F},
                        {0x77,0x77,0x77},
                        {0x86,0x86,0x86},
                        {0x96,0x96,0x96},
                        {0xCB,0xCB,0xCB},
                        {0xB2,0xB2,0xB2},
                        {0xD7,0xD7,0xD7},
                        {0xDD,0xDD,0xDD},
                        {0xE3,0xE3,0xE3},
                        {0xEA,0xEA,0xEA},
                        {0xF1,0xF1,0xF1},
                        {0xF8,0xF8,0xF8},
                        {0xFF,0xFB,0xF0},
                        {0xA0,0xA0,0xA4},
                        {0x80,0x80,0x80},
                        {0xFF,0x00,0x00},
                        {0x00,0xFF,0x00},
                        {0xFF,0xFF,0x00},
                        {0x00,0x00,0xFF},
                        {0xFF,0x00,0xFF},
                        {0x00,0xFF,0xFF},
                        {0xFF,0xFF,0xFF}
                       };

BYTE bLookupTable1[216] = { 0x00, 0x1D, 0x1E, 0x1F, 0x20, 0xF9, 0x21, 0x22,
                            0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A,
                            0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32,
                            0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0xFA, 0xFA,
                            0x39, 0x3A, 0x3B, 0xFB, 0x3C, 0x3D, 0x3E, 0x3F,
                            0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
                            0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
                            0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
                            0x58, 0x59, 0xFA, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E,
                            0x5F, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66,
                            0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E,
                            0x6F, 0xE3, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75,
                            0x76, 0x77, 0x97, 0x78, 0x79, 0x7A, 0x7B, 0x7C,
                            0xE4, 0x7D, 0x7E, 0xE5, 0x85, 0xA2, 0x87,
                            0x83, 0x84, 0x89, 0xA6, 0x86, 0x8C, 0x82, 0x88,
                            0x8F, 0x8A, 0x8B, 0xAE, 0x8D, 0x8E, 0xB1, 0x81,
                            0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x9D,
                            0x98, 0x99, 0x9A, 0x9B, 0x9C, 0xC0, 0x9E, 0x9F,
                            0xA0, 0xA1, 0xC4, 0xA3, 0xA4, 0xA5, 0x7F,
                            0xC7, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC,
                            0xAD, 0xCF, 0xAF, 0xB0, 0xD2, 0xB2, 0xB3,
                            0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA,
                            0xBB, 0xBC, 0xBD, 0xBE, 0xBF, 0xE0, 0xC1,
                            0xC2, 0xC3, 0xFC, 0xFC, 0xC5, 0xC6, 0x80,
                            0xFD, 0xFC, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC,
                            0xCD, 0xCE, 0xE6, 0xD0, 0xD1, 0xE7, 0xD3,
                            0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA,
                            0xDB, 0xDC, 0xDD, 0xDE, 0xFE, 0xDF, 0xE8,
                            0xE1, 0xE2, 0xFF
                          };

BYTE bLookupTable2[512] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                            0x00, 0x00,
                            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
                            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
                            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
                            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
                            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
                            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
                            0x01, 0x01, 0x01,
                            0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
                            0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
                            0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
                            0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
                            0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
                            0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
                            0x02, 0x02, 0x02,
                            0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
                            0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
                            0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
                            0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
                            0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
                            0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
                            0x03, 0x03, 0x03,
                            0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
                            0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
                            0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
                            0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
                            0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
                            0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
                            0x04, 0x04, 0x04,
                            0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
                            0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
                            0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
                            0x05, 0x05,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00,
                            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
                            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
                            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
                            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
                            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
                            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
                            0x01, 0x01, 0x01,
                            0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
                            0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
                            0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
                            0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
                            0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
                            0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
                            0x02, 0x02, 0x02,
                            0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
                            0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
                            0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
                            0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
                            0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
                            0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
                            0x03, 0x03, 0x03,
                            0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
                            0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
                            0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
                            0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
                            0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
                            0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
                            0x04, 0x04, 0x04,
                            0x05
                          };

BYTE bLookupTable3[256] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                            0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
                            0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
                            0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
                            0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
                            0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
                            0x30, 0x31, 0x32,
                            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                            0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
                            0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
                            0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
                            0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
                            0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
                            0x30, 0x31, 0x32,
                            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                            0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
                            0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
                            0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
                            0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
                            0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
                            0x30, 0x31, 0x32,
                            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                            0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
                            0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
                            0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
                            0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
                            0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
                            0x30, 0x31, 0x32,
                            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                            0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
                            0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
                            0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
                            0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
                            0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
                            0x30, 0x31, 0x32,
                            0x00

                          };


BYTE bLookupTable4[8] = { 0x00, 0x06, 0x0C, 0x12, 0x18, 0x1E, 0x00, 0x00
                        };

BYTE bLookupTable5[112] = { 0x00, 0x24, 0x48, 0x6C, 0x90, 0xB4, 0x00, 0x00,
                            0x00, 0x26, 0x09, 0x2F, 0x02, 0x28, 0x0B, 0x32,
                            0x19, 0x0C, 0x23, 0x16, 0x1B, 0x0F, 0x25, 0x18,
                            0x06, 0x2C, 0x03, 0x29, 0x08, 0x2F, 0x05, 0x2B,
                            0x1F, 0x13, 0x1C, 0x0F, 0x22, 0x15, 0x1F, 0x12,
                            0x01, 0x27, 0x0B, 0x31, 0x00, 0x27, 0x0A, 0x30,
                            0x1B, 0x0E, 0x24, 0x17, 0x1A, 0x0D, 0x23, 0x17,
                            0x07, 0x2E, 0x04, 0x2B, 0x07, 0x2D, 0x03, 0x2A,
                            0x21, 0x14, 0x1E, 0x11, 0x20, 0x13, 0x1D, 0x10,
                            0x00, 0x19, 0x06, 0x1F, 0x26, 0x0C, 0x2C, 0x13,
                            0x09, 0x23, 0x03, 0x1C, 0x2F, 0x16, 0x29, 0x0F,
                            0x29, 0x03, 0x09, 0x1C, 0x23, 0x0F, 0x16, 0x2F,
                            0x06, 0x19, 0x26, 0x00, 0x13, 0x2C, 0x1F, 0x0C,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                          };

BYTE bLookupTable6[64] = {  0x00, 0x00, 0x0A, 0x04, 0x0B, 0x08, 0x0C, 0x0C,
                            0x0D, 0x11, 0x0E, 0x16, 0x0F, 0x1C, 0x10, 0x22,
                            0x11, 0x29, 0x43, 0x33, 0x15, 0x39, 0x14, 0x42,
                            0x13, 0x4D, 0x12, 0x55, 0xEA, 0x5F, 0x6D, 0x66,
                            0xEB, 0x77, 0x16, 0x80, 0xEC, 0x86, 0xED, 0x96,
                            0x92, 0x99, 0xEF, 0xB2, 0xE9, 0xC0, 0xEE, 0xCB,
                            0xBC, 0xCC, 0xF0, 0xD7, 0xF1, 0xDD, 0xF2, 0xE3,
                            0xF3, 0xEA, 0xF4, 0xF1, 0xF5, 0xF8, 0xFF, 0xFF
                          };

#pragma pack()

#pragma pack(2)

struct
{
    WORD           palVersion;
    WORD           palNumEntries;
    PALETTEENTRY   palPalEntry[256];
} HalfTonePal;

#pragma pack()

BYTE DitherBmp8x8[64];
HBITMAP hbmpPattern;
DWORD dwTotalPixels;
DWORD dwCapsRaster;

struct {
  BITMAPINFOHEADER bmiHeader;
  RGBQUAD bmiColors[256];
} bmiPattern;


HDC WINAPI WinGCreateDC()
{
  return CreateCompatibleDC(NULL);
}

BOOL WINAPI WinGRecommendDIBFormat(BITMAPINFO *bmpi)
{
  memset( bmpi, 0, sizeof(BITMAPINFO) );
  bmpi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
  bmpi->bmiHeader.biWidth = 1;
  bmpi->bmiHeader.biHeight = 1;
  bmpi->bmiHeader.biPlanes = 1;
  bmpi->bmiHeader.biBitCount = 8;

  return TRUE;
}

HBITMAP WINAPI WinGCreateBitmap( HDC hdc,
                  BITMAPINFO *bmpi,
                  LPVOID *bits)
{
  return CreateDIBSection( hdc, bmpi, 0, bits, 0, 0);
}

LPVOID WINAPI WinGGetDIBPointer(HBITMAP hWinGBitmap, BITMAPINFO* bmpi)
{
  DIBSECTION dibSect ;
  DWORD rc;
  rc = GetObjectA( hWinGBitmap,
                  sizeof(DIBSECTION),
                  &dibSect);
  if(0==rc)
  {
    memcpy( bmpi,
            &dibSect.dsBmih,
            sizeof(BITMAPINFOHEADER));
    if( bmpi->bmiHeader.biCompression == BI_RGB)
    {
       // Copy 3 RGB values
       memcpy( bmpi->bmiColors,
               &dibSect.dsBitfields,
               sizeof(*dibSect.dsBitfields));
    }
  }

  return dibSect.dsBm.bmBits;
}

UINT WINAPI WinGGetDIBColorTable(HDC hdc, UINT start, UINT num, RGBQUAD *colors)
{
  return GetDIBColorTable(hdc,start,num,colors);
}

UINT WINAPI WinGSetDIBColorTable(HDC hdc, UINT start, UINT num, RGBQUAD *colors)
{
  return SetDIBColorTable(hdc,start,num,colors);
}

BOOL WINAPI WinGBitBlt( HDC destDC, UINT xDest, UINT yDest,
                 UINT widDest, UINT heiDest, HDC srcDC,
                 UINT xSrc, UINT ySrc)
{
  return BitBlt( destDC,
                 xDest,
                 yDest,
                 widDest,
                 heiDest,
                 srcDC,
                 xSrc,
                 ySrc,
                 SRCCOPY);
}

BOOL WINAPI WinGStretchBlt( HDC destDC, UINT xDest, UINT yDest,
                     UINT widDest, UINT heiDest,
                     HDC srcDC, UINT xSrc, UINT ySrc,
                     UINT widSrc, UINT heiSrc)
{
  INT iOldMode;
  BOOL fRC;
  iOldMode = SetStretchBltMode( destDC, COLORONCOLOR);
  fRC= StretchBlt( destDC,
                   xDest,
                   yDest,
                   widDest,
                   heiDest,
                   srcDC,
                   xSrc,
                   ySrc,
                   widSrc,
                   heiSrc,
                   SRCCOPY);
  SetStretchBltMode(destDC,iOldMode);
  return fRC;
}

// Todo  check this and move to right include etc..
#define WING_DITHER_TYPE DWORD

HBRUSH WINAPI WinGCreateHalftoneBrush( HDC winDC,
                                       COLORREF col,
                                       WING_DITHER_TYPE type)
{
  DWORD Idx;
  BYTE bI;

  if(NULL==winDC)
    return NULL;

  if(type>2)
    return NULL;

  if(!(0x01000000 & col)) // Color is PALETTEINDEX
  {
    Idx = (col & 0xFF) *3;
    return CreateSolidBrush( PALETTERGB( RGBTable[Idx].rgbtRed, RGBTable[Idx].rgbtGreen, RGBTable[Idx].rgbtBlue));
  }
  else
  {
    if( ( (col&0xFF) == ((col>>8)&0xFF) ) && ( (col&0xFF) == ((col>>16)&0xFF) ) )
    {
       // All colors equal find index
       Idx = ((((col &0xFF)<<5)-(col&0xFF))/0xFF)&0xFF;
       if(bLookupTable6[Idx*2+1] <= (BYTE)((col>>8)& 0xFF))
         do
         {
           Idx--;
         }
         while(bLookupTable6[Idx*2+1] > (BYTE)((col>>8)& 0xFF));

       while(Idx<31)
       {
         if(bLookupTable6[Idx*2+2] >=(BYTE)(col& 0xFF))
          break;
         Idx++;
       }

       if(Idx!=31)
       {
         if(bLookupTable6[Idx*2] !=(BYTE)((col>>16)& 0xFF))
         {
         }
         if(col & 0x02000000)
         {
         }
       }
       else
       {
         bI = bLookupTable6[Idx*2];
         col = PALETTERGB(RGBTable[bI].rgbtRed, RGBTable[bI].rgbtGreen, RGBTable[bI].rgbtBlue);
       }
       return CreateSolidBrush(col);
    }
    else
    {
      DWORD dwHlp;

      if(col & 0x02000000) // PaletteRGB ?
      {
        Idx = col&0xFF;
        if( (0!=bLookupTable3[col&0xFF]) ||
            (0!=bLookupTable3[(col>>16)&0xFF]) ||
            (0!=bLookupTable3[(col>>8)&0xFF]) )
        {

          switch(type)
          {
            case 0:
              SetupDitherBit2(col, (BYTE*)&DitherBmp8x8, &bLookupTable5[0x48]);
              break;
            case 1:
              SetupDitherBit1(col, (BYTE*)&DitherBmp8x8);
              break;
            case 2:
              SetupDitherBit2(col, (BYTE*)&DitherBmp8x8, &bLookupTable5[0x58]);
              break;
          }
          return CreatePatternHTBrush( winDC,(BYTE*) &DitherBmp8x8);
        }
      }

      bI = bLookupTable2[(col>>16)&0xFF];
      dwHlp = bLookupTable4[bI];
      bI = bLookupTable2[col&0xFF];
      dwHlp += bLookupTable4[bI];
      bI = bLookupTable2[(col>>8)&0xFF];
      Idx = bLookupTable1[dwHlp+bI];

      return CreateSolidBrush(PALETTERGB(RGBTable[Idx].rgbtRed, RGBTable[Idx].rgbtGreen, RGBTable[Idx].rgbtBlue));
    }
  }
}

void SetupDitherBit1(COLORREF col, BYTE *pBits)
{
  BYTE b1,b2,b3,b4,
       b5,b6,b7,b8,
       b9,bA,bB,bC,
       bD,bE;
  BYTE *ptr;

  b5 = bLookupTable2[256+(col&0xFF)];
  b6 = bLookupTable3[col&0xFF];
  b3 = bLookupTable2[256+((col>>8)&0xFF)];
  b4 = bLookupTable3[(col>>8)&0xFF];
  b2 = bLookupTable2[256+((col>>16)&0xFF)];
  b1 = bLookupTable3[(col>>16)&0xFF];

  ptr = &bLookupTable5[8];
  for(int i=0;i<8;i++)
  {
    bE = ptr[0]>b6?b5+1:b5;
    pBits[0] = bLookupTable1[bLookupTable4[((ptr[0]>b4)?b3+1:b3)&0xFF]+bLookupTable5[((ptr[0]<b2)?b1+1:b1)&0xFF]+bE];

    bD = ptr[1]>b6?b5+1:b5;
    pBits[1] = bLookupTable1[bLookupTable4[((ptr[1]>b4)?b3+1:b3)&0xFF]+bLookupTable5[((ptr[1]<b2)?b1+1:b1)&0xFF]+bD];

    bC = ptr[2]>b6?b5+1:b5;
    pBits[2] = bLookupTable1[bLookupTable4[((ptr[2]>b4)?b3+1:b3)&0xFF]+bLookupTable5[((ptr[2]<b2)?b1+1:b1)&0xFF]+bC];

    bB = ptr[3]>b6?b5+1:b5;
    pBits[3] = bLookupTable1[bLookupTable4[((ptr[3]>b4)?b3+1:b3)&0xFF]+bLookupTable5[((ptr[3]<b2)?b1+1:b1)&0xFF]+bB];

    bA = ptr[4]>b6?b5+1:b5;
    pBits[4] = bLookupTable1[bLookupTable4[((ptr[4]>b4)?b3+1:b3)&0xFF]+bLookupTable5[((ptr[4]<b2)?b1+1:b1)&0xFF]+bA];

    b9 = ptr[5]>b6?b5+1:b5;
    pBits[5] = bLookupTable1[bLookupTable4[((ptr[5]>b4)?b3+1:b3)&0xFF]+bLookupTable5[((ptr[5]<b2)?b1+1:b1)&0xFF]+b9];

    b8 = ptr[6]>b6?b5+1:b5;
    pBits[6] = bLookupTable1[bLookupTable4[((ptr[6]>b4)?b3+1:b3)&0xFF]+bLookupTable5[((ptr[6]<b2)?b1+1:b1)&0xFF]+b8];

    b7 = ptr[7]>b6?b5+1:b5;
    pBits[7] = bLookupTable1[bLookupTable4[((ptr[7]>b4)?b3+1:b3)&0xFF]+bLookupTable5[((ptr[7]<b2)?b1+1:b1)&0xFF]+b7];

    pBits+=8;
    ptr+=8;
  }
}

void SetupDitherBit2(COLORREF col, BYTE *pBits, BYTE *ptr)
{
  BYTE b1,b2,b3,b4,
       b5,b6,b7,b8,
       b9,bA;

  b5 = bLookupTable2[256+(col&0xFF)];
  b6 = bLookupTable3[col&0xFF];
  b3 = bLookupTable2[256+((col>>8)&0xFF)];
  b4 = bLookupTable3[(col>>8)&0xFF];
  b2 = bLookupTable2[256+((col>>16)&0xFF)];
  b1 = bLookupTable3[(col>>16)&0xFF];

  for(int i=0;i<4;i++)
  {
    bA = ptr[0]<b6?b5+1:b5;
    pBits[0] = bLookupTable1[ bLookupTable4[((ptr[0]>b4)?b3+1:b3)&0xFF]+bLookupTable5[((ptr[0]>b2)?b1+1:b1)&0xFF]+bA];
    pBits[4] = pBits[0];
    pBits[32] = pBits[0];
    pBits[36] = pBits[0];

    b9 = ptr[1]<b6?b5+1:b5;
    pBits[1] = bLookupTable1[ bLookupTable4[((ptr[1]>b4)?b3+1:b3)&0xFF]+bLookupTable5[((ptr[1]>b2)?b1+1:b1)&0xFF]+b9];
    pBits[5] = pBits[1];
    pBits[33] = pBits[1];
    pBits[37] = pBits[1];

    b8 = ptr[2]<b6?b5+1:b5;
    pBits[2] = bLookupTable1[ bLookupTable4[((ptr[2]>b4)?b3+1:b3)&0xFF]+bLookupTable5[((ptr[2]>b2)?b1+1:b1)&0xFF]+b8];
    pBits[6] = pBits[2];
    pBits[34] = pBits[2];
    pBits[38] = pBits[2];

    b7 = ptr[3]<b6?b5+1:b5;
    pBits[3] = bLookupTable1[ bLookupTable4[((ptr[3]>b4)?b3+1:b3)&0xFF]+bLookupTable5[((ptr[3]>b2)?b1+1:b1)&0xFF]+b7];
    pBits[7] = pBits[3];
    pBits[35] = pBits[3];
    pBits[39] = pBits[3];

    pBits+=8;

    ptr+=4;
  }
}

DWORD InitWing32()
{
  HDC hdc;

  hdc = GetDC(NULL);

  if(NULL==hdc)
    return 0;

  dwTotalPixels = GetDeviceCaps(hdc, BITSPIXEL) * GetDeviceCaps(hdc, PLANES);
  dwCapsRaster  = GetDeviceCaps(hdc, RASTERCAPS);
  hbmpPattern   = CreateCompatibleBitmap(hdc,8,8);

  ReleaseDC(0, hdc);

  return 1;
}


HBRUSH CreatePatternHTBrush(HDC hdc, BYTE *pBits)
{
  if( 0==bmiPattern.bmiHeader.biSize)
  {
    bmiPattern.bmiHeader.biSize     = sizeof(BITMAPINFOHEADER);
    bmiPattern.bmiHeader.biWidth    = 8;
    bmiPattern.bmiHeader.biHeight   = 8;
    bmiPattern.bmiHeader.biPlanes   = 1;
    bmiPattern.bmiHeader.biBitCount = 8;

    for(int i=0;i <256;i++)
    {
      bmiPattern.bmiColors[i].rgbRed   = RGBTable[i].rgbtRed;
      bmiPattern.bmiColors[i].rgbGreen = RGBTable[i].rgbtGreen;
      bmiPattern.bmiColors[i].rgbBlue  = RGBTable[i].rgbtBlue;
      bmiPattern.bmiColors[i].rgbReserved = 0;
    }
  }
  if( (8==dwTotalPixels) &&
      (RC_PALETTE & dwCapsRaster))
  {
    SetBitmapBits( hbmpPattern, 64, &DitherBmp8x8);
  }
  else
  {
    SetDIBits( hdc,
               hbmpPattern,
               0,
               8,
               pBits,
               (LPBITMAPINFO)&bmiPattern,
               0);
  }
  return CreatePatternBrush(hbmpPattern);
}


HPALETTE WINAPI WinGCreateHalftonePalette()
{
  if(HalfTonePal.palVersion!=0)
  {
    return CreatePalette((PLOGPALETTE)&HalfTonePal);
  }
  else
  {
    HDC hdc;
    HPALETTE hPal;
    int iRasterCaps,
        iSizePal,
        iNumResCol,
        iPalEntry,
        iRGBIndex;

    hdc = GetDC(0);

    if(NULL==hdc)
      return NULL;

    HalfTonePal.palVersion    = 0x0300;
    HalfTonePal.palNumEntries = 0x0100;

    iRasterCaps = GetDeviceCaps(hdc, RASTERCAPS);
    if((RC_PALETTE & iRasterCaps))
    {
      // Mode has a paette
      iSizePal = GetDeviceCaps(hdc, SIZEPALETTE);
      iNumResCol = GetDeviceCaps(hdc, NUMRESERVED);
      if(iNumResCol<iSizePal)
      {
        GetSystemPaletteEntries( hdc,
                                 0,
                                 iNumResCol/2,
                                 (LPPALETTEENTRY)&HalfTonePal.palPalEntry);
        GetSystemPaletteEntries( hdc,
                                 iSizePal-(iNumResCol/2),
                                 (iNumResCol/2),
                                 (LPPALETTEENTRY)&HalfTonePal.palPalEntry[256-iNumResCol/2]);
        iRGBIndex = 10;
        iPalEntry = iNumResCol/2;
        while(&HalfTonePal.palPalEntry[iPalEntry] != &HalfTonePal.palPalEntry[256-iNumResCol/2])
        {
          HalfTonePal.palPalEntry[iPalEntry].peBlue  = RGBTable[iRGBIndex].rgbtBlue;
          HalfTonePal.palPalEntry[iPalEntry].peGreen = RGBTable[iRGBIndex].rgbtGreen;
          HalfTonePal.palPalEntry[iPalEntry].peRed   = RGBTable[iRGBIndex].rgbtRed;
        }
      }
    }
    else
    {
      // Hi/TrueColor Mode
      for(iPalEntry=0;iPalEntry<256;iPalEntry++)
      {
        HalfTonePal.palPalEntry[iPalEntry].peBlue  = RGBTable[iPalEntry].rgbtBlue;
        HalfTonePal.palPalEntry[iPalEntry].peGreen = RGBTable[iPalEntry].rgbtGreen;
        HalfTonePal.palPalEntry[iPalEntry].peRed   = RGBTable[iPalEntry].rgbtRed;
      }
    }

    hPal = CreatePalette((PLOGPALETTE)&HalfTonePal);
    ReleaseDC(0,hdc);
    return hPal;
  }
}
