/*
** THIS SOFTWARE IS SUBJECT TO COPYRIGHT PROTECTION AND IS OFFERED ONLY
** PURSUANT TO THE 3DFX GLIDE GENERAL PUBLIC LICENSE. THERE IS NO RIGHT
** TO USE THE GLIDE TRADEMARK WITHOUT PRIOR WRITTEN PERMISSION OF 3DFX
** INTERACTIVE, INC. A COPY OF THIS LICENSE MAY BE OBTAINED FROM THE 
** DISTRIBUTOR OR BY CONTACTING 3DFX INTERACTIVE INC(info@3dfx.com). 
** THIS PROGRAM IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
** EXPRESSED OR IMPLIED. SEE THE 3DFX GLIDE GENERAL PUBLIC LICENSE FOR A
** FULL TEXT OF THE NON-WARRANTY PROVISIONS.  
** 
** USE, DUPLICATION OR DISCLOSURE BY THE GOVERNMENT IS SUBJECT TO
** RESTRICTIONS AS SET FORTH IN SUBDIVISION (C)(1)(II) OF THE RIGHTS IN
** TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013,
** AND/OR IN SIMILAR OR SUCCESSOR CLAUSES IN THE FAR, DOD OR NASA FAR
** SUPPLEMENT. UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS OF
** THE UNITED STATES.  
** 
** COPYRIGHT 3DFX INTERACTIVE, INC. 1999, ALL RIGHTS RESERVED
**
**
** $Revision: 1.1 $ 
** $Date: 2000/02/25 00:31:31 $ 
**
*/
#ifndef __INITAT3D_H__
#define __INITAT3D_H__

#define AT3D_IN_VSYNC (_inp(INPUT_STATUS_1) & VERTICAL_RETRACE_ACTIVE)

#ifdef INIT_AT3D_LIB
#define INITAT3DENTRY(fun, type, args) FX_EXPORT type FX_CALL fun args
#else
#define INITAT3DENTRY(fun, type, args) FX_ENTRY type FX_CSTYLE fun args
#endif
INITAT3DENTRY(initAT3DGetHALData, Init96HALData *, (void) );
INITAT3DENTRY(initAT3DAperture, FxBool, (InitRegisterDesc *rd) );
INITAT3DENTRY(initAT3DSetVideo, FxBool, ( GrScreenResolution_t res, GrScreenRefresh_t refresh, FxU32 *xr, FxU32 *yr ));
INITAT3DENTRY(initAT3DEnableRegs, FxBool,(InitRegisterDesc *rd));
INITAT3DENTRY(initAT3DDisableRegs,FxBool,(InitRegisterDesc *rd));
#ifdef H3D
INITAT3DENTRY(initAT3DUseTiles, int, (InitRegisterDesc *rd,
        FxU32 *buffers, FxU32 nBuffers,
        FxU32 strideInBytes, FxU32 width, FxU32 height, FxU32 pageFlipping)); 
#else
INITAT3DENTRY(initAT3DUseTiles, int, (InitRegisterDesc *rd,
        FxU32 *buffers, FxU32 nBuffers,
        FxU32 strideInBytes, FxU32 width, FxU32 height)); 
#endif
INITAT3DENTRY(initAT3DGetInfo, FxBool,(VG96Info *info));
#endif /* __INITAT3D_H__ */

