/*
 * Language neutral resources for Common Dialogs
 *
 * Copyright 1999 Bertho Stultiens
 * Copyright 1999 Klaas van Gend
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "winver.h"

LANGUAGE LANG_NEUTRAL, SUBLANG_NEUTRAL

1 VERSIONINFO
FILEVERSION	4, 0, 0, 950	/* Maybe 4.1.0.980 for win98?? */
PRODUCTVERSION	4, 0, 0, 950	/* id. */
FILEFLAGSMASK	VS_FFI_FILEFLAGSMASK
FILEOS		VOS_DOS_WINDOWS16
FILETYPE	VFT_DLL
{
	BLOCK "StringFileInfo"
	{
		BLOCK "040604B0"
		{
			VALUE "CompanyName", "Wine Developer Team\000"
			VALUE "FileDescription", "Common Dialog Boxes\000"
			VALUE "FileVersion", "0.01\000"
			VALUE "InternalName", "COMDLG32\000"
			VALUE "LegalCopyright", "Copyright \251 B. A. Stultiens 1998,1999\000"
			VALUE "OriginalFilename", "COMDLG32.DLL\000"
			VALUE "ProductName", "Wine\000"
			VALUE "ProductVersion", "1.00\000"
		}
	}

	/* Do we need this? It isn't a translation, but we have all languages at once... */
/*
	BLOCK "VarFileInfo"
	{
		VALUE "Translation", 1030, 1200
	}
*/
}

/* BINRES pd32_collate.ico */
PD32_COLLATE ICON DISCARDABLE LOADONCALL
{
 '00 00 01 00 01 00 4C 18 10 00 00 00 00 00 48 05'
 '00 00 16 00 00 00 28 00 00 00 4C 00 00 00 30 00'
 '00 00 01 00 04 00 00 00 00 00 E0 04 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 80 00 00 80 00 00 00 80 80 00 80 00'
 '00 00 80 00 80 00 80 80 00 00 C0 C0 C0 00 80 80'
 '80 00 00 00 FF 00 00 FF 00 00 00 FF FF 00 FF 00'
 '00 00 FF 00 FF 00 FF FF 00 00 FF FF FF 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 80 04 00 00 00 00 00 0F F0 00 00 00'
 '00 00 0F F0 00 00 00 00 00 00 00 00 00 0F F0 00'
 '00 00 00 00 0F F0 00 00 00 00 00 00 80 04 00 00'
 '00 00 00 0F FF F0 00 00 00 0F FF F0 00 00 00 00'
 '00 00 00 00 00 0F FF F0 00 00 00 0F FF F0 00 00'
 '00 00 00 00 80 04 00 00 00 00 00 FF FF FF FF 00'
 '00 00 00 F0 00 00 00 00 00 00 00 00 00 FF FF FF'
 'FF 00 00 00 00 F0 00 00 00 00 00 00 44 03 00 00'
 '00 00 00 FF FF FF FF FF 00 FF F0 FF 00 00 00 00'
 '00 00 00 00 00 FF FF FF FF FF 00 FF F0 FF 00 00'
 '00 00 00 00 80 04 00 00 00 00 0F FF FF FF FF FF'
 'FF 00 F0 FF 00 00 00 00 00 00 00 00 0F FF FF FF'
 'FF FF FF 00 F0 FF 00 00 00 00 00 00 04 00 00 00'
 '00 00 0F FF FF FF FF FF FF 0F F0 FF F0 00 00 00'
 '00 00 00 00 0F FF FF FF FF FF FF 0F F0 FF F0 00'
 '00 00 00 00 62 01 00 00 00 00 0F FF FF FF FF FF'
 'FF 0F F0 FF F0 00 00 00 00 00 00 00 0F FF FF FF'
 'FF FF FF 0F F0 FF F0 00 00 00 00 00 E2 00 00 00'
 '00 00 FF FF FF FF FF FF F0 FF F0 FF F0 00 00 00'
 '00 00 00 00 FF FF FF FF FF FF F0 FF F0 FF F0 00'
 '00 00 00 00 00 A0 00 00 00 00 FF FF FF FF FF FF'
 'F0 FF F0 FF FF 00 00 00 00 00 00 00 FF FF FF FF'
 'FF FF F0 FF F0 FF FF 00 00 00 00 00 FF FF 00 00'
 '00 0F FF FF FF FF FF FF 0F FF F0 FF FF 00 00 00'
 '00 00 00 0F FF FF FF FF FF FF 0F FF F0 FF FF 00'
 '00 00 00 00 FF FF 00 00 00 0F FF FF FF FF FF FF'
 '0F FF F0 FF FF 00 00 00 00 00 00 0F FF FF FF FF'
 'FF FF 0F FF F0 FF FF 00 00 00 00 00 FF FF 00 00'
 '00 0F FF FF FF FF FF FF 0F FF F0 F0 0F F0 00 00'
 '00 00 00 0F FF FF FF FF FF FF 0F FF F0 F0 0F F0'
 '00 00 00 00 FF FF 00 00 00 FF FF FF FF FF FF F0'
 'FF FF F0 0F F0 F0 00 00 00 00 00 FF FF FF FF FF'
 'FF F0 FF FF F0 0F F0 F0 00 00 00 00 FF FF 00 00'
 '00 FF FF FF FF FF FF F0 FF FF F0 FF F0 FF 00 00'
 '00 00 00 FF FF FF FF FF FF F0 FF FF F0 FF F0 FF'
 '00 00 00 00 FF FF 00 00 00 FF FF FF FF FF 0F F0'
 'FF FF F0 FF 00 0F 00 00 00 00 00 FF FF FF FF FF'
 '0F F0 FF FF F0 FF 00 0F 00 00 00 00 FF FF 00 00'
 '0F FF FF FF FF FF 0F 0F 00 00 F0 FF FF 0F 00 00'
 '00 00 0F FF FF FF FF FF 0F 0F 00 00 F0 FF FF 0F'
 '00 00 00 00 FF FF 00 00 0F FF FF FF FF F0 FF 0F'
 'F0 FF F0 FF 00 FF F0 00 00 00 0F FF FF FF FF F0'
 'FF 0F F0 FF F0 FF 00 FF F0 00 00 00 FF FF 00 00'
 '00 0F FF FF F0 F0 F0 FF FF 0F F0 FF F0 00 00 00'
 '00 00 00 0F FF FF F0 F0 F0 FF FF 0F F0 FF F0 00'
 '00 00 00 00 FF FF 00 00 00 00 00 FF FF 00 F0 FF'
 '0F F0 F0 F0 00 00 00 00 00 00 00 00 00 FF FF 00'
 'F0 FF 0F F0 F0 F0 00 00 00 00 00 00 FF FF 00 00'
 '00 00 00 00 FF FF 0F FF 0F F0 F0 00 00 00 00 00'
 '00 00 00 00 00 00 FF FF 0F FF 0F F0 F0 00 00 00'
 '00 00 00 00 FF FF 00 00 00 00 00 00 00 0F 0F FF'
 'F0 0F F0 00 00 00 00 00 00 00 00 00 00 00 00 0F'
 '0F FF F0 0F F0 00 00 00 00 00 00 00 FF FF 00 00'
 '00 00 00 00 0F F0 FF FF FF FF F0 00 00 00 00 00'
 '00 00 00 00 00 00 0F F0 FF FF FF FF F0 00 00 00'
 '00 00 00 00 FF FF 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 A0 FF C7'
 'FF 9F FF FC 7F F9 FF F0 00 00 FF C0 FC 0F FF FC'
 '0F C0 FF F0 00 00 FF C0 30 0F FF FC 03 00 FF F0'
 '00 00 FF 80 00 0F FF F8 00 00 FF F0 00 00 FF 80'
 '00 07 FF F8 00 00 7F F0 00 00 FF 00 00 03 FF F0'
 '00 00 3F F0 00 00 FF 00 00 03 FF F0 00 00 3F F0'
 '00 00 FF 00 00 03 FF F0 00 00 3F F0 00 00 FE 00'
 '00 03 FF E0 00 00 3F F0 00 00 FE 00 00 01 FF E0'
 '00 00 1F F0 00 00 FC 00 00 01 FF C0 00 00 1F F0'
 '00 00 FC 00 00 00 FF C0 00 00 0F F0 00 00 FC 00'
 '00 00 FF C0 00 00 0F F0 00 00 F8 00 00 00 FF 80'
 '00 00 0F F0 00 00 F8 00 00 00 7F 80 00 00 07 F0'
 '00 00 F8 00 00 00 7F 80 00 00 07 F0 00 00 F0 00'
 '00 00 7F 00 00 00 07 F0 00 00 F0 00 00 00 3F 00'
 '00 00 03 F0 00 00 F8 00 00 00 7F 80 00 00 07 F0'
 '00 00 FF 00 00 07 FF F0 00 00 7F F0 00 00 FF C0'
 '00 1F FF FC 00 01 FF F0 00 00 FF F0 00 3F FF FF'
 '00 03 FF F0 00 00 FF F0 00 3F FF FF 00 03 FF F0'
 '00 00 FF F0 00 3F FF FF 00 03 FF F0 00 00'
}



/* BINRES pd32_nocollate.ico */
PD32_NOCOLLATE ICON
{
 '00 00 01 00 01 00 4C 18 10 00 00 00 00 00 48 05'
 '00 00 16 00 00 00 28 00 00 00 4C 00 00 00 30 00'
 '00 00 01 00 04 00 00 00 00 00 E0 04 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 80 00 00 80 00 00 00 80 80 00 80 00'
 '00 00 80 00 80 00 80 80 00 00 C0 C0 C0 00 80 80'
 '80 00 00 00 FF 00 00 FF 00 00 00 FF FF 00 FF 00'
 '00 00 FF 00 FF 00 FF FF 00 00 FF FF FF 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 FA 02 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 AD 81 00 FF'
 'FF FF FF FF FF 00 00 00 00 00 00 00 FF FF FF FF'
 'FF FF 00 00 00 00 00 00 00 FF FF FF FF FF FF 00'
 '00 00 00 00 13 00 00 FF FF FF FF FF FF 00 00 00'
 '00 00 00 00 FF FF FF FF FF FF 00 00 00 00 00 00'
 '00 FF FF FF FF FF FF 00 00 00 00 00 32 04 00 FF'
 'FF FF FF FF FF 00 00 00 00 00 00 00 FF FF FF FF'
 'FF FF 0F 00 00 00 00 00 00 FF FF FF FF FF FF 0F'
 '00 00 00 00 02 00 00 FF FF FF FF FF FF 0F 00 00'
 '00 00 00 00 FF FF FF FF FF FF 0F 00 00 00 00 00'
 '00 FF FF FF FF FF FF 0F 00 00 00 00 56 01 00 FF'
 'FF FF FF FF FF 0F F0 00 00 00 00 00 FF FF FF FF'
 'FF FF 0F F0 00 00 00 00 00 FF FF FF FF FF FF 0F'
 'F0 00 00 00 4D 04 00 FF FF FF FF FF FF 0F F0 00'
 '00 00 00 00 FF FF FF FF FF FF 0F F0 00 00 00 00'
 '00 FF FF FF FF FF FF 0F F0 00 00 00 02 00 00 FF'
 'FF FF FF FF FF 0F FF 00 00 00 00 00 FF FF FF FF'
 'FF FF 0F FF 00 00 00 00 00 FF FF FF FF FF FF 0F'
 'FF 00 00 00 62 01 00 FF FF FF FF FF FF 0F FF 00'
 '00 00 00 00 FF FF FF FF FF FF 0F FF 00 00 00 00'
 '00 FF FF FF FF FF FF 0F FF 00 00 00 4D 04 00 FF'
 'FF FF FF FF FF 0F FF F0 00 00 00 00 FF FF FF FF'
 'FF FF 0F FF F0 00 00 00 00 FF FF FF FF FF FF 0F'
 'FF F0 00 00 02 00 00 FF FF FF FF FF FF 0F FF F0'
 '00 00 00 00 FF FF FF FF FF FF 0F FF 00 00 00 00'
 '00 FF FF FF FF FF FF 0F FF F0 00 00 62 01 00 FF'
 'FF FF FF FF FF 0F F0 FF 00 00 00 00 FF FF FF FF'
 'FF FF 0F 00 0F 00 00 00 00 FF FF FF FF FF FF 0F'
 '00 FF 00 00 00 00 00 FF FF FF FF FF FF 0F F0 FF'
 '00 00 00 00 FF FF FF FF FF FF 00 0F FF 00 00 00'
 '00 FF FF FF FF FF FF 00 FF 0F 00 00 02 00 00 FF'
 'FF FF FF F0 FF 0F FF 0F F0 00 00 00 FF FF FF F0'
 '00 0F 0F 00 0F F0 00 00 00 FF FF FF FF 00 FF 0F'
 'F0 0F F0 00 62 01 00 FF FF FF FF F0 FF 0F FF F0'
 'FF 00 00 00 FF FF FF F0 FF FF 0F FF F0 F0 00 00'
 '00 FF FF FF F0 FF 0F 0F 0F 0F F0 00 00 00 00 FF'
 'FF FF FF F0 FF 0F FF 00 FF 00 00 00 FF FF FF FF'
 '0F FF 0F FF F0 FF 00 00 00 FF FF FF FF FF 0F 0F'
 'FF F0 FF 00 02 00 00 FF FF FF FF F0 FF 0F FF FF'
 '00 00 00 00 FF FF FF FF F0 FF 0F F0 0F F0 00 00'
 '00 FF FF FF FF F0 FF 0F F0 0F F0 00 C4 00 00 FF'
 'FF FF FF F0 FF 0F FF F0 00 00 00 00 FF FF FF F0'
 'FF 0F 0F FF FF 00 00 00 00 FF FF FF F0 FF 0F 0F'
 'FF FF 00 00 32 04 00 FF FF FF FF 00 FF 0F FF 00'
 '00 00 00 00 FF FF FF FF 00 FF 0F FF 00 00 00 00'
 '00 FF FF FF FF 00 FF 0F FF 00 00 00 02 00 00 FF'
 'FF FF FF FF FF 0F 00 00 00 00 00 00 FF FF FF FF'
 'FF FF 0F 00 00 00 00 00 00 FF FF FF FF FF FF 0F'
 '00 00 00 00 FF 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 0F F0 00 00 00 00 00 00 00 00 00 00 00'
 '0F F0 00 00 00 00 00 00 00 00 00 00 00 0F F0 00'
 '00 00 00 00 AD 81 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 FF 07 FF F3'
 'FF FF FC FF FF FF 3F F0 0F FF 80 01 FF E0 00 7F'
 'F8 00 1F F0 00 00 80 01 FF E0 00 3F F8 00 0F FF'
 'FF FF 80 00 FF E0 00 3F F8 00 0F F0 00 00 80 00'
 'FF E0 00 1F F8 00 07 FF F0 FF 80 00 7F E0 00 1F'
 'F8 00 07 F0 00 00 80 00 3F E0 00 0F F8 00 03 FF'
 'F0 00 80 00 3F E0 00 0F F8 00 03 FF FF FF 80 00'
 '1F E0 00 07 F8 00 01 F0 E2 00 80 00 1F E0 00 07'
 'F8 00 01 FF F0 FF 80 00 0F E0 00 03 F8 00 00 F0'
 'FF FF 80 00 0F E0 00 03 F8 00 00 F0 00 00 80 00'
 '07 E0 00 01 F8 00 00 7F FF FF 80 00 07 E0 00 01'
 'F8 00 00 70 00 00 80 00 03 E0 00 00 F8 00 00 3F'
 'F0 FF 80 00 01 E0 00 00 F8 00 00 30 00 0F 80 00'
 '01 E0 00 00 78 00 00 1F FF 00 80 00 03 E0 00 00'
 '78 00 00 1F FF FF 80 00 0F E0 00 01 F8 00 00 70'
 'FF FF 80 00 1F E0 00 03 F8 00 00 FF 0F FF 80 00'
 '3F E0 00 0F F8 00 03 FF FF FF 80 00 FF E0 00 3F'
 'F8 00 0F F0 00 00 FF C3 FF FF F0 FF FF FC 3F FF'
 'FF FF FF E7 FF FF F9 FF FF FE 7F F0 00 00'
}

/* BINRES pd32_portrait.ico */
PD32_PORTRAIT ICON
{
 '00 00 01 00 01 00 20 20 10 00 00 00 00 00 E8 02'
 '00 00 16 00 00 00 28 00 00 00 20 00 00 00 40 00'
 '00 00 01 00 04 00 00 00 00 00 80 02 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 80 00 00 80 00 00 00 80 80 00 80 00'
 '00 00 80 00 80 00 80 80 00 00 C0 C0 C0 00 80 80'
 '80 00 00 00 FF 00 00 FF 00 00 00 FF FF 00 FF 00'
 '00 00 FF 00 FF 00 FF FF 00 00 FF FF FF 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF FF FF FF 00 00 00 00'
 'FF F0 00 00 FF FF FF 00 00 00 FF FF 00 00 00 00'
 'FF FF 00 FF FF FF FF FF 00 0F FF FF 00 00 00 00'
 'FF FF F0 FF FF FF FF FF 00 FF FF FF 00 00 00 00'
 'FF FF F0 0F FF FF FF F0 00 FF FF FF 00 00 00 00'
 'FF FF FF 0F FF FF FF F0 0F FF FF FF 00 00 00 00'
 'FF FF FF 00 00 00 00 00 0F FF FF FF 00 00 00 00'
 'FF FF FF F0 FF FF FF 00 FF FF FF FF 00 00 00 00'
 'FF FF FF F0 0F FF F0 00 FF FF FF FF 00 00 00 00'
 'FF FF FF FF 0F FF F0 0F FF FF FF FF 00 00 00 00'
 'FF FF FF FF 00 FF 00 0F FF FF FF FF 00 00 00 00'
 'FF FF FF FF F0 FF 00 FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF F0 00 00 FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF FF 00 0F FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF FF 00 0F FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF FF F0 FF FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF FF F0 FF FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF FF FF FF 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF 00 00 00 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF 0F FF F0 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF 0F FF 00 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF 0F F0 00 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF 0F 00 00 00 00 00 00'
 'FF FF FF FF FF FF FF FF FF 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00'
 '00 07 E0 00 00 07 E0 00 00 07 E0 00 00 07 E0 00'
 '00 07 E0 00 00 07 E0 00 00 07 E0 00 00 07 E0 00'
 '00 07 E0 00 00 07 E0 00 00 07 E0 00 00 07 E0 00'
 '00 07 E0 00 00 07 E0 00 00 07 E0 00 00 07 E0 00'
 '00 07 E0 00 00 07 E0 00 00 07 E0 00 00 07 E0 00'
 '00 07 E0 00 00 07 E0 00 00 07 E0 00 00 07 E0 00'
 '00 07 E0 00 00 07 E0 00 00 0F E0 00 00 1F E0 00'
 '00 3F E0 00 00 7F E0 00 00 FF E0 00 01 FF'
}

/* BINRES pd32_landscape.ico */
PD32_LANDSCAPE ICON
{
 '00 00 01 00 01 00 20 20 10 00 00 00 00 00 E8 02'
 '00 00 16 00 00 00 28 00 00 00 20 00 00 00 40 00'
 '00 00 01 00 04 00 00 00 00 00 80 02 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 80 00 00 80 00 00 00 80 80 00 80 00'
 '00 00 80 00 80 00 80 80 00 00 C0 C0 C0 00 80 80'
 '80 00 00 00 FF 00 00 FF 00 00 00 FF FF 00 FF 00'
 '00 00 FF 00 FF 00 FF FF 00 00 FF FF FF 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 0F FF'
 'FF FF FF FF FF FF FF FF FF FF FF FF FF F0 0F FF'
 'FF FF FF FF FF FF FF FF FF FF FF FF FF F0 0F FF'
 'FF FF FF FF FF FF FF FF FF FF FF FF FF F0 0F FF'
 'FF FF FF FF FF FF FF FF FF FF FF FF FF F0 0F FF'
 'FF FF FF FF FF FF FF FF FF FF FF FF FF F0 0F FF'
 'FF F0 00 00 FF FF FF 00 00 00 FF FF FF F0 0F FF'
 'FF FF 00 FF FF FF FF FF 00 0F FF FF FF F0 0F FF'
 'FF FF F0 FF FF FF FF FF 00 FF FF FF FF F0 0F FF'
 'FF FF F0 0F FF FF FF F0 00 FF FF FF FF F0 0F FF'
 'FF FF FF 0F FF FF FF F0 0F FF FF FF FF F0 0F FF'
 'FF FF FF 00 00 00 00 00 0F FF FF FF FF F0 0F FF'
 'FF FF FF F0 FF FF FF 00 FF FF FF FF FF F0 0F FF'
 'FF FF FF F0 0F FF F0 00 FF FF FF FF FF F0 0F FF'
 'FF FF FF FF 0F FF F0 0F FF FF FF FF FF F0 0F FF'
 'FF FF FF FF 00 FF 00 0F FF FF FF FF FF F0 0F FF'
 'FF FF FF FF F0 FF 00 FF FF FF FF FF FF F0 0F FF'
 'FF FF FF FF F0 00 00 FF FF FF FF FF FF F0 0F FF'
 'FF FF FF FF FF 00 0F FF FF FF FF FF FF F0 0F FF'
 'FF FF FF FF FF 00 0F FF FF FF F0 00 00 00 0F FF'
 'FF FF FF FF FF F0 FF FF FF FF F0 FF FF 00 0F FF'
 'FF FF FF FF FF F0 FF FF FF FF F0 FF F0 00 0F FF'
 'FF FF FF FF FF FF FF FF FF FF F0 FF 00 00 0F FF'
 'FF FF FF FF FF FF FF FF FF FF F0 F0 00 00 0F FF'
 'FF FF FF FF FF FF FF FF FF FF F0 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 FF FF'
 'FF FF FF FF FF FF FF FF FF FF 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00'
 '00 03 00 00 00 07 00 00 00 0F 00 00 00 1F 00 00'
 '00 3F FF FF FF FF FF FF FF FF FF FF FF FF'
}

/* BINRES 800.bmp */
800 BITMAP DISCARDABLE LOADONCALL
{
 '42 4D 36 05 00 00 00 00 00 00 36 04 00 00 28 00'
 '00 00 10 00 00 00 10 00 00 00 01 00 08 00 00 00'
 '00 00 00 01 00 00 12 0B 00 00 12 0B 00 00 00 01'
 '00 00 00 01 00 00 00 00 00 00 00 00 80 00 00 80'
 '00 00 00 80 80 00 80 00 00 00 80 00 80 00 80 80'
 '00 00 C0 C0 C0 00 80 80 80 00 00 00 FF 00 00 FF'
 '00 00 00 FF FF 00 FF 00 00 00 FF 00 FF 00 FF FF'
 '00 00 FF FF FF 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 07 07 07 08 08 08 08 08 08 08'
 '08 08 08 08 08 07 07 07 07 08 08 08 08 08 08 08'
 '08 08 08 08 08 07 07 00 00 00 00 00 00 00 00 00'
 '00 00 00 08 08 07 07 00 0F 0F 0F 00 0B 0B 00 0F'
 '0F 0F 00 08 08 07 07 00 0F 0F 0F 00 0B 0B 00 0F'
 '0F 0F 00 08 08 07 07 00 0F 0F 0F 00 0B 0B 00 0F'
 '0F 0F 00 08 08 07 07 00 0F 0F 0F 00 0B 0B 00 0F'
 '0F 0F 00 08 08 07 07 00 0F 0F 0F 00 00 00 00 0F'
 '0F 0F 00 08 08 08 07 00 0F 0F 0F 0F 0F 0F 0F 0F'
 '0F 0F 00 08 08 07 00 0B 00 0F 0F 0F 0F 0F 0F 0F'
 '0F 00 0B 00 07 07 07 00 0B 00 0F 0F 0F 0F 0F 0F'
 '00 0B 00 08 07 07 07 07 00 0B 00 0F 0F 0F 0F 00'
 '0B 00 08 08 07 07 07 07 07 00 0B 00 0F 0F 00 0B'
 '00 00 08 08 07 07 07 07 07 07 00 0B 00 00 0B 00'
 '01 00 08 08 07 07 07 07 07 07 07 00 0B 0B 00 07'
 '01 00 07 07 07 07 07 07 07 07 07 07 00 00 07 07'
 '01 00 07 07 07 07'
}


/* BINRES folder.ico */
FOLDER ICON
{
 '00 00 01 00 01 00 10 10 10 00 00 00 00 00 28 01'
 '00 00 16 00 00 00 28 00 00 00 10 00 00 00 20 00'
 '00 00 01 00 04 00 00 00 00 00 C0 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 80 00 00 80 00 00 00 80 80 00 80 00'
 '00 00 80 00 80 00 80 80 00 00 80 80 80 00 C0 C0'
 'C0 00 00 00 FF 00 00 FF 00 00 00 FF FF 00 FF 00'
 '00 00 FF 00 FF 00 FF FF 00 00 FF FF FF 00 00 00'
 '00 00 00 00 00 00 00 77 77 77 77 77 77 77 07 77'
 '77 77 77 77 77 77 07 FB 8B 8B 8B 8B 8B 77 07 F8'
 'B8 B8 B8 B8 B8 77 07 FB 8B 8B 8B 8B 8B 77 07 F8'
 'B8 B8 B8 B8 B8 77 07 FB 8B 8B 8B 8B 8B 77 07 F8'
 'B8 B8 B8 B8 B8 77 07 FB 8B 8B 8B 8B 8B 77 07 FF'
 'FF FF FF FF FF 77 07 B8 B8 B8 B7 77 77 70 00 7B'
 '8B 8B 70 00 00 00 00 07 77 77 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 FF FF'
 '00 00 C0 00 00 00 80 00 00 00 80 00 00 00 80 00'
 '00 00 80 00 00 00 80 00 00 00 80 00 00 00 80 00'
 '00 00 80 00 00 00 80 00 00 00 80 01 00 00 C0 7F'
 '00 00 E0 FF 00 00 FF FF 00 00 FF FF 00 00'
}


/* BINRES folder2.ico */
FOLDER2 ICON
{
 '00 00 01 00 01 00 10 10 10 00 00 00 00 00 28 01'
 '00 00 16 00 00 00 28 00 00 00 10 00 00 00 20 00'
 '00 00 01 00 04 00 00 00 00 00 C0 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 80 00 00 80 00 00 00 80 80 00 80 00'
 '00 00 80 00 80 00 80 80 00 00 80 80 80 00 C0 C0'
 'C0 00 00 00 FF 00 00 FF 00 00 00 FF FF 00 FF 00'
 '00 00 FF 00 FF 00 FF FF 00 00 FF FF FF 00 00 00'
 '00 00 00 00 00 00 00 07 77 77 77 77 77 77 00 77'
 '77 77 77 77 77 77 00 7F B8 B8 B8 B8 B7 77 07 FB'
 '8B 8B 8B 8B 87 77 07 F8 B8 B8 B8 B8 77 77 7F 8B'
 '8B 8B 8B 8B 77 77 7F FF FF FF FF F7 77 77 77 77'
 '77 77 77 77 7B 77 07 F7 B7 B7 B7 B7 B7 77 07 FB'
 '7B 7B 7F FF FF 77 07 F7 B7 B7 F7 77 77 70 00 7F'
 'FF FF 70 00 00 00 00 07 77 77 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 FF FF'
 '00 00 E0 00 00 00 C0 00 00 00 C0 00 00 00 80 00'
 '00 00 80 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 80 00 00 00 80 00 00 00 80 01 00 00 C0 7F'
 '00 00 E0 FF 00 00 FF FF 00 00 FF FF 00 00'
}


/* BINRES floppy.ico */
FLOPPY ICON
{
 '00 00 01 00 01 00 10 10 10 00 00 00 00 00 28 01'
 '00 00 16 00 00 00 28 00 00 00 10 00 00 00 20 00'
 '00 00 01 00 04 00 00 00 00 00 C0 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 80 00 00 80 00 00 00 80 80 00 80 00'
 '00 00 80 00 80 00 80 80 00 00 80 80 80 00 C0 C0'
 'C0 00 00 00 FF 00 00 FF 00 00 00 FF FF 00 FF 00'
 '00 00 FF 00 FF 00 FF FF 00 00 FF FF FF 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 77'
 '77 77 77 77 77 70 00 88 AA 88 88 00 88 70 00 88'
 'AA 88 88 00 88 70 00 88 88 88 88 88 88 70 00 88'
 '88 00 00 88 88 70 00 80 00 00 00 00 08 70 00 88'
 '88 00 00 88 88 70 00 88 88 88 88 88 88 70 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 FF FF'
 '00 00 FF FF 00 00 FF FF 00 00 80 00 00 00 80 00'
 '00 00 80 00 00 00 80 00 00 00 80 00 00 00 80 00'
 '00 00 80 00 00 00 80 00 00 00 80 00 00 00 80 00'
 '00 00 FF FF 00 00 FF FF 00 00 FF FF 00 00'
}


/* BINRES cdrom.ico */
CDROM ICON
{
 '00 00 01 00 01 00 10 10 10 00 00 00 00 00 28 01'
 '00 00 16 00 00 00 28 00 00 00 10 00 00 00 20 00'
 '00 00 01 00 04 00 00 00 00 00 C0 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 80 00 00 80 00 00 00 80 80 00 80 00'
 '00 00 80 00 80 00 80 80 00 00 80 80 80 00 C0 C0'
 'C0 00 00 00 FF 00 00 FF 00 00 00 FF FF 00 FF 00'
 '00 00 FF 00 FF 00 FF FF 00 00 FF FF FF 00 00 00'
 '00 00 00 00 00 00 00 00 77 BB 88 80 00 00 00 07'
 'AE EB 88 88 80 00 00 7B AA EB 88 88 88 00 00 7B'
 'BA EE 88 88 88 00 07 BB BB BE FF F8 88 80 07 88'
 '88 87 07 F8 88 80 07 88 88 80 00 F8 88 80 07 88'
 '88 87 07 88 88 80 07 88 88 88 88 EB BB B0 00 78'
 '88 88 88 AE BB 00 00 78 88 88 88 AA EB 00 00 07'
 '88 88 88 BA E0 00 00 00 77 88 88 B0 00 00 00 00'
 '00 77 77 70 00 00 00 00 00 00 00 00 00 00 FC 1F'
 '00 00 F0 07 00 00 E0 03 00 00 C0 01 00 00 C0 01'
 '00 00 80 00 00 00 80 00 00 00 80 00 00 00 80 00'
 '00 00 80 00 00 00 C0 01 00 00 C0 01 00 00 E0 03'
 '00 00 F0 07 00 00 FC 1F 00 00 FF FF 00 00'
}


/* BINRES hdisk.ico */
HDISK ICON
{
 '00 00 01 00 01 00 10 10 10 00 00 00 00 00 28 01'
 '00 00 16 00 00 00 28 00 00 00 10 00 00 00 20 00'
 '00 00 01 00 04 00 00 00 00 00 C0 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 80 00 00 80 00 00 00 80 80 00 80 00'
 '00 00 80 00 80 00 80 80 00 00 80 80 80 00 C0 C0'
 'C0 00 00 00 FF 00 00 FF 00 00 00 FF FF 00 FF 00'
 '00 00 FF 00 FF 00 FF FF 00 00 FF FF FF 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 77'
 '77 77 77 77 77 70 00 88 88 88 88 AA 88 70 00 88'
 '88 88 88 AA 88 70 00 77 77 77 77 77 77 70 00 88'
 '88 88 88 88 88 70 00 88 88 88 88 88 88 70 00 88'
 '88 88 88 88 88 70 00 88 88 88 88 88 88 70 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 FF FF'
 '00 00 FF FF 00 00 FF FF 00 00 80 00 00 00 80 00'
 '00 00 80 00 00 00 80 00 00 00 80 00 00 00 80 00'
 '00 00 80 00 00 00 80 00 00 00 80 00 00 00 80 00'
 '00 00 FF FF 00 00 FF FF 00 00 FF FF 00 00'
}


/* BINRES network.ico */
NETWORK ICON
{
 '00 00 01 00 01 00 10 10 10 00 00 00 00 00 28 01'
 '00 00 16 00 00 00 28 00 00 00 10 00 00 00 20 00'
 '00 00 01 00 04 00 00 00 00 00 C0 00 00 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 80 00 00 80 00 00 00 80 80 00 80 00'
 '00 00 80 00 80 00 80 80 00 00 80 80 80 00 C0 C0'
 'C0 00 00 00 FF 00 00 FF 00 00 00 FF FF 00 FF 00'
 '00 00 FF 00 FF 00 FF FF 00 00 FF FF FF 00 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 BF B0 00 00 00 08 88 88 BB B0 88 88 88 00 00'
 '00 08 00 00 00 00 00 00 00 00 00 00 00 00 00 00'
 '00 00 00 00 00 00 07 8F FF FF FF FF 87 00 07 87'
 '77 77 77 77 87 70 07 88 88 88 88 88 87 70 07 88'
 '88 88 88 8A 87 70 07 FF FF FF FF FF F7 70 00 78'
 '88 88 88 88 88 70 00 07 77 77 77 77 77 70 00 00'
 '00 00 00 00 00 00 00 00 00 00 00 00 00 00 FF FF'
 '00 00 FC 3F 00 00 80 00 00 00 80 00 00 00 FE 7F'
 '00 00 FE 7F 00 00 C0 03 00 00 80 01 00 00 80 00'
 '00 00 80 00 00 00 80 00 00 00 80 00 00 00 C0 00'
 '00 00 E0 01 00 00 FF FF 00 00 FF FF 00 00'
}
