/* $Id: Configure.cmd,v 1.4 2002/04/29 11:34:59 bird Exp $
 *
 * Configuration script.
 * Generates global makefile.inc.
 *
 * Copyright (c) 1999-2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 * Project Odin Software License can be found in LICENSE.TXT
 *
 */
    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
    call SysLoadFuncs;

    /* Argument defaults */
    fInteractive    = 1;
    fWin32k         = 1;
    fWithkLib       = 0;


    /* parse arguments */
    parse arg asArgs.1 asArgs.2 asArgs.3 asArgs.4 asArgs.5 asArgs.6 asArgs.7 asArgs.8 asArgs.9
    asArgs.0 = 0;
    do i = 1 to 9
        if (asArgs.i <> '') then
            asArgs.0 = i;
    end
    do i = 1 to asArgs.0
        if (substr(asArgs.i, 1, 1) = '-' | substr(asArgs.i, 1, 1) = '/')  then
        do
            sArg = translate(substr(asArgs.i, 2));
            ch = substr(sArg, 1, 1);
            select
                when (ch = 'N') then
                    fInteractive = 0;
                when (ch = 'I') then
                    fInteractive = 1;
                when (ch = 'W') then
                    fWin32k = 0;
                when (ch = '-') then
                do
                    parse var sArg sParm'='sOpt
                    select
                        when (sParm = '-WITH-KLIB') then
                            fWithkLib = 1;
                        otherwise
                            say 'syntax error ('asArgs.i')';
                            exit(2);
                    end
                end

                when (ch = '?' | ch = 'H' | substr(sArg, 1, 2) = '-H') then
                do
                    say 'Odin32 Configure.cmd. $Revision: 1.4 $.'
                    say 'syntax: Configure.cmd [-n] [-w]'
                    say '  -n           Noninteractive.'
                    say '  -w           Don''t build Win32k.'
                    say '  --with-klib  Build with kLib. (Will checkout kLib for you.)'
                    say '  -h           This text.'
                    exit(1);
                end
                otherwise
                    say 'syntax error ('asArgs.i')';
                    exit(2);
            end
        end
    end

    /* strings */
    sIncFile='Makefile.inc';

    /* Status */
    if (fInteractive) then
        say 'Configuring Odin32...';


    /* delete old makefile.inc file */
    call SysFileDelete sIncFile;

    /* open target file */
    if (stream(sIncFile, 'c', 'open write' ) <> '') then
    do
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# Generated by 'directory()'\configure.cmd'
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, ''
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# Odin32 basedirectories'
        call lineout sIncFile, '# Note! These should be absolute paths!'
        call lineout sIncFile, '################################################################################'
        sOdin32Base = directory();
        call lineout sIncFile, 'ODIN32_BASE      =' sOdin32Base;
        call lineout sIncFile, 'ODIN32_SRC       =' sOdin32Base'\src';
        call lineout sIncFile, 'ODIN32_LIB_      =' sOdin32Base'\lib';
        call lineout sIncFile, 'ODIN32_BIN_      =' sOdin32Base'\bin';
        call lineout sIncFile, 'ODIN32_INCLUDE   =' sOdin32Base'\include';
        call lineout sIncFile, 'ODIN32_TOOLS     =' sOdin32Base'\tools\bin';
        if (fWithkLib) then
            call lineout sIncFile, 'WITH_KLIB        = 1'
        call lineout sIncFile, ''
        call lineout sIncFile, ''
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# Include the odin32.mk file'
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '!include 'sOdin32Base'\include\odin32.mk'
        call lineout sIncFile, ''

        call stream sIncFile, 'c', 'close';


        /*
         * Configure Win32k.
         */
        if (fInteractive) then
            say 'Configuring Win32k...';

        sOldDir = directory();
        if (directory('.\src\win32k') <> '') then
        do
            parse arg sArgs
            '@call .\configure.cmd' sArgs
            if (rc <> 0) then
            do
                call directory(sOldDir);
                exit(rc);
            end
        end
        else
        do
            say 'oops! failed to change directory to .\src\win32k.';
            exit(2);
        end
        call directory(sOldDir);


        /*
         * Display start info.
         */
        if (fInteractive = 1) then
        do
            say 'Configuration completed!'
            say ''
            say 'To build Odin32 do:'
            say '   nmake dep'
            say '   nmake'
        end
    end
    else
    do
        say 'oops, failed to open outputfile,' sIncFile;
        exit 1;
    end
    exit 0;



/*****************/
/* function area */
/*****************/


/**
 * SearchPaths
 * Parameters:
 *   Takes pair of <envionment variable name> and <filename> as parameters
 *   As final optional parameter you may specify a question to request the string from the user.
 * Returns:
 *   sPath-sFile ignoring '..\'s in sFile.
 */
SearchPaths: procedure expose fInteractive;
    i = 1;
    sEnv  = arg(i);
    sFile = arg(i+1);
    sPath = '';
    do while (sPath == '' & sEnv <> '' & sFile <> '')
        sPath = SysSearchPath(sEnv, sFile);
        /* debug: say 'sEnv:'sEnv 'sFile:'sFile 'sPath:'sPath 'i:'i */
        i = i + 2;
        sEnv  = arg(i);
        sFile = arg(i+1);
    end

    if (sPath == '' & sEnv <> '' & sFile == '') then
    do
        say sEnv;
        if (fInteractive = 1) then
            sPath = linein();
        else
            say '!ignored!';
    end
    else
    do
        if sPath <> '' then do
            /*  */
            i = lastpos('..\', sFile);
            if i <> 0 then
                sFile = substr(sFile, i + 2);

            /* cut equally */
            i = lastpos(sFile, sPath);
            if i == 0 then
                say '!error! sFile:'sFile  'sPath:'sPath;
            /* debug: say 'sPath:'sPath  'sFile:'sFile */
            sPath = substr(sPath, 1, i-1);
        end
    end

    return sPath;
