# Perl script to convert Oracle Business Objects to JDBC.

#!/usr/bin/perl

bag("Usage: $0 input_file_list(comma separated) output_file") unless @ARGV == 2;

my ($infile, $outfile) = @ARGV;
my $inf="";
my $filename="";
my %file_obj_name_cache;
my %hashcache=();

my @in_file_list=split(/\,/,$infile);
my @in_file_list1=@in_file_list;


# Copy the ReposVersion information to the output. It is assumed that 
# ReposVersion.txt is present in the current directory.

open(REPOSVER,"ReposVersion.txt") || die "Could not open ReposVersion.txt.\n";
open(OUTPUT,">$outfile");

while (<REPOSVER>)
{
    print OUTPUT $_;
}
close(REPOSVER);


# Cache the objectname => tablename information from the input files.
# Also, the objectname => filename information is cached in this subroutine.

cache_object_table_names();

# Convert the appspecificinfo from Oracle to JDBC.

convert_oracle_to_jdbc();


sub convert_oracle_to_jdbc
{
    # Open each one of the input files, transform the same to JDBC and write
    # to the output.

    while ($inf = shift(@in_file_list1))
    {
	open(INPUT,$inf);
	my $objectname="";
	my $attrname="";
	my $tablename="";
	my $objname="";

	while (<INPUT>)
	{
	    $eachline=$_;
	    if ($eachline = m /BusinessObjectDefinition/)
	    {
		$busobj=1;
		$attr=0;
		$verb=0;
	    }
	    if ($eachline = m /Attribute/)
	    {
		$busobj=0;
		$attr=1;
	    }
	    if ($eachline = m /Verb/)
	    {
		$attr=0;
		$verb=1;
	    }

	    # AppSpecificInfo for business object and each attribute gets
	    # transformed. AppSpecificInfo for the verb remains as is.

	    if (($eachline = m /Name/) && ($verb == 0))
	    {
		@nameval=split(/=/,$_);
		$val=@nameval[1];
		$val=~s/^\s+//;
		chop($val);
		if ($busobj == 1)
		{
		    $objectname=$val;
		    
		} else
		{
		    $attrname=$val;
		}
	    }
	    if (($eachline= m /AppSpecificInfo/) && ($verb==0))
	    {
		@appspecvals=split(/=/,$_);
		chop(@appspecvals[1]);
		@appspecvals[1]=~s/^\s+//;

		# Print to the output in case there is no value
		# specified for appspecificinfo.

		if ((length(@appspecvals[1]) == 0) && ($attr == 1))
		{
		    print OUTPUT $_;
		} else
		{
		    # Build the JDBC syntax for business object AppSpecificInfo.

		    if ($busobj == 1)
		    {
			while (($objname,$tblname) = each(%hashcache))
			{
			    if ($objname eq $objectname)
			    {
				$tablename=$tblname;
			    }
			}
			if (length(@appspecvals[1]) > 1)
			{
			    print OUTPUT "@appspecvals[0]= SCN=@appspecvals[1];TN=$tablename\n";
			} else
			{
			    print OUTPUT "@appspecvals[0]= TN=$tablename\n";
			}
			
		    }
		
		    # Transform the attribute AppSpecificInfo.

		    if ($attr==1)
		    {
			@fieldvals=split(/:/,@appspecvals[1]);

			# Handle the case for child attributes. Normally,
			# when AppSpecificInfo = KEEP_RELATIONSHIP.

			if (@fieldvals[0] eq @appspecvals[1])
			{
			    if (@fieldvals[0] = m /KEEP_RELATIONSHIP/)
			    {
				print OUTPUT "@appspecvals[0]= KEEP_RELATIONSHIP=true\n";
			    } elsif ((@fieldvals[0] = m /OWNERSHIP/) || (@fieldvals[0] = m /NOOWNERSHIP/))
			    {
				print OUTPUT "@appspecvals[0]= CONTAINMENT=@appspecvals[1]\n";
			    } else
			    {
				print OUTPUT $_;
			    }
			} else
			{
			    # Splitting on the delimiter : yields the 
			    # values for each information part.

			    # Oracle ASI has the form tablename.columnname.
		            # The same changes to CN=columnname for JDBC.

			    if(length(@fieldvals[0]) > 0)
			    {
				@fieldvals[0]=~s/[a-zA-Z_0-9]*\./CN=/;
			    }

			    # Oracle recognises the foreign key with the
			    # foreignkeytablename.fkcolumnname syntax. The
			    # same changes to fkobjectname.fkattributename
			    # for JDBC.

			    if(length(@fieldvals[1]) > 0)
			    {
				($fktblname,$fkcolname) = split(/\./,@fieldvals[1]);
				# Look in the cache to obtain the object name
				# corresponding to fktblname.
				# If found, look in the objectname => filename
				# cache to open the corresponding file.

				while (($objname,$tblname) = each(%hashcache))
				{
				    if ($tblname eq $fktblname)
				    {
					while (($oname,$fname) = each(%file_obj_name_cache))
					{
					    if ($oname eq $objname)
					    {
						$filename = $fname;
					    }
					    
					}
					open(FKINPUT,$filename) || die "Could not open foreign key table $filename.txt.\n";
					$attribute=0;
					$vb=0;
					$bo=0;
					$wrongbo=1;
					while (<FKINPUT>)
					{
					    $line=$_;
					    if ($line = m /BusinessObjectDefinition/)
					    {
						$wrongbo=0;
						$bo=1;
						$attribute=0;
					    }
					    if (($bo == 1) && ($attribute == 0) && ($line = m /Name/))
					    {
						@nameval=split(/=/,$_);
						chop(@nameval[1]);
						@nameval[1]=~s/^\s+//;
						
						# One file can have more than one
						# BOs. To process only the correct
						# object, wrongbo is used.

						if (@nameval[1] ne $objname)
						{
						    $wrongbo=1;
						    next;
						}
					    }
					    if ($wrongbo == 0)
					    {
						$objectname=$objname;
						if ($line = m /Attribute/)
						{
						    $attribute=1;
						}
						if ($line = m /Verb/)
						{
						    $vb=1;
						}
						# Store the attribute name.

						if (($attribute == 1) && ($line = m /Name/))
						{
						    @attrvals=split(/=/,$_);
						    $aname=@attrvals[1];
						    chop($aname);
						    $aname=~s/^\s+//;
						}

						# In case the ASI for the attribute
						# corresponds to the fkcolname,
						# the attribute name is set for	
						# JDBC.

						if (($attribute == 1) && ($line = m /AppSpecificInfo/))
						{
						    @appspec=split(/=/,$_);
						    @appvals=split(/:/,$appspec[1]);
						    if (@appvals[0] eq $appspec[1])
						    {
							next;
						    }
						    ($tname,$cname)=split(/\./,@appvals[0]);
						    if ($cname eq $fkcolname)
						    {
							$attrname=$aname;
						    
						    }
						}
					
					    }
					}
				    }
				}
				@fieldvals[1]=~s/@fieldvals[1]/FK=$objectname.$attrname/;
			    }

			    # Oracle sequence gets changed to UID=sequence for
			    # JDBC.

			    if(length(@fieldvals[2]) > 0)
			    {
				@fieldvals[2]=~s/@fieldvals[2]/UID=@fieldvals[2]/;
			    }

			    # CA= gets added for JDBC for set_attr_name.

			    if(length(@fieldvals[3]) > 0)
			    {
				@fieldvals[3]=~s/@fieldvals[3]/CA=@fieldvals[3]/;
			    }

			    # ORDER_BY_DESC of Oracle changes to OB=DESC for JDBC.
			    # ORDER_BY of Oracle changes to OB=ASC for JDBC.

			    if(length(@fieldvals[4]) > 0)
			    {
				@fieldvals[4]=~s/ORDER_BY_DESC/OB=DESC/;
				@fieldvals[4]=~s/ORDER_BY/OB=ASC/;
			    }
			    
			    # JDBC has an extra delimiter for UNVL specification.
			    # Write the changed ASI to the output.

			    print OUTPUT "@appspecvals[0]= $fieldvals[0]:$fieldvals[1]:$fieldvals[2]:$fieldvals[3]:$fieldvals[4]:\n";
			}
		    }
		}
	    } else
	    {
		print OUTPUT $_;
	    }
	}
    }
}




sub cache_object_table_names 
{

    while ($inf = shift(@in_file_list))
    {
	open(INPUT,$inf);
	$busobj=0;
	$firstattr=1;
	$attr=0;
        $objectname="";
        
	while (<INPUT>)
	{
	    $eachline=$_;
	    if ($eachline = m /BusinessObjectDefinition/)
	    {
		$busobj=1;
		$firstattr=1;
		$attr=0;
	    }
	    if ($eachline = m /Attribute/)
	    {
		$busobj=0;
		$attr=1;
	    }
	    # Indicates the first attribute has been processed. There is no
	    # need to process the rest of the attributes as the table name 
	    # information has been obtained.

	    if ($firstattr==0)
	    {
		next;
	    }
	    if ($eachline = m /Attribute/)
	    {
		$busobj=0;
		$attr=1;
	    }
	    # Get the object name using the Name field under BusinessObjectDefinition.
	    if ($busobj==1)
	    {
		if ($eachline= m/Name/)
		{
		    @nameval=split(/=/,$_);
		    $objectname=@nameval[1];
		    $objectname=~s/^\s+//;
		    chop($objectname);
		}
	    }
	    # Get the tablename information from appspecificinfo of the first
	    # attribute.
	    if ($attr == 1)
	    {
		if ($eachline = m/AppSpecificInfo/)
		{
		    @nameval=split(/=/,$_);
		    @appspecvals=split(/:/,@nameval[1]);
		    ($tablename,$colname)=split(/\./,@appspecvals[0]);
		    $tablename=~s/^\s+//;
		    $firstattr=0;
		    $hashcache{$objectname} = $tablename;
		    $file_obj_name_cache{$objectname}=$inf;
			
		}
	    }
	}
    }
    close(INPUT);
}

sub bag {
  my $msg = shift;
  $msg .= "\n";
  warn $msg;
  exit 2;
}
