
/*********************************************************************

   Module Name    = NSCRSIGN.H

   Descriptive Name: Network SignON Coordinator/2 External Header File

   Copyright = 5648-049 (c) Copyright IBM Corp. 1992, 1993
               Licensed Material - Program Property of IBM
               Refer to Copyright Instructions Form Number G120-3083

   Status = NSC Version 1.2

   Function: Header File defining

      NSCRSIGN constant parameter values
      NSCRSIGN function prototype
      NSCRSIGN return codes

   Compile Options:

      Microsoft C 6.0: none

      IBM CSet/2:      -DNSC32 to call NSCRSIGN from a 32-bit app

   Operating System: OS/2

*********************************************************************/

#ifndef   NSCRSIGN_INCLUDED
#define   NSCRSIGN_INCLUDED

/* API Function Attributes */
#ifndef   NSC_DLL_ENTRY
  #ifdef    NSC32
    #define   NSC_DLL_ENTRY
  #else
    #define   NSC_DLL_ENTRY _export _loadds _far _pascal
  #endif
#endif

/* Pointer Types */
#ifdef    NSC32
  #define   NSCPTR _Seg16
#else
  #define   NSCPTR
#endif

/* Constants defining internal string length limits */
#define   NSC_MAXUIDLEN  47             /* Maximum User ID length  = 47 */
#define   NSC_MAXPWLEN   14             /* Maximum Password length = 14 */


/* Typedef for callback procedure to be called for displaying errors */
typedef void NSC_DLL_ENTRY \
    FNMSGDSP (short config_index, \
              short return_code, \
              short reserved, \
              unsigned char * NSCPTR message_txt);
typedef FNMSGDSP *PFNMSGDSP;

/* callback procedure linkage */
#ifdef    NSC32
 #pragma   linkage (FNMSGDSP, far16 pascal)
#endif


/*             Function Prototype                                    */

short NSC_DLL_ENTRY   NSCRSIGN (
   unsigned char *UserId,              /* User Id */
   unsigned char *Password,            /* Current Password */
   unsigned char *NewPassword,         /* New Password, NULL if none */
   short          Action,              /* NSC_LOGON, NSC_LOGOFF or NSC_CHGPW */
                    #define  NSC_LOGON   0   /* Signon */
                    #define  NSC_LOGOFF  1   /* Signoff */
                    #define  NSC_CHGPW   2   /* Change Password */
                    #define  NSC_LOGON_NEW_INI 3   /* Signon and force read of */
                                                   /* ini file                 */
   void          *reserved,            /* Reserved, should be NULL */
   FNMSGDSP      *msgdsp);             /* Error message display function */

/* 32-bit API linkage */
#ifdef    NSC32
 #pragma   linkage (NSCRSIGN, far16 pascal)
#endif

/********************************************************************/
/*      Return codes from the NSCRSIGN api                          */
/*                                                                  */
/********************************************************************/

#define   NSC_OK                    0   /* Successful               */
                                        /****************************/
                                        /*                          */
                                        /*  Informational Messages  */
                                        /*     and Warnings         */
                                        /*                          */
                                        /****************************/
#define   NSC_PW_WILL_EXPIRE        1   /* OK, but password will expire soon */
#define   NSC_ALREADY_LOGGED_ON     2   /* Someone is already logged on */
#define   NSC_ALREADY_LOGGED_OFF    3   /* User was not logged on */
#define   NSC_PW_CHGD_SIGNON_NOT    4   /* Password changed, signon failed */
#define   NSC_OK_PW_EXPIRED         5   /* OK, but password has expired */
#define   NSC_IN_PROGRESS           6   /* Operation in progress (info) */
#define   NSC_PW_CHGD_WARN          7   /* Password changed, but unable to
                                           relogon user originally logged on */

#define   NSC_RC_ERROR_BOUNDARY    10   /* Warnings are less than this value,
                                           Errors are greater than or equal to
                                           this value. */
                                        /****************************/
                                        /*                          */
                                        /*  Configuration Errors    */
                                        /*                          */
                                        /****************************/
#define   NSC_CONFIG_FILE_ERROR    10   /* Error reading configuration file */
#define   NSC_TOO_MANY_OPTS        11   /* Too many definitions */
#define   NSC_TOO_MANY_HOSTS       12   /* Too many hosts for remote loc */
#define   NSC_INVALID_PARM         13   /* Invalid parameter */
#define   NSC_INVALID_VALUE        14   /* Invalid parameter value */
#define   NSC_INVALID_OPTION       15   /* Invalid definition */
#define   NSC_CONFIG_LINE          16   /* Text from configuration line */
#define   NSC_CFG_FILE_NOT_FOUND   17   /* Config file not found */
                                        /****************************/
                                        /*                          */
                                        /*  API Errors              */
                                        /*                          */
                                        /****************************/
#define   NSC_INVALID_REQUEST      20   /* Invalid Requested Action */
#define   NSC_BAD_ADDRESS          21   /* Bad Parameter Address */
#define   NSC_BAD_PARMS            22   /* UserID or Passwords too long */
#define   NSC_NO_USERID            23   /* No User ID */
#define   NSC_NO_PW                24   /* No Password */
#define   NSC_CONFIG_ERRORS        25   /* Configuration Errors */
#define   NSC_EXEC_WARNINGS        26   /* Execution Warnings */
#define   NSC_EXEC_ERRORS          27   /* Execution Errors */
#define   NSC_PM_EXEC_ERROR        28   /* Unable to execute NSCPM.EXE */
                                        /****************************/
                                        /*                          */
                                        /*  Execution Errors        */
                                        /*    ID or password related*/
                                        /*                          */
                                        /****************************/
#define   NSC_UID_INVALID          30   /* User ID is invalid */
#define   NSC_UID_OR_PW_INVALID    31   /* User ID or password is invalid */
#define   NSC_PW_INVALID           32   /* Password is invalid */
#define   NSC_PW_EXPIRED           33   /* Password has expired */
#define   NSC_PW_OR_NEWPW_INVALID  34   /* Password or new password invalid */
#define   NSC_NEWPW_NOT_ALLOWED    35   /* Password cannot be changed */
#define   NSC_NEWPW_INVALID        36   /* New password is invalid */
#define   NSC_LOGON_EXEC_ERROR     37   /* Unable to execute LOGON program */
#define   NSC_LOGOFF_EXEC_ERROR    38   /* Unable to execute LOGOFF program */
                                        /****************************/
                                        /*                          */
                                        /*  Execution Errors        */
                                        /*    from LAN Server       */
                                        /*                          */
                                        /****************************/
#define   NSC_NET_NOT_STARTED      40   /* NETWKSTA.SYS is not started */
#define   NSC_WKS_NOT_STARTED      41   /* LAN Requester not started */
#define   NSC_WKS_NOT_STARTED_Q    42   /* LAN Requester not started,
                                           Operation was queued. */
#define   NSC_ADDITIONAL_SERVER    43   /* Cannot ChgPW on additional server */
#define   NSC_NET_EXEC_ERROR       44   /* Unable to execute NET program */
#define   NSC_ACTIVE_SESSIONS      45   /* Active sessions for domain logon */
#define   NSC_ACTIVE_SESSIONS_Q    46   /* Active sessions for domain logon,
                                           Operation was queued. */
#define   NSC_LOGGED_ELSEWHERE     47   /* User signed onto domain elsewhere */
#define   NSC_NO_MAIL_SLOTS        48   /* No mail slots on DOS */
                                        /****************************/
                                        /*                          */
                                        /*  Execution Errors        */
                                        /*    Using NSC Server      */
                                        /*                          */
                                        /****************************/
#define   NSC_NETB_NOT_INSTALLED   50   /* NetBios not installed */
#define   NSC_NB_CONNECT_ERROR     51   /* NetBios connection failed */
#define   NSC_NB_CONNECT_ERROR_Q   52   /* NetBios connection failed,
                                           Operation was queued. */
#define   NSC_NOT_ATTEMPTED        55   /* Operation not attempted because
                                           of NetBios errors */
                                        /****************************/
                                        /*                          */
                                        /*  Execution Errors        */
                                        /*    Comm Mgr - APPC       */
                                        /*                          */
                                        /****************************/
#define   NSC_CM_NOT_STARTED       60   /* Comm Manager not started */
#define   NSC_CM_NOT_STARTED_Q     61   /* Comm Manager not started,
                                           Operation was queued. */
#define   NSC_APPC_NOT_INSTALLED   62   /* APPC not installed */
#define   NSC_APPC_NOT_AVAILABLE   63   /* APPC not configured/started */
#define   NSC_APPC_ALLOC_ERROR     64   /* APPC connection failed */
#define   NSC_APPC_INVALID_PLU     65   /* Partner LU definition missing */
#define   NSC_CM_NOT_INSTALLED     66   /* Comm Manager not installed*/
#define   NSC_CM_FAILED            67   /* CM failed, must be restarted */
                                        /****************************/
                                        /*                          */
                                        /*  Execution Errors        */
                                        /*    Comm Mgr - EHLLAPI    */
                                        /*                          */
                                        /****************************/
#define   NSC_EHLL_NOT_INSTALLED   70   /* EHLLAPI not installed */
#define   NSC_EHLL_SESSION_USED    71   /* Emulator session was being used */
#define   NSC_EHLL_SESSION_USED_Q  72   /* Emulator session was being used,
                                           Operation was queued. */
#define   NSC_EHLL_FILE_ERROR      73   /* Host info file access error */
#define   NSC_EHLL_SESSION_INVALID 74   /* Session ID not 'A'-'Z' or 'a'-'z' */
#define   NSC_EHLL_SYNTAX_INVALID  75   /* Invalid syntax in host info file */
#define   NSC_EHLL_PARM_INVALID    76   /* Invalid parameter in hif */
#define   NSC_EHLL_STATE_EXCEEDED  77   /* NO LONGER RETURNED */
#define   NSC_EHLL_LINE_EXCEEDED   78   /* Maximum line length exceeded */
#define   NSC_EHLL_STRING_EXCEEDED 79   /* NO LONGER RETURNED */
#define   NSC_EHLL_NO_START_STATE  80   /* Host was not in a start state */
#define   NSC_EHLL_STATE_INVALID   81   /* Current host state is invalid */
#define   NSC_EHLL_NO_STATES       82   /* No states for this action */
#define   NSC_EHLL_NO_SESSIONS     83   /* No available emulator session */
                                        /****************************/
                                        /*                          */
                                        /*  Execution Errors        */
                                        /*    Other                 */
                                        /*                          */
                                        /****************************/
#define   NSC_SYS_ERROR            90   /* Unexpected system error */
#define   NSC_MEMORY_ERROR         91   /* Out of memory error */
#define   NSC_EXIT_EXEC_ERROR      92   /* Unable to execute user exit */
#define   NSC_EXIT_RTN_ERROR       93   /* Unknown error from user exit */
                                        /****************************/
                                        /*                          */
                                        /*  Execution Errors        */
                                        /*  Common for multiple     */
                                        /*  location types          */
                                        /*  (continued..)           */
                                        /****************************/
#define   NSC_NOT_AVAILABLE        53   /* Remote machine not available */
#define   NSC_NOT_AVAILABLE_Q      54   /* Remote machine not available,
                                           Operation was queued. */
#define   NSC_UNAUTH_TIME         100   /* Cannot logon: time restriction */
#define   NSC_UNAUTH_CLIENT       101   /* Cannot logon from this client */
#define   NSC_ACCOUNT_ERR         102   /* Account disabled, or has no
                                           balance or no credit */

#define   NSC_EHLL_TIMEOUT        103   /* Account disabled, or has no
                                        /****************************/
                                        /*                          */
                                        /*  Execution Errors        */
                                        /*    Novell NetWare        */
                                        /*                          */
                                        /****************************/
#define   NSC_NOVELL_NOT_INSTALLED 120  /* NetWare not installed    */

#endif
